<?php
/**
 * Login Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.7.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<div class="col-md-12">

	<?php do_action( 'woocommerce_before_customer_login_form' ); ?>

	<?php if ( 'yes' === get_option( 'woocommerce_enable_myaccount_registration' ) ) : ?>

	<div class="col2-set" id="customer_login">

		<div class="col-1">

	<?php endif; ?>

			<h2 class="black-text font-weight-600 text-uppercase title-small margin-bottom-20px"><?php esc_html_e( 'Login', 'H-Code' ); ?></h2>

			<form method="post" class="login">

				<?php do_action( 'woocommerce_login_form_start' ); ?>

				<div class="form-row form-row-wide col-sm-12 no-padding">
					<label for="username"><?php esc_html_e( 'Username or email address', 'H-Code' ); ?>&nbsp;<em class="required">*</em></label>
					<input type="text" class="input-text" name="username" id="username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
				</div>
				<div class="form-row form-row-wide col-sm-12 no-padding">
					<label for="password"><?php esc_html_e( 'Password', 'H-Code' ); ?>&nbsp;<em class="required">*</em></label>
					<input class="input-text" type="password" name="password" id="password" />
				</div>

				<?php do_action( 'woocommerce_login_form' ); ?>

				<div class="form-row">
					<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>
					<button type="submit" class="woocommerce-Button highlight-button btn-small button btn<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="login" value="<?php esc_attr_e( 'Log in', 'H-Code' ); ?>"><?php esc_html_e( 'Log in', 'H-Code' ); ?></button>
					<div class="login-lost-password">
						<label for="rememberme" class="inline">
							<input name="rememberme" type="checkbox" id="rememberme" value="forever" /> <?php esc_html_e( 'Remember me', 'H-Code' ); ?>
						</label>
						<p class="lost_password">
							<a href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php esc_html_e( 'Lost your password?', 'H-Code' ); ?></a>
						</p>
					</div>
				</div>

				<?php do_action( 'woocommerce_login_form_end' ); ?>

			</form>

	<?php if ( 'yes' === get_option( 'woocommerce_enable_myaccount_registration' ) ) : ?>

		</div>

		<div class="col-2">

			<h2 class="black-text font-weight-600 text-uppercase title-small margin-bottom-20px"><?php esc_html_e( 'Register', 'H-Code' ); ?></h2>

			<form method="post" class="woocommerce-form-register register">

				<?php do_action( 'woocommerce_register_form_start' ); ?>

				<?php if ( 'no' === get_option( 'woocommerce_registration_generate_username' ) ) : ?>

					<div class="form-row form-row-wide col-sm-12 no-padding">
						<label for="reg_username"><?php esc_html_e( 'Username', 'H-Code' ); ?>&nbsp;<em class="required">*</em></label>
						<input type="text" class="input-text" name="username" id="reg_username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
					</div>

				<?php endif; ?>

				<div class="form-row form-row-wide col-sm-12 no-padding">
					<label for="reg_email"><?php esc_html_e( 'Email address', 'H-Code' ); ?>&nbsp;<em class="required">*</em></label>
					<input type="email" class="input-text" name="email" id="reg_email" autocomplete="email" value="<?php echo ( ! empty( $_POST['email'] ) ) ? esc_attr( wp_unslash( $_POST['email'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
				</div>

				<?php if ( 'no' === get_option( 'woocommerce_registration_generate_password' ) ) : ?>

					<div class="form-row form-row-wide col-sm-12 no-padding">
						<label for="reg_password"><?php esc_html_e( 'Password', 'H-Code' ); ?>&nbsp;<em class="required">*</em></label>
						<input type="password" class="input-text" name="password" id="reg_password" autocomplete="new-password" />
					</div>
				<?php else : ?>		
					<p><?php esc_html_e( 'A password will be sent to your email address.', 'H-Code' ); ?></p>
				<?php endif; ?>

				<?php do_action( 'woocommerce_register_form' ); ?>

				<div class="woocommerce-form-row form-row col-md-12 no-padding">
					<?php wp_nonce_field( 'woocommerce-register', 'woocommerce-register-nonce' ); ?>
					<button type="submit" class="woocommerce-Button highlight-button btn-small button btn<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="register" value="<?php esc_attr_e( 'Register', 'H-Code' ); ?>"><?php esc_html_e( 'Register', 'H-Code' ); ?></button>
				</div>

				<?php do_action( 'woocommerce_register_form_end' ); ?>

			</form>

		</div>

	</div>
	<?php endif; ?>

	<?php do_action( 'woocommerce_after_customer_login_form' ); ?>
</div>
