<?php
/**
 * Cart Page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.9.0
 */

defined( 'ABSPATH' ) || exit;

$hcode_cart_section_classes = $hcode_cart_coupon_classes = $hcode_cart_total_classes = '';

$hcode_layout_settings_single = hcode_option( 'hcode_layout_settings' );

switch( $hcode_layout_settings_single ) {
	case 'hcode_layout_left_sidebar':
	case 'hcode_layout_right_sidebar':
		$hcode_cart_section_classes .= 'no-padding';
		$hcode_cart_coupon_classes  .= 'col-md-5 col-sm-12 calculate padding-five no-padding-bottom no-padding-right xs-padding-five-lr xs-margin-bottom-ten';
		$hcode_cart_total_classes   .= 'col-md-6 col-sm-12 col-md-offset-1 col-sm-offset-0 padding-five no-padding-bottom no-padding-left sm-no-padding xs-padding-five-lr';
		break;
	case 'hcode_layout_both_sidebar':
		$hcode_cart_section_classes .= 'no-padding';
		$hcode_cart_coupon_classes  .= 'col-md-5 col-sm-12 calculate padding-five no-padding-bottom no-padding-right sm-padding-five-lr xs-margin-bottom-ten';
		$hcode_cart_total_classes   .= 'col-md-6 col-sm-12 col-md-offset-1 col-sm-offset-0 padding-five no-padding-bottom no-padding-left sm-no-padding sm-padding-five-lr';
		break;
	case 'hcode_layout_full_screen':
		$hcode_cart_coupon_classes .= 'col-md-5 col-sm-5 calculate padding-five no-padding-bottom no-padding-right xs-margin-bottom-ten xs-padding-five-lr';
		$hcode_cart_total_classes  .= 'col-md-6 col-sm-7 col-md-offset-1 padding-five no-padding-bottom no-padding-left xs-padding-five-lr xs-no-padding-top';
		break;
}
?>
<section class="<?php echo esc_attr( $hcode_cart_section_classes ); ?>">
	<div class="container">
		<div class="row">
			<?php
			wc_print_notices();

			do_action( 'woocommerce_before_cart' ); ?>

			<form class="woocommerce-cart-form" action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">
				<div class="col-sm-12 shop-cart-table">
					<?php
					do_action( 'woocommerce_before_cart_table' );
					switch( $hcode_layout_settings_single ) {
						case 'hcode_layout_left_sidebar':
						case 'hcode_layout_right_sidebar':
							echo '<div class="shopping-cart-scroll">';
							break;
						case 'hcode_layout_both_sidebar':
							echo '<div class="shopping-cart-scroll shopping-cart-both-col-scroll">';
							break;
						case 'hcode_layout_full_screen':
							echo '<div class="shopping-cart-scroll shopping-cart-full-screen-scroll">';
							break;
					}
					?>
					<table class="table shop-cart shop_table shop_table_responsive cart text-center woocommerce-cart-form__contents">
						<thead>
							<tr>
								<th class="product-thumbnail first">&nbsp;</th>
								<th class="product-name text-left text-uppercase font-weight-600 letter-spacing-2 text-small black-text"><?php echo esc_html__( 'Product', 'H-Code' ); ?></th>
								<th class="product-price text-left text-uppercase font-weight-600 letter-spacing-2 text-small black-text"><?php echo esc_html__( 'Price', 'H-Code' ); ?></th>
								<th class="product-quantity text-left text-uppercase font-weight-600 letter-spacing-2 text-small black-text"><?php echo esc_html__( 'Quantity', 'H-Code' ); ?></th>
								<th class="product-subtotal text-left text-uppercase font-weight-600 letter-spacing-2 text-small black-text"><?php echo esc_html__( 'Subtotal', 'H-Code' ); ?></th>
								<th class="product-remove">&nbsp;</th>
							</tr>
						</thead>
						<tbody>
							<?php do_action( 'woocommerce_before_cart_contents' ); ?>

							<?php
							foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
								$_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
								$product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

								if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
									$product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
									?>
									<tr class="woocommerce-cart-form__cart-item <?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">

										<td class="product-thumbnail text-left">
											<?php												
												$thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );

												if ( ! $product_permalink ) {
													echo $thumbnail; // PHPCS: XSS ok.
												} else {
													printf( '<a href="%s">%s</a>', esc_url( $product_permalink ), $thumbnail ); // PHPCS: XSS ok.
												}
											?>
										</td>

										<td class="product-name text-left" data-title="<?php echo esc_attr__( 'Product', 'H-Code' ); ?>">
											<?php

												if ( ! $product_permalink ) {
													echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key ) . '&nbsp;' );
												} else {
													echo wp_kses_post( apply_filters( 'woocommerce_cart_item_name', sprintf( '<a class="margin-two-bottom" href="%s">%s</a>', esc_url( $product_permalink ), $_product->get_name() ), $cart_item, $cart_item_key ) );
												}

												do_action( 'woocommerce_after_cart_item_name', $cart_item, $cart_item_key );

												// Meta data
												echo wc_get_formatted_cart_item_data( $cart_item );

												//sku
												if ( wc_product_sku_enabled() && ( $_product->get_sku() || $_product->is_type( 'variable' ) ) ) : 
													echo '<span class="text-uppercase display-block text-small margin-two no-margin-top light-gray-text2">';
														echo esc_html__( 'SKU:', 'H-Code' );
														echo ( $sku = $_product->get_sku() ) ? $sku : '';
													echo '</span>';
												endif;

												// Backorder notification
												if ( $_product->backorders_require_notification() && $_product->is_on_backorder( $cart_item['quantity'] ) ) {
													echo wp_kses_post( apply_filters( 'woocommerce_cart_item_backorder_notification', '<p class="backorder_notification">' . esc_html__( 'Available on backorder', 'H-Code' ) . '</p>' ) );
												}
												
												if ( ! $product_permalink ) {
													echo '<a class="text-small" href="#"><i class="fa-solid fa-edit black-text"></i> '.esc_html__( 'Edit', 'H-Code' ).'</a>';
												} else {
													echo '<a class="text-small" href="'.esc_url( $product_permalink ).'"><i class="fa-solid fa-edit black-text"></i> '.esc_html__( 'Edit', 'H-Code' ).'</a>';
												}
											?>
										</td>

										<td class="product-price text-left" data-title="<?php echo esc_attr__( 'Price', 'H-Code' ); ?>">
											<?php
												echo apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
											?>
										</td>

										<td class="product-quantity" data-title="<?php echo esc_attr__( 'Quantity', 'H-Code' ); ?>">
											<?php
												if ( $_product->is_sold_individually() ) {
													$product_quantity = sprintf( '1 <input type="hidden" name="cart[%s][qty]" value="1" />', $cart_item_key );
												} else {
													$product_quantity = woocommerce_quantity_input(
														array(
															'input_name'   => "cart[{$cart_item_key}][qty]",
															'input_value'  => $cart_item['quantity'],
															'max_value'    => $_product->get_max_purchase_quantity(),
															'min_value'    => '0',
															'product_name' => $_product->get_name(),
														),
														$_product,
														false
													);
												}

												echo apply_filters( 'woocommerce_cart_item_quantity', $product_quantity, $cart_item_key, $cart_item );
											?>
										</td>

										<td class="product-subtotal text-left" data-title="<?php echo esc_attr__( 'Subtotal', 'H-Code' ); ?>">
											<?php
												echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key );
											?>
										</td>

										<td class="product-remove text-center">
											<?php
												echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
													'woocommerce_cart_item_remove_link',
													sprintf(
														'<a href="%s" class="remove" aria-label="%s" data-product_id="%s" data-product_sku="%s">&times;</a>',
														esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
														esc_html__( 'Remove this item', 'H-Code' ),
														esc_attr( $product_id ),
														esc_attr( $_product->get_sku() )
													),
													$cart_item_key
												);
											?>
										</td>
									</tr>
									<?php
								}
							}

							do_action( 'woocommerce_cart_contents' );
							
							do_action( 'woocommerce_after_cart_contents' );

						?>
						</tbody>
					</table>
					<?php do_action( 'woocommerce_after_cart_table' ); ?>
					</div><!-- .shopping-cart-scroll -->
				</div><!-- .shop-cart-table -->

				<div class="col-sm-12">
					<div class="cupon padding-five border-top border-bottom">
						<?php global $woocommerce;?>
						<a href="<?php echo add_query_arg( 'empty-cart', '', esc_url( wc_get_cart_url() ) ); ?>" class="highlight-button btn btn-very-small no-margin pull-left"><?php echo esc_html__('Empty Cart', 'H-Code');?></a>
						<?php do_action( 'hcode_woocommerce_continue_shopping_link' ); ?>
						<button type="submit" class="button  highlight-button btn btn-very-small no-margin pull-right" name="update_cart" value="<?php echo esc_attr__( 'Update cart', 'H-Code' ); ?>"><?php echo esc_html__( 'Update cart', 'H-Code' ); ?></button>

						<?php do_action( 'woocommerce_cart_actions' ); ?>
						<?php wp_nonce_field( 'woocommerce-cart', 'woocommerce-cart-nonce' ); ?>
					</div>
				</div>
			</form>
			<div class="<?php echo esc_attr( $hcode_cart_coupon_classes );?>">
				<?php if ( wc_coupons_enabled() ) { ?>
				<div class="panel panel-default border margin-five no-margin-top">
			        <div role="tablist" id="headingOne" class="panel-heading no-padding">
			            <a class="collapsed" data-toggle="collapse" data-parent="#collapse-two" href="#collapse-two-link1">
			                <h4 class="panel-title no-border black-text font-weight-600 letter-spacing-2"><?php echo esc_html__( 'Coupon code', 'H-Code' ); ?> <span class="pull-right"><i class="fa-solid fa-plus"></i></span></h4>
			            </a>
			        </div>
			        <div id="collapse-two-link1" class="panel-collapse collapse">
			            <div class="panel-body">
			            	<form action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">
							<div class="coupon">
								<input type="text" name="coupon_code" class="input-text" id="coupon_code" value="" placeholder="<?php echo esc_attr__( 'Coupon code', 'H-Code' ); ?>" />
								<button type="submit" class="button highlight-button btn btn-very-small no-margin pull-left" name="apply_coupon" value="<?php echo esc_attr__( 'Apply coupon', 'H-Code' ); ?>"><?php echo esc_html__( 'Apply coupon', 'H-Code' ); ?></button>
								<?php do_action( 'woocommerce_cart_coupon' ); ?>
							</div>
							</form>
			            </div>
			        </div>
			    </div>
				<?php } ?>	
			</div>
			<div class="<?php echo esc_attr( $hcode_cart_total_classes );?>">
				<?php woocommerce_cart_totals(); ?>
			</div>
			<?php do_action( 'woocommerce_before_cart_collaterals' ); ?>
			<div class="cart-collaterals">
				<?php
				/**
				 * Cart collaterals hook.
				 *
				 * @hooked woocommerce_cross_sell_display
				 * @hooked woocommerce_cart_totals - 10
				 */
				do_action( 'woocommerce_cart_collaterals' );
				?>
			</div>
			<?php do_action( 'woocommerce_after_cart' ); ?>
		</div>
	</div>
</section>