<?php
/**
 * Empty cart page
 *
 * @package H-Code
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;

?>
<section>
	<div class="container">
		<div class="row">
			<?php wc_print_notices(); ?>
			<div class="col-md-12 text-center">
				<?php do_action( 'woocommerce_cart_is_empty' ); ?>

				<?php if ( wc_get_page_id( 'shop' ) > 0 ) : ?>
					<p class="return-to-shop">
						<a class="button wc-backward highlight-button-dark btn-medium button btn<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
							<?php
								/**
								 * Filter "Return To Shop" text.
								 *
								 * @since 4.6.0
								 * @param string $default_text Default text.
								 */
								echo esc_html( apply_filters( 'woocommerce_return_to_shop_text', __( 'Return to shop', 'H-Code' ) ) );
							?>
						</a>
					</p>
				<?php endif; ?>
			</div>
		</div>
	</div>
</section>