<?php
/**
 * Footer Tab For Theme Option.
 *
 * @package H-Code
 */
?>
<?php
$this->sections[] = array(
    'icon' => 'el-icon-website icon-rotate',
    'title' => esc_html__('Footer', 'H-Code'),
    'desc' => esc_html__('Footer section configuration settings', 'H-Code'),
    'fields' => array(
    	array(
            'id'       => 'hcode_enable_page_footer',
            'type'     => 'switch',
            'title'    => esc_html__('Enable Footer', 'H-Code'),
            'default'  => true,
            '1'       => 'On',
            '0'      => 'Off',
        ),
        array(
            'id'       => 'hcode_enable_sidebar_section',
            'type'     => 'switch',
            'title'    => esc_html__('Enable Footer Information Links Block', 'H-Code'),
            'default'  => false,
            '1'       => 'On',
            '0'      => 'Off',
        ),
        array(
            'id'        => 'hcode_footer_sidebar_1',
            'type'      => 'select',
            'title'     => esc_html__('Information Block', 'H-Code'),
            'subtitle'  => esc_html__('Select custom sidebar', 'H-Code'),
            'data'      => 'sidebar',
            'default'   => '',
            'required'  => array('hcode_enable_sidebar_section', 'equals', '1'),
        ),
        array(
            'id'=>'hcode_footer_sidebar_1_md_column',
            'type' => 'select',
            'title' => esc_html__('Information Block Column (For Desktop Device)', 'H-Code'),
            'subtitle' => esc_html__('Select information block column. default: 4 columns', 'H-Code'),
            'options' => array(
                'col-md-1' => esc_html__('1 column - 1/12', 'H-Code'),
                'col-md-2' => esc_html__('2 columns - 1/6', 'H-Code'),
                'col-md-3' => esc_html__('3 columns - 1/4', 'H-Code'),
                'col-md-4' => esc_html__('4 columns - 1/3', 'H-Code'),
                'col-md-5' => esc_html__('5 columns - 5/12', 'H-Code'),
                'col-md-6' => esc_html__('6 columns - 1/2', 'H-Code'),
                'col-md-7' => esc_html__('7 columns - 7/12', 'H-Code'),
                'col-md-8' => esc_html__('8 columns - 2/3', 'H-Code'),
                'col-md-9' => esc_html__('9 columns - 3/4', 'H-Code'),
                'col-md-10' => esc_html__('10 columns - 5/6', 'H-Code'),
                'col-md-11' => esc_html__('11 columns - 11/12', 'H-Code'),
                'col-md-12' => esc_html__('12 columns - 1/1', 'H-Code'),
            ),
            'default'   => 'col-md-4',
            'required'  => array('hcode_enable_sidebar_section', 'equals', '1'),
        ),
        array(
            'id'=>'hcode_footer_sidebar_1_sm_column',
            'type' => 'select',
            'title' => esc_html__('Information Block Column (For iPad/Tablet Device)', 'H-Code'),
            'subtitle' => esc_html__('Select information block column. default: 12 columns', 'H-Code'),
            'options' => array(
                'col-sm-1' => esc_html__('1 column - 1/12', 'H-Code'),
                'col-sm-2' => esc_html__('2 columns - 1/6', 'H-Code'),
                'col-sm-3' => esc_html__('3 columns - 1/4', 'H-Code'),
                'col-sm-4' => esc_html__('4 columns - 1/3', 'H-Code'),
                'col-sm-5' => esc_html__('5 columns - 5/12', 'H-Code'),
                'col-sm-6' => esc_html__('6 columns - 1/2', 'H-Code'),
                'col-sm-7' => esc_html__('7 columns - 7/12', 'H-Code'),
                'col-sm-8' => esc_html__('8 columns - 2/3', 'H-Code'),
                'col-sm-9' => esc_html__('9 columns - 3/4', 'H-Code'),
                'col-sm-10' => esc_html__('10 columns - 5/6', 'H-Code'),
                'col-sm-11' => esc_html__('11 columns - 11/12', 'H-Code'),
                'col-sm-12' => esc_html__('12 columns - 1/1', 'H-Code'),
            ),
            'default'   => 'col-sm-12',
            'required'  => array('hcode_enable_sidebar_section', 'equals', '1'),
        ),
        array(
            'id'=>'hcode_footer_sidebar_1_xs_column',
            'type' => 'select',
            'title' => esc_html__('Information Block Column (For Mobile Device)', 'H-Code'),
            'subtitle' => esc_html__('Select information block column. default: 12 columns', 'H-Code'),
            'options' => array(
                'col-xs-1' => esc_html__('1 column - 1/12', 'H-Code'),
                'col-xs-2' => esc_html__('2 columns - 1/6', 'H-Code'),
                'col-xs-3' => esc_html__('3 columns - 1/4', 'H-Code'),
                'col-xs-4' => esc_html__('4 columns - 1/3', 'H-Code'),
                'col-xs-5' => esc_html__('5 columns - 5/12', 'H-Code'),
                'col-xs-6' => esc_html__('6 columns - 1/2', 'H-Code'),
                'col-xs-7' => esc_html__('7 columns - 7/12', 'H-Code'),
                'col-xs-8' => esc_html__('8 columns - 2/3', 'H-Code'),
                'col-xs-9' => esc_html__('9 columns - 3/4', 'H-Code'),
                'col-xs-10' => esc_html__('10 columns - 5/6', 'H-Code'),
                'col-xs-11' => esc_html__('11 columns - 11/12', 'H-Code'),
                'col-xs-12' => esc_html__('12 columns - 1/1', 'H-Code'),
            ),
            'default'   => 'col-xs-12',
            'required'  => array('hcode_enable_sidebar_section', 'equals', '1'),
        ),
		array(
			'id'        => 'hcode_footer_sidebar_2',
			'type'      => 'select',
			'title'     => esc_html__('Link Block 1', 'H-Code'),
			'subtitle'  => esc_html__('Select custom sidebar', 'H-Code'),
            'data'      => 'sidebar',
			'default'   => '',
			'required'  => array('hcode_enable_sidebar_section', 'equals', '1'),
		),
        array(
            'id'=>'hcode_footer_sidebar_2_md_column',
            'type' => 'select',
            'title' => esc_html__('Link Block 1 Column (For Desktop Device)', 'H-Code'),
            'subtitle' => esc_html__('Select link block 1 column. default: 2 columns', 'H-Code'),
            'options' => array(
                'col-md-1' => esc_html__('1 column - 1/12', 'H-Code'),
                'col-md-2' => esc_html__('2 columns - 1/6', 'H-Code'),
                'col-md-3' => esc_html__('3 columns - 1/4', 'H-Code'),
                'col-md-4' => esc_html__('4 columns - 1/3', 'H-Code'),
                'col-md-5' => esc_html__('5 columns - 5/12', 'H-Code'),
                'col-md-6' => esc_html__('6 columns - 1/2', 'H-Code'),
                'col-md-7' => esc_html__('7 columns - 7/12', 'H-Code'),
                'col-md-8' => esc_html__('8 columns - 2/3', 'H-Code'),
                'col-md-9' => esc_html__('9 columns - 3/4', 'H-Code'),
                'col-md-10' => esc_html__('10 columns - 5/6', 'H-Code'),
                'col-md-11' => esc_html__('11 columns - 11/12', 'H-Code'),
                'col-md-12' => esc_html__('12 columns - 1/1', 'H-Code'),
            ),
            'default'   => 'col-md-2',
            'required'  => array('hcode_enable_sidebar_section', 'equals', '1'),
        ),
        array(
            'id'=>'hcode_footer_sidebar_2_sm_column',
            'type' => 'select',
            'title' => esc_html__('Link Block 1 Column (For iPad/Tablet Device)', 'H-Code'),
            'subtitle' => esc_html__('Select link block 1 column. default: 3 columns', 'H-Code'),
            'options' => array(
                'col-sm-1' => esc_html__('1 column - 1/12', 'H-Code'),
                'col-sm-2' => esc_html__('2 columns - 1/6', 'H-Code'),
                'col-sm-3' => esc_html__('3 columns - 1/4', 'H-Code'),
                'col-sm-4' => esc_html__('4 columns - 1/3', 'H-Code'),
                'col-sm-5' => esc_html__('5 columns - 5/12', 'H-Code'),
                'col-sm-6' => esc_html__('6 columns - 1/2', 'H-Code'),
                'col-sm-7' => esc_html__('7 columns - 7/12', 'H-Code'),
                'col-sm-8' => esc_html__('8 columns - 2/3', 'H-Code'),
                'col-sm-9' => esc_html__('9 columns - 3/4', 'H-Code'),
                'col-sm-10' => esc_html__('10 columns - 5/6', 'H-Code'),
                'col-sm-11' => esc_html__('11 columns - 11/12', 'H-Code'),
                'col-sm-12' => esc_html__('12 columns - 1/1', 'H-Code'),
            ),
            'default'   => 'col-sm-3',
            'required'  => array('hcode_enable_sidebar_section', 'equals', '1'),
        ),
        array(
            'id'=>'hcode_footer_sidebar_2_xs_column',
            'type' => 'select',
            'title' => esc_html__('Link Block 1 Column (For Mobile Device)', 'H-Code'),
            'subtitle' => esc_html__('Select link block 1 column. default: 3 columns', 'H-Code'),
            'options' => array(
                'col-xs-1' => esc_html__('1 column - 1/12', 'H-Code'),
                'col-xs-2' => esc_html__('2 columns - 1/6', 'H-Code'),
                'col-xs-3' => esc_html__('3 columns - 1/4', 'H-Code'),
                'col-xs-4' => esc_html__('4 columns - 1/3', 'H-Code'),
                'col-xs-5' => esc_html__('5 columns - 5/12', 'H-Code'),
                'col-xs-6' => esc_html__('6 columns - 1/2', 'H-Code'),
                'col-xs-7' => esc_html__('7 columns - 7/12', 'H-Code'),
                'col-xs-8' => esc_html__('8 columns - 2/3', 'H-Code'),
                'col-xs-9' => esc_html__('9 columns - 3/4', 'H-Code'),
                'col-xs-10' => esc_html__('10 columns - 5/6', 'H-Code'),
                'col-xs-11' => esc_html__('11 columns - 11/12', 'H-Code'),
                'col-xs-12' => esc_html__('12 columns - 1/1', 'H-Code'),
            ),
            'default'   => 'col-xs-12',
            'required'  => array('hcode_enable_sidebar_section', 'equals', '1'),
        ),
		array(
			'id'        => 'hcode_footer_sidebar_3',
			'type'      => 'select',
			'title'     => esc_html__('Link Block 2', 'H-Code'),
			'subtitle'  => esc_html__('Select custom sidebar', 'H-Code'),
            'data'      => 'sidebar',
			'default'   => '',
			'required'  => array('hcode_enable_sidebar_section', 'equals', '1'),
		),
        array(
            'id'=>'hcode_footer_sidebar_3_md_column',
            'type' => 'select',
            'title' => esc_html__('Link Block 2 Column (For Desktop Device)', 'H-Code'),
            'subtitle' => esc_html__('Select link block 2 column. default: 2 columns', 'H-Code'),
            'options' => array(
                'col-md-1' => esc_html__('1 column - 1/12', 'H-Code'),
                'col-md-2' => esc_html__('2 columns - 1/6', 'H-Code'),
                'col-md-3' => esc_html__('3 columns - 1/4', 'H-Code'),
                'col-md-4' => esc_html__('4 columns - 1/3', 'H-Code'),
                'col-md-5' => esc_html__('5 columns - 5/12', 'H-Code'),
                'col-md-6' => esc_html__('6 columns - 1/2', 'H-Code'),
                'col-md-7' => esc_html__('7 columns - 7/12', 'H-Code'),
                'col-md-8' => esc_html__('8 columns - 2/3', 'H-Code'),
                'col-md-9' => esc_html__('9 columns - 3/4', 'H-Code'),
                'col-md-10' => esc_html__('10 columns - 5/6', 'H-Code'),
                'col-md-11' => esc_html__('11 columns - 11/12', 'H-Code'),
                'col-md-12' => esc_html__('12 columns - 1/1', 'H-Code'),
            ),
            'default'   => 'col-md-2',
            'required'  => array('hcode_enable_sidebar_section', 'equals', '1'),
        ),
        array(
            'id'=>'hcode_footer_sidebar_3_sm_column',
            'type' => 'select',
            'title' => esc_html__('Link Block 2 Column (For iPad/Tablet Device)', 'H-Code'),
            'subtitle' => esc_html__('Select link block 2 column. default: 3 columns', 'H-Code'),
            'options' => array(
                'col-sm-1' => esc_html__('1 column - 1/12', 'H-Code'),
                'col-sm-2' => esc_html__('2 columns - 1/6', 'H-Code'),
                'col-sm-3' => esc_html__('3 columns - 1/4', 'H-Code'),
                'col-sm-4' => esc_html__('4 columns - 1/3', 'H-Code'),
                'col-sm-5' => esc_html__('5 columns - 5/12', 'H-Code'),
                'col-sm-6' => esc_html__('6 columns - 1/2', 'H-Code'),
                'col-sm-7' => esc_html__('7 columns - 7/12', 'H-Code'),
                'col-sm-8' => esc_html__('8 columns - 2/3', 'H-Code'),
                'col-sm-9' => esc_html__('9 columns - 3/4', 'H-Code'),
                'col-sm-10' => esc_html__('10 columns - 5/6', 'H-Code'),
                'col-sm-11' => esc_html__('11 columns - 11/12', 'H-Code'),
                'col-sm-12' => esc_html__('12 columns - 1/1', 'H-Code'),
            ),
            'default'   => 'col-sm-3',
            'required'  => array('hcode_enable_sidebar_section', 'equals', '1'),
        ),
        array(
            'id'=>'hcode_footer_sidebar_3_xs_column',
            'type' => 'select',
            'title' => esc_html__('Link Block 2 Column (For Mobile Device)', 'H-Code'),
            'subtitle' => esc_html__('Select link block 2 column. default: 3 columns', 'H-Code'),
            'options' => array(
                'col-xs-1' => esc_html__('1 column - 1/12', 'H-Code'),
                'col-xs-2' => esc_html__('2 columns - 1/6', 'H-Code'),
                'col-xs-3' => esc_html__('3 columns - 1/4', 'H-Code'),
                'col-xs-4' => esc_html__('4 columns - 1/3', 'H-Code'),
                'col-xs-5' => esc_html__('5 columns - 5/12', 'H-Code'),
                'col-xs-6' => esc_html__('6 columns - 1/2', 'H-Code'),
                'col-xs-7' => esc_html__('7 columns - 7/12', 'H-Code'),
                'col-xs-8' => esc_html__('8 columns - 2/3', 'H-Code'),
                'col-xs-9' => esc_html__('9 columns - 3/4', 'H-Code'),
                'col-xs-10' => esc_html__('10 columns - 5/6', 'H-Code'),
                'col-xs-11' => esc_html__('11 columns - 11/12', 'H-Code'),
                'col-xs-12' => esc_html__('12 columns - 1/1', 'H-Code'),
            ),
            'default'   => 'col-xs-12',
            'required'  => array('hcode_enable_sidebar_section', 'equals', '1'),
        ),
		array(
			'id'        => 'hcode_footer_sidebar_4',
			'type'      => 'select',
			'title'     => esc_html__('Link Block 3', 'H-Code'),
			'subtitle'  => esc_html__('Select custom sidebar', 'H-Code'),
            'data'      => 'sidebar',
			'default'   => '',
			'required'  => array('hcode_enable_sidebar_section', 'equals', '1'),
		),
        array(
            'id'=>'hcode_footer_sidebar_4_md_column',
            'type' => 'select',
            'title' => esc_html__('Link Block 3 Column (For Desktop Device)', 'H-Code'),
            'subtitle' => esc_html__('Select link block 3 column. default: 2 columns', 'H-Code'),
            'options' => array(
                'col-md-1' => esc_html__('1 column - 1/12', 'H-Code'),
                'col-md-2' => esc_html__('2 columns - 1/6', 'H-Code'),
                'col-md-3' => esc_html__('3 columns - 1/4', 'H-Code'),
                'col-md-4' => esc_html__('4 columns - 1/3', 'H-Code'),
                'col-md-5' => esc_html__('5 columns - 5/12', 'H-Code'),
                'col-md-6' => esc_html__('6 columns - 1/2', 'H-Code'),
                'col-md-7' => esc_html__('7 columns - 7/12', 'H-Code'),
                'col-md-8' => esc_html__('8 columns - 2/3', 'H-Code'),
                'col-md-9' => esc_html__('9 columns - 3/4', 'H-Code'),
                'col-md-10' => esc_html__('10 columns - 5/6', 'H-Code'),
                'col-md-11' => esc_html__('11 columns - 11/12', 'H-Code'),
                'col-md-12' => esc_html__('12 columns - 1/1', 'H-Code'),
            ),
            'default'   => 'col-md-2',
            'required'  => array('hcode_enable_sidebar_section', 'equals', '1'),
        ),
        array(
            'id'=>'hcode_footer_sidebar_4_sm_column',
            'type' => 'select',
            'title' => esc_html__('Link Block 3 Column (For iPad/Tablet Device)', 'H-Code'),
            'subtitle' => esc_html__('Select link block 3 column. default: 3 columns', 'H-Code'),
            'options' => array(
                'col-sm-1' => esc_html__('1 column - 1/12', 'H-Code'),
                'col-sm-2' => esc_html__('2 columns - 1/6', 'H-Code'),
                'col-sm-3' => esc_html__('3 columns - 1/4', 'H-Code'),
                'col-sm-4' => esc_html__('4 columns - 1/3', 'H-Code'),
                'col-sm-5' => esc_html__('5 columns - 5/12', 'H-Code'),
                'col-sm-6' => esc_html__('6 columns - 1/2', 'H-Code'),
                'col-sm-7' => esc_html__('7 columns - 7/12', 'H-Code'),
                'col-sm-8' => esc_html__('8 columns - 2/3', 'H-Code'),
                'col-sm-9' => esc_html__('9 columns - 3/4', 'H-Code'),
                'col-sm-10' => esc_html__('10 columns - 5/6', 'H-Code'),
                'col-sm-11' => esc_html__('11 columns - 11/12', 'H-Code'),
                'col-sm-12' => esc_html__('12 columns - 1/1', 'H-Code'),
            ),
            'default'   => 'col-sm-3',
            'required'  => array('hcode_enable_sidebar_section', 'equals', '1'),
        ),
        array(
            'id'=>'hcode_footer_sidebar_4_xs_column',
            'type' => 'select',
            'title' => esc_html__('Link Block 3 Column (For Mobile Device)', 'H-Code'),
            'subtitle' => esc_html__('Select link block 3 column. default: 3 columns', 'H-Code'),
            'options' => array(
                'col-xs-1' => esc_html__('1 column - 1/12', 'H-Code'),
                'col-xs-2' => esc_html__('2 columns - 1/6', 'H-Code'),
                'col-xs-3' => esc_html__('3 columns - 1/4', 'H-Code'),
                'col-xs-4' => esc_html__('4 columns - 1/3', 'H-Code'),
                'col-xs-5' => esc_html__('5 columns - 5/12', 'H-Code'),
                'col-xs-6' => esc_html__('6 columns - 1/2', 'H-Code'),
                'col-xs-7' => esc_html__('7 columns - 7/12', 'H-Code'),
                'col-xs-8' => esc_html__('8 columns - 2/3', 'H-Code'),
                'col-xs-9' => esc_html__('9 columns - 3/4', 'H-Code'),
                'col-xs-10' => esc_html__('10 columns - 5/6', 'H-Code'),
                'col-xs-11' => esc_html__('11 columns - 11/12', 'H-Code'),
                'col-xs-12' => esc_html__('12 columns - 1/1', 'H-Code'),
            ),
            'default'   => 'col-xs-12',
            'required'  => array('hcode_enable_sidebar_section', 'equals', '1'),
        ),
        array(
            'id'        => 'hcode_footer_sidebar_5',
            'type'      => 'select',
            'title'     => esc_html__('Link Block 4', 'H-Code'),
            'subtitle'  => esc_html__('Select custom sidebar', 'H-Code'),
            'data'      => 'sidebar',
            'default'   => '',
            'required'  => array('hcode_enable_sidebar_section', 'equals', '1'),
        ),
        array(
            'id'=>'hcode_footer_sidebar_5_md_column',
            'type' => 'select',
            'title' => esc_html__('Link Block 4 Column (For Desktop Device)', 'H-Code'),
            'subtitle' => esc_html__('Select link block 4 column. default: 2 columns', 'H-Code'),
            'options' => array(
                'col-md-1' => esc_html__('1 column - 1/12', 'H-Code'),
                'col-md-2' => esc_html__('2 columns - 1/6', 'H-Code'),
                'col-md-3' => esc_html__('3 columns - 1/4', 'H-Code'),
                'col-md-4' => esc_html__('4 columns - 1/3', 'H-Code'),
                'col-md-5' => esc_html__('5 columns - 5/12', 'H-Code'),
                'col-md-6' => esc_html__('6 columns - 1/2', 'H-Code'),
                'col-md-7' => esc_html__('7 columns - 7/12', 'H-Code'),
                'col-md-8' => esc_html__('8 columns - 2/3', 'H-Code'),
                'col-md-9' => esc_html__('9 columns - 3/4', 'H-Code'),
                'col-md-10' => esc_html__('10 columns - 5/6', 'H-Code'),
                'col-md-11' => esc_html__('11 columns - 11/12', 'H-Code'),
                'col-md-12' => esc_html__('12 columns - 1/1', 'H-Code'),
            ),
            'default'   => 'col-md-2',
            'required'  => array('hcode_enable_sidebar_section', 'equals', '1'),
        ),
        array(
            'id'=>'hcode_footer_sidebar_5_sm_column',
            'type' => 'select',
            'title' => esc_html__('Link Block 4 Column (For iPad/Tablet Device)', 'H-Code'),
            'subtitle' => esc_html__('Select link block 4 column. default: 3 columns', 'H-Code'),
            'options' => array(
                'col-sm-1' => esc_html__('1 column - 1/12', 'H-Code'),
                'col-sm-2' => esc_html__('2 columns - 1/6', 'H-Code'),
                'col-sm-3' => esc_html__('3 columns - 1/4', 'H-Code'),
                'col-sm-4' => esc_html__('4 columns - 1/3', 'H-Code'),
                'col-sm-5' => esc_html__('5 columns - 5/12', 'H-Code'),
                'col-sm-6' => esc_html__('6 columns - 1/2', 'H-Code'),
                'col-sm-7' => esc_html__('7 columns - 7/12', 'H-Code'),
                'col-sm-8' => esc_html__('8 columns - 2/3', 'H-Code'),
                'col-sm-9' => esc_html__('9 columns - 3/4', 'H-Code'),
                'col-sm-10' => esc_html__('10 columns - 5/6', 'H-Code'),
                'col-sm-11' => esc_html__('11 columns - 11/12', 'H-Code'),
                'col-sm-12' => esc_html__('12 columns - 1/1', 'H-Code'),
            ),
            'default'   => 'col-sm-3',
            'required'  => array('hcode_enable_sidebar_section', 'equals', '1'),
        ),
        array(
            'id'=>'hcode_footer_sidebar_5_xs_column',
            'type' => 'select',
            'title' => esc_html__('Link Block 4 Column (For Mobile Device)', 'H-Code'),
            'subtitle' => esc_html__('Select link block 4 column. default: 3 columns', 'H-Code'),
            'options' => array(
                'col-xs-1' => esc_html__('1 column - 1/12', 'H-Code'),
                'col-xs-2' => esc_html__('2 columns - 1/6', 'H-Code'),
                'col-xs-3' => esc_html__('3 columns - 1/4', 'H-Code'),
                'col-xs-4' => esc_html__('4 columns - 1/3', 'H-Code'),
                'col-xs-5' => esc_html__('5 columns - 5/12', 'H-Code'),
                'col-xs-6' => esc_html__('6 columns - 1/2', 'H-Code'),
                'col-xs-7' => esc_html__('7 columns - 7/12', 'H-Code'),
                'col-xs-8' => esc_html__('8 columns - 2/3', 'H-Code'),
                'col-xs-9' => esc_html__('9 columns - 3/4', 'H-Code'),
                'col-xs-10' => esc_html__('10 columns - 5/6', 'H-Code'),
                'col-xs-11' => esc_html__('11 columns - 11/12', 'H-Code'),
                'col-xs-12' => esc_html__('12 columns - 1/1', 'H-Code'),
            ),
            'default'   => 'col-xs-12',
            'required'  => array('hcode_enable_sidebar_section', 'equals', '1'),
        ),
        array(
            'id'       => 'hcode_enable_footer_menu',
            'type'     => 'switch',
            'title'    => esc_html__('Enable Footer Menu', 'H-Code'),
            'default'  => false,
            '1'       => 'On',
            '0'      => 'Off',
        ),
        array(
            'id'       => 'hcode_footer_menu',
            'type'     => 'select',
            'data'     => 'menus',
            'title'    => esc_html__( 'Select Footer Menu', 'H-Code' ),
            'required'  => array('hcode_enable_footer_menu', 'equals', '1'),
        ),
		array(
            'id'       => 'hcode_enable_footer_logo',
            'type'     => 'switch',
            'title'    => esc_html__('Enable Footer Logo', 'H-Code'),
            'default'  => false,
            '1'       => 'On',
            '0'      => 'Off',
        ),
        array(
            'id'       => 'hcode_footer_logo',
            'type'     => 'media',
            'required'  => array('hcode_enable_footer_logo', 'equals', '1'),
            'preview'  => true,
            'url'      => true,
            'title'    => esc_html__( 'Footer Logo', 'H-Code' ),
        ),
        array(
            'id'       => 'hcode_enable_social_icons',
            'type'     => 'switch',
            'title'    => esc_html__('Enable Social Icons', 'H-Code'),
            'default'  => false,
            '1'       => 'On',
            '0'      => 'Off',
        ),
        array(
            'id'        => 'hcode_social_sidebar',
            'type'      => 'select',
            'title'     => esc_html__('Social Sidebar', 'H-Code'),
            'subtitle'  => esc_html__('Select custom sidebar', 'H-Code'),
            'data'      => 'sidebar',
            'default'   => 'footer-social-icons',
            'required'  => array('hcode_enable_social_icons', 'equals', '1'),
        ),
        array(
            'id'       => 'hcode_enable_footer_copyright',
            'type'     => 'switch',
            'title'    => esc_html__('Enable Footer Copyright', 'H-Code'),
            'default'  => false,
            '1'       => 'On',
            '0'      => 'Off',
        ),
        array(
            'id'       => 'hcode_footer_copyright',
            'type'     => 'textarea',
            'title'    => esc_html__( 'Copyright', 'H-Code' ),
            'required'  => array('hcode_enable_footer_copyright', 'equals', '1'),
            'subtitle' => esc_html__( 'Add copyright content here', 'H-Code' ),
        ),
        array(
            'id'       => 'hcode_enable_scrolltotop_button',
            'type'     => 'switch',
            'title'    => esc_html__('Enable ScrollToTop Button', 'H-Code'),
            'default'  => true,
            '1'        => 'On',
            '0'        => 'Off',
        ),
        array(
            'id'       => 'hcode_enable_scrolltotop_button_mobile',
            'type'     => 'switch',
            'title'    => esc_html__('Enable Mobile ScrollToTop Button', 'H-Code'),
            'required'  => array('hcode_enable_scrolltotop_button', 'equals', '0'),
            'default'  => false,
            '1'        => 'On',
            '0'        => 'Off',
        ),
        array(
            'id'       => 'hcode_enable_scrolltotop_button_position',
            'type'     => 'switch',
            'title'    => esc_html__('ScrollToTop Button Right Position', 'H-Code'),
            'subtitle' => esc_html__( 'If off, a ScrollToTop Button will be displayed in Left Position.', 'H-Code' ),
            'default'  => true,
            '1'        => 'On',
            '0'        => 'Off',
        ),
    )
);