<?php
/**
 * Social Profiles Default Class.
 *
 * @package     Redux
 * @subpackage  Extensions
 * @author      Kevin Provance (kprovance)
 */

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Redux_Social_Profiles_Defaults' ) ) {

	/**
	 * Class Redux_Social_Profiles_Defaults
	 */
	class Redux_Social_Profiles_Defaults {

		/**
		 * Get defaults array.
		 *
		 * @return array
		 */
		public static function get_social_media_defaults(): array {
			return array(
				0  => array(
					'id'         => 'adn',
					'icon'       => 'fa-adn',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'ADN', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 0,
				),
				1  => array(
					'id'         => 'android',
					'icon'       => 'fa-android',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Android', 'H-Code' ),
					'background' => '',
					'color'      => '#A4C639',
					'url'        => '',
					'order'      => 1,
				),
				2  => array(
					'id'         => 'apple',
					'icon'       => 'fa-apple',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Apple', 'H-Code' ),
					'style'      => '',
					'background' => '',
					'color'      => '#e4e4e5',
					'url'        => '',
					'order'      => 2,
				),
				3  => array(
					'id'         => 'behance',
					'icon'       => 'fa-behance',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'behance', 'H-Code' ),
					'background' => '',
					'color'      => '#1769ff',
					'url'        => '',
					'order'      => 3,
				),
				4  => array(
					'id'         => 'behance-square',
					'icon'       => 'fa-behance-square',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'behance square', 'H-Code' ),
					'background' => '',
					'color'      => '#1769ff',
					'url'        => '',
					'order'      => 4,
				),
				5  => array(
					'id'         => 'bitbucket',
					'icon'       => 'fa-bitbucket',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Bitbucket', 'H-Code' ),
					'background' => '',
					'color'      => '#205081',
					'url'        => '',
					'order'      => 5,
				),
				6  => array(
					'id'         => 'bitbucket-square',
					'icon'       => 'fa-bitbucket-square',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Bitbucket square', 'H-Code' ),
					'background' => '',
					'color'      => '#205081',
					'url'        => '',
					'order'      => 6,
				),
				7  => array(
					'id'         => 'bitcoin',
					'icon'       => 'fa-btc',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Bitcoin', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 7,
				),
				8  => array(
					'id'         => 'codepen',
					'icon'       => 'fa-codepen',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'CodePen', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 8,
				),
				9  => array(
					'id'         => 'css3',
					'icon'       => 'fa-css3',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'CSS3', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 9,
				),
				10 => array(
					'id'         => 'delicious',
					'icon'       => 'fa-delicious',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Delicious', 'H-Code' ),
					'background' => '',
					'color'      => '#3399ff',
					'url'        => '',
					'order'      => 10,
				),
				11 => array(
					'id'         => 'deviantart',
					'icon'       => 'fa-deviantart',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Deviantart', 'H-Code' ),
					'background' => '',
					'color'      => '#4e6252',
					'url'        => '',
					'order'      => 11,
				),
				12 => array(
					'id'         => 'digg',
					'icon'       => 'fa-digg',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Digg', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 12,
				),
				13 => array(
					'id'         => 'dribbble',
					'icon'       => 'fa-dribbble',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Dribbble', 'H-Code' ),
					'background' => '',
					'color'      => '#444444',
					'url'        => '',
					'order'      => 13,
				),
				14 => array(
					'id'         => 'dropbox',
					'icon'       => 'fa-dropbox',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Dropbox', 'H-Code' ),
					'background' => '',
					'color'      => '#007ee5',
					'url'        => '',
					'order'      => 14,
				),
				15 => array(
					'id'         => 'drupal',
					'icon'       => 'fa-drupal',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Drupal', 'H-Code' ),
					'background' => '',
					'color'      => '#0077c0',
					'url'        => '',
					'order'      => 15,
				),
				16 => array(
					'id'         => 'empire',
					'icon'       => 'fa-empire',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Empire', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 16,
				),
				17 => array(
					'id'         => 'facebook',
					'icon'       => 'fa-facebook',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Facebook', 'H-Code' ),
					'background' => '',
					'color'      => '#3b5998',
					'url'        => '',
					'order'      => 17,
				),
				18 => array(
					'id'         => 'facebook-square',
					'icon'       => 'fa-facebook-square',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Facebook square', 'H-Code' ),
					'background' => '',
					'color'      => '#3b5998',
					'url'        => '',
					'order'      => 18,
				),
				19 => array(
					'id'         => 'flickr',
					'icon'       => 'fa-flickr',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Flickr', 'H-Code' ),
					'background' => '',
					'color'      => '#0063dc',
					'url'        => '',
					'order'      => 19,
				),
				20 => array(
					'id'         => 'foursquare',
					'icon'       => 'fa-foursquare',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'FourSquare', 'H-Code' ),
					'background' => '',
					'color'      => '#0072b1',
					'url'        => '',
					'order'      => 20,
				),
				21 => array(
					'id'         => 'git',
					'icon'       => 'fa-git',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'git', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 21,
				),
				22 => array(
					'id'         => 'git-square',
					'icon'       => 'fa-git-square',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'git square', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 22,
				),
				23 => array(
					'id'         => 'github',
					'icon'       => 'fa-github',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'github', 'H-Code' ),
					'background' => '',
					'color'      => '#4183c4',
					'url'        => '',
					'order'      => 23,
				),
				24 => array(
					'id'         => 'github-alt',
					'icon'       => 'fa-github-alt',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'github alt', 'H-Code' ),
					'background' => '',
					'color'      => '#4183c4',
					'url'        => '',
					'order'      => 24,
				),
				25 => array(
					'id'         => 'github-square',
					'icon'       => 'fa-github-square',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'github square', 'H-Code' ),
					'background' => '',
					'color'      => '#4183c4',
					'url'        => '',
					'order'      => 25,
				),
				26 => array(
					'id'         => 'gittip',
					'icon'       => 'fa-gittip',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'git tip', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 26,
				),
				27 => array(
					'id'         => 'google',
					'icon'       => 'fa-google',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Google', 'H-Code' ),
					'background' => '',
					'color'      => '#dd4b39',
					'url'        => '',
					'order'      => 27,
				),
				28 => array(
					'id'         => 'google-plus',
					'icon'       => 'fa-google-plus',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Google Plus', 'H-Code' ),
					'background' => '',
					'color'      => '#dd4b39',
					'url'        => '',
					'order'      => 28,
				),
				29 => array(
					'id'         => 'google-plus-square',
					'icon'       => 'fa-google-plus-square',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Google Plus square', 'H-Code' ),
					'background' => '',
					'color'      => '#dd4b39',
					'url'        => '',
					'order'      => 29,
				),
				30 => array(
					'id'         => 'hacker-news',
					'icon'       => 'fa-hacker-news',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Hacker News', 'H-Code' ),
					'background' => '',
					'color'      => '#ff6600',
					'url'        => '',
					'order'      => 30,
				),
				31 => array(
					'id'         => 'html5',
					'icon'       => 'fa-html5',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'HTML5', 'H-Code' ),
					'background' => '',
					'color'      => '#e34f26',
					'url'        => '',
					'order'      => 31,
				),
				32 => array(
					'id'         => 'instagram',
					'icon'       => 'fa-instagram',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Instagram', 'H-Code' ),
					'background' => '',
					'color'      => '#3f729b',
					'url'        => '',
					'order'      => 32,
				),
				33 => array(
					'id'         => 'joomla',
					'icon'       => 'fa-joomla',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Joomla', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 33,
				),
				34 => array(
					'id'         => 'jsfiddle',
					'icon'       => 'fa-jsfiddle',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'JS Fiddle', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 34,
				),
				35 => array(
					'id'         => 'linkedin',
					'icon'       => 'fa-linkedin',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'LinkedIn', 'H-Code' ),
					'background' => '',
					'color'      => '#0976b4',
					'url'        => '',
					'order'      => 35,
				),
				36 => array(
					'id'         => 'linkedin-square',
					'icon'       => 'fa-linkedin-square',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'LinkedIn square', 'H-Code' ),
					'background' => '',
					'color'      => '#0976b4',
					'url'        => '',
					'order'      => 36,
				),
				37 => array(
					'id'         => 'linux',
					'icon'       => 'fa-linux',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Linux', 'H-Code' ),
					'background' => '',
					'color'      => '#333333',
					'url'        => '',
					'order'      => 37,
				),
				38 => array(
					'id'         => 'maxcdn',
					'icon'       => 'fa-maxcdn',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'MaxCDN', 'H-Code' ),
					'background' => '',
					'color'      => '#f8711e',
					'url'        => '',
					'order'      => 38,
				),
				39 => array(
					'id'         => 'openid',
					'icon'       => 'fa-openid',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'OpenID', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 39,
				),
				40 => array(
					'id'         => 'pagelines',
					'icon'       => 'fa-pagelines',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Page Lines', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 40,
				),
				41 => array(
					'id'         => 'pied-piper',
					'icon'       => 'fa-pied-piper',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Pied Piper', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 41,
				),
				42 => array(
					'id'         => 'pied-piper-alt',
					'icon'       => 'fa-pied-piper-alt',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Pied Piper alt', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 42,
				),
				43 => array(
					'id'         => 'pinterest',
					'icon'       => 'fa-pinterest',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Pinterest', 'H-Code' ),
					'background' => '',
					'color'      => '#1769ff',
					'url'        => '',
					'order'      => 43,
				),
				44 => array(
					'id'         => 'pinterest-square',
					'icon'       => 'fa-pinterest-square',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Pinterest square', 'H-Code' ),
					'background' => '',
					'color'      => '#1769ff',
					'url'        => '',
					'order'      => 44,
				),
				45 => array(
					'id'         => 'qq',
					'icon'       => 'fa-qq',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'QQ', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 45,
				),
				46 => array(
					'id'         => 'rebel',
					'icon'       => 'fa-rebel',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Rebel', 'H-Code' ),
					'background' => '',
					'color'      => '#517fa4',
					'url'        => '',
					'order'      => 46,
				),
				47 => array(
					'id'         => 'reddit',
					'icon'       => 'fa-reddit',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Reddit', 'H-Code' ),
					'background' => '',
					'color'      => '#ff4500',
					'url'        => '',
					'order'      => 47,
				),
				48 => array(
					'id'         => 'reddit-square',
					'icon'       => 'fa-reddit-square',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Reddit square', 'H-Code' ),
					'background' => '',
					'color'      => '#ff4500',
					'url'        => '',
					'order'      => 48,
				),
				49 => array(
					'id'         => 'renren',
					'icon'       => 'fa-renren',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Ren Ren', 'H-Code' ),
					'background' => '',
					'color'      => '#007bb6',
					'url'        => '',
					'order'      => 49,
				),
				50 => array(
					'id'         => 'share-alt',
					'icon'       => 'fa-share-alt',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Share alt', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 50,
				),
				51 => array(
					'id'         => 'share-alt-square',
					'icon'       => 'fa-share-alt-square',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Share square', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 51,
				),
				52 => array(
					'id'         => 'skype',
					'icon'       => 'fa-skype',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Skype', 'H-Code' ),
					'background' => '',
					'color'      => '#00aff0',
					'url'        => '',
					'order'      => 52,
				),
				53 => array(
					'id'         => 'slack',
					'icon'       => 'fa-slack',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Slack', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 53,
				),
				54 => array(
					'id'         => 'soundcloud',
					'icon'       => 'fa-soundcloud',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Sound Cloud', 'H-Code' ),
					'background' => '',
					'color'      => '#f80',
					'url'        => '',
					'order'      => 54,
				),
				55 => array(
					'id'         => 'spotify',
					'icon'       => 'fa-spotify',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Spotify', 'H-Code' ),
					'background' => '',
					'color'      => '#7ab800',
					'url'        => '',
					'order'      => 55,
				),
				56 => array(
					'id'         => 'stack-exchange',
					'icon'       => 'fa-stack-exchange',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Stack Exchange', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 56,
				),
				57 => array(
					'id'         => 'stack-overflow',
					'icon'       => 'fa-stack-overflow',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Stack Overflow', 'H-Code' ),
					'background' => '',
					'color'      => '#fe7a15',
					'url'        => '',
					'order'      => 57,
				),
				58 => array(
					'id'         => 'steam',
					'icon'       => 'fa-steam',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Steam', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 58,
				),
				59 => array(
					'id'         => 'steam-square',
					'icon'       => 'fa-steam-square',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Steam square', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 59,
				),
				60 => array(
					'id'         => 'stumbleupon',
					'icon'       => 'fa-stumbleupon',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Stumble Upon', 'H-Code' ),
					'background' => '',
					'color'      => '#eb4924',
					'url'        => '',
					'order'      => 60,
				),
				61 => array(
					'id'         => 'stumbleupon-circle',
					'icon'       => 'fa-stumbleupon-circle',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Stumble Upon circle', 'H-Code' ),
					'background' => '',
					'color'      => '#eb4924',
					'url'        => '',
					'order'      => 61,
				),
				62 => array(
					'id'         => 'tencent-weibo',
					'icon'       => 'fa-tencent-weibo',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Tencent Weibo', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 62,
				),
				63 => array(
					'id'         => 'trello',
					'icon'       => 'fa-trello',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Trello', 'H-Code' ),
					'background' => '',
					'color'      => '#256a92',
					'url'        => '',
					'order'      => 63,
				),
				64 => array(
					'id'         => 'tumblr',
					'icon'       => 'fa-tumblr',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Tumblr', 'H-Code' ),
					'background' => '',
					'color'      => '#35465c',
					'url'        => '',
					'order'      => 64,
				),
				65 => array(
					'id'         => 'tumblr-square',
					'icon'       => 'fa-tumblr-square',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Tumblr square', 'H-Code' ),
					'background' => '',
					'color'      => '#35465c',
					'url'        => '',
					'order'      => 65,
				),
				66 => array(
					'id'         => 'twitter',
					'icon'       => 'fa-x-twitter',
					'class'      => 'fa-brands',
					'enabled'    => false,
					'name'       => esc_html__( 'X', 'H-Code' ),
					'background' => '',
					'color'      => '#55acee',
					'url'        => '',
					'order'      => 66,
				),
				67 => array(
					'id'         => 'twitter-square',
					'icon'       => 'fa-square-x-twitter',
					'class'      => 'fa-brands',
					'enabled'    => false,
					'name'       => esc_html__( 'X square', 'H-Code' ),
					'background' => '',
					'color'      => '#55acee',
					'url'        => '',
					'order'      => 67,
				),
				68 => array(
					'id'         => 'vimeo-square',
					'icon'       => 'fa-vimeo-square',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Vimeo square', 'H-Code' ),
					'background' => '',
					'color'      => '#1ab7ea',
					'url'        => '',
					'order'      => 68,
				),
				69 => array(
					'id'         => 'vine',
					'icon'       => 'fa-vine',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Vine', 'H-Code' ),
					'background' => '',
					'color'      => '#00b488',
					'url'        => '',
					'order'      => 69,
				),
				70 => array(
					'id'         => 'vk',
					'icon'       => 'fa-vk',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'VK', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 70,
				),
				71 => array(
					'id'         => 'weibo',
					'icon'       => 'fa-weibo',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Weibo', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 71,
				),
				72 => array(
					'id'         => 'weixin',
					'icon'       => 'fa-weixin',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Weixin', 'H-Code' ),
					'background' => '',
					'color'      => '#000000',
					'url'        => '',
					'order'      => 72,
				),
				73 => array(
					'id'         => 'windows',
					'icon'       => 'fa-windows',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Windows', 'H-Code' ),
					'background' => '',
					'color'      => '#00bcf2',
					'url'        => '',
					'order'      => 73,
				),
				74 => array(
					'id'         => 'wordpress',
					'icon'       => 'fa-wordpress',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'WordPress', 'H-Code' ),
					'background' => '',
					'color'      => '#21759b',
					'url'        => '',
					'order'      => 74,
				),
				75 => array(
					'id'         => 'xing',
					'icon'       => 'fa-xing',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Xing', 'H-Code' ),
					'background' => '',
					'color'      => '#026466',
					'url'        => '',
					'order'      => 75,
				),
				76 => array(
					'id'         => 'xing-square',
					'icon'       => 'fa-xing-square',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Xing square', 'H-Code' ),
					'background' => '',
					'color'      => '#026466',
					'url'        => '',
					'order'      => 76,
				),
				77 => array(
					'id'         => 'yahoo',
					'icon'       => 'fa-yahoo',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Yahoo', 'H-Code' ),
					'background' => '',
					'color'      => '#400191',
					'url'        => '',
					'order'      => 77,
				),
				78 => array(
					'id'         => 'yelp',
					'icon'       => 'fa-yelp',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'Yelp', 'H-Code' ),
					'background' => '',
					'color'      => '#C93C27',
					'url'        => '',
					'order'      => 78,
				),
				79 => array(
					'id'         => 'youtube',
					'icon'       => 'fa-youtube',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'YouTube', 'H-Code' ),
					'background' => '',
					'color'      => '#e52d27',
					'url'        => '',
					'order'      => 79,
				),
				80 => array(
					'id'         => 'youtube-play',
					'icon'       => 'fa-youtube-play',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'YouTube play', 'H-Code' ),
					'background' => '',
					'color'      => '#e52d27',
					'url'        => '',
					'order'      => 80,
				),
				81 => array(
					'id'         => 'youtube-square',
					'icon'       => 'fa-youtube-square',
					'class'      => 'fa',
					'enabled'    => false,
					'name'       => esc_html__( 'YouTube square', 'H-Code' ),
					'background' => '',
					'color'      => '#e52d27',
					'url'        => '',
					'order'      => 81,
				),
			);
		}
	}
}
