<?php
/**
 * H-Code Addons plugin update notice
 *
 */

if( !class_exists( 'Hcode_Addons_Update_Plugin_Notice' ) ) {
	class Hcode_Addons_Update_Plugin_Notice {
		
		private $hcode_addons_current_version;
		private $hcode_addons_update_path;
		private $hcode_addons_plugin_slug;
		private $slug;

		public function __construct( $hcode_addons_current_version, $hcode_addons_update_path, $hcode_addons_plugin_slug ) {
			
			// Set the class public variables
			$this->hcode_addons_current_version = $hcode_addons_current_version;
			$this->hcode_addons_update_path = $hcode_addons_update_path;
			$this->hcode_addons_plugin_slug = $hcode_addons_plugin_slug;

			list ($t1, $t2) = explode( '/', $hcode_addons_plugin_slug );
			$this->slug = str_replace( '.php', '', $t2 );		

			// define the alternative API for updating checking
			add_filter( 'pre_set_site_transient_update_plugins', array( $this, 'hcode_addons_check_plugin_update' ) );

			// Define the alternative response for information checking
			add_filter( 'plugins_api', array( $this, 'hcode_addons_check_plugin_info' ), 10, 3 );
		}

		public function hcode_addons_check_plugin_update( $transient ) {
			if ( empty( $transient->checked ) ) {
				return $transient;
			}

			$remote_version = $this->hcode_addons_getremote( 'version' );
			//print_r($remote_version);die;
			if( isset( $remote_version->new_version ) ){
				if ( version_compare( $this->hcode_addons_current_version, $remote_version->new_version, '<' ) ) {
					$obj = new stdClass();
					$obj->slug = $this->slug;
					$obj->new_version = $remote_version->new_version;
					$obj->plugin = $this->hcode_addons_plugin_slug;
					$transient->response[$this->hcode_addons_plugin_slug] = $obj;
				}
			}
			return $transient;
		}

		public function hcode_addons_check_plugin_info( $obj, $action, $arg ) {
			if( ( 'query_plugins' === $action || 'plugin_information' === $action ) && isset( $arg->slug ) && $arg->slug === $this->slug ) {
				return $this->hcode_addons_getremote( 'info' );
			}
			
			return $obj;
		}

		public function hcode_addons_getremote( $action = '' ) {
			$params = array(
				'timeout' => 45,
				'body' => array(
					'action' => $action,
				),
			);
			
			$request = wp_remote_post( $this->hcode_addons_update_path, $params );
			
			if ( !is_wp_error( $request ) || 200 === wp_remote_retrieve_response_code( $request ) ) {
				return @unserialize( $request['body'] );
			}
			
			return false;
		}
	}
}