<?php
/**
 * Shortcode For Related Product Block
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Related Product Block */
/*-----------------------------------------------------------------------------------*/

if ( ! function_exists( 'hcode_recent_products_shortcode' ) ) {
    function hcode_recent_products_shortcode( $atts, $content = null ) {
        if(!class_exists( 'WooCommerce' )){
            return false;
        }
        $atts = shortcode_atts( array(
            'class' =>'',
            'id' => '',
            'recent_product_type' => '',
            'per_page'  => '12',
            'columns'   => '4',
            'orderby'   => 'date',
            'order'     => 'desc',
            'desktop_per_page' => '3',
            'mini_desktop_per_page' => '3',
            'ipad_per_page' => '3',
            'mobile_per_page' => '1',
            'hcode_related_title_font_settings' => '',
            'hcode_related_title_color' => '',
            'hcode_related_title_hover_color' => '',
            'hcode_related_price_font_settings' => '',
            'hcode_related_price_color' => '',
            'poduct_related_button_settings' => '',
        ), $atts );
        
        global $hcode_featured_array, $font_settings_array, $hcode_blog_token;

        $hcode_blog_token       = !empty( $hcode_blog_token ) ? $hcode_blog_token : 0;
        $hcode_blog_token       = $hcode_blog_token + 1;
        $hcode_token_class      = 'hcode-blog-'.$hcode_blog_token;

        $hcode_related_title_font_settings_id = $hcode_related_title_font_settings_id_style = $hcode_related_title_font_settings_id_class = $hcode_related_price_font_settings_id = $hcode_related_price_font_settings_id_style = $hcode_related_price_font_settings_id_class = '';

        $responsive_id='';
        if( !empty( $atts['poduct_related_button_settings'] ) ) {
            $responsive_style = Hcode_Font_Color_Settings::generate_css( $atts['poduct_related_button_settings'], $responsive_id.'product-share.'.$hcode_token_class.' a' );
        } 
        (!empty( $responsive_style)) ? $hcode_featured_array[] = $responsive_style : '';


        // Product Title settings
        if( !empty( $atts['hcode_related_title_font_settings'] ) ) {
            $hcode_related_title_font_settings_id = uniqid('hcode-font-setting-');
            $hcode_related_title_font_settings_id_style = Hcode_Responsive_Font_Settings::generate_css( $atts['hcode_related_title_font_settings'], $hcode_related_title_font_settings_id );
            $hcode_related_title_font_settings_id_class = ' '.$hcode_related_title_font_settings_id;
        }

        // Product Price settings
        if( !empty( $atts['hcode_related_price_font_settings'] ) ) {
            $hcode_related_price_font_settings_id = uniqid('hcode-font-setting-');
            $hcode_related_price_font_settings_id_style = Hcode_Responsive_Font_Settings::generate_css( $atts['hcode_related_price_font_settings'], $hcode_related_price_font_settings_id.' .'.$hcode_token_class.' + .price del, .'.$hcode_token_class.' + .price ins, .'.$hcode_token_class.' + .price .amount' );
            $hcode_related_price_font_settings_id_class = ' '.$hcode_related_price_font_settings_id;
        }

        ( !empty( $hcode_related_title_font_settings_id_style ) ) ? $font_settings_array[] = $hcode_related_title_font_settings_id_style : '';
        ( !empty( $hcode_related_price_font_settings_id_style ) ) ? $font_settings_array[] = $hcode_related_price_font_settings_id_style : '';
        
        $product_title_setting = ( $hcode_related_title_font_settings_id_class ) ? 'class="'.$hcode_related_title_font_settings_id_class.'"' : '';

        // Coloe Settings
        !empty( $atts['hcode_related_title_color'] ) ? $hcode_featured_array[] = '.product-name.'.$hcode_token_class.' a { color: '.$atts['hcode_related_title_color'].' !important}' : '';
        !empty( $atts['hcode_related_title_hover_color'] ) ? $hcode_featured_array[] = '.product-name.'.$hcode_token_class.' a:hover { color: '.$atts['hcode_related_title_hover_color'].' !important}' : '';
        !empty( $atts['hcode_related_price_color'] ) ? $hcode_featured_array[] = '.'.$hcode_token_class.' + .price del, .'.$hcode_token_class.' + .price ins, .'.$hcode_token_class.' + .price .amount { color: '.$atts['hcode_related_price_color'].' !important}' : '';
        
        $query_args = array(
            'post_type'           => 'product',
            'post_status'         => 'publish',
            'ignore_sticky_posts' => 1,
            'posts_per_page'      => $atts['per_page'],
            'orderby'             => $atts['orderby'],
            'order'               => $atts['order'],
            'meta_query'          => WC()->query->get_meta_query(),
            'tax_query' => WC()->query->get_tax_query(),
        );

        global $woocommerce_loop;
        $products                    = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $query_args, $atts ) );
        $columns                     = absint( $atts['columns'] );
        $woocommerce_loop['columns'] = $columns;
        $loop_name                   = 'recent_products';
        $id = ( $atts['id'] ) ? ' id= "'.$atts['id'].'"': '';
        $class = ( $atts['class'] ) ? $atts['class']: '';
        
        ob_start();

        if ( $products->have_posts() ) {

            do_action( "woocommerce_shortcode_before_{$loop_name}_loop" );

            if( 'slider' === $atts['recent_product_type'] ) {
            ?>
            <div class="owl-carousel hcode-recent-<?php echo $atts['recent_product_type']?> owl-theme dark-pagination owl-no-pagination owl-prev-next-simple" <?php echo $id;?>>
            <?php } else { ?>
            <div class="product-<?php echo $columns;?>" <?php echo $id;?>>
            <?php
            }
            
            while ( $products->have_posts() ) : $products->the_post();
                    
                global $product, $woocommerce_loop;

                // Store loop count we're currently on
                if ( empty( $woocommerce_loop['loop'] ) ) {
                    $woocommerce_loop['loop'] = 0;
                }
                // Store column count for displaying the grid
                if ( empty( $woocommerce_loop['columns'] ) ) {
                    $woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 4 );
                }
                // Ensure visibility
                if ( ! $product || ! $product->is_visible() ) {
                    return;
                }
                // Increase loop count
                $woocommerce_loop['loop']++;

                // Extra post classes
                $classes = array();
                if ( 0 == ( $woocommerce_loop['loop'] - 1 ) % $woocommerce_loop['columns'] || 1 == $woocommerce_loop['columns'] ) {
                    $classes[] = 'first';
                }
                if ( 0 == $woocommerce_loop['loop'] % $woocommerce_loop['columns'] ) {
                    $classes[] = 'last';
                }
                if($atts['recent_product_type'] == 'slider'){
                    $classes[] = 'item';
                }else{
                    switch ($woocommerce_loop['columns']) {
                        case '6':
                            $set_column = '2';
                            $set_ipad_column = '6';
                            break;
                        case '4':
                            $set_column = '3';
                            $set_ipad_column = '6';
                            break;
                        case '3':
                            $set_column = '4';
                            $set_ipad_column = '6';
                            break;
                        case '2':
                            $set_column = '6';
                            $set_ipad_column = '6';
                            break;
                        case '1':
                            $set_column = '12';
                            $set_ipad_column = '12';
                            break;
                    }
                    $classes[] = 'col-md-'.$set_column.' col-sm-'.$set_ipad_column.' col-xs-12';
                }
                ?>
                <div <?php post_class( $classes ); ?>>
                    <div class="home-product text-center position-relative overflow-hidden margin-ten no-margin-top">
                        <div class="product-image-wrapper">
                            <a href="<?php echo get_permalink(); ?>">
                                <?php 
                                if ( has_post_thumbnail() ) {
                                    the_post_thumbnail( 'shop_catalog' );
                                } elseif ( wc_placeholder_img_src() ) {
                                    echo wc_placeholder_img( 'shop_catalog' );
                                }
                                ?>
                            </a>
                            <?php do_action ( 'hcode_sale_flash' ); ?>
                        </div>
                        <?php
                        echo '<div class="product-content-wrapper'.$hcode_related_price_font_settings_id_class.'">';
                            echo '<span class="product-name text-uppercase '.$hcode_token_class.'">';
                                echo '<a '.$product_title_setting.' href="'.get_permalink().'">';
                                    /**
                                     * woocommerce_shop_loop_item_title hook
                                     *
                                     * @hooked woocommerce_template_loop_product_title - 10
                                     */
                                    wc_get_template( 'loop/title.php' );
                                echo '</a>';
                            echo '</span>';
                            /**
                             * woocommerce_after_shop_loop_item_title hook
                             *
                             * @hooked woocommerce_template_loop_rating - 5
                             * @hooked woocommerce_template_loop_price - 10
                             */
                            do_action( 'woocommerce_after_shop_loop_item_title' );
                            
                            echo '<div class="quick-buy">';
                                echo '<div class="product-share '.$hcode_token_class.'">';
                                    /**
                                     * woocommerce_after_shop_loop_item hook
                                     *
                                     * @hooked woocommerce_template_loop_add_to_cart - 10
                                     */
                                    do_action( 'woocommerce_after_shop_loop_item' );
                                echo '</div>';
                            echo '</div>';
                        echo '</div>';
                        ?>
                    </div>

                </div>
                <?php endwhile; // end of the loop. ?>
            </div>
            <?php do_action( "woocommerce_shortcode_after_{$loop_name}_loop" );
        }

        woocommerce_reset_loop();
        wp_reset_postdata();

        if( 'slider' === $atts['recent_product_type'] ) {
            $slider_rtl_enable = ( is_rtl() ) ? 'true' : 'false';
        ?>
<script type="text/javascript">jQuery(document).ready(function(){ jQuery(".hcode-recent-slider").owlCarousel({ nav: true, rtl: <?php echo $slider_rtl_enable ?> ,loop: true, responsive:{ 0: { items: <?php echo $atts['mobile_per_page']; ?> }, 767: { items: <?php echo $atts['ipad_per_page']; ?> }, 991:{ items: <?php echo $atts['mini_desktop_per_page']; ?> }, 1200:{ items: <?php echo $atts['desktop_per_page']; ?> } }, navText: ["<i class='fa-solid fa-angle-left'></i>", "<i class='fa-solid fa-angle-right'></i>"] }); });</script>
        <?php
        }
        return ob_get_clean();
    }
}
add_shortcode( 'hcode_recent_products', 'hcode_recent_products_shortcode' );