<?php
/**
 * Map For Related Product Block
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Related Product Block */
/*-----------------------------------------------------------------------------------*/

vc_map( array(
      'name' => __( 'New Arrival Products', 'hcode-addons' ),
      'base' => 'hcode_recent_products',
      'category' => 'H-Code',
      'icon' => 'h-code-shortcode-icon fa-solid fa-rocket',
      'description' => __( 'Place new arrival products block', 'hcode-addons' ),
      'params' => array(
        array(
            'type' => 'dropdown',
            'admin_label' => true,
            'heading' => __('Products Block Style', 'hcode-addons'),
            'param_name' => 'recent_product_type',
            'value' => array(__('Select Products Block Style', 'hcode-addons') => '',
                             __('Slider', 'hcode-addons') => 'slider',
                             __('Grid', 'hcode-addons') => 'grid',
          ),
        ), 
        array(
          'type' => 'textfield',
          'heading' => __( 'Show No. of Total Products', 'hcode-addons' ),
          'description' => __( 'Enter numeric value like 6', 'hcode-addons' ),
          'value' => 6,
          'param_name' => 'per_page',
          'dependency'  => array( 'element' => 'recent_product_type', 'not_empty' => true ),
        ),
        array(
          'type' => 'dropdown',
          'admin_label' => true,
          'heading' => __( 'Column Type', 'hcode-addons' ),
          'value' => array(__('Select Column Type', 'hcode-addons') => '',
                           __( '1 Column', 'hcode-addons' ) => '1',
                           __( '2 Columns', 'hcode-addons' ) => '2',
                           __( '3 Columns', 'hcode-addons' ) => '3',
                           __( '4 Columns', 'hcode-addons' ) => '4',
                           __( '6 Columns', 'hcode-addons' ) => '6',
                          ),
          'param_name' => 'columns',
          'dependency'  => array( 'element' => 'recent_product_type', 'value' => array('grid') ),
        ),
        array(
          'type' => 'dropdown',
          'admin_label' => true,
          'heading' => __( 'Display Products Order by', 'hcode-addons' ),
          'param_name' => 'orderby',
          'value' => array(__('Select Order by', 'hcode-addons') => '',
                           __( 'Date', 'hcode-addons' ) => 'date',
                           __( 'ID', 'hcode-addons' ) => 'ID',
                           __( 'Author', 'hcode-addons' ) => 'author',
                           __( 'Title', 'hcode-addons' ) => 'title',
                           __( 'Modified', 'hcode-addons' ) => 'modified',
                           __( 'Random', 'hcode-addons' ) => 'rand',
                           __( 'Comment count', 'hcode-addons' ) => 'comment_count',
                           __( 'Menu order', 'hcode-addons' ) => 'menu_order',
                          ),
          'dependency'  => array( 'element' => 'recent_product_type', 'not_empty' => true ),
        ),
        array(
          'type' => 'dropdown',
          'admin_label' => true,
          'heading' => __( 'Display Products Sort by', 'hcode-addons' ),
          'param_name' => 'order',
          'value' => array(__('Select Sort by', 'hcode-addons') => '',
                           __( 'Descending', 'hcode-addons' ) => 'DESC',
                           __( 'Ascending', 'hcode-addons' ) => 'ASC',
                          ),
          'dependency'  => array( 'element' => 'recent_product_type', 'not_empty' => true ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'No. of Products Per Page (For Desktop Device)', 'hcode-addons' ),
          'description' => __( 'Enter numeric value like 3', 'hcode-addons' ),          
          'value' => '3',
          'param_name' => 'desktop_per_page',
          'dependency'  => array( 'element' => 'recent_product_type', 'value' => array('slider') ),
          'group'       => 'Slider Config'
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'No. of Products Per Page (For Mini Desktop Device)', 'hcode-addons' ),
          'description' => __( 'Enter numeric value like 3', 'hcode-addons' ),          
          'value' => '3',
          'param_name' => 'mini_desktop_per_page',
          'dependency'  => array( 'element' => 'recent_product_type', 'value' => array('slider') ),
          'group'       => 'Slider Config'
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'No. of Products Per Page (For iPad/Tablet Device)', 'hcode-addons' ),
          'description' => __( 'Enter numeric value like 3', 'hcode-addons' ),          
          'value' => '3',
          'param_name' => 'ipad_per_page',
          'dependency'  => array( 'element' => 'recent_product_type', 'value' => array('slider') ),
          'group'       => 'Slider Config'
        ),
        array(
          'type' => 'responsive_font_settings',
          'param_name' => 'hcode_related_title_font_settings',
          'heading' => esc_html__( 'Font Settings For Product Title', 'hcode-addons' ),
          'hide_font_settings_element_lg' => array('text-align'),
          'hide_font_settings_element_md' => array('text-align'),
          'hide_font_settings_element_sm' => array('text-align'),
          'hide_font_settings_element_xs' => array('text-align'),
          'group' => 'Font & Color Settings',
          'dependency'  => array( 'element' => 'recent_product_type', 'value' => array('slider', 'grid') ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => __( 'Product Title Color', 'hcode-addons' ),
          'param_name' => 'hcode_related_title_color',
          'description' => __( 'Choose Product Title Color', 'hcode-addons' ),
          'group' => 'Font & Color Settings',
          'dependency'  => array( 'element' => 'recent_product_type', 'value' => array('slider', 'grid') ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => __( 'Product Title Hover Color', 'hcode-addons' ),
          'param_name' => 'hcode_related_title_hover_color',
          'description' => __( 'Choose Product Title Hover Color', 'hcode-addons' ),
          'group' => 'Font & Color Settings',
          'dependency'  => array( 'element' => 'recent_product_type', 'value' => array('slider', 'grid') ),
        ),
        array(
          'type' => 'responsive_font_settings',
          'param_name' => 'hcode_related_price_font_settings',
          'heading' => esc_html__( 'Font Settings For Product Price', 'hcode-addons' ),
          'hide_font_settings_element_lg' => array('text-align','font-transform'),
          'hide_font_settings_element_md' => array('text-align','font-transform'),
          'hide_font_settings_element_sm' => array('text-align','font-transform'),
          'hide_font_settings_element_xs' => array('text-align','font-transform'),
          'group' => 'Font & Color Settings',
          'dependency'  => array( 'element' => 'recent_product_type', 'value' => array('slider', 'grid') ),
        ),
        array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => __( 'Product Price Color', 'hcode-addons' ),
          'param_name' => 'hcode_related_price_color',
          'description' => __( 'Choose Product Price Color', 'hcode-addons' ),
          'group' => 'Font & Color Settings',
          'dependency'  => array( 'element' => 'recent_product_type', 'value' => array('slider', 'grid') ),
        ),
        array(
            'type'        => 'hcode_button_settings',
            'param_name'  => 'poduct_related_button_settings',
            'heading'     => esc_html__( 'Product Button Font Settings', 'hcode-addons' ),
            'group' => 'Button Configuration',
            'description' => __( 'You can easily set button text-transform, font-size, line-height, letter-spacing for all devices ', 'hcode-addons' ),
            'hide_font_settings_element' => array( 'text-align', 'icon-color', 'icon-hover-color' ),
            'dependency'  => array( 'element' => 'recent_product_type', 'value' => array('slider', 'grid') ),
          ),
        array(
          'type' => 'textfield',
          'heading' => __( 'No. of Products Per Page (For Mobile Device)', 'hcode-addons' ),
          'description' => __( 'Enter numeric value like 1', 'hcode-addons' ),          
          'value' => '1',
          'param_name' => 'mobile_per_page',
          'dependency'  => array( 'element' => 'recent_product_type', 'value' => array('slider') ),
          'group'       => 'Slider Config'
        ),
        $hcode_vc_extra_id,
        $hcode_vc_extra_class,
      )
    ) );