<?php
/**
 * Map For Row
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Row */
/*-----------------------------------------------------------------------------------*/

vc_map( 
  array(
      'name' => __( 'Inner Row' , 'hcode-addons' ),
      'base' => 'vc_row_inner',
      'content_element' => false,
      'description' => __( 'Place content elements inside the inner row','hcode-addons' ),
      'icon' => 'fa-solid fa-th h-code-shortcode-icon',
      'is_container' => true,
      'js_view' => 'VcRowView',
      'category' => 'H-Code',
      'params' => array(
          array(
            'type' => 'dropdown',
            'param_name' => 'hcode_row_style',
            'heading' => __( 'Please Select Row Style','hcode-addons' ),
            'value' => array(__('Please Select Row Style', 'hcode-addons') => '',
                             __('Color', 'hcode-addons') => 'color',
                             __('Image', 'hcode-addons') => 'image',
                            ),
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => __( 'Background Color', 'hcode-addons' ),
            'param_name' => 'hcode_row_bg_color',
            'dependency' => array( 'element' => 'hcode_row_style', 'value' => array('color') ),
          ),
          array(
            'type' => 'attach_image',
            'heading' => __( 'Background Image', 'hcode-addons' ),
            'param_name' => 'hcode_row_bg_image',
            'dependency' => array( 'element' => 'hcode_row_style', 'value' => array('image') ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'hcode_row_image_type',
            'heading' => __( 'Background Image Type', 'hcode-addons' ),
            'value' => array(__('Select Background Image Type', 'hcode-addons') => '',
                             __('Parallax', 'hcode-addons') => 'parallax',
                             __('Background Image', 'hcode-addons') => 'background-image',
                            ),
            'dependency' => array( 'element' => 'hcode_row_style', 'value' => array('image') ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'hcode_bg_image_type', 
            'heading' => __( 'Background Image Type', 'hcode-addons' ),
            'value' => array(__('Select Background Image Type', 'hcode-addons') => '',
                             __('Fix Background', 'hcode-addons') => 'fix-background',
                             __('Cover Background', 'hcode-addons') => 'cover-background',
                             __('Fill Background', 'hcode-addons') => 'fill',
                            ),
            'dependency' => array( 'element' => 'hcode_row_image_type', 'value' => array('background-image') ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'hcode_parallax_image_type',
            'heading' => __('Parallax Type', 'hcode-addons' ),
            'value' => array(__('no parallax', 'hcode-addons') => '',
                             __('Parallax1', 'hcode-addons') => 'parallax1',
                             __('Parallax2', 'hcode-addons') => 'parallax2',
                             __('Parallax3', 'hcode-addons') => 'parallax3',
                             __('Parallax4', 'hcode-addons') => 'parallax4',
                             __('Parallax5', 'hcode-addons') => 'parallax5',
                             __('Parallax6', 'hcode-addons') => 'parallax6',
                             __('Parallax7', 'hcode-addons') => 'parallax7',
                             __('Parallax8', 'hcode-addons') => 'parallax8',
                             __('Parallax9', 'hcode-addons') => 'parallax9',
                             __('Parallax10', 'hcode-addons') => 'parallax10',
                             __('Parallax11', 'hcode-addons') => 'parallax11',
                             __('Parallax12', 'hcode-addons') => 'parallax12',
                            ),
            'dependency' => array( 'element' => 'hcode_row_image_type', 'value' => array('parallax') ),
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'class' => '',
                'heading' => __( 'Disable row', 'hcode-addons' ),
                'param_name' => 'disable_element', // Inner param name.
                'value' => array(__('NO', 'hcode-addons') => '', 
                                 __('YES', 'hcode-addons') => '1'
                                ),
                'description' => __( 'If selected YES the row won\'t be visible on the public side of your website. You can switch it back any time.', 'hcode-addons' ),
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'class' => '',
                'heading' => __('Overlay Div', 'hcode-addons'),
                'param_name' => 'show_overlay',
                'value' => array(__('OFF', 'hcode-addons') => '0', 
                                 __('ON', 'hcode-addons') => '1'
                                ),
                'dependency' => array( 'element' => 'hcode_row_style', 'value' => array('image') ),
                'description' => __( 'Select ON to show overlay in row', 'hcode-addons' ),
                'group' => 'Opacity',
          ),
          array(
                'type' => 'hcode_custom_switch_option',
                'class' => '',
                'heading' => __('Hide Background For Mobile Device', 'hcode-addons'),
                'param_name' => 'hide_background',
                'value' => array(__('NO', 'hcode-addons') => '0', 
                                 __('YES', 'hcode-addons') => '1'
                                ),
                'description' => __( 'Select Yes to hide background in mobile device', 'hcode-addons' ),
                'dependency' => array( 'element' => 'hcode_row_style', 'value' => array('image') ),
                'group' => 'Hide Background',
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'hcode_overlay_opacity',
            'heading' => __('Overlay Opacity', 'hcode-addons'),
            'value' => array(__('no opacity', 'hcode-addons') => '',
                             __('0.1', 'hcode-addons') => '0.1',
                             __('0.2', 'hcode-addons') => '0.2',
                             __('0.3', 'hcode-addons') => '0.3',
                             __('0.4', 'hcode-addons') => '0.4',
                             __('0.5', 'hcode-addons') => '0.5',
                             __('0.6', 'hcode-addons') => '0.6',
                             __('0.7', 'hcode-addons') => '0.7',
                             __('0.8', 'hcode-addons') => '0.8',
                             __('0.9', 'hcode-addons') => '0.9',
                             __('1.0', 'hcode-addons') => '1.0',
                            ),
            'dependency' => array( 'element' => 'show_overlay', 'value' => array('1') ),
            'group' => 'Opacity',
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => __( 'Overlay Color', 'hcode-addons' ),
            'param_name' => 'hcode_row_overlay_color',
            'dependency' => array( 'element' => 'show_overlay', 'value' => array('1') ),
            'group' => 'Opacity',
          ),
          array(
            'type' => 'textfield',
            'heading' => __( 'Z Index', 'hcode-addons'),
            'param_name' => 'hcode_z_index',
            'dependency' => array( 'element' => 'show_overlay', 'value' => array('1') ),
            'group' => 'Opacity',
          ),
          array(
              'type' => 'hcode_custom_switch_option',
              'class' => '',
              'heading' => __('Position Relative', 'hcode-addons'),
              'param_name' => 'position_relative',
              'value' => array(__('OFF', 'hcode-addons') => '0', 
                               __('ON', 'hcode-addons') => '1'
                              ),
          ),
          array(
              'type' => 'hcode_custom_switch_option',
              'class' => '',
              'heading' => __('Overflow Hidden', 'hcode-addons'),
              'param_name' => 'overflow_hidden',
              'value' => array(__('OFF', 'hcode-addons') => '0', 
                               __('ON', 'hcode-addons') => '1'
                              ),
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'hcode_row_border_position',
            'heading' => __('Row Border Position', 'hcode-addons' ),
            'value' => array(__('No Border', 'hcode-addons') => '',
                             __('Border Top', 'hcode-addons') => 'border-top',
                             __('Border Bottom', 'hcode-addons') => 'border-bottom',
                            ),
            'group' => 'Style',
          ),
          array(
            'type' => 'colorpicker',
            'class' => '',
            'heading' => __( 'Border Color', 'hcode-addons' ),
            'param_name' => 'hcode_row_border_color',
            'dependency' => array( 'element' => 'hcode_row_border_position', 'value' => array('border-top','border-bottom') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'heading' => __( 'Border Size', 'hcode-addons' ),
            'param_name' => 'hcode_border_size',
            'dependency' => array( 'element' => 'hcode_row_border_position', 'value' => array('border-top','border-bottom') ),
            'description' => __( 'Define border size like 2px', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'hcode_border_type',
            'heading' => __( 'Border Type', 'hcode-addons' ),
            'value' => array(__('no border', 'hcode-addons') => '',
                             __('Dotted', 'hcode-addons') => 'dotted',
                             __('Dashed', 'hcode-addons') => 'dashed',
                             __('Solid', 'hcode-addons') => 'solid',
                             __('Double', 'hcode-addons') => 'double',
                            ),
            'dependency' => array( 'element' => 'hcode_row_border_position', 'value' => array('border-top','border-bottom') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_switch_option',
            'class' => '',
            'heading' => __('Required Padding Setting?', 'hcode-addons'),
            'param_name' => 'padding_setting',
            'value' => array(__('No', 'hcode-addons') => '0', 
                             __('Yes', 'hcode-addons') => '1'
                            ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_desktop_padding',
            'param_name' => 'desktop_padding',
            'heading' => __('Padding (For Desktop Device)', 'hcode-addons' ),
            'value' => '',
            'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Custom Padding (For Desktop Devices)', 'hcode-addons' ),
            'param_name' => 'custom_desktop_padding',
            'dependency' => array( 'element' => 'desktop_padding', 'value' => array('custom-desktop-padding') ),
            'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),

            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_ipad_padding',
            'param_name' => 'ipad_padding',
            'heading' => __('Padding (For iPad Device)', 'hcode-addons' ),
            'value' => '',
            'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Custom Padding (For iPad Devices)', 'hcode-addons' ),
            'param_name' => 'custom_ipad_padding',
            'dependency' => array( 'element' => 'ipad_padding', 'value' => array('custom-ipad-padding') ),
            'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_mobile_padding',
            'param_name' => 'mobile_padding',
            'heading' => __('Padding (For Mobile Device)', 'hcode-addons' ),
            'value' => '',
            'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Custom Padding (For Mobile Devices)', 'hcode-addons' ),
            'param_name' => 'custom_mobile_padding',
            'dependency' => array( 'element' => 'mobile_padding', 'value' => array('custom-mobile-padding') ),
            'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_switch_option',
            'class' => '',
            'heading' => __('Required Margin Setting?', 'hcode-addons'),
            'param_name' => 'margin_setting',
            'value' => array(__('No', 'hcode-addons') => '0', 
                             __('Yes', 'hcode-addons') => '1'
                            ),
              'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_desktop_margin',
            'param_name' => 'desktop_margin',
            'heading' => __('Margin (For Desktop Device)', 'hcode-addons' ),
            'value' => '',
            'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Custom Margin (For Desktop Devices)', 'hcode-addons' ),
            'param_name' => 'custom_desktop_margin',
            'dependency' => array( 'element' => 'desktop_margin', 'value' => array('custom-desktop-margin') ),
            'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_ipad_margin',
            'param_name' => 'ipad_margin',
            'heading' => __('Margin (For iPad Device)', 'hcode-addons' ),
            'value' => '',
            'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Custom Margin (For iPad Devices)', 'hcode-addons' ),
            'param_name' => 'custom_ipad_margin',
            'dependency' => array( 'element' => 'ipad_margin', 'value' => array('custom-ipad-margin') ),
            'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_mobile_margin',
            'param_name' => 'mobile_margin',
            'heading' => __('Margin (For Mobile Device)', 'hcode-addons' ),
            'value' => '',
            'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Custom Margin (For Mobile Devices)', 'hcode-addons' ),
            'param_name' => 'custom_mobile_margin',
            'dependency' => array( 'element' => 'mobile_margin', 'value' => array('custom-mobile-margin') ),
            'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'param_name' => 'hcode_min_height',
            'heading' => __('Min Height ( For Desktop )', 'hcode-addons' ),
            'value' => '',
            'edit_field_class' => 'vc_col-sm-4',
            'description' => __( 'Define min height like 500px', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'param_name' => 'hcode_min_height_ipad',
            'heading' => __('Min Height ( For iPad)', 'hcode-addons' ),
            'value' => '',
            'edit_field_class' => 'vc_col-sm-4',
            'description' => __( 'Define min height like 500px', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'param_name' => 'hcode_min_height_mobile',
            'heading' => __('Min Height ( For Mobile )', 'hcode-addons' ),
            'value' => '',
            'edit_field_class' => 'vc_col-sm-4',
            'description' => __( 'Define min height like 500px', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_srcset',
            'param_name' => 'hcode_image_srcset',
            'heading' => __('Image SRCSET', 'hcode-addons' ),
            'value' => 'full',
            'dependency' => array( 'element' => 'hcode_row_style', 'value' => array('image') ),
            'group' => 'SRCSET',
          ),
          array(
            'type' => 'hcode_animation_style',
            'param_name' => 'hcode_row_animation_style',
            'heading' => __('Animation Style', 'hcode-addons' ),
            'value' => '',
            'group' => 'Animation',
          ),
          array(
            'type' => 'css_editor',
            'heading' => __( 'Css box', 'hcode-addons' ),
            'param_name' => 'css',
            'group' => __( 'Design options', 'hcode-addons' ),
          ),
          $hcode_vc_extra_id,
          $hcode_vc_extra_class,
      ),
  )
);