<?php
/**
 * Map For Counter or Skill
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Hcode Counter or Skill */
/*-----------------------------------------------------------------------------------*/
vc_map( 
  array(
    'name' => __( 'Counter and Skills', 'hcode-addons' ),
    'base' => 'hcode_counter_or_skill',
    'category' => 'H-Code',
    'description' => __( 'Place a counter and skills', 'hcode-addons' ),
    'icon' => 'fa-regular fa-clock h-code-shortcode-icon', //URL or CSS class with icon image.
    'params' => array(
      array(
          'type' => 'dropdown',
          'class' => '',
          'heading' => __('Counter or Skill', 'hcode-addons'),
          'param_name' => 'counter_or_chart',
          'value' => array(__('Select Counter or Skill', 'hcode-addons') => '',
                           __('Counter', 'hcode-addons') => 'counter',
                           __('Skill', 'hcode-addons') => 'skill',
                          ),
      ),
      array(
          'type' => 'hcode_preview_image',
          'heading' => __('Select pre-made style', 'hcode-addons'),
          'param_name' => 'hcode_counter_skill_preview_image',
      ),
      array(
          'type' => 'dropdown',
          'class' => '',
          'heading' => __('Counter Style', 'hcode-addons'),
          'param_name' => 'counter_style',
          'value' => array(__('Style 1', 'hcode-addons') => 'style-1',
                           __('Style 2', 'hcode-addons') => 'style-2',
                          ),
          'std' => 'style-1',
          'dependency'  => array( 'element' => 'counter_or_chart', 'value' => array('counter') ),
      ),
      array(
        'type' => 'hcode_custom_switch_option',
        'heading' => __('Custom Icon', 'hcode-addons'),
        'param_name' => 'custom_icon',
        'value' => array(__('NO', 'hcode-addons') => '0',
                         __('YES', 'hcode-addons') => '1'
                        ),
        'dependency'  => array( 'element' => 'counter_or_chart', 'value' => array('counter') ),
      ),
      array(
        'type' => 'attach_image',
        'heading' => __('Custom Icon Image', 'hcode-addons'),
        'param_name' => 'custom_icon_image',
        'dependency' => array( 'element' => 'custom_icon', 'value' => '1' ),
        'description' => __( 'Recommended size: Extra Large - 60px X 60px, Large - 50px X 50px, Medium - 40px X 40px, Small - 25px X 25px, Extra Small - 18px X 18px', 'hcode-addons' ),
      ),
      array(
          'type' => 'hcode_icon',
          'heading' => __('Select Counter Icon', 'hcode-addons'),
          'param_name' => 'counter_icon',
          'value' => '',
          'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),
      ),
      array(
          'type' => 'textfield',
          'heading' => __('Percentage', 'hcode-addons'),
          'param_name' => 'skill_percent',
          'admin_label' => true,
          'dependency'  => array( 'element' => 'counter_or_chart', 'value' => array('skill') ),
          'description' => __( 'Percentage, add numeric value only like 75 for 75%', 'hcode-addons' ),

      ),
      array(
          'type' => 'textfield',
          'heading' => __('Counter Number', 'hcode-addons'),
          'param_name' => 'counter_number',
          'admin_label' => true,
          'dependency'  => array( 'element' => 'counter_or_chart', 'value' => array('counter') ),
      ),
      array(
          'type' => 'textfield',
          'heading' => __('Title', 'hcode-addons'),
          'param_name' => 'title',
          'admin_label' => true,
          'dependency'  => array( 'element' => 'counter_or_chart', 'value' => array('skill', 'counter') ),
      ),
      array(
          'type' => 'textfield',
          'heading' => __('Subtitle', 'hcode-addons'),
          'param_name' => 'subtitle',
          'admin_label' => true,
          'dependency'  => array( 'element' => 'counter_or_chart', 'value' => array('skill') ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => __('Counter Number style', 'hcode-addons'),
        'param_name' => 'counter_number_style',
        'value' => array(__('Default', 'hcode-addons') => '',
                         __('White', 'hcode-addons') => 'white-text',
                         __('Black', 'hcode-addons') => 'black-text',
                         __('Custom Color', 'hcode-addons') => 'custom',
                        ),
        'dependency' => array( 'element' => 'counter_or_chart', 'value' => array('counter') ),
        'group' => 'Configuration',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Counter Number Color', 'hcode-addons' ),
        'param_name' => 'counter_number_color',
        'dependency' => array( 'element' => 'counter_number_style', 'value' => array('custom') ),
        'description' => __( 'Specify counter number color', 'hcode-addons' ),
        'group' => 'Configuration',
      ),
      array(
          'type' => 'dropdown',
          'heading' => __('Icon Size', 'hcode-addons'),
          'param_name' => 'counter_icon_size',
          'value' => array(__('Default', 'hcode-addons') => '',
                           __('Extra Large', 'hcode-addons') => 'extra-large-icon', 
                           __('Large', 'hcode-addons') => 'large-icon',
                           __('Medium', 'hcode-addons') => 'medium-icon',
                           __('Small', 'hcode-addons') => 'small-icon',
                           __('Extra Small', 'hcode-addons') => 'extra-small-icon',
                          ),
          'dependency' => array( 'element' => 'counter_or_chart', 'value' => array('counter') ),
          'group' => 'Configuration',
      ),
      array(
        'type' => 'dropdown',
        'heading' => __('Title Style', 'hcode-addons'),
        'param_name' => 'title_style',
        'value' => array(__('Default', 'hcode-addons') => '',
                         __('White', 'hcode-addons') => 'white-text',
                         __('Black', 'hcode-addons') => 'black-text',
                         __('Custom Color', 'hcode-addons') => 'custom',
                        ),
        'dependency' => array( 'element' => 'counter_or_chart', 'value' => array('counter','skill') ),
        'group' => 'Configuration',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Title Color', 'hcode-addons' ),
        'param_name' => 'title_color',
        'dependency' => array( 'element' => 'title_style', 'value' => array('custom') ),
        'description' => __( 'Specify title color', 'hcode-addons' ),
        'group' => 'Configuration',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Subtitle Color', 'hcode-addons' ),
        'param_name' => 'subtitle_color',
        'dependency' => array( 'element' => 'counter_or_chart', 'value' => array('skill') ),
        'group' => 'Configuration',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Icon Color', 'hcode-addons' ),
        'param_name' => 'icon_color',
        'dependency' => array( 'element' => 'counter_or_chart', 'value' => array('counter') ),
        'group' => 'Configuration',
      ),
      array(
          'type' => 'dropdown',
          'heading' => __('Animation Duration Time', 'hcode-addons'),
          'param_name' => 'counter_animation_duration',
          'value' => array(__('Default', 'hcode-addons') => '',
                           __('100ms', 'hcode-addons') => '100', 
                           __('200ms', 'hcode-addons') => '200',
                           __('300ms', 'hcode-addons') => '300',
                           __('400ms', 'hcode-addons') => '400',
                           __('500ms', 'hcode-addons') => '500',
                          ),
          'dependency' => array( 'element' => 'counter_or_chart', 'value' => array('counter') ),
          'group' => 'Animation',
      ),
      /* Skill settings */
      array(
        'type' => 'dropdown',
        'heading' => __('Percentage Style', 'hcode-addons'),
        'param_name' => 'skill_percent_style',
        'value' => array(__('Default', 'hcode-addons') => '',
                         __('White', 'hcode-addons') => 'white-text',
                         __('Black', 'hcode-addons') => 'black-text',
                         __('Custom Color', 'hcode-addons') => 'custom',
                        ),
        'dependency' => array( 'element' => 'counter_or_chart', 'value' => array('skill') ),
        'group' => 'Configuration',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Percentage Color', 'hcode-addons' ),
        'param_name' => 'skill_percent_color',
        'dependency' => array( 'element' => 'skill_percent_style', 'value' => array('custom') ),
        'group' => 'Configuration',
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Line Width', 'hcode-addons'),
        'param_name' => 'skill_line_width',
        'dependency'  => array( 'element' => 'counter_or_chart', 'value' => array('skill') ),
        'description' => __( 'Specify line width eg. 2', 'hcode-addons' ),
        'group' => 'Configuration',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Bar Color', 'hcode-addons' ),
        'param_name' => 'skill_barcolor_color',
        'dependency' => array( 'element' => 'counter_or_chart', 'value' => array('skill') ),
        'group' => 'Configuration',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Track Color', 'hcode-addons' ),
        'param_name' => 'skill_trackcolor_color',
        'dependency' => array( 'element' => 'counter_or_chart', 'value' => array('skill') ),
        'group' => 'Configuration',
      ),
      array(
        'type'        => 'responsive_font_settings',
        'param_name'  => 'hcode_responsive_number_font',
        'heading'     => esc_html__( 'Font Settings For Number', 'hcode-addons' ),
        'hide_font_settings_element_lg' => array('font-transform'),
        'hide_font_settings_element_md' => array('font-transform'),
        'hide_font_settings_element_sm' => array('font-transform'),
        'hide_font_settings_element_xs' => array('font-transform'),
        'dependency'  => array( 'element' => 'counter_or_chart', 'value' => array('counter') ),
        'group' => 'Font Settings',
      ),
      array(
        'type'        => 'responsive_font_settings',
        'param_name'  => 'hcode_responsive_percentage_font',
        'heading'     => esc_html__( 'Font Settings For Percentage', 'hcode-addons' ),
        'hide_font_settings_element_lg' => array('text-align','font-transform'),
        'hide_font_settings_element_md' => array('text-align','font-transform'),
        'hide_font_settings_element_sm' => array('text-align','font-transform'),
        'hide_font_settings_element_xs' => array('text-align','font-transform'),
        'dependency'  => array( 'element' => 'counter_or_chart', 'value' => array('skill') ),
        'group' => 'Font Settings',
      ),
      array(
        'type'        => 'responsive_font_settings',
        'param_name'  => 'hcode_responsive_title_font',
        'heading'     => esc_html__( 'Font Settings For Title', 'hcode-addons' ),
        'dependency'  => array( 'element' => 'counter_or_chart', 'value' => array('skill', 'counter') ),
        'group' => 'Font Settings',
      ),
      array(
        'type'        => 'responsive_font_settings',
        'param_name'  => 'hcode_responsive_subtitle_font',
        'heading'     => esc_html__( 'Font Settings For Subtitle', 'hcode-addons' ),
        'dependency'  => array( 'element' => 'counter_or_chart', 'value' => array('skill') ),
        'group' => 'Font Settings',
      ),
      array(
        'type' => 'dropdown',
        'heading' => __('Animation Duration Time', 'hcode-addons'),
        'param_name' => 'animate_duration',
        'value' => array(__('Select Animation Duration Time', 'hcode-addons') => '',
                         __('1000', 'hcode-addons') => '1000',
                         __('2000', 'hcode-addons') => '2000',
                        __('3000', 'hcode-addons') => '3000',
                        __('4000', 'hcode-addons') => '4000',
                        __('5000', 'hcode-addons') => '5000',
                        __('6000', 'hcode-addons') => '6000',
                        __('7000', 'hcode-addons') => '7000',
                        __('8000', 'hcode-addons') => '8000',
                        __('9000', 'hcode-addons') => '9000',
                        __('10000', 'hcode-addons') => '10000',
                        ),
        'description' => __('Select animation duration time (1s = 1000)', 'hcode-addons'),
        'dependency' => array( 'element' => 'counter_or_chart', 'value' => array('skill') ),
        'std' => '2000',
        'group' => 'Animation',
      ),
      array(
          'type' => 'hcode_custom_srcset',
          'param_name' => 'hcode_icon_image_srcset',
          'heading' => __('Icon Image SRCSET', 'hcode-addons' ),
          'value' => 'full',
          'dependency' => array( 'element' => 'custom_icon', 'value' => '1' ),
          'group' => 'SRCSET',
      ),
      $hcode_vc_extra_id,
      $hcode_vc_extra_class,
    ),
  ) 
);