/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-01-20 16:43:02 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `dev_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dev_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dev_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dev_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=172 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dev_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dev_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dev_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dev_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dev_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dev_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dev_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `dev_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=2812 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=204018 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=8428 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_cff_facebook_feed_locator` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `feed_id` varchar(50) NOT NULL DEFAULT '',
  `post_id` bigint unsigned NOT NULL,
  `html_location` varchar(50) NOT NULL DEFAULT 'unknown',
  `shortcode_atts` longtext NOT NULL,
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `feed_id` (`feed_id`),
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_cff_feed_caches` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `feed_id` bigint unsigned NOT NULL DEFAULT '1',
  `cache_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cache_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `cron_update` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  `last_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `feed_id` (`feed_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_cff_feeds` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `feed_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `feed_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `author` bigint unsigned NOT NULL DEFAULT '1',
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `last_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `author` (`author`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_cff_sources` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `account_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `account_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `privilege` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `access_token` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `info` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `error` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `author` bigint unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `account_type` (`account_type`(191)),
  KEY `author` (`author`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=423 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_geodir_attachments` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `post_id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `title` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `caption` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `file` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `mime_type` varchar(150) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `menu_order` int NOT NULL DEFAULT '0',
  `is_featured` enum('1','0') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '0',
  `is_approved` enum('1','0') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '1',
  `metadata` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_geodir_countries` (
  `CountryId` smallint NOT NULL AUTO_INCREMENT,
  `Country` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `FIPS104` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `ISO2` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `ISO3` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `ISON` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `Internet` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `Capital` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `MapReference` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `NationalitySingular` varchar(35) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `NationalityPlural` varchar(35) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `Currency` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `CurrencyCode` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `Population` bigint DEFAULT NULL,
  `Title` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `Comment` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`CountryId`)
) ENGINE=InnoDB AUTO_INCREMENT=283 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_geodir_custom_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `post_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `data_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `field_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL COMMENT 'text,checkbox,radio,select,textarea',
  `field_type_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `admin_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `admin_desc` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `site_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `htmlvar_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `default_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `sort_order` int NOT NULL,
  `option_values` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `clabels` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `is_active` enum('0','1') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `is_default` enum('0','1') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '0',
  `is_admin` enum('0','1') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '0',
  `is_required` enum('0','1') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '0',
  `required_msg` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `show_on_listing` enum('0','1') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `show_in` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `show_on_detail` enum('0','1') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `show_as_tab` enum('0','1') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '0',
  `for_admin_use` enum('0','1') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '0',
  `packages` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `cat_sort` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `cat_filter` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `extra_fields` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `field_icon` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `css_class` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `decimal_point` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `validation_pattern` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `validation_msg` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_geodir_custom_sort_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `post_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `field_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `site_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `htmlvar_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `sort_order` int NOT NULL,
  `is_active` int NOT NULL,
  `is_default` int NOT NULL,
  `default_order` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `sort_asc` int NOT NULL,
  `sort_desc` int NOT NULL,
  `asc_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `desc_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_geodir_gd_place_detail` (
  `post_id` int NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `default_category` int DEFAULT NULL,
  `post_tags` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `post_location_id` int NOT NULL,
  `geodir_link_business` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `marker_json` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `claimed` enum('1','0') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '0',
  `businesses` enum('1','0') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '0',
  `is_featured` enum('1','0') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '0',
  `featured_image` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `paid_amount` double NOT NULL DEFAULT '0',
  `package_id` int NOT NULL DEFAULT '0',
  `alive_days` int NOT NULL DEFAULT '0',
  `paymentmethod` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `expire_date` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `submit_time` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `submit_ip` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `overall_rating` float DEFAULT '0',
  `rating_count` int DEFAULT '0',
  `post_locations` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `post_dummy` enum('1','0') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '0',
  `gd_placecategory` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `post_address` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `post_city` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `post_region` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `post_country` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `post_zip` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `post_latitude` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `post_longitude` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `post_mapview` varchar(15) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `post_mapzoom` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `post_latlng` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '1',
  `geodir_timing` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `geodir_contact` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `geodir_email` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `geodir_website` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `geodir_twitter` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `geodir_facebook` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `geodir_video` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `geodir_special_offers` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`post_id`),
  KEY `post_locations` (`post_locations`(191)),
  KEY `is_featured` (`is_featured`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_geodir_post_icon` (
  `id` int NOT NULL AUTO_INCREMENT,
  `post_id` int NOT NULL,
  `post_title` varchar(254) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `cat_id` int NOT NULL,
  `json` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_geodir_post_review` (
  `id` int NOT NULL AUTO_INCREMENT,
  `post_id` int DEFAULT NULL,
  `post_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `post_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `comment_id` int DEFAULT NULL,
  `rating_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ratings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `overall_rating` float DEFAULT NULL,
  `comment_images` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `wasthis_review` int NOT NULL,
  `status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` int DEFAULT NULL,
  `post_date` datetime NOT NULL,
  `post_city` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `post_region` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `post_country` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `post_latitude` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `post_longitude` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=1005414 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=16501 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1360 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_refonte_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_refonte_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_refonte_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_refonte_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=224 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_refonte_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_refonte_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_refonte_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_refonte_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_refonte_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_refonte_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_refonte_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_refonte_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `params` longtext NOT NULL,
  `advanced` longtext,
  UNIQUE KEY `id` (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `params` longtext NOT NULL,
  `advanced` longtext,
  UNIQUE KEY `id` (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_navigations` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  `type` varchar(191) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  `type` varchar(191) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_sliders` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `slide_order` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int NOT NULL AUTO_INCREMENT,
  `slider_id` int NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_sbi_feed_caches` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `feed_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cache_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cache_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `cron_update` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  `last_updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `feed_id` (`feed_id`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_sbi_feeds` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `feed_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `feed_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `author` bigint unsigned NOT NULL DEFAULT '1',
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `last_modified` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `author` (`author`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_sbi_instagram_feed_locator` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `feed_id` varchar(50) NOT NULL DEFAULT '',
  `post_id` bigint unsigned NOT NULL,
  `html_location` varchar(50) NOT NULL DEFAULT 'unknown',
  `shortcode_atts` longtext NOT NULL,
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `feed_id` (`feed_id`),
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_sbi_instagram_feeds_posts` (
  `record_id` int unsigned NOT NULL AUTO_INCREMENT,
  `id` int unsigned NOT NULL,
  `instagram_id` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `feed_id` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `hashtag` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`record_id`),
  KEY `hashtag` (`hashtag`(191)),
  KEY `feed_id` (`feed_id`(191))
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_sbi_instagram_posts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `instagram_id` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `time_stamp` datetime DEFAULT NULL,
  `top_time_stamp` datetime DEFAULT NULL,
  `json_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `media_id` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `sizes` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `aspect_ratio` decimal(4,2) NOT NULL DEFAULT '0.00',
  `images_done` tinyint(1) NOT NULL DEFAULT '0',
  `last_requested` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_sbi_sources` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `account_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `account_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `privilege` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `access_token` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `info` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `error` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `expires` datetime NOT NULL,
  `last_updated` datetime NOT NULL,
  `author` bigint unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `account_type` (`account_type`(191)),
  KEY `author` (`author`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  `term_icon` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3638 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=2000 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=10583 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`),
  KEY `woo_idx_comment_date_type` (`comment_date_gmt`,`comment_type`,`comment_approved`,`comment_post_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_hfcm_scripts` (
  `script_id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `snippet` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `snippet_type` enum('html','js','css') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'html',
  `device_type` enum('mobile','desktop','both') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'both',
  `location` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `display_on` enum('All','s_pages','s_posts','s_categories','s_custom_posts','s_tags','s_is_home','s_is_search','s_is_archive','latest_posts','manual') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'All',
  `lp_count` int DEFAULT NULL,
  `s_pages` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `ex_pages` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `s_posts` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `ex_posts` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `s_custom_posts` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `s_categories` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `s_tags` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `spt_display_on` enum('both','posts','archives') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'both',
  `status` enum('active','inactive') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'active',
  `created_by` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `last_modified_by` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created` datetime DEFAULT NULL,
  `last_revision_date` datetime DEFAULT NULL,
  PRIMARY KEY (`script_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_mapp_maps` (
  `mapid` int NOT NULL AUTO_INCREMENT,
  `otype` varchar(32) DEFAULT NULL,
  `oid` int DEFAULT NULL,
  `status` varchar(64) DEFAULT NULL,
  `title` varchar(512) DEFAULT NULL,
  `obj` longtext,
  PRIMARY KEY (`mapid`),
  UNIQUE KEY `object_idx` (`otype`,`oid`,`mapid`),
  KEY `title_idx` (`title`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_test_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=19535 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3640 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1012 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actioned_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=26700 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wc_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `address_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `last_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `company` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `address_1` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `address_2` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `city` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `state` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `postcode` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `country` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wc_order_operational_data` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_via` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `woocommerce_version` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`),
  KEY `idx_date_paid_status_parent` (`date_paid`,`status`,`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wc_orders` (
  `id` bigint unsigned NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `billing_email` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint unsigned DEFAULT NULL,
  `payment_method` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `customer_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wc_orders_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wc_product_attributes_lookup` (
  `product_id` bigint NOT NULL,
  `product_or_parent_id` bigint NOT NULL,
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wc_product_download_directories` (
  `url_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `global_unique_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wc_rate_limits` (
  `rate_limit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint unsigned NOT NULL,
  `rate_limit_remaining` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`),
  KEY `session_expiry` (`session_expiry`)
) ENGINE=InnoDB AUTO_INCREMENT=1000 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wpforms_logs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `types` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `create_at` datetime NOT NULL,
  `form_id` bigint DEFAULT NULL,
  `entry_id` bigint DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wpforms_payment_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `payment_id` bigint NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `payment_id` (`payment_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wpforms_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `form_id` bigint NOT NULL,
  `status` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subtotal_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `discount_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `total_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `currency` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `entry_id` bigint NOT NULL DEFAULT '0',
  `gateway` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `type` varchar(12) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `mode` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `transaction_id` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `customer_id` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subscription_id` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subscription_status` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `date_created_gmt` datetime NOT NULL,
  `date_updated_gmt` datetime NOT NULL,
  `is_published` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `status` (`status`(8)),
  KEY `total_amount` (`total_amount`),
  KEY `type` (`type`(8)),
  KEY `transaction_id` (`transaction_id`(32)),
  KEY `customer_id` (`customer_id`(32)),
  KEY `subscription_id` (`subscription_id`(32)),
  KEY `subscription_status` (`subscription_status`(8)),
  KEY `title` (`title`(64))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wpforms_tasks_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wpmailsmtp_debug_events` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `initiator` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `event_type` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_wpmailsmtp_tasks_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_yoast_indexable` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint DEFAULT NULL,
  `object_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint DEFAULT NULL,
  `post_parent` bigint DEFAULT NULL,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int unsigned DEFAULT NULL,
  `canonical` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int DEFAULT NULL,
  `readability_score` int DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `link_count` int DEFAULT NULL,
  `incoming_link_count` int DEFAULT NULL,
  `prominent_words_version` int unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  `language` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int DEFAULT NULL,
  `version` int DEFAULT '1',
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=132 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_yoast_indexable_hierarchy` (
  `indexable_id` int unsigned NOT NULL,
  `ancestor_id` int unsigned NOT NULL,
  `depth` int unsigned DEFAULT NULL,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_yoast_migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wp_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_yoast_primary_term` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint DEFAULT NULL,
  `term_id` bigint DEFAULT NULL,
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_test_yoast_seo_links` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint unsigned DEFAULT NULL,
  `target_post_id` bigint unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int unsigned DEFAULT NULL,
  `target_indexable_id` int unsigned DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `width` int unsigned DEFAULT NULL,
  `size` int unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=167 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5192 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=129 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actioned_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=112576 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=268 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint unsigned NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned DEFAULT NULL,
  `username` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=157 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned NOT NULL,
  `address_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `last_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `company` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `address_1` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `address_2` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `city` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `state` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `postcode` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `country` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `coupon_id` bigint NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `created_via` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `woocommerce_version` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `variation_id` bigint unsigned NOT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint unsigned NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint unsigned NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint unsigned DEFAULT NULL,
  `billing_email` varchar(320) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint unsigned DEFAULT NULL,
  `payment_method` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `customer_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`),
  KEY `billing_email` (`billing_email`),
  KEY `type_status` (`type`,`status`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`,`meta_value`(100)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`,`meta_value`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint NOT NULL,
  `product_or_parent_id` bigint NOT NULL,
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint NOT NULL,
  `sku` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint DEFAULT '0',
  `tax_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `global_unique_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint unsigned NOT NULL,
  `rate_limit_remaining` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint NOT NULL,
  `product_id` bigint NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `delivery_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint NOT NULL,
  `failure_count` smallint NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wcpdf_invoice_number` (
  `id` int NOT NULL AUTO_INCREMENT,
  `order_id` int DEFAULT NULL,
  `date` datetime NOT NULL DEFAULT '1000-01-01 00:00:00',
  `calculated_number` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `description` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint unsigned NOT NULL,
  `order_id` bigint unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint NOT NULL,
  `source` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=9651 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1094 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=191713 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint unsigned NOT NULL,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint unsigned NOT NULL,
  `instance_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint unsigned NOT NULL,
  `location_type` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint unsigned NOT NULL,
  `tax_rate_compound` int NOT NULL DEFAULT '0',
  `tax_rate_shipping` int NOT NULL DEFAULT '1',
  `tax_rate_order` bigint unsigned NOT NULL,
  `tax_rate_class` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpgmza` (
  `id` int NOT NULL AUTO_INCREMENT,
  `map_id` int NOT NULL,
  `address` varchar(700) NOT NULL,
  `description` mediumtext NOT NULL,
  `pic` varchar(700) NOT NULL,
  `link` varchar(2083) NOT NULL,
  `icon` varchar(700) NOT NULL,
  `lat` varchar(100) NOT NULL,
  `lng` varchar(100) NOT NULL,
  `anim` varchar(3) NOT NULL,
  `title` varchar(700) NOT NULL,
  `infoopen` varchar(3) NOT NULL,
  `category` varchar(500) NOT NULL,
  `approved` tinyint(1) DEFAULT '1',
  `retina` tinyint(1) DEFAULT '0',
  `type` tinyint(1) DEFAULT '0',
  `did` varchar(500) NOT NULL,
  `other_data` longtext NOT NULL,
  `sticky` tinyint(1) DEFAULT '0',
  `latlng` point DEFAULT NULL,
  `layergroup` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=459 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wpgmza_admin_notices` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `active_date` datetime DEFAULT NULL,
  `options` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `dismissed` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpgmza_categories` (
  `id` int NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL,
  `category_name` varchar(50) NOT NULL,
  `category_icon` varchar(700) NOT NULL,
  `retina` tinyint(1) DEFAULT '0',
  `parent` int DEFAULT '0',
  `priority` int NOT NULL,
  `image` varchar(512) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wpgmza_category_maps` (
  `id` int NOT NULL AUTO_INCREMENT,
  `cat_id` int NOT NULL,
  `map_id` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wpgmza_circles` (
  `id` int NOT NULL AUTO_INCREMENT,
  `map_id` int NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `center` point DEFAULT NULL,
  `radius` float DEFAULT NULL,
  `color` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `opacity` float DEFAULT NULL,
  `lineColor` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lineOpacity` float DEFAULT '0',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `hoverEnabled` tinyint(1) DEFAULT '0',
  `ohFillColor` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ohLineColor` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ohFillOpacity` float DEFAULT NULL,
  `ohLineOpacity` float DEFAULT NULL,
  `link` varchar(700) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `layergroup` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpgmza_custom_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `icon` varchar(128) NOT NULL,
  `attributes` text,
  `widget_type` varchar(128) DEFAULT 'none',
  `display_in_infowindows` tinyint(1) DEFAULT '1',
  `display_in_marker_listings` tinyint(1) DEFAULT '1',
  `stack_order` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wpgmza_datasets` (
  `id` int NOT NULL AUTO_INCREMENT,
  `map_id` int NOT NULL,
  `type` int NOT NULL,
  `dataset_name` varchar(100) NOT NULL,
  `dataset` longtext NOT NULL,
  `options` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wpgmza_image_overlays` (
  `id` int NOT NULL AUTO_INCREMENT,
  `map_id` int NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `cornerA` point DEFAULT NULL,
  `cornerB` point DEFAULT NULL,
  `image` varchar(700) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `opacity` float DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpgmza_maps` (
  `id` int NOT NULL AUTO_INCREMENT,
  `map_title` varchar(256) NOT NULL,
  `map_width` varchar(6) NOT NULL,
  `map_height` varchar(6) NOT NULL,
  `map_start_lat` varchar(700) NOT NULL,
  `map_start_lng` varchar(700) NOT NULL,
  `map_start_location` varchar(700) NOT NULL,
  `map_start_zoom` int NOT NULL,
  `default_marker` varchar(700) NOT NULL,
  `type` int NOT NULL,
  `alignment` int NOT NULL,
  `directions_enabled` int NOT NULL,
  `styling_enabled` int NOT NULL,
  `styling_json` mediumtext NOT NULL,
  `active` int NOT NULL,
  `kml` varchar(700) NOT NULL,
  `bicycle` int NOT NULL,
  `traffic` int NOT NULL,
  `dbox` int NOT NULL,
  `dbox_width` varchar(10) NOT NULL,
  `listmarkers` int NOT NULL,
  `listmarkers_advanced` int NOT NULL,
  `filterbycat` tinyint(1) NOT NULL,
  `ugm_enabled` int NOT NULL,
  `ugm_category_enabled` tinyint(1) NOT NULL,
  `fusion` varchar(100) NOT NULL,
  `map_width_type` varchar(3) NOT NULL,
  `map_height_type` varchar(3) NOT NULL,
  `mass_marker_support` int NOT NULL,
  `ugm_access` int NOT NULL,
  `order_markers_by` int NOT NULL,
  `order_markers_choice` int NOT NULL,
  `show_user_location` int NOT NULL,
  `default_to` varchar(700) NOT NULL,
  `other_settings` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wpgmza_maps_has_custom_fields_filters` (
  `map_id` int NOT NULL,
  `field_id` int NOT NULL,
  PRIMARY KEY (`map_id`,`field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wpgmza_markers_has_categories` (
  `marker_id` int NOT NULL,
  `category_id` int NOT NULL,
  PRIMARY KEY (`marker_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wpgmza_markers_has_custom_fields` (
  `field_id` int NOT NULL,
  `object_id` int NOT NULL,
  `value` text,
  PRIMARY KEY (`field_id`,`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

CREATE TABLE `wp_wpgmza_nominatim_geocode_cache` (
  `id` int NOT NULL AUTO_INCREMENT,
  `query` varchar(512) DEFAULT NULL,
  `response` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wpgmza_point_labels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `map_id` int NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `center` point DEFAULT NULL,
  `fillColor` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lineColor` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `opacity` float DEFAULT NULL,
  `fontSize` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpgmza_polygon` (
  `id` int NOT NULL AUTO_INCREMENT,
  `map_id` int NOT NULL,
  `polydata` longtext NOT NULL,
  `innerpolydata` longtext NOT NULL,
  `linecolor` varchar(7) NOT NULL,
  `lineopacity` varchar(7) NOT NULL,
  `fillcolor` varchar(7) NOT NULL,
  `opacity` varchar(3) NOT NULL,
  `title` varchar(250) NOT NULL,
  `link` varchar(700) NOT NULL,
  `ohfillcolor` varchar(7) NOT NULL,
  `ohlinecolor` varchar(7) NOT NULL,
  `ohopacity` varchar(3) NOT NULL,
  `polyname` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `linethickness` varchar(3) NOT NULL,
  `layergroup` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wpgmza_polylines` (
  `id` int NOT NULL AUTO_INCREMENT,
  `map_id` int NOT NULL,
  `polydata` longtext NOT NULL,
  `linecolor` varchar(7) NOT NULL,
  `linethickness` varchar(3) NOT NULL,
  `opacity` varchar(3) NOT NULL,
  `polyname` varchar(100) NOT NULL,
  `layergroup` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wpgmza_rectangles` (
  `id` int NOT NULL AUTO_INCREMENT,
  `map_id` int NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `cornerA` point DEFAULT NULL,
  `cornerB` point DEFAULT NULL,
  `color` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `opacity` float DEFAULT NULL,
  `lineColor` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lineOpacity` float DEFAULT '0',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `hoverEnabled` tinyint(1) DEFAULT '0',
  `ohFillColor` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ohLineColor` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ohFillOpacity` float DEFAULT NULL,
  `ohLineOpacity` float DEFAULT NULL,
  `link` varchar(700) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `layergroup` int DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpml_mails` (
  `mail_id` int NOT NULL AUTO_INCREMENT,
  `timestamp` timestamp NOT NULL,
  `host` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '0',
  `receiver` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '0',
  `subject` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '0',
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `headers` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `attachments` varchar(800) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '0',
  `error` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `plugin_version` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '0',
  PRIMARY KEY (`mail_id`),
  FULLTEXT KEY `idx_message` (`message`)
) ENGINE=InnoDB AUTO_INCREMENT=232 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint DEFAULT NULL,
  `object_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint DEFAULT NULL,
  `post_parent` bigint DEFAULT NULL,
  `title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int unsigned DEFAULT NULL,
  `canonical` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int DEFAULT NULL,
  `readability_score` int DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `link_count` int DEFAULT NULL,
  `incoming_link_count` int DEFAULT NULL,
  `prominent_words_version` int unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  `language` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int DEFAULT NULL,
  `version` int DEFAULT '1',
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=410 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable_hierarchy` (
  `indexable_id` int unsigned NOT NULL DEFAULT '0',
  `ancestor_id` int unsigned NOT NULL DEFAULT '0',
  `depth` int unsigned DEFAULT NULL,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wp_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_primary_term` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint DEFAULT NULL,
  `term_id` bigint DEFAULT NULL,
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  `target_post_id` bigint unsigned NOT NULL,
  `type` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `indexable_id` int unsigned DEFAULT NULL,
  `target_indexable_id` int unsigned DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `width` int unsigned DEFAULT NULL,
  `size` int unsigned DEFAULT NULL,
  `language` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=3399 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_seo_meta` (
  `object_id` bigint unsigned NOT NULL,
  `internal_link_count` int unsigned DEFAULT NULL,
  `incoming_link_count` int unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: dev_comments */
INSERT INTO `dev_comments` VALUES("1", "1", "Un commentateur ou commentatrice WordPress", "wapuu@wordpress.example", "https://fr.wordpress.org/", "", "2026-01-20 16:50:05", "2026-01-20 15:50:05", "Bonjour, ceci est un commentaire.\nPour débuter avec la modération, la modification et la suppression de commentaires, veuillez visiter l’écran des Commentaires dans le Tableau de bord.\nLes avatars des personnes qui commentent arrivent depuis <a href=\"https://fr.gravatar.com/\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: dev_options */
INSERT INTO `dev_options` VALUES("1", "cron", "a:10:{i:1768927805;a:2:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1768929605;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1768931405;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1768967425;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1769010605;a:2:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769010625;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769010627;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769010649;a:1:{s:21:\"ai1wm_storage_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1769529042;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `dev_options` VALUES("2", "siteurl", "http://dev.odysseedengrain-patesbio.fr", "on");
INSERT INTO `dev_options` VALUES("3", "home", "http://dev.odysseedengrain-patesbio.fr", "on");
INSERT INTO `dev_options` VALUES("4", "blogname", "Odyssee d&#039;engrain", "on");
INSERT INTO `dev_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `dev_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `dev_options` VALUES("7", "admin_email", "contact@originartstudio.fr", "on");
INSERT INTO `dev_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `dev_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `dev_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `dev_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `dev_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `dev_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `dev_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `dev_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `dev_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `dev_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `dev_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `dev_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `dev_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `dev_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `dev_options` VALUES("22", "default_pingback_flag", "0", "on");
INSERT INTO `dev_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `dev_options` VALUES("24", "date_format", "j F Y", "on");
INSERT INTO `dev_options` VALUES("25", "time_format", "G\\hi", "on");
INSERT INTO `dev_options` VALUES("26", "links_updated_date_format", "d F Y G\\hi", "on");
INSERT INTO `dev_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `dev_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `dev_options` VALUES("29", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "on");
INSERT INTO `dev_options` VALUES("30", "rewrite_rules", "a:82:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:23:\"index.php?sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "on");
INSERT INTO `dev_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `dev_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `dev_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `dev_options` VALUES("34", "active_plugins", "a:1:{i:0;s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";}", "on");
INSERT INTO `dev_options` VALUES("35", "category_base", "", "on");
INSERT INTO `dev_options` VALUES("36", "ping_sites", "https://rpc.pingomatic.com/", "on");
INSERT INTO `dev_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `dev_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `dev_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `dev_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `dev_options` VALUES("41", "template", "twentytwentyfive", "on");
INSERT INTO `dev_options` VALUES("42", "stylesheet", "twentytwentyfive", "on");
INSERT INTO `dev_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `dev_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `dev_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `dev_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `dev_options` VALUES("47", "db_version", "60717", "on");
INSERT INTO `dev_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `dev_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `dev_options` VALUES("50", "blog_public", "0", "on");
INSERT INTO `dev_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `dev_options` VALUES("52", "show_on_front", "posts", "on");
INSERT INTO `dev_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `dev_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `dev_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `dev_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `dev_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `dev_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `dev_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `dev_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `dev_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `dev_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `dev_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `dev_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `dev_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `dev_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `dev_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `dev_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `dev_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `dev_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `dev_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `dev_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `dev_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `dev_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `dev_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `dev_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `dev_options` VALUES("77", "widget_categories", "a:0:{}", "on");
INSERT INTO `dev_options` VALUES("78", "widget_text", "a:0:{}", "on");
INSERT INTO `dev_options` VALUES("79", "widget_rss", "a:0:{}", "on");
INSERT INTO `dev_options` VALUES("80", "uninstall_plugins", "a:0:{}", "off");
INSERT INTO `dev_options` VALUES("81", "timezone_string", "Europe/Paris", "on");
INSERT INTO `dev_options` VALUES("82", "page_for_posts", "0", "on");
INSERT INTO `dev_options` VALUES("83", "page_on_front", "0", "on");
INSERT INTO `dev_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `dev_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `dev_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `dev_options` VALUES("87", "site_icon", "0", "on");
INSERT INTO `dev_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `dev_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `dev_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `dev_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `dev_options` VALUES("92", "admin_email_lifespan", "1784476205", "on");
INSERT INTO `dev_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `dev_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `dev_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `dev_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `dev_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `dev_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `dev_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `dev_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `dev_options` VALUES("101", "wp_notes_notify", "1", "on");
INSERT INTO `dev_options` VALUES("102", "initial_db_version", "60717", "on");
INSERT INTO `dev_options` VALUES("103", "dev_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:61:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "on");
INSERT INTO `dev_options` VALUES("104", "fresh_site", "1", "off");
INSERT INTO `dev_options` VALUES("105", "WPLANG", "fr_FR", "auto");
INSERT INTO `dev_options` VALUES("106", "user_count", "1", "off");
INSERT INTO `dev_options` VALUES("107", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Articles récents</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:233:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Commentaires récents</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:151:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Catégories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `dev_options` VALUES("108", "sidebars_widgets", "a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `dev_options` VALUES("109", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `dev_options` VALUES("110", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `dev_options` VALUES("111", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `dev_options` VALUES("112", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `dev_options` VALUES("113", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `dev_options` VALUES("114", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `dev_options` VALUES("115", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `dev_options` VALUES("116", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `dev_options` VALUES("117", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `dev_options` VALUES("118", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `dev_options` VALUES("119", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `dev_options` VALUES("120", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `dev_options` VALUES("121", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `dev_options` VALUES("122", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `dev_options` VALUES("123", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:3:\"6.9\";s:5:\"files\";a:584:{i:0;s:31:\"accordion-heading/style-rtl.css\";i:1;s:35:\"accordion-heading/style-rtl.min.css\";i:2;s:27:\"accordion-heading/style.css\";i:3;s:31:\"accordion-heading/style.min.css\";i:4;s:28:\"accordion-item/style-rtl.css\";i:5;s:32:\"accordion-item/style-rtl.min.css\";i:6;s:24:\"accordion-item/style.css\";i:7;s:28:\"accordion-item/style.min.css\";i:8;s:29:\"accordion-panel/style-rtl.css\";i:9;s:33:\"accordion-panel/style-rtl.min.css\";i:10;s:25:\"accordion-panel/style.css\";i:11;s:29:\"accordion-panel/style.min.css\";i:12;s:23:\"accordion/style-rtl.css\";i:13;s:27:\"accordion/style-rtl.min.css\";i:14;s:19:\"accordion/style.css\";i:15;s:23:\"accordion/style.min.css\";i:16;s:23:\"archives/editor-rtl.css\";i:17;s:27:\"archives/editor-rtl.min.css\";i:18;s:19:\"archives/editor.css\";i:19;s:23:\"archives/editor.min.css\";i:20;s:22:\"archives/style-rtl.css\";i:21;s:26:\"archives/style-rtl.min.css\";i:22;s:18:\"archives/style.css\";i:23;s:22:\"archives/style.min.css\";i:24;s:20:\"audio/editor-rtl.css\";i:25;s:24:\"audio/editor-rtl.min.css\";i:26;s:16:\"audio/editor.css\";i:27;s:20:\"audio/editor.min.css\";i:28;s:19:\"audio/style-rtl.css\";i:29;s:23:\"audio/style-rtl.min.css\";i:30;s:15:\"audio/style.css\";i:31;s:19:\"audio/style.min.css\";i:32;s:19:\"audio/theme-rtl.css\";i:33;s:23:\"audio/theme-rtl.min.css\";i:34;s:15:\"audio/theme.css\";i:35;s:19:\"audio/theme.min.css\";i:36;s:21:\"avatar/editor-rtl.css\";i:37;s:25:\"avatar/editor-rtl.min.css\";i:38;s:17:\"avatar/editor.css\";i:39;s:21:\"avatar/editor.min.css\";i:40;s:20:\"avatar/style-rtl.css\";i:41;s:24:\"avatar/style-rtl.min.css\";i:42;s:16:\"avatar/style.css\";i:43;s:20:\"avatar/style.min.css\";i:44;s:21:\"button/editor-rtl.css\";i:45;s:25:\"button/editor-rtl.min.css\";i:46;s:17:\"button/editor.css\";i:47;s:21:\"button/editor.min.css\";i:48;s:20:\"button/style-rtl.css\";i:49;s:24:\"button/style-rtl.min.css\";i:50;s:16:\"button/style.css\";i:51;s:20:\"button/style.min.css\";i:52;s:22:\"buttons/editor-rtl.css\";i:53;s:26:\"buttons/editor-rtl.min.css\";i:54;s:18:\"buttons/editor.css\";i:55;s:22:\"buttons/editor.min.css\";i:56;s:21:\"buttons/style-rtl.css\";i:57;s:25:\"buttons/style-rtl.min.css\";i:58;s:17:\"buttons/style.css\";i:59;s:21:\"buttons/style.min.css\";i:60;s:22:\"calendar/style-rtl.css\";i:61;s:26:\"calendar/style-rtl.min.css\";i:62;s:18:\"calendar/style.css\";i:63;s:22:\"calendar/style.min.css\";i:64;s:25:\"categories/editor-rtl.css\";i:65;s:29:\"categories/editor-rtl.min.css\";i:66;s:21:\"categories/editor.css\";i:67;s:25:\"categories/editor.min.css\";i:68;s:24:\"categories/style-rtl.css\";i:69;s:28:\"categories/style-rtl.min.css\";i:70;s:20:\"categories/style.css\";i:71;s:24:\"categories/style.min.css\";i:72;s:19:\"code/editor-rtl.css\";i:73;s:23:\"code/editor-rtl.min.css\";i:74;s:15:\"code/editor.css\";i:75;s:19:\"code/editor.min.css\";i:76;s:18:\"code/style-rtl.css\";i:77;s:22:\"code/style-rtl.min.css\";i:78;s:14:\"code/style.css\";i:79;s:18:\"code/style.min.css\";i:80;s:18:\"code/theme-rtl.css\";i:81;s:22:\"code/theme-rtl.min.css\";i:82;s:14:\"code/theme.css\";i:83;s:18:\"code/theme.min.css\";i:84;s:22:\"columns/editor-rtl.css\";i:85;s:26:\"columns/editor-rtl.min.css\";i:86;s:18:\"columns/editor.css\";i:87;s:22:\"columns/editor.min.css\";i:88;s:21:\"columns/style-rtl.css\";i:89;s:25:\"columns/style-rtl.min.css\";i:90;s:17:\"columns/style.css\";i:91;s:21:\"columns/style.min.css\";i:92;s:33:\"comment-author-name/style-rtl.css\";i:93;s:37:\"comment-author-name/style-rtl.min.css\";i:94;s:29:\"comment-author-name/style.css\";i:95;s:33:\"comment-author-name/style.min.css\";i:96;s:29:\"comment-content/style-rtl.css\";i:97;s:33:\"comment-content/style-rtl.min.css\";i:98;s:25:\"comment-content/style.css\";i:99;s:29:\"comment-content/style.min.css\";i:100;s:26:\"comment-date/style-rtl.css\";i:101;s:30:\"comment-date/style-rtl.min.css\";i:102;s:22:\"comment-date/style.css\";i:103;s:26:\"comment-date/style.min.css\";i:104;s:31:\"comment-edit-link/style-rtl.css\";i:105;s:35:\"comment-edit-link/style-rtl.min.css\";i:106;s:27:\"comment-edit-link/style.css\";i:107;s:31:\"comment-edit-link/style.min.css\";i:108;s:32:\"comment-reply-link/style-rtl.css\";i:109;s:36:\"comment-reply-link/style-rtl.min.css\";i:110;s:28:\"comment-reply-link/style.css\";i:111;s:32:\"comment-reply-link/style.min.css\";i:112;s:30:\"comment-template/style-rtl.css\";i:113;s:34:\"comment-template/style-rtl.min.css\";i:114;s:26:\"comment-template/style.css\";i:115;s:30:\"comment-template/style.min.css\";i:116;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:117;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:118;s:38:\"comments-pagination-numbers/editor.css\";i:119;s:42:\"comments-pagination-numbers/editor.min.css\";i:120;s:34:\"comments-pagination/editor-rtl.css\";i:121;s:38:\"comments-pagination/editor-rtl.min.css\";i:122;s:30:\"comments-pagination/editor.css\";i:123;s:34:\"comments-pagination/editor.min.css\";i:124;s:33:\"comments-pagination/style-rtl.css\";i:125;s:37:\"comments-pagination/style-rtl.min.css\";i:126;s:29:\"comments-pagination/style.css\";i:127;s:33:\"comments-pagination/style.min.css\";i:128;s:29:\"comments-title/editor-rtl.css\";i:129;s:33:\"comments-title/editor-rtl.min.css\";i:130;s:25:\"comments-title/editor.css\";i:131;s:29:\"comments-title/editor.min.css\";i:132;s:23:\"comments/editor-rtl.css\";i:133;s:27:\"comments/editor-rtl.min.css\";i:134;s:19:\"comments/editor.css\";i:135;s:23:\"comments/editor.min.css\";i:136;s:22:\"comments/style-rtl.css\";i:137;s:26:\"comments/style-rtl.min.css\";i:138;s:18:\"comments/style.css\";i:139;s:22:\"comments/style.min.css\";i:140;s:20:\"cover/editor-rtl.css\";i:141;s:24:\"cover/editor-rtl.min.css\";i:142;s:16:\"cover/editor.css\";i:143;s:20:\"cover/editor.min.css\";i:144;s:19:\"cover/style-rtl.css\";i:145;s:23:\"cover/style-rtl.min.css\";i:146;s:15:\"cover/style.css\";i:147;s:19:\"cover/style.min.css\";i:148;s:22:\"details/editor-rtl.css\";i:149;s:26:\"details/editor-rtl.min.css\";i:150;s:18:\"details/editor.css\";i:151;s:22:\"details/editor.min.css\";i:152;s:21:\"details/style-rtl.css\";i:153;s:25:\"details/style-rtl.min.css\";i:154;s:17:\"details/style.css\";i:155;s:21:\"details/style.min.css\";i:156;s:20:\"embed/editor-rtl.css\";i:157;s:24:\"embed/editor-rtl.min.css\";i:158;s:16:\"embed/editor.css\";i:159;s:20:\"embed/editor.min.css\";i:160;s:19:\"embed/style-rtl.css\";i:161;s:23:\"embed/style-rtl.min.css\";i:162;s:15:\"embed/style.css\";i:163;s:19:\"embed/style.min.css\";i:164;s:19:\"embed/theme-rtl.css\";i:165;s:23:\"embed/theme-rtl.min.css\";i:166;s:15:\"embed/theme.css\";i:167;s:19:\"embed/theme.min.css\";i:168;s:19:\"file/editor-rtl.css\";i:169;s:23:\"file/editor-rtl.min.css\";i:170;s:15:\"file/editor.css\";i:171;s:19:\"file/editor.min.css\";i:172;s:18:\"file/style-rtl.css\";i:173;s:22:\"file/style-rtl.min.css\";i:174;s:14:\"file/style.css\";i:175;s:18:\"file/style.min.css\";i:176;s:23:\"footnotes/style-rtl.css\";i:177;s:27:\"footnotes/style-rtl.min.css\";i:178;s:19:\"footnotes/style.css\";i:179;s:23:\"footnotes/style.min.css\";i:180;s:23:\"freeform/editor-rtl.css\";i:181;s:27:\"freeform/editor-rtl.min.css\";i:182;s:19:\"freeform/editor.css\";i:183;s:23:\"freeform/editor.min.css\";i:184;s:22:\"gallery/editor-rtl.css\";i:185;s:26:\"gallery/editor-rtl.min.css\";i:186;s:18:\"gallery/editor.css\";i:187;s:22:\"gallery/editor.min.css\";i:188;s:21:\"gallery/style-rtl.css\";i:189;s:25:\"gallery/style-rtl.min.css\";i:190;s:17:\"gallery/style.css\";i:191;s:21:\"gallery/style.min.css\";i:192;s:21:\"gallery/theme-rtl.css\";i:193;s:25:\"gallery/theme-rtl.min.css\";i:194;s:17:\"gallery/theme.css\";i:195;s:21:\"gallery/theme.min.css\";i:196;s:20:\"group/editor-rtl.css\";i:197;s:24:\"group/editor-rtl.min.css\";i:198;s:16:\"group/editor.css\";i:199;s:20:\"group/editor.min.css\";i:200;s:19:\"group/style-rtl.css\";i:201;s:23:\"group/style-rtl.min.css\";i:202;s:15:\"group/style.css\";i:203;s:19:\"group/style.min.css\";i:204;s:19:\"group/theme-rtl.css\";i:205;s:23:\"group/theme-rtl.min.css\";i:206;s:15:\"group/theme.css\";i:207;s:19:\"group/theme.min.css\";i:208;s:21:\"heading/style-rtl.css\";i:209;s:25:\"heading/style-rtl.min.css\";i:210;s:17:\"heading/style.css\";i:211;s:21:\"heading/style.min.css\";i:212;s:19:\"html/editor-rtl.css\";i:213;s:23:\"html/editor-rtl.min.css\";i:214;s:15:\"html/editor.css\";i:215;s:19:\"html/editor.min.css\";i:216;s:20:\"image/editor-rtl.css\";i:217;s:24:\"image/editor-rtl.min.css\";i:218;s:16:\"image/editor.css\";i:219;s:20:\"image/editor.min.css\";i:220;s:19:\"image/style-rtl.css\";i:221;s:23:\"image/style-rtl.min.css\";i:222;s:15:\"image/style.css\";i:223;s:19:\"image/style.min.css\";i:224;s:19:\"image/theme-rtl.css\";i:225;s:23:\"image/theme-rtl.min.css\";i:226;s:15:\"image/theme.css\";i:227;s:19:\"image/theme.min.css\";i:228;s:29:\"latest-comments/style-rtl.css\";i:229;s:33:\"latest-comments/style-rtl.min.css\";i:230;s:25:\"latest-comments/style.css\";i:231;s:29:\"latest-comments/style.min.css\";i:232;s:27:\"latest-posts/editor-rtl.css\";i:233;s:31:\"latest-posts/editor-rtl.min.css\";i:234;s:23:\"latest-posts/editor.css\";i:235;s:27:\"latest-posts/editor.min.css\";i:236;s:26:\"latest-posts/style-rtl.css\";i:237;s:30:\"latest-posts/style-rtl.min.css\";i:238;s:22:\"latest-posts/style.css\";i:239;s:26:\"latest-posts/style.min.css\";i:240;s:18:\"list/style-rtl.css\";i:241;s:22:\"list/style-rtl.min.css\";i:242;s:14:\"list/style.css\";i:243;s:18:\"list/style.min.css\";i:244;s:22:\"loginout/style-rtl.css\";i:245;s:26:\"loginout/style-rtl.min.css\";i:246;s:18:\"loginout/style.css\";i:247;s:22:\"loginout/style.min.css\";i:248;s:19:\"math/editor-rtl.css\";i:249;s:23:\"math/editor-rtl.min.css\";i:250;s:15:\"math/editor.css\";i:251;s:19:\"math/editor.min.css\";i:252;s:18:\"math/style-rtl.css\";i:253;s:22:\"math/style-rtl.min.css\";i:254;s:14:\"math/style.css\";i:255;s:18:\"math/style.min.css\";i:256;s:25:\"media-text/editor-rtl.css\";i:257;s:29:\"media-text/editor-rtl.min.css\";i:258;s:21:\"media-text/editor.css\";i:259;s:25:\"media-text/editor.min.css\";i:260;s:24:\"media-text/style-rtl.css\";i:261;s:28:\"media-text/style-rtl.min.css\";i:262;s:20:\"media-text/style.css\";i:263;s:24:\"media-text/style.min.css\";i:264;s:19:\"more/editor-rtl.css\";i:265;s:23:\"more/editor-rtl.min.css\";i:266;s:15:\"more/editor.css\";i:267;s:19:\"more/editor.min.css\";i:268;s:30:\"navigation-link/editor-rtl.css\";i:269;s:34:\"navigation-link/editor-rtl.min.css\";i:270;s:26:\"navigation-link/editor.css\";i:271;s:30:\"navigation-link/editor.min.css\";i:272;s:29:\"navigation-link/style-rtl.css\";i:273;s:33:\"navigation-link/style-rtl.min.css\";i:274;s:25:\"navigation-link/style.css\";i:275;s:29:\"navigation-link/style.min.css\";i:276;s:33:\"navigation-submenu/editor-rtl.css\";i:277;s:37:\"navigation-submenu/editor-rtl.min.css\";i:278;s:29:\"navigation-submenu/editor.css\";i:279;s:33:\"navigation-submenu/editor.min.css\";i:280;s:25:\"navigation/editor-rtl.css\";i:281;s:29:\"navigation/editor-rtl.min.css\";i:282;s:21:\"navigation/editor.css\";i:283;s:25:\"navigation/editor.min.css\";i:284;s:24:\"navigation/style-rtl.css\";i:285;s:28:\"navigation/style-rtl.min.css\";i:286;s:20:\"navigation/style.css\";i:287;s:24:\"navigation/style.min.css\";i:288;s:23:\"nextpage/editor-rtl.css\";i:289;s:27:\"nextpage/editor-rtl.min.css\";i:290;s:19:\"nextpage/editor.css\";i:291;s:23:\"nextpage/editor.min.css\";i:292;s:24:\"page-list/editor-rtl.css\";i:293;s:28:\"page-list/editor-rtl.min.css\";i:294;s:20:\"page-list/editor.css\";i:295;s:24:\"page-list/editor.min.css\";i:296;s:23:\"page-list/style-rtl.css\";i:297;s:27:\"page-list/style-rtl.min.css\";i:298;s:19:\"page-list/style.css\";i:299;s:23:\"page-list/style.min.css\";i:300;s:24:\"paragraph/editor-rtl.css\";i:301;s:28:\"paragraph/editor-rtl.min.css\";i:302;s:20:\"paragraph/editor.css\";i:303;s:24:\"paragraph/editor.min.css\";i:304;s:23:\"paragraph/style-rtl.css\";i:305;s:27:\"paragraph/style-rtl.min.css\";i:306;s:19:\"paragraph/style.css\";i:307;s:23:\"paragraph/style.min.css\";i:308;s:35:\"post-author-biography/style-rtl.css\";i:309;s:39:\"post-author-biography/style-rtl.min.css\";i:310;s:31:\"post-author-biography/style.css\";i:311;s:35:\"post-author-biography/style.min.css\";i:312;s:30:\"post-author-name/style-rtl.css\";i:313;s:34:\"post-author-name/style-rtl.min.css\";i:314;s:26:\"post-author-name/style.css\";i:315;s:30:\"post-author-name/style.min.css\";i:316;s:25:\"post-author/style-rtl.css\";i:317;s:29:\"post-author/style-rtl.min.css\";i:318;s:21:\"post-author/style.css\";i:319;s:25:\"post-author/style.min.css\";i:320;s:33:\"post-comments-count/style-rtl.css\";i:321;s:37:\"post-comments-count/style-rtl.min.css\";i:322;s:29:\"post-comments-count/style.css\";i:323;s:33:\"post-comments-count/style.min.css\";i:324;s:33:\"post-comments-form/editor-rtl.css\";i:325;s:37:\"post-comments-form/editor-rtl.min.css\";i:326;s:29:\"post-comments-form/editor.css\";i:327;s:33:\"post-comments-form/editor.min.css\";i:328;s:32:\"post-comments-form/style-rtl.css\";i:329;s:36:\"post-comments-form/style-rtl.min.css\";i:330;s:28:\"post-comments-form/style.css\";i:331;s:32:\"post-comments-form/style.min.css\";i:332;s:32:\"post-comments-link/style-rtl.css\";i:333;s:36:\"post-comments-link/style-rtl.min.css\";i:334;s:28:\"post-comments-link/style.css\";i:335;s:32:\"post-comments-link/style.min.css\";i:336;s:26:\"post-content/style-rtl.css\";i:337;s:30:\"post-content/style-rtl.min.css\";i:338;s:22:\"post-content/style.css\";i:339;s:26:\"post-content/style.min.css\";i:340;s:23:\"post-date/style-rtl.css\";i:341;s:27:\"post-date/style-rtl.min.css\";i:342;s:19:\"post-date/style.css\";i:343;s:23:\"post-date/style.min.css\";i:344;s:27:\"post-excerpt/editor-rtl.css\";i:345;s:31:\"post-excerpt/editor-rtl.min.css\";i:346;s:23:\"post-excerpt/editor.css\";i:347;s:27:\"post-excerpt/editor.min.css\";i:348;s:26:\"post-excerpt/style-rtl.css\";i:349;s:30:\"post-excerpt/style-rtl.min.css\";i:350;s:22:\"post-excerpt/style.css\";i:351;s:26:\"post-excerpt/style.min.css\";i:352;s:34:\"post-featured-image/editor-rtl.css\";i:353;s:38:\"post-featured-image/editor-rtl.min.css\";i:354;s:30:\"post-featured-image/editor.css\";i:355;s:34:\"post-featured-image/editor.min.css\";i:356;s:33:\"post-featured-image/style-rtl.css\";i:357;s:37:\"post-featured-image/style-rtl.min.css\";i:358;s:29:\"post-featured-image/style.css\";i:359;s:33:\"post-featured-image/style.min.css\";i:360;s:34:\"post-navigation-link/style-rtl.css\";i:361;s:38:\"post-navigation-link/style-rtl.min.css\";i:362;s:30:\"post-navigation-link/style.css\";i:363;s:34:\"post-navigation-link/style.min.css\";i:364;s:27:\"post-template/style-rtl.css\";i:365;s:31:\"post-template/style-rtl.min.css\";i:366;s:23:\"post-template/style.css\";i:367;s:27:\"post-template/style.min.css\";i:368;s:24:\"post-terms/style-rtl.css\";i:369;s:28:\"post-terms/style-rtl.min.css\";i:370;s:20:\"post-terms/style.css\";i:371;s:24:\"post-terms/style.min.css\";i:372;s:31:\"post-time-to-read/style-rtl.css\";i:373;s:35:\"post-time-to-read/style-rtl.min.css\";i:374;s:27:\"post-time-to-read/style.css\";i:375;s:31:\"post-time-to-read/style.min.css\";i:376;s:24:\"post-title/style-rtl.css\";i:377;s:28:\"post-title/style-rtl.min.css\";i:378;s:20:\"post-title/style.css\";i:379;s:24:\"post-title/style.min.css\";i:380;s:26:\"preformatted/style-rtl.css\";i:381;s:30:\"preformatted/style-rtl.min.css\";i:382;s:22:\"preformatted/style.css\";i:383;s:26:\"preformatted/style.min.css\";i:384;s:24:\"pullquote/editor-rtl.css\";i:385;s:28:\"pullquote/editor-rtl.min.css\";i:386;s:20:\"pullquote/editor.css\";i:387;s:24:\"pullquote/editor.min.css\";i:388;s:23:\"pullquote/style-rtl.css\";i:389;s:27:\"pullquote/style-rtl.min.css\";i:390;s:19:\"pullquote/style.css\";i:391;s:23:\"pullquote/style.min.css\";i:392;s:23:\"pullquote/theme-rtl.css\";i:393;s:27:\"pullquote/theme-rtl.min.css\";i:394;s:19:\"pullquote/theme.css\";i:395;s:23:\"pullquote/theme.min.css\";i:396;s:39:\"query-pagination-numbers/editor-rtl.css\";i:397;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:398;s:35:\"query-pagination-numbers/editor.css\";i:399;s:39:\"query-pagination-numbers/editor.min.css\";i:400;s:31:\"query-pagination/editor-rtl.css\";i:401;s:35:\"query-pagination/editor-rtl.min.css\";i:402;s:27:\"query-pagination/editor.css\";i:403;s:31:\"query-pagination/editor.min.css\";i:404;s:30:\"query-pagination/style-rtl.css\";i:405;s:34:\"query-pagination/style-rtl.min.css\";i:406;s:26:\"query-pagination/style.css\";i:407;s:30:\"query-pagination/style.min.css\";i:408;s:25:\"query-title/style-rtl.css\";i:409;s:29:\"query-title/style-rtl.min.css\";i:410;s:21:\"query-title/style.css\";i:411;s:25:\"query-title/style.min.css\";i:412;s:25:\"query-total/style-rtl.css\";i:413;s:29:\"query-total/style-rtl.min.css\";i:414;s:21:\"query-total/style.css\";i:415;s:25:\"query-total/style.min.css\";i:416;s:20:\"query/editor-rtl.css\";i:417;s:24:\"query/editor-rtl.min.css\";i:418;s:16:\"query/editor.css\";i:419;s:20:\"query/editor.min.css\";i:420;s:19:\"quote/style-rtl.css\";i:421;s:23:\"quote/style-rtl.min.css\";i:422;s:15:\"quote/style.css\";i:423;s:19:\"quote/style.min.css\";i:424;s:19:\"quote/theme-rtl.css\";i:425;s:23:\"quote/theme-rtl.min.css\";i:426;s:15:\"quote/theme.css\";i:427;s:19:\"quote/theme.min.css\";i:428;s:23:\"read-more/style-rtl.css\";i:429;s:27:\"read-more/style-rtl.min.css\";i:430;s:19:\"read-more/style.css\";i:431;s:23:\"read-more/style.min.css\";i:432;s:18:\"rss/editor-rtl.css\";i:433;s:22:\"rss/editor-rtl.min.css\";i:434;s:14:\"rss/editor.css\";i:435;s:18:\"rss/editor.min.css\";i:436;s:17:\"rss/style-rtl.css\";i:437;s:21:\"rss/style-rtl.min.css\";i:438;s:13:\"rss/style.css\";i:439;s:17:\"rss/style.min.css\";i:440;s:21:\"search/editor-rtl.css\";i:441;s:25:\"search/editor-rtl.min.css\";i:442;s:17:\"search/editor.css\";i:443;s:21:\"search/editor.min.css\";i:444;s:20:\"search/style-rtl.css\";i:445;s:24:\"search/style-rtl.min.css\";i:446;s:16:\"search/style.css\";i:447;s:20:\"search/style.min.css\";i:448;s:20:\"search/theme-rtl.css\";i:449;s:24:\"search/theme-rtl.min.css\";i:450;s:16:\"search/theme.css\";i:451;s:20:\"search/theme.min.css\";i:452;s:24:\"separator/editor-rtl.css\";i:453;s:28:\"separator/editor-rtl.min.css\";i:454;s:20:\"separator/editor.css\";i:455;s:24:\"separator/editor.min.css\";i:456;s:23:\"separator/style-rtl.css\";i:457;s:27:\"separator/style-rtl.min.css\";i:458;s:19:\"separator/style.css\";i:459;s:23:\"separator/style.min.css\";i:460;s:23:\"separator/theme-rtl.css\";i:461;s:27:\"separator/theme-rtl.min.css\";i:462;s:19:\"separator/theme.css\";i:463;s:23:\"separator/theme.min.css\";i:464;s:24:\"shortcode/editor-rtl.css\";i:465;s:28:\"shortcode/editor-rtl.min.css\";i:466;s:20:\"shortcode/editor.css\";i:467;s:24:\"shortcode/editor.min.css\";i:468;s:24:\"site-logo/editor-rtl.css\";i:469;s:28:\"site-logo/editor-rtl.min.css\";i:470;s:20:\"site-logo/editor.css\";i:471;s:24:\"site-logo/editor.min.css\";i:472;s:23:\"site-logo/style-rtl.css\";i:473;s:27:\"site-logo/style-rtl.min.css\";i:474;s:19:\"site-logo/style.css\";i:475;s:23:\"site-logo/style.min.css\";i:476;s:27:\"site-tagline/editor-rtl.css\";i:477;s:31:\"site-tagline/editor-rtl.min.css\";i:478;s:23:\"site-tagline/editor.css\";i:479;s:27:\"site-tagline/editor.min.css\";i:480;s:26:\"site-tagline/style-rtl.css\";i:481;s:30:\"site-tagline/style-rtl.min.css\";i:482;s:22:\"site-tagline/style.css\";i:483;s:26:\"site-tagline/style.min.css\";i:484;s:25:\"site-title/editor-rtl.css\";i:485;s:29:\"site-title/editor-rtl.min.css\";i:486;s:21:\"site-title/editor.css\";i:487;s:25:\"site-title/editor.min.css\";i:488;s:24:\"site-title/style-rtl.css\";i:489;s:28:\"site-title/style-rtl.min.css\";i:490;s:20:\"site-title/style.css\";i:491;s:24:\"site-title/style.min.css\";i:492;s:26:\"social-link/editor-rtl.css\";i:493;s:30:\"social-link/editor-rtl.min.css\";i:494;s:22:\"social-link/editor.css\";i:495;s:26:\"social-link/editor.min.css\";i:496;s:27:\"social-links/editor-rtl.css\";i:497;s:31:\"social-links/editor-rtl.min.css\";i:498;s:23:\"social-links/editor.css\";i:499;s:27:\"social-links/editor.min.css\";i:500;s:26:\"social-links/style-rtl.css\";i:501;s:30:\"social-links/style-rtl.min.css\";i:502;s:22:\"social-links/style.css\";i:503;s:26:\"social-links/style.min.css\";i:504;s:21:\"spacer/editor-rtl.css\";i:505;s:25:\"spacer/editor-rtl.min.css\";i:506;s:17:\"spacer/editor.css\";i:507;s:21:\"spacer/editor.min.css\";i:508;s:20:\"spacer/style-rtl.css\";i:509;s:24:\"spacer/style-rtl.min.css\";i:510;s:16:\"spacer/style.css\";i:511;s:20:\"spacer/style.min.css\";i:512;s:20:\"table/editor-rtl.css\";i:513;s:24:\"table/editor-rtl.min.css\";i:514;s:16:\"table/editor.css\";i:515;s:20:\"table/editor.min.css\";i:516;s:19:\"table/style-rtl.css\";i:517;s:23:\"table/style-rtl.min.css\";i:518;s:15:\"table/style.css\";i:519;s:19:\"table/style.min.css\";i:520;s:19:\"table/theme-rtl.css\";i:521;s:23:\"table/theme-rtl.min.css\";i:522;s:15:\"table/theme.css\";i:523;s:19:\"table/theme.min.css\";i:524;s:24:\"tag-cloud/editor-rtl.css\";i:525;s:28:\"tag-cloud/editor-rtl.min.css\";i:526;s:20:\"tag-cloud/editor.css\";i:527;s:24:\"tag-cloud/editor.min.css\";i:528;s:23:\"tag-cloud/style-rtl.css\";i:529;s:27:\"tag-cloud/style-rtl.min.css\";i:530;s:19:\"tag-cloud/style.css\";i:531;s:23:\"tag-cloud/style.min.css\";i:532;s:28:\"template-part/editor-rtl.css\";i:533;s:32:\"template-part/editor-rtl.min.css\";i:534;s:24:\"template-part/editor.css\";i:535;s:28:\"template-part/editor.min.css\";i:536;s:27:\"template-part/theme-rtl.css\";i:537;s:31:\"template-part/theme-rtl.min.css\";i:538;s:23:\"template-part/theme.css\";i:539;s:27:\"template-part/theme.min.css\";i:540;s:24:\"term-count/style-rtl.css\";i:541;s:28:\"term-count/style-rtl.min.css\";i:542;s:20:\"term-count/style.css\";i:543;s:24:\"term-count/style.min.css\";i:544;s:30:\"term-description/style-rtl.css\";i:545;s:34:\"term-description/style-rtl.min.css\";i:546;s:26:\"term-description/style.css\";i:547;s:30:\"term-description/style.min.css\";i:548;s:23:\"term-name/style-rtl.css\";i:549;s:27:\"term-name/style-rtl.min.css\";i:550;s:19:\"term-name/style.css\";i:551;s:23:\"term-name/style.min.css\";i:552;s:28:\"term-template/editor-rtl.css\";i:553;s:32:\"term-template/editor-rtl.min.css\";i:554;s:24:\"term-template/editor.css\";i:555;s:28:\"term-template/editor.min.css\";i:556;s:27:\"term-template/style-rtl.css\";i:557;s:31:\"term-template/style-rtl.min.css\";i:558;s:23:\"term-template/style.css\";i:559;s:27:\"term-template/style.min.css\";i:560;s:27:\"text-columns/editor-rtl.css\";i:561;s:31:\"text-columns/editor-rtl.min.css\";i:562;s:23:\"text-columns/editor.css\";i:563;s:27:\"text-columns/editor.min.css\";i:564;s:26:\"text-columns/style-rtl.css\";i:565;s:30:\"text-columns/style-rtl.min.css\";i:566;s:22:\"text-columns/style.css\";i:567;s:26:\"text-columns/style.min.css\";i:568;s:19:\"verse/style-rtl.css\";i:569;s:23:\"verse/style-rtl.min.css\";i:570;s:15:\"verse/style.css\";i:571;s:19:\"verse/style.min.css\";i:572;s:20:\"video/editor-rtl.css\";i:573;s:24:\"video/editor-rtl.min.css\";i:574;s:16:\"video/editor.css\";i:575;s:20:\"video/editor.min.css\";i:576;s:19:\"video/style-rtl.css\";i:577;s:23:\"video/style-rtl.min.css\";i:578;s:15:\"video/style.css\";i:579;s:19:\"video/style.min.css\";i:580;s:19:\"video/theme-rtl.css\";i:581;s:23:\"video/theme-rtl.min.css\";i:582;s:15:\"video/theme.css\";i:583;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `dev_options` VALUES("126", "theme_mods_twentytwentyfive", "a:1:{s:18:\"custom_css_post_id\";i:-1;}", "auto");
INSERT INTO `dev_options` VALUES("127", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"52df3fed8c18942fbf07b3fb425f8998\";s:6:\"blocks\";a:53:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:18:\"core/term-template\";s:0:\"\";s:12:\"core/columns\";s:769:\":root :where(.wp-block-columns-is-layout-flow) > :first-child{margin-block-start: 0;}:root :where(.wp-block-columns-is-layout-flow) > :last-child{margin-block-end: 0;}:root :where(.wp-block-columns-is-layout-flow) > *{margin-block-start: var(--wp--preset--spacing--50);margin-block-end: 0;}:root :where(.wp-block-columns-is-layout-constrained) > :first-child{margin-block-start: 0;}:root :where(.wp-block-columns-is-layout-constrained) > :last-child{margin-block-end: 0;}:root :where(.wp-block-columns-is-layout-constrained) > *{margin-block-start: var(--wp--preset--spacing--50);margin-block-end: 0;}:root :where(.wp-block-columns-is-layout-flex){gap: var(--wp--preset--spacing--50);}:root :where(.wp-block-columns-is-layout-grid){gap: var(--wp--preset--spacing--50);}\";s:14:\"core/pullquote\";s:306:\":root :where(.wp-block-pullquote){font-size: var(--wp--preset--font-size--xx-large);font-weight: 300;line-height: 1.2;padding-top: var(--wp--preset--spacing--30);padding-bottom: var(--wp--preset--spacing--30);}:root :where(.wp-block-pullquote p:last-of-type){margin-bottom: var(--wp--preset--spacing--30);}\";s:32:\"c48738dcb285a3f6ab83acff204fc486\";s:106:\":root :where(.wp-block-pullquote cite){font-size: var(--wp--preset--font-size--small);font-style: normal;}\";s:11:\"core/avatar\";s:57:\":root :where(.wp-block-avatar img){border-radius: 100px;}\";s:12:\"core/buttons\";s:665:\":root :where(.wp-block-buttons-is-layout-flow) > :first-child{margin-block-start: 0;}:root :where(.wp-block-buttons-is-layout-flow) > :last-child{margin-block-end: 0;}:root :where(.wp-block-buttons-is-layout-flow) > *{margin-block-start: 16px;margin-block-end: 0;}:root :where(.wp-block-buttons-is-layout-constrained) > :first-child{margin-block-start: 0;}:root :where(.wp-block-buttons-is-layout-constrained) > :last-child{margin-block-end: 0;}:root :where(.wp-block-buttons-is-layout-constrained) > *{margin-block-start: 16px;margin-block-end: 0;}:root :where(.wp-block-buttons-is-layout-flex){gap: 16px;}:root :where(.wp-block-buttons-is-layout-grid){gap: 16px;}\";s:9:\"core/code\";s:427:\":root :where(.wp-block-code){background-color: var(--wp--preset--color--accent-5);color: var(--wp--preset--color--contrast);font-family: var(--wp--preset--font-family--fira-code);font-size: var(--wp--preset--font-size--medium);font-weight: 300;padding-top: var(--wp--preset--spacing--40);padding-right: var(--wp--preset--spacing--40);padding-bottom: var(--wp--preset--spacing--40);padding-left: var(--wp--preset--spacing--40);}\";s:24:\"core/comment-author-name\";s:169:\":root :where(.wp-block-comment-author-name){color: var(--wp--preset--color--accent-4);font-size: var(--wp--preset--font-size--small);margin-top: 5px;margin-bottom: 0px;}\";s:32:\"c0002c260f8238c4212f3e4c369fc4f7\";s:143:\":root :where(.wp-block-comment-author-name a:where(:not(.wp-element-button))){color: var(--wp--preset--color--accent-4);text-decoration: none;}\";s:32:\"1e7c38b45537b325dbbbaec17a301676\";s:112:\":root :where(.wp-block-comment-author-name a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:20:\"core/comment-content\";s:178:\":root :where(.wp-block-comment-content){font-size: var(--wp--preset--font-size--medium);margin-top: var(--wp--preset--spacing--30);margin-bottom: var(--wp--preset--spacing--30);}\";s:17:\"core/comment-date\";s:127:\":root :where(.wp-block-comment-date){color: var(--wp--preset--color--contrast);font-size: var(--wp--preset--font-size--small);}\";s:32:\"c83ca7b3e52884c70f7830c54f99b318\";s:114:\":root :where(.wp-block-comment-date a:where(:not(.wp-element-button))){color: var(--wp--preset--color--contrast);}\";s:22:\"core/comment-edit-link\";s:90:\":root :where(.wp-block-comment-edit-link){font-size: var(--wp--preset--font-size--small);}\";s:32:\"41d70710612536a90e368c12bcb0efea\";s:119:\":root :where(.wp-block-comment-edit-link a:where(:not(.wp-element-button))){color: var(--wp--preset--color--contrast);}\";s:23:\"core/comment-reply-link\";s:91:\":root :where(.wp-block-comment-reply-link){font-size: var(--wp--preset--font-size--small);}\";s:32:\"13c96340dbf37700add1f4c5cae19f3e\";s:120:\":root :where(.wp-block-comment-reply-link a:where(:not(.wp-element-button))){color: var(--wp--preset--color--contrast);}\";s:23:\"core/post-comments-form\";s:565:\":root :where(.wp-block-post-comments-form){font-size: var(--wp--preset--font-size--medium);padding-top: var(--wp--preset--spacing--40);padding-bottom: var(--wp--preset--spacing--40);}:root :where(.wp-block-post-comments-form textarea, .wp-block-post-comments-form input:not([type=submit])){border-radius:.25rem; border-color: var(--wp--preset--color--accent-6) !important;}:root :where(.wp-block-post-comments-form input[type=checkbox]){margin:0 .2rem 0 0 !important;}:root :where(.wp-block-post-comments-form label){font-size: var(--wp--preset--font-size--small);}\";s:24:\"core/comments-pagination\";s:182:\":root :where(.wp-block-comments-pagination){font-size: var(--wp--preset--font-size--medium);margin-top: var(--wp--preset--spacing--40);margin-bottom: var(--wp--preset--spacing--40);}\";s:29:\"core/comments-pagination-next\";s:98:\":root :where(.wp-block-comments-pagination-next){font-size: var(--wp--preset--font-size--medium);}\";s:32:\"core/comments-pagination-numbers\";s:101:\":root :where(.wp-block-comments-pagination-numbers){font-size: var(--wp--preset--font-size--medium);}\";s:33:\"core/comments-pagination-previous\";s:102:\":root :where(.wp-block-comments-pagination-previous){font-size: var(--wp--preset--font-size--medium);}\";s:14:\"core/post-date\";s:124:\":root :where(.wp-block-post-date){color: var(--wp--preset--color--accent-4);font-size: var(--wp--preset--font-size--small);}\";s:32:\"ac0d4e00f5ec22d14451759983e5bd43\";s:133:\":root :where(.wp-block-post-date a:where(:not(.wp-element-button))){color: var(--wp--preset--color--accent-4);text-decoration: none;}\";s:32:\"0ae6ffd1b886044c2da62d75d05ab13d\";s:102:\":root :where(.wp-block-post-date a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:25:\"core/post-navigation-link\";s:94:\":root :where(.wp-block-post-navigation-link){font-size: var(--wp--preset--font-size--medium);}\";s:15:\"core/post-terms\";s:158:\":root :where(.wp-block-post-terms){font-size: var(--wp--preset--font-size--small);font-weight: 600;}:root :where(.wp-block-post-terms a){white-space: nowrap;}\";s:15:\"core/post-title\";s:0:\"\";s:32:\"bb496d3fcd9be3502ce57ff8281e5687\";s:92:\":root :where(.wp-block-post-title a:where(:not(.wp-element-button))){text-decoration: none;}\";s:32:\"12380ab98fdc81351bb32a39bbfc9249\";s:103:\":root :where(.wp-block-post-title a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:10:\"core/quote\";s:1315:\":root :where(.wp-block-quote){border-color: currentColor;border-width: 0 0 0 2px;border-style: solid;font-size: var(--wp--preset--font-size--large);font-weight: 300;margin-right: 0;margin-left: 0;padding-top: var(--wp--preset--spacing--30);padding-right: var(--wp--preset--spacing--40);padding-bottom: var(--wp--preset--spacing--30);padding-left: var(--wp--preset--spacing--40);}:root :where(.wp-block-quote-is-layout-flow) > :first-child{margin-block-start: 0;}:root :where(.wp-block-quote-is-layout-flow) > :last-child{margin-block-end: 0;}:root :where(.wp-block-quote-is-layout-flow) > *{margin-block-start: var(--wp--preset--spacing--30);margin-block-end: 0;}:root :where(.wp-block-quote-is-layout-constrained) > :first-child{margin-block-start: 0;}:root :where(.wp-block-quote-is-layout-constrained) > :last-child{margin-block-end: 0;}:root :where(.wp-block-quote-is-layout-constrained) > *{margin-block-start: var(--wp--preset--spacing--30);margin-block-end: 0;}:root :where(.wp-block-quote-is-layout-flex){gap: var(--wp--preset--spacing--30);}:root :where(.wp-block-quote-is-layout-grid){gap: var(--wp--preset--spacing--30);}:root :where(.wp-block-quote.has-text-align-right ){border-width: 0 2px 0 0;}:root :where(.wp-block-quote.has-text-align-center ){border-width: 0;border-inline: 0; padding-inline: 0;}\";s:32:\"1de7a22e22013106efc5be82788cb6c0\";s:176:\":root :where(.wp-block-quote cite){font-size: var(--wp--preset--font-size--small);font-style: normal;font-weight: 300;}:root :where(.wp-block-quote cite sub){font-size: 0.65em}\";s:21:\"core/query-pagination\";s:107:\":root :where(.wp-block-query-pagination){font-size: var(--wp--preset--font-size--medium);font-weight: 500;}\";s:11:\"core/search\";s:380:\":root :where(.wp-block-search .wp-block-search__label, .wp-block-search .wp-block-search__input, .wp-block-search .wp-block-search__button){font-size: var(--wp--preset--font-size--medium);line-height: 1.6;}:root :where(.wp-block-search .wp-block-search__input){border-radius:3.125rem;padding-left:1.5625rem;padding-right:1.5625rem;border-color:var(--wp--preset--color--accent-6);}\";s:32:\"14fa6a3d0cfbde171cbc0fb04aa8a6cf\";s:138:\":root :where(.wp-block-search .wp-element-button,.wp-block-search  .wp-block-button__link){border-radius: 3.125rem;margin-left: 1.125rem;}\";s:32:\"05993ee2f3de94b5d1350998a7e9b6b0\";s:130:\":root :where(.wp-block-search .wp-element-button:hover,.wp-block-search  .wp-block-button__link:hover){border-color: transparent;}\";s:14:\"core/separator\";s:148:\":root :where(.wp-block-separator){border-color: currentColor;border-width: 0 0 1px 0;border-style: solid;color: var(--wp--preset--color--accent-6);}\";s:17:\"core/site-tagline\";s:86:\":root :where(.wp-block-site-tagline){font-size: var(--wp--preset--font-size--medium);}\";s:15:\"core/site-title\";s:75:\":root :where(.wp-block-site-title){font-weight: 700;letter-spacing: -.5px;}\";s:32:\"f513d889cf971b13995cc3fffed2f39b\";s:92:\":root :where(.wp-block-site-title a:where(:not(.wp-element-button))){text-decoration: none;}\";s:32:\"22c37a317cc0ebd50155b5ad78564f37\";s:103:\":root :where(.wp-block-site-title a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:21:\"core/term-description\";s:90:\":root :where(.wp-block-term-description){font-size: var(--wp--preset--font-size--medium);}\";s:15:\"core/navigation\";s:84:\":root :where(.wp-block-navigation){font-size: var(--wp--preset--font-size--medium);}\";s:32:\"25289a01850f5a0264ddb79a9a3baf3d\";s:92:\":root :where(.wp-block-navigation a:where(:not(.wp-element-button))){text-decoration: none;}\";s:32:\"026c04da08398d655a95047f1f235d97\";s:103:\":root :where(.wp-block-navigation a:where(:not(.wp-element-button)):hover){text-decoration: underline;}\";s:9:\"core/list\";s:52:\":root :where(.wp-block-list li){margin-top: 0.5rem;}\";s:12:\"core/heading\";s:0:\"\";s:14:\"core/paragraph\";s:0:\"\";s:10:\"core/group\";s:0:\"\";s:11:\"core/column\";s:0:\"\";}}", "on");
INSERT INTO `dev_options` VALUES("129", "recovery_keys", "a:0:{}", "off");
INSERT INTO `dev_options` VALUES("130", "_site_transient_timeout_available_translations", "1768935011", "off");
INSERT INTO `dev_options` VALUES("131", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.11/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.7/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-07-10 08:09:09\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.7/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2024-12-26 00:37:42\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.28/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-01 10:38:20\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-19 13:30:22\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-07 17:22:08\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-11 21:36:34\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-06 10:29:49\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-18 15:47:02\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-10-23 12:01:47\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-15 02:39:48\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-15 02:38:57\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.9/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-28 08:11:27\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-28 08:08:17\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.9/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-18 14:30:43\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-25 13:30:15\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-23 16:40:44\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-24 12:51:19\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-30 11:47:57\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-13 06:27:29\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-13 20:32:21\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-12 22:21:48\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-10-01 22:54:47\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-05 13:30:31\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-07 17:17:39\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-07 19:47:18\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2024-10-16 21:04:12\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.12/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.18/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.23/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-13 04:21:30\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-06-06 09:50:37\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.7/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-11-05 21:53:17\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9-RC/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-25 18:17:43\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-02-14 17:29:08\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-29 11:04:04\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-10-03 04:54:28\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-02-01 23:56:53\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.7/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-10 11:15:06\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2025-12-20 19:08:53\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2025-10-21 16:35:04\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.8/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-18 15:51:09\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-09 11:14:55\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.34\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.34/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2024-05-04 18:39:24\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2025-02-06 05:17:11\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-06 08:46:03\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-07 20:36:41\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-16 11:21:47\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.28/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-01 17:48:46\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-08 15:07:02\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.28/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-11 16:56:34\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2024-07-18 02:49:24\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9-RC/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.23/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-31 11:41:21\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-16 00:49:25\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-08 08:55:07\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/6.9/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-01 21:45:29\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/translation/core/6.9/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-13 06:21:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-09-27 20:51:17\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-07-15 19:11:43\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.0.11/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-18 18:01:28\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-06-20 17:22:06\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.7/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-07 14:17:20\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.17\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.17/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-20 10:02:28\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-11-07 08:26:32\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.9-RC/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-28 09:40:20\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-18 15:26:13\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.9/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-12 18:34:59\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-01 09:45:52\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.35\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.35/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-02 18:21:27\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-08-21 12:15:00\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-02 10:17:43\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-02 00:03:57\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/6.9/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-09 09:48:35\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-02 08:03:19\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.18/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-01 04:57:17\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:6:\"6.9-RC\";s:7:\"updated\";s:19:\"2025-04-24 16:58:02\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/6.9-RC/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-10-29 11:19:02\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-24 16:29:39\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-03 15:37:44\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-27 15:18:03\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-11-16 17:19:56\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.12/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-13 08:39:22\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-12 14:35:24\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-24 03:42:11\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"6.8\";s:7:\"updated\";s:19:\"2025-04-18 21:10:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.8/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.18/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-09-01 09:12:13\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.9/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2025-12-02 00:32:44\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"6.9\";s:7:\"updated\";s:19:\"2026-01-06 20:16:48\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.9/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "off");
INSERT INTO `dev_options` VALUES("134", "_site_transient_timeout_theme_roots", "1768926026", "off");
INSERT INTO `dev_options` VALUES("135", "_site_transient_theme_roots", "a:4:{s:16:\"twentytwentyfive\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";s:15:\"twentytwentytwo\";s:7:\"/themes\";}", "off");
INSERT INTO `dev_options` VALUES("137", "_site_transient_timeout_browser_684fac3d8e595845640e507a9122bd55", "1769529027", "off");
INSERT INTO `dev_options` VALUES("138", "_site_transient_browser_684fac3d8e595845640e507a9122bd55", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"143.0.0.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `dev_options` VALUES("139", "_site_transient_timeout_php_check_7b9fb72b3bf6b27c046e3a9832dfe8e2", "1769529027", "off");
INSERT INTO `dev_options` VALUES("140", "_site_transient_php_check_7b9fb72b3bf6b27c046e3a9832dfe8e2", "a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:0;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `dev_options` VALUES("142", "can_compress_scripts", "0", "on");
INSERT INTO `dev_options` VALUES("143", "_site_transient_timeout_community-events-968af744fa494fbc8021c8b5cb964f36", "1768967429", "off");
INSERT INTO `dev_options` VALUES("144", "_site_transient_community-events-968af744fa494fbc8021c8b5cb964f36", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:21:\"2a01:cb19:8241:c100::\";}s:6:\"events\";a:2:{i:0;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:38:\"WordPress Campus Connect Zaragoza 2026\";s:3:\"url\";s:57:\"https://events.wordpress.org/campusconnect/2026/Zaragoza/\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2026-01-23 09:30:00\";s:8:\"end_date\";s:19:\"2026-01-23 09:30:00\";s:20:\"start_unix_timestamp\";i:1769157000;s:18:\"end_unix_timestamp\";i:1769157000;s:8:\"location\";a:4:{s:8:\"location\";s:12:\"Zaragoza, ES\";s:7:\"country\";s:2:\"ES\";s:8:\"latitude\";d:41.6593958;s:9:\"longitude\";d:-0.9072404;}}i:1;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:22:\"WordCamp Zaragoza 2026\";s:3:\"url\";s:35:\"https://zaragoza.wordcamp.org/2026/\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2026-01-23 09:30:00\";s:8:\"end_date\";s:19:\"2026-01-24 00:00:00\";s:20:\"start_unix_timestamp\";i:1769157000;s:18:\"end_unix_timestamp\";i:1769209200;s:8:\"location\";a:4:{s:8:\"location\";s:15:\"Zaragoza, Spain\";s:7:\"country\";s:2:\"ES\";s:8:\"latitude\";d:41.6593958;s:9:\"longitude\";d:-0.9072404;}}}}", "off");
INSERT INTO `dev_options` VALUES("145", "_site_transient_timeout_feed_0d2db5fea5a8633b56992c916819b198", "1768967429", "off");
INSERT INTO `dev_options` VALUES("146", "_site_transient_feed_0d2db5fea5a8633b56992c916819b198", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Blog – WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 10 Jan 2026 23:18:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fr-FR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=7.0-alpha-61499\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"Blog – WordPress.org Français\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fr.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"Arrêt du support des versions 7.2 et 7.3 de PHP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://fr.wordpress.org/2026/01/10/arret-support-php-version-72-73/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 10 Jan 2026 08:29:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Securité\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3423\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:383:\"À partir de WordPress 7.0 (version attendue en avril 2026), les versions 7.2 et 7.3 de PHP ne seront plus supportées par notre CMS. La&#160;version minimale recommandée&#160;de PHP restera 8.3, tandis que la&#160;version minimale supportée&#160;de PHP sera dorénavant la version 7.4. La version minimale supportée de PHP avait été montée à 7.2.24 en juillet 2024. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4603:\"\n<p>À partir de WordPress 7.0 (version attendue en avril 2026), les versions 7.2 et 7.3 de PHP ne seront plus supportées par notre CMS.</p>\n\n\n\n<p>La&nbsp;<em>version minimale recommandée</em>&nbsp;de PHP restera 8.3, tandis que la&nbsp;<em>version minimale supportée</em>&nbsp;de PHP sera dorénavant la version 7.4.</p>\n\n\n\n<p>La version minimale supportée de PHP avait été montée à 7.2.24 en juillet 2024. Depuis, les parts de marché combinées de PHP 7.2 et 7.3 dans l&rsquo;écosystème WordPress sont tombés <a href=\"https://fr.wordpress.org/about/stats/\">sous le seuil de 4 % des installations WordPress</a>.</p>\n\n\n\n<p>Historiquement, le projet WordPress définit à 5 % le seuil d&rsquo;utilisation minimal pour qu&rsquo;une version de PHP puisse être retirée du support. L&rsquo;utilisation combinée de PHP 7.2 et 7.3 étant désormais bien inférieure à 5 % d&rsquo;installations, le processus d&rsquo;augmentation de la version minimale de PHP requise peut être lancé.</p>\n\n\n\n<p>L&rsquo;objectif de l&rsquo;augmentation de la version minimale de PHP requise est de garantir la maintenabilité à long terme de WordPress. Les avantages de cette augmentation se manifestent progressivement dans de nombreux domaines&nbsp;: l&rsquo;écosystème des extensions et des thèmes, les outils et bibliothèques, la perception à long terme du projet WordPress, les relations avec les développeur·euses et, à terme, le code source de WordPress lui-même, notamment ses outils de développement et son infrastructure de tests automatisés.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Quelles projections à moyen terme sur le support de PHP par WordPress&nbsp;?</h2>\n\n\n\n<p>Il n&rsquo;est pas prévu d&rsquo;augmenter la version minimale de PHP requise selon un calendrier fixe. Les équipes <em><bdo lang=\"en\" dir=\"ltr\">Core</bdo></em> et <bdo lang=\"en\" dir=\"ltr\"><em>Security</em></bdo> de WP continueront de surveiller l&rsquo;utilisation des versions de PHP et de collaborer avec l&rsquo;équipe <em><bdo lang=\"en\" dir=\"ltr\">Hosting</bdo></em> (constituée d&rsquo;hébergeurs qui contribuent activement à WordPress) afin d&rsquo;inciter l&rsquo;écosystème à mettre à jour leur version de PHP le plus rapidement possible.</p>\n\n\n\n<p>Le seuil d&rsquo;utilisation de 5&nbsp;% restera la norme pour le moment pour décider de l&rsquo;arrêt ou non du support d&rsquo;une version.</p>\n\n\n\n<h3 class=\"wp-block-heading\">PHP 7.4, le principal goulot d&rsquo;étranglement pour monter la version minimale supportée de PHP </h3>\n\n\n\n<p>À ce jour, PHP 7.4 est le principal goulot d&rsquo;étranglement empêchant d&rsquo;aller plus loin. Voici en effet les parts de marché de chaque version de PHP dans l&rsquo;écosystème WP, au 10 janvier 2026&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>8.5 : 0,23&nbsp;%</li>\n\n\n\n<li>8.4 : 4,90&nbsp;%</li>\n\n\n\n<li>8.3 : 16,74&nbsp;%</li>\n\n\n\n<li>8.2 : 27,29&nbsp;%</li>\n\n\n\n<li>8.1 : 15,39&nbsp;%</li>\n\n\n\n<li>8.0 : 5,69&nbsp;%</li>\n\n\n\n<li><strong>7.4 : 22,20&nbsp;%</strong></li>\n\n\n\n<li>7.3 : 2,04&nbsp;% (arrêt du support en avril 2026)</li>\n\n\n\n<li>7.2 : 1,81&nbsp;% (arrêt du support en avril 2026)</li>\n</ul>\n\n\n\n<p>Avec 22,2% de parts de marché, PHP 7.4 risque de ne pas pouvoir être abandonné avant plusieurs années. Or, cette version est sortie en 2019 et son support officiel par PHP s&rsquo;est arrêté en 2022.</p>\n\n\n\n<p>Malheureusement, en dehors même de WordPress, il existe une multitude d&rsquo;applications et de sites construits sur d&rsquo;anciennes versions de PHP et qui sont incompatibles avec les versions ultérieures. C&rsquo;est sans doute pour cela que tant d&rsquo;hébergeurs proposent toujours PHP 7.4 à leurs clients, et qu&rsquo;il leur est si difficile d&rsquo;opérer des mises à niveau forcées vers des versions plus récentes&nbsp;: tant qu&rsquo;aucune faille de sécurité majeure ne sera publiée concernant PHP 7.4, il y a de fortes chances que ce <em>statu quo</em> demeure chez les hébergeurs importants, qui peuvent difficilement imposer une telle migration sur leur parc et risquer de casser des applicatifs critiques pour leurs clients.</p>\n\n\n\n<p>En attendant, <strong>WordPress est entièrement compatible avec PHP 8.3 qui est la version minimale officiellement recommandée pour faire tourner WP</strong>. Et <a href=\"https://make.wordpress.org/core/handbook/references/php-compatibility-and-wordpress-versions/\">la compatibilité 8.4 et 8.5 est presque complète (en anglais)</a> au niveau du cœur du CMS. N&rsquo;attendez pas pour effectuer la montée de version de PHP de votre côté&nbsp;!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3423\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"WordPress 6.9 « Gene »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://fr.wordpress.org/2025/12/02/wordpress-6-9-gene/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Dec 2025 20:17:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3411\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:350:\"Chaque version de WordPress rend hommage à un artiste ayant laissé une marque indélébile dans le monde la musique. Le nom de code de WordPress 6.9 est «&#160;Gene&#160;», en l&#8217;honneur du jazzman américain Gene Harris. Ce pianiste autodidacte dès l&#8217;âge de 6 ans a infusé le jazz populaire de soul de blues et de gospel, [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:77715:\"\n<figure class=\"wp-block-image size-full\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"535\" src=\"https://fr.wordpress.org/files/2025/12/Release-Edition-Featured-Image-6.9-1024x535-1.png\" alt=\"\" class=\"wp-image-3413\" srcset=\"https://fr.wordpress.org/files/2025/12/Release-Edition-Featured-Image-6.9-1024x535-1.png 1024w, https://fr.wordpress.org/files/2025/12/Release-Edition-Featured-Image-6.9-1024x535-1-300x157.png 300w, https://fr.wordpress.org/files/2025/12/Release-Edition-Featured-Image-6.9-1024x535-1-768x401.png 768w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></figure>\n\n\n\n<p>Chaque version de WordPress rend hommage à un artiste ayant laissé une marque indélébile dans le monde la musique. Le nom de code de WordPress 6.9 est «&nbsp;Gene&nbsp;», en l&rsquo;honneur du jazzman américain Gene Harris.</p>\n\n\n\n<p>Ce pianiste autodidacte dès l&rsquo;âge de 6 ans a infusé le jazz populaire de soul de blues et de gospel, apportant une chaleur et une signature iconique. L&rsquo;approche «&nbsp;<bdo lang=\"en\" dir=\"ltr\">bluesy</bdo>&nbsp;» du jazz de Gene Harris vivait à l&rsquo;intersection de deux mondes musicaux, apportant un paysage riche de textures et un supplément d&rsquo;âme qui restera à jamais.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue sur WordPress&nbsp;6.9</h2>\n\n\n\n<p>WordPress 6.9 apporte des changements majeurs concernant le travail collaboratif sur vos contenus éditoriaux.</p>\n\n\n\n<p>La nouvelle fonctionnalité «&nbsp;Notes&nbsp;» permet d&rsquo;ajouter des commentaires au niveau des blocs lors de la rédaction de publications, simplifiant ainsi la relecture et la validation du contenu.</p>\n\n\n\n<p>La palette de commandes étendue offre une navigation plus rapide dans votre administration.</p>\n\n\n\n<p>La nouvelle API «&nbsp;<bdo lang=\"en\" dir=\"ltr\">Abilities</bdo>&nbsp;» fournit un système de déclaration de fonctionnalités standardisé et lisible par machine, ouvrant la voie à des flux de travail automatisés et basés sur les nouvelles générations d&rsquo;outils IA.</p>\n\n\n\n<p>Cette version améliore également les performances de vos sites, notamment la vitesse de chargement des pages, et ajoute de nombreux nouveaux blocs éditoriaux, ainsi qu&rsquo;une interface de glisser-déposer plus intuitive, pour vous aider à concevoir du contenu riche et dynamique plus efficacement.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/download/\">Télécharger WordPress 6.9 «&nbsp;Gene&nbsp;»</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Les Notes, un nouveau système collaboratif</h2>\n\n\n\n<p><strong>Faites vos retours directement là où vous travaillez.</strong><br>Avec les notes liées directement aux blocs, votre équipe peut rester en phase, suivre les modifications, et transformer les retours en actions, tout au même endroit. Que vous travailliez sur l’écriture des textes ou sur l’affinage de la mise en page, la collaboration se fait avec fluidité directement dans le canevas de l’éditeur.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2025/12/6-9-notes.png\" alt=\"\" class=\"wp-image-19410\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Une palette de commandes disponible partout</h2>\n\n\n\n<p><strong>Vos outils sont toujours à portée de main.</strong><br>Accédez à la Palette de commandes depuis n’importe quelle partie de votre site, que vous soyez en train de rédiger votre dernier article, de travailler en profondeur sur le design du site dans l’Éditeur de site, ou de parcourir vos extensions. Tout ce dont vous avez besoin est maintenant à portée de clic.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2025/12/6-9-command-palette-everywhere.png\" alt=\"\" class=\"wp-image-19412\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Adapter le texte à son conteneur</h2>\n\n\n\n<p><strong>Un contenu qui s’adapte.</strong><br>Une nouvelle option de typographie pour les blocs de texte, à commencer par les blocs Paragraphe et Titre, qui ajuste automatiquement la taille de la police pour remplir parfaitement son conteneur. Idéal pour les bannières, les encadrés ou les éléments qui doivent se démarquer dans votre design. Aucun réglage manuel n’est nécessaire, vous obtenez instantanément un rendu propre.</p>\n\n\n\n<figure class=\"wp-block-image size-full\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2025/12/6-9-fit-text.png\" alt=\"\" class=\"wp-image-19413\" /></figure>\n\n\n\n<h2 class=\"wp-block-heading\">Une nouvelle API «&nbsp;Abilities&nbsp;»</h2>\n\n\n\n<p><strong>Un gestionnaire de fonctionnalités au cœur de WordPress</strong>.</p>\n\n\n\n<p>WordPress 6.9 pose les bases de l&rsquo;automatisation de demain grâce à l&rsquo;API «&nbsp;Abilities&nbsp;» unifiée. En créant un registre standardisé des fonctionnalités des sites, les développeurs peuvent désormais enregistrer, valider et exécuter des actions de manière cohérente dans tous les contextes (des points de terminaison PHP et REST aux agents IA), ouvrant ainsi la voie à des expériences WordPress plus intelligentes et connectées.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Amélioration de l’accessibilité</h2>\n\n\n\n<p>Plus de 30 corrections et améliorations en matière d’accessibilité, centrées sur les principales zones de l’expérience d’administration de WordPress. Cela va de la suppression complète du contenu généré par le CSS pour les technologies d’assistance, à l’amélioration des annonces des lecteurs d’écran, en passant par la correction de la position du curseur et le maintien du focus de saisie lors du clic sur les éléments de suggestion automatique.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Amélioration des performances</h2>\n\n\n\n<p>WordPress 6.9 comprend un vaste ensemble d’améliorations de performances. De meilleurs résultats sur la métrique&nbsp;LCP&nbsp;(<bdo lang=\"en\" dir=\"ltr\">Largest Contentful Paint</bdo>) sont obtenus grâce à un chargement amélioré des feuilles de style conditionnelles et en ligne, et grâce au chargement des scripts avec prise en charge de l’attribut <code>fetchpriority</code> et à des optimisations du cœur complémentaires. Les avancées de l’éditeur comprennent des correctifs pour les modifications de mise en page causés par le bloc Vidéo et un chargement plus rapide du sélecteur de termes.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Et bien plus encore</h3>\n\n\n\n<p>Pour une liste complète des nouvelles fonctionnalités, lisez <a href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/\" data-type=\"post\" data-id=\"3383\">notre guide technique à destination des développeurs et des développeuses (en français)</a>, ou consultez le <a href=\"https://wordpress.org/download/releases/6-9\">site dédié à WordPress 6.9 (en anglais)</a>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.9</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale :&nbsp;<a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination de la version :&nbsp;<a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a>, <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a></li>\n\n\n\n<li>Direction technique :&nbsp;<a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van Durpe</a>, <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a></li>\n\n\n\n<li>Direction artistique :&nbsp;<a href=\"https://profiles.wordpress.org/karmatosed/\"></a><a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco Vera</a></li>\n\n\n\n<li>Gestion de projet :&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\"></a><a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a>, <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a></li>\n\n\n\n<li>Direction des tests :&nbsp;<a href=\"https://profiles.wordpress.org/krupajnanda/\"></a><a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a>, <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>La mission de WordPress est de <a href=\"https://fr.wordpress.org/about/\">démocratiser la publication de contenu</a> et ce projet <a href=\"https://opensource.org/osd-annotated\">embrasse les libertés fondamentales de l&rsquo;open-source (en anglais)</a>. Une communauté mondiale et diversifiée supporte cet effort.</p>\n\n\n\n<p>WordPress 6.9 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>900 personnes provenant de près de 67 pays différents</strong>.</p>\n\n\n\n<p>Ce travail collaboratif a abouti à plus de 340 améliorations et correctifs, ce qui donne une nouvelle version majeure stable et efficace – un vrai témoignage de la vivacité de l&rsquo;écosystème open-source de notre CMS.</p>\n\n\n\n<div class=\"wp-block-group alignwide is-layout-constrained wp-block-group-is-layout-constrained\">\n<p class=\"has-extra-small-font-size\"><a href=\"https://profiles.wordpress.org/o-o/\">2046</a> · <a href=\"https://profiles.wordpress.org/aakashverma1/\">Aakash Verma</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/aarti1318/\">Aarti Chauhan</a> · <a href=\"https://profiles.wordpress.org/thehercules/\">Aashish Sharma</a> · <a href=\"https://profiles.wordpress.org/aatospaja/\">aatospaja</a> · <a href=\"https://profiles.wordpress.org/abduremon/\">Abdur Rahman Emon</a> · <a href=\"https://profiles.wordpress.org/hurayraiit/\">Abu Hurayra</a> · <a href=\"https://profiles.wordpress.org/kawauso/\">Adam Harley (Kawauso)</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adityab98/\">Aditya Bansode</a> · <a href=\"https://profiles.wordpress.org/b1ink0/\">Aditya Dhade</a> · <a href=\"https://profiles.wordpress.org/adityashah2411/\">aditya shah</a> · <a href=\"https://profiles.wordpress.org/iamadisingh/\">Aditya Singh</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/agulbra/\">agulbra</a> · <a href=\"https://profiles.wordpress.org/elazzabi/\">Ahmed</a> · <a href=\"https://profiles.wordpress.org/ajaxstardust/\">ajaxStardust</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akanshusingh/\">Akanshu Singh</a> · <a href=\"https://profiles.wordpress.org/akeda/\">Akeda Bagus</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/wpfy/\">Akramul Hasan</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/akshaydhere/\">Akshay Dhere</a> · <a href=\"https://profiles.wordpress.org/akshayar/\">Akshaya Rane</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a> · <a href=\"https://profiles.wordpress.org/alejandrogonzalvo/\">alejandrogonzalvo</a> · <a href=\"https://profiles.wordpress.org/alexcu21/\">Alex Cuadra</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexclassroom/\">Alex Lion (阿力獅)</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexus450/\">Alexei Samarschi</a> · <a href=\"https://profiles.wordpress.org/alexius08/\">Alexis Pandaan</a> · <a href=\"https://profiles.wordpress.org/alordiel/\">alordiel</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro Gómez</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/amin7/\">Amin</a> · <a href=\"https://profiles.wordpress.org/theaminuldev/\">Aminul Islam</a> · <a href=\"https://profiles.wordpress.org/aialvi/\">Aminul Islam Alvi</a> · <a href=\"https://profiles.wordpress.org/amitbhosale/\">Amit Bhosale</a> · <a href=\"https://profiles.wordpress.org/amykamala/\">Amy Kamala</a> · <a href=\"https://profiles.wordpress.org/anatolbroder/\">Anatol Broder</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Norén</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/andrewhoyer/\">Andrew Hoyer</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/mymothersdaughter/\">Anita C</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/annebovelett/\">Anne-Mieke Bovelett</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antoniosejas/\">Antonio Sejas</a> · <a href=\"https://profiles.wordpress.org/anujrathore24/\">Anuj Singh</a> · <a href=\"https://profiles.wordpress.org/anveshika/\">Anveshika Srivastava</a> · <a href=\"https://profiles.wordpress.org/apmeyer/\">apmeyer</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/fliespl/\">Arkadiusz Rzadkowolski</a> · <a href=\"https://profiles.wordpress.org/armandovias/\">Armando</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/artpi/\">Artur Piszek</a> · <a href=\"https://profiles.wordpress.org/artz91/\">ArtZ91</a> · <a href=\"https://profiles.wordpress.org/asafm7/\">asafm7</a> · <a href=\"https://profiles.wordpress.org/asdofindia/\">asdofindia</a> · <a href=\"https://profiles.wordpress.org/ashfame/\">Ashish Kumar (Ashfame)</a> · <a href=\"https://profiles.wordpress.org/akashdev/\">Ashraful Haque Akash</a> · <a href=\"https://profiles.wordpress.org/askapache/\">askapache</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/aurooba/\">Aurooba Ahmed</a> · <a href=\"https://profiles.wordpress.org/aut0poietic/\">aut0poietic</a> · <a href=\"https://profiles.wordpress.org/aksl95/\">Axel DUCORON</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/azharderaiya/\">Azhar Deraiya</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/bartnv/\">bartnv</a> · <a href=\"https://profiles.wordpress.org/bchecketts/\">bchecketts</a> · <a href=\"https://profiles.wordpress.org/beee/\">Beee</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/benazeer/\">Benazeer</a> · <a href=\"https://profiles.wordpress.org/rainbowgeek/\">Benjamin Denis</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/bvl/\">Benny</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/kau-boy/\">Bernhard Kau</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/bgermann/\">bgermann</a> · <a href=\"https://profiles.wordpress.org/bhattaganesh/\">bhattaganesh</a> · <a href=\"https://profiles.wordpress.org/bhaveshdesai/\">Bhavesh Desai</a> · <a href=\"https://profiles.wordpress.org/bidbmak/\">BiDbMAK</a> · <a href=\"https://profiles.wordpress.org/mbigul/\">Bigul Malayi</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/rainynewt/\">Bishal Shrestha</a> · <a href=\"https://profiles.wordpress.org/bobbyleenoblestudios/\">bobbyleenoblestudios</a> · <a href=\"https://profiles.wordpress.org/bogdanungureanu/\">BogdanUngureanu</a> · <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a> · <a href=\"https://profiles.wordpress.org/bor0/\">Boro Sitnikovski</a> · <a href=\"https://profiles.wordpress.org/burlesonbrad/\">Brad Griffin</a> · <a href=\"https://profiles.wordpress.org/bradley2083/\">brad hogan</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradshawtm/\">bradshawtm</a> · <a href=\"https://profiles.wordpress.org/bhubbard/\">Brandon Hubbard</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/heybran/\">Brandon Zhang</a> · <a href=\"https://profiles.wordpress.org/bgoewert/\">Brennan Goewert</a> · <a href=\"https://profiles.wordpress.org/brhodes/\">brhodes</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/brumack/\">brumack</a> · <a href=\"https://profiles.wordpress.org/bschneidewind/\">Bryan Schneidewind</a> · <a href=\"https://profiles.wordpress.org/bshuchter/\">bshuchter</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/byteninjaa0/\">byteninjaa0</a> · <a href=\"https://profiles.wordpress.org/cedche99/\">Cédric Chevillard</a> · <a href=\"https://profiles.wordpress.org/callumbw95/\">Callum Bridgford-Whittick</a> · <a href=\"https://profiles.wordpress.org/snicco/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/karl94/\">Carlo Cannas</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/carlsteffen/\">CarlSteffen</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/corazondejaguar/\">Carolina Romo</a> · <a href=\"https://profiles.wordpress.org/ciobanucatalin/\">Catalin Ciobanu</a> · <a href=\"https://profiles.wordpress.org/catgofire/\">catgofire</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/ccharel/\">ccharel</a> · <a href=\"https://profiles.wordpress.org/cbutlerjr/\">Chad Butler</a> · <a href=\"https://profiles.wordpress.org/shireling/\">Chad Chadbourne</a> · <a href=\"https://profiles.wordpress.org/cherrygot/\">Chakrapani Gautam</a> · <a href=\"https://profiles.wordpress.org/chihsuan/\">Chi-Hsuan Huang</a> · <a href=\"https://profiles.wordpress.org/chillifish/\">Chillifish</a> · <a href=\"https://profiles.wordpress.org/chloed/\">ChloeD</a> · <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a> · <a href=\"https://profiles.wordpress.org/czarate/\">Chris Zarate</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/chrisdotdotdot/\">chrisdotdotdot</a> · <a href=\"https://profiles.wordpress.org/chrismattix/\">chrismattix</a> · <a href=\"https://profiles.wordpress.org/christinecooper/\">christinecooper</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/nyiriland/\">Christy Nyiri</a> · <a href=\"https://profiles.wordpress.org/cikrimcin/\">cikrimcin</a> · <a href=\"https://profiles.wordpress.org/butterflymedia/\">Ciprian Popescu</a> · <a href=\"https://profiles.wordpress.org/chrisvendiadvertisingcom/\">cjhaas</a> · <a href=\"https://profiles.wordpress.org/ckoerner/\">ckoerner</a> · <a href=\"https://profiles.wordpress.org/claimableperch/\">claimableperch</a> · <a href=\"https://profiles.wordpress.org/codeamp/\">Code Amp</a> · <a href=\"https://profiles.wordpress.org/codebuddy/\">codebuddy</a> · <a href=\"https://profiles.wordpress.org/coleatkinson1/\">coleatkinson1</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/ogrecooper/\">Cooper Dalrymple</a> · <a href=\"https://profiles.wordpress.org/coralietixeront/\">Coralie Tixeront</a> · <a href=\"https://profiles.wordpress.org/salzano/\">Corey Salzano</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/cornwell/\">Cornwell</a> · <a href=\"https://profiles.wordpress.org/cr0ybot/\">Cory Hughart</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/cucocreative/\">cucocreative</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cyrille37/\">Cyrille37</a> · <a href=\"https://profiles.wordpress.org/daanvandenbergh/\">Daan van den Bergh</a> · <a href=\"https://profiles.wordpress.org/acketon/\">Dakota Chichester</a> · <a href=\"https://profiles.wordpress.org/damchtlv/\">damchtlv</a> · <a href=\"https://profiles.wordpress.org/damir-webthemer/\">Damir</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dancameron/\">Dan Cameron</a> · <a href=\"https://profiles.wordpress.org/danielpw/\">Dan Waldschmidt</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/danieliser/\">Daniel Iser</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/daniellacatus/\">daniellacatus</a> · <a href=\"https://profiles.wordpress.org/danielmorell/\">danielmorell</a> · <a href=\"https://profiles.wordpress.org/dscqbus/\">Danny Schmarsel</a> · <a href=\"https://profiles.wordpress.org/dannyreaktiv/\">dannyreaktiv</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/dryanpress/\">Dave Ryan</a> · <a href=\"https://profiles.wordpress.org/daveguitaruno/\">daveguitaruno</a> · <a href=\"https://profiles.wordpress.org/davilera/\">David Aguilera</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">David Arenas</a> · <a href=\"https://profiles.wordpress.org/dartiss/\">David Artiss</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/davidperez/\">David Perez</a> · <a href=\"https://profiles.wordpress.org/djivad/\">David Riviera</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/davidb/\">DavidB</a> · <a href=\"https://profiles.wordpress.org/dawidadach/\">dawidadach</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/dkarfa/\">Debabrata Karfa</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a> · <a href=\"https://profiles.wordpress.org/dingo_d/\">Denis Žoljom</a> · <a href=\"https://profiles.wordpress.org/realloc/\">Dennis Ploetner</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dennysdionigi/\">Dennys Dionigi</a> · <a href=\"https://profiles.wordpress.org/densinakum/\">Densi Nakum</a> · <a href=\"https://profiles.wordpress.org/derekherman/\">derekherman</a> · <a href=\"https://profiles.wordpress.org/devasheeshkaul/\">Devasheesh Kaul</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruval04/\">Dhruval Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dhruvik18/\">Dhruvik Malaviya</a> · <a href=\"https://profiles.wordpress.org/diebombe/\">diebombe</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divinenephron/\">divinenephron</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/dominiquepijnenburg/\">dominiquepijnenburg</a> · <a href=\"https://profiles.wordpress.org/donalirl/\">donalirl</a> · <a href=\"https://profiles.wordpress.org/doughamlin/\">doughamlin</a> · <a href=\"https://profiles.wordpress.org/dougmelvin/\">DougMelvin</a> · <a href=\"https://profiles.wordpress.org/drawcard/\">drawcard</a> · <a href=\"https://profiles.wordpress.org/dretzlaff/\">dretzlaff</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/dsawyers/\">dsawyers</a> · <a href=\"https://profiles.wordpress.org/dustintechsmith/\">dustintechsmith</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/eduwass/\">eduwass</a> · <a href=\"https://profiles.wordpress.org/ehti/\">Ehti</a> · <a href=\"https://profiles.wordpress.org/elialum/\">elialum</a> · <a href=\"https://profiles.wordpress.org/eliezerspp/\">Eliezer Peña</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/elvismdev/\">Elvis Morales</a> · <a href=\"https://profiles.wordpress.org/emaildano/\">emaildano</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emlebrun/\">Emilie LEBRUN</a> · <a href=\"https://profiles.wordpress.org/emranahmed/\">Emran Ahmed</a> · <a href=\"https://profiles.wordpress.org/enaanfarhan/\">Enaan Farhan</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/nrqsnchz/\">Enrique Sánchez</a> · <a href=\"https://profiles.wordpress.org/epeicher/\">epeicher</a> · <a href=\"https://profiles.wordpress.org/ekazda/\">Eric</a> · <a href=\"https://profiles.wordpress.org/ericlewis/\">Eric Andrew Lewis</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/ejoling/\">Erik Joling</a> · <a href=\"https://profiles.wordpress.org/im3dabasia1/\">Eshaan Dabasiya</a> · <a href=\"https://profiles.wordpress.org/ethanscorey/\">ethanscorey</a> · <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a> · <a href=\"https://profiles.wordpress.org/etobiesen/\">Even Tobiesen</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fakhriaz/\">fakhriaz</a> · <a href=\"https://profiles.wordpress.org/falgunihdesai/\">Falguni Desai</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/fellyph/\">Fellyph Cintra</a> · <a href=\"https://profiles.wordpress.org/mista-flo/\">Florian TIAR</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco Vera</a> · <a href=\"https://profiles.wordpress.org/frogdesk/\">FrogDesk Strategy</a> · <a href=\"https://profiles.wordpress.org/takahashi_fumiki/\">Fumiki Takahashi</a> · <a href=\"https://profiles.wordpress.org/gaeldenysiak/\">Gael Denysiak</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/guddu1315/\">Gaurang Dabhi</a> · <a href=\"https://profiles.wordpress.org/gautam23/\">Gautam Mehta</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/georgestephanis/\">George Stephanis</a> · <a href=\"https://profiles.wordpress.org/stoyanovgs/\">Georgi Stoyanov</a> · <a href=\"https://profiles.wordpress.org/gernberg/\">gernberg</a> · <a href=\"https://profiles.wordpress.org/giuliorubelli/\">giuliorubelli</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/ingeniumed/\">Gopal Krishnan</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/guido07111975/\">Guido</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/guillaumeturpin/\">Guillaume TURPIN</a> · <a href=\"https://profiles.wordpress.org/gulamdastgir04/\">Gulamdastgir Momin</a> · <a href=\"https://profiles.wordpress.org/adrock42/\">H. Adam Lenz</a> · <a href=\"https://profiles.wordpress.org/kabir93/\">H. Kabir</a> · <a href=\"https://profiles.wordpress.org/hanimbarek/\">hanimbarek</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hardik2221/\">Hardik Raval</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harshalkadu/\">Harshal Kadu</a> · <a href=\"https://profiles.wordpress.org/harshbhonsle08/\">harshbhonsle08</a> · <a href=\"https://profiles.wordpress.org/harshdeepgill/\">harshdeepgill</a> · <a href=\"https://profiles.wordpress.org/haruncpi/\">Harun</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/helgatheviking/\">HelgaTheViking</a> · <a href=\"https://profiles.wordpress.org/hideishi/\">Hidenori ISHIKAWA</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hiroshisato/\">Hiroshi Sato</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hitendra-chopda/\">Hitendra Chopda</a> · <a href=\"https://profiles.wordpress.org/hiteshtalpada/\">Hitesh Talpada</a> · <a href=\"https://profiles.wordpress.org/hozefasmile/\">Hozefa Saleh</a> · <a href=\"https://profiles.wordpress.org/hrohh/\">Hrohh</a> · <a href=\"https://profiles.wordpress.org/hugod/\">hugod</a> · <a href=\"https://profiles.wordpress.org/hugosolar/\">hugosolar</a> · <a href=\"https://profiles.wordpress.org/humanify/\">humanify</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/ignatiusjeroe/\">ignatiusjeroe</a> · <a href=\"https://profiles.wordpress.org/igorradovanov/\">Igor Radovanov</a> · <a href=\"https://profiles.wordpress.org/ikriv/\">ikriv</a> · <a href=\"https://profiles.wordpress.org/imokweb/\">imokweb</a> · <a href=\"https://profiles.wordpress.org/imranhasanraaz/\">Imran</a> · <a href=\"https://profiles.wordpress.org/indirabiswas27/\">Indira Biswas</a> · <a href=\"https://profiles.wordpress.org/ipstenu/\">Ipstenu (Mika Epstein)</a> · <a href=\"https://profiles.wordpress.org/iqbal1hossain/\">Iqbal Hossain</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/ishikaatxecurify/\">Ishika Bansal</a> · <a href=\"https://profiles.wordpress.org/ivanottinger/\">Ivan Ottinger</a> · <a href=\"https://profiles.wordpress.org/jabe/\">Jabe</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">Jagir Bahesh</a> · <a href=\"https://profiles.wordpress.org/jaiminp/\">Jaimin Prajapati</a> · <a href=\"https://profiles.wordpress.org/jakariaistauk/\">Jakaria Istauk</a> · <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a> · <a href=\"https://profiles.wordpress.org/jakeparis/\">jakeparis</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/isotropic/\">James LePage</a> · <a href=\"https://profiles.wordpress.org/jhmonroe/\">James Monroe</a> · <a href=\"https://profiles.wordpress.org/q0rban/\">James Sansbury</a> · <a href=\"https://profiles.wordpress.org/jamestitus299/\">James Titus</a> · <a href=\"https://profiles.wordpress.org/codente/\">Jamie</a> · <a href=\"https://profiles.wordpress.org/jamieburchell/\">Jamie Burchell</a> · <a href=\"https://profiles.wordpress.org/jamesmarsland/\">Jamie Marsland</a> · <a href=\"https://profiles.wordpress.org/janthiel/\">janthiel</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/jasalt/\">Jarkko Saltiola</a> · <a href=\"https://profiles.wordpress.org/jason_the_adams/\">Jason Adams</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/jasonsa19/\">Jason Sauerwald</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/jonmcpartland/\">Jay McPartland</a> · <a href=\"https://profiles.wordpress.org/shovan_jaya/\">Jayaram</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">Jaydip</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/jeffmatson/\">Jeff Matson</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffr0/\">Jeffro</a> · <a href=\"https://profiles.wordpress.org/jeflopodev/\">jeflopo</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremiahbratton/\">Jeremiah Bratton</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jkmassel/\">Jeremy Massel</a> · <a href=\"https://profiles.wordpress.org/slimndap/\">Jeroen Schmit</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/jesin/\">Jesin A</a> · <a href=\"https://profiles.wordpress.org/jessedyck/\">jessedyck</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">Jigar Bhanushali</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jikamens/\">jikamens</a> · <a href=\"https://profiles.wordpress.org/jnweaver/\">jnweaver</a> · <a href=\"https://profiles.wordpress.org/jojo256/\">Joan Namunina</a> · <a href=\"https://profiles.wordpress.org/jobata/\">JoAnne Obata</a> · <a href=\"https://profiles.wordpress.org/jochent/\">JochenT</a> · <a href=\"https://profiles.wordpress.org/jodamo5/\">jodamo5</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/timse201/\">Johannes Jülg</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/brandbrilliance/\">John Brand</a> · <a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/mindctrl/\">John Parris</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/johnvieth/\">JohnVieth</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/jrchamp/\">Jonathan Champ</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/n2erjo00/\">Joni Erkkilä</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonoaldersonwp/\">Jono Alderson</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josvelasco/\">Jos Velasco</a> · <a href=\"https://profiles.wordpress.org/josephscott/\">Joseph Scott</a> · <a href=\"https://profiles.wordpress.org/jhabdas/\">Josh Habdas</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/jrmd/\">jrmd</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juampick/\">Juan Cook</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juliengardair/\">juliengardair</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/itsroy69/\">Jyotirmoy Roy</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/trepmal/\">Kailey (trepmal)</a> · <a href=\"https://profiles.wordpress.org/kaitohm/\">Kaito Hanamori</a> · <a href=\"https://profiles.wordpress.org/kakomap/\">Kakoma</a> · <a href=\"https://profiles.wordpress.org/kalpeshh/\">Kalpesh</a> · <a href=\"https://profiles.wordpress.org/karinchristen/\">Karin Christen</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/karthickmurugan/\">Karthick Murugan</a> · <a href=\"https://profiles.wordpress.org/karthikeya01/\">Karthikeya Bethu</a> · <a href=\"https://profiles.wordpress.org/kasparsd/\">Kaspars</a> · <a href=\"https://profiles.wordpress.org/codebykat/\">Kat Hagan</a> · <a href=\"https://profiles.wordpress.org/katinthehatsite/\">Kateryna K. a11n</a> · <a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn Presner</a> · <a href=\"https://profiles.wordpress.org/katrinadtl/\">Katrina Massey</a> · <a href=\"https://profiles.wordpress.org/kausaralm/\">Kausar Alam</a> · <a href=\"https://profiles.wordpress.org/khushdoms/\">Kaushik Domadiya</a> · <a href=\"https://profiles.wordpress.org/onlykawshar/\">Kawshar Ahmed</a> · <a href=\"https://profiles.wordpress.org/kaygee79/\">kaygee79</a> · <a href=\"https://profiles.wordpress.org/mt8biz/\">Kazuto Takeshita</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/kellychoffman/\">Kelly Hoffman</a> · <a href=\"https://profiles.wordpress.org/tinypixel/\">Kelly Mears</a> · <a href=\"https://profiles.wordpress.org/kerfred/\">Kerfred</a> · <a href=\"https://profiles.wordpress.org/gwwar/\">Kerry Liu</a> · <a href=\"https://profiles.wordpress.org/kesselb/\">kesselb</a> · <a href=\"https://profiles.wordpress.org/kevinlearynet/\">Kevin Leary</a> · <a href=\"https://profiles.wordpress.org/kgagne/\">kgagne</a> · <a href=\"https://profiles.wordpress.org/khoipro/\">Khoi Pro</a> · <a href=\"https://profiles.wordpress.org/khushipatel15/\">Khushi Patel</a> · <a href=\"https://profiles.wordpress.org/killerbishop/\">killerbishop</a> · <a href=\"https://profiles.wordpress.org/iamkingsleyf/\">Kingsley Felix</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kitchin/\">kitchin</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/kleor/\">Kleor</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a> · <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a> · <a href=\"https://profiles.wordpress.org/kpapazov/\">kpapazov</a> · <a href=\"https://profiles.wordpress.org/kprocyszyn/\">kprocyszyn</a> · <a href=\"https://profiles.wordpress.org/krishaamer/\">krishaamer</a> · <a href=\"https://profiles.wordpress.org/krunal265/\">Krunal Bhimajiyani</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/kshaner/\">kshaner</a> · <a href=\"https://profiles.wordpress.org/kub1x/\">kub1x</a> · <a href=\"https://profiles.wordpress.org/kubiq/\">kubiq</a> · <a href=\"https://profiles.wordpress.org/kunalpuri123/\">kunalpuri123</a> · <a href=\"https://profiles.wordpress.org/kushsharma/\">Kush Sharma</a> · <a href=\"https://profiles.wordpress.org/kush123/\">Kushagra Goyal</a> · <a href=\"https://profiles.wordpress.org/lgadzhev/\">Lachezar Gadzhev</a> · <a href=\"https://profiles.wordpress.org/lakrisgubben/\">lakrisgubben</a> · <a href=\"https://profiles.wordpress.org/lakshyajeet/\">Lakshyajeet Singh Goyal</a> · <a href=\"https://profiles.wordpress.org/lalitkumawat/\">Lalit Kumawat</a> · <a href=\"https://profiles.wordpress.org/lancewillett/\">Lance Willett</a> · <a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a> · <a href=\"https://profiles.wordpress.org/laurisaarni/\">Lauri Saarni</a> · <a href=\"https://profiles.wordpress.org/ldanielgiuliani/\">ldanielgiuliani</a> · <a href=\"https://profiles.wordpress.org/leewillis77/\">Lee Willis</a> · <a href=\"https://profiles.wordpress.org/leedxw/\">leedxw</a> · <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/leonidasmilossis/\">Leonidas Milosis</a> · <a href=\"https://profiles.wordpress.org/levinbaria/\">Levin Baria</a> · <a href=\"https://profiles.wordpress.org/lgseo/\">lgseo</a> · <a href=\"https://profiles.wordpress.org/lilgames/\">LilGames</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/logiclink/\">logiclink</a> · <a href=\"https://profiles.wordpress.org/logicrays/\">LogicRays Technologies</a> · <a href=\"https://profiles.wordpress.org/lordandy1984/\">lordandy1984</a> · <a href=\"https://profiles.wordpress.org/lovor/\">Lovro Hrust</a> · <a href=\"https://profiles.wordpress.org/lucasms/\">Lucas Martins</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/lukasfritzedev/\">LukasFritzeDev</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/maccyd/\">maccyd</a> · <a href=\"https://profiles.wordpress.org/madhavishah01/\">Madhavi Shah</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/maikuolan/\">Maikuolan</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manhatthien98/\">manhatthien98</a> · <a href=\"https://profiles.wordpress.org/sirlouen/\">Manuel Camargo</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani</a> · <a href=\"https://profiles.wordpress.org/maorb/\">maorb</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/marc4/\">Marc Armengou</a> · <a href=\"https://profiles.wordpress.org/pagelab/\">Marcio Duarte</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/leadclown/\">Marcus</a> · <a href=\"https://profiles.wordpress.org/mkaz/\">Marcus Kazmierczak</a> · <a href=\"https://profiles.wordpress.org/marian1/\">marian1</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/mariohamann/\">mariohamann</a> · <a href=\"https://profiles.wordpress.org/marius84/\">mariushosting</a> · <a href=\"https://profiles.wordpress.org/bozzmedia/\">Marty</a> · <a href=\"https://profiles.wordpress.org/martythornley/\">MartyThornley</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/4thhubbard/\">Mary Hubbard</a> · <a href=\"https://profiles.wordpress.org/mat-lipe/\">Mat Lipe</a> · <a href=\"https://profiles.wordpress.org/mathiscode/\">mathiscode</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattwest/\">Matt West</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/pfefferle/\">Matthias Pfefferle</a> · <a href=\"https://profiles.wordpress.org/mattryanwalker/\">mattryanwalker</a> · <a href=\"https://profiles.wordpress.org/maxschmeling/\">Max Schmeling</a> · <a href=\"https://profiles.wordpress.org/maxpertici/\">Maxime Pertici</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/faithcoder/\">Md Abdullah Al Arif</a> · <a href=\"https://profiles.wordpress.org/mabfahad/\">Md Abdullah Al Fahad</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/ismail0071/\">MD ISMAIL</a> · <a href=\"https://profiles.wordpress.org/kawsar007/\">MD Kawsar Chowdhury</a> · <a href=\"https://profiles.wordpress.org/masummollaalhaz/\">Md Masum Molla Alhaz</a> · <a href=\"https://profiles.wordpress.org/obiplabon/\">Md Obidullah (obiPlabon)</a> · <a href=\"https://profiles.wordpress.org/wprashed/\">Md Rashed Hossain</a> · <a href=\"https://profiles.wordpress.org/sabbir20/\">Md Sabbir Hossain</a> · <a href=\"https://profiles.wordpress.org/najmulsaju/\">Md. Najmul Islam</a> · <a href=\"https://profiles.wordpress.org/mehedi_csit/\">Md.Mehedi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdmoreau/\">mdmoreau</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/immeet94/\">Meet Makadia</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/meher/\">Meher Bala</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/mfgmicha/\">Micha Krapp</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/michaelkeck/\">Michael Keck</a> · <a href=\"https://profiles.wordpress.org/mnelson4/\">Michael Nelson</a> · <a href=\"https://profiles.wordpress.org/xmic/\">Michael Sumner</a> · <a href=\"https://profiles.wordpress.org/michaelreetz/\">michaelreetz</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/marktimemedia/\">Michelle Schulp Hunt</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/migueluy/\">Miguel Lezama</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mobius5150/\">Mike</a> · <a href=\"https://profiles.wordpress.org/mikefitzman/\">Mike Fitzpatrick</a> · <a href=\"https://profiles.wordpress.org/mikehansenme/\">Mike Hansen</a> · <a href=\"https://profiles.wordpress.org/mikejolley/\">Mike Jolley</a> · <a href=\"https://profiles.wordpress.org/mmcalister/\">Mike McAlister</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/firestar300/\">Milan Ricoul</a> · <a href=\"https://profiles.wordpress.org/multidots1896/\">Minal Diwan</a> · <a href=\"https://profiles.wordpress.org/369work/\">Miroku</a> · <a href=\"https://profiles.wordpress.org/missveronicatv/\">missveronica</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/mkeck/\">mkeck</a> · <a href=\"https://profiles.wordpress.org/mlaetitia1986/\">mlaetitia1986</a> · <a href=\"https://profiles.wordpress.org/mleray/\">mleray</a> · <a href=\"https://profiles.wordpress.org/mleraygp/\">mleraygp</a> · <a href=\"https://profiles.wordpress.org/mobarak/\">Mobarak Ali</a> · <a href=\"https://profiles.wordpress.org/opurockey/\">Mohammad Rockeybul Alam</a> · <a href=\"https://profiles.wordpress.org/mohkatz/\">Mohammed Kateregga</a> · <a href=\"https://profiles.wordpress.org/mosescursor/\">Moses Cursor Ssebunya</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/mtg169/\">mtg169</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/mukulsingh27/\">Mukul Singh</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/sedmikrasky/\">Núria Nadal i Rovira</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">n8finch</a> · <a href=\"https://profiles.wordpress.org/vyasnaman/\">Naman Vyas</a> · <a href=\"https://profiles.wordpress.org/nanisamireddy/\">NANI SAMIREDDY</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/muddassirnasim/\">Nasim Miah</a> · <a href=\"https://profiles.wordpress.org/naveendwivedi/\">Naveen Dwivedi</a> · <a href=\"https://profiles.wordpress.org/navi161/\">Navneet Kaur</a> · <a href=\"https://profiles.wordpress.org/bugnumber9/\">Nazar Hotsa</a> · <a href=\"https://profiles.wordpress.org/nazmul111/\">Nazmul Hosen</a> · <a href=\"https://profiles.wordpress.org/greatislander/\">Ned Zimmerman</a> · <a href=\"https://profiles.wordpress.org/nexbridge/\">nexbridge</a> · <a href=\"https://profiles.wordpress.org/nextendweb/\">Nextendweb</a> · <a href=\"https://profiles.wordpress.org/neychok/\">Neycho Kalaydzhiev</a> · <a href=\"https://profiles.wordpress.org/nickchomey/\">Nick</a> · <a href=\"https://profiles.wordpress.org/nickstarkloff/\">Nick</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/nickbrazilian/\">nickbrazilian</a> · <a href=\"https://profiles.wordpress.org/nickjbedford/\">nickjbedford</a> · <a href=\"https://profiles.wordpress.org/nickpagz/\">nickpagz</a> · <a href=\"https://profiles.wordpress.org/nickwilmot/\">nickwilmot</a> · <a href=\"https://profiles.wordpress.org/nico23/\">Nico</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nielslange/\">Niels Lange</a> · <a href=\"https://profiles.wordpress.org/nigelnelles/\">nigelnelles</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/smushytaco/\">Nikan Radan</a> · <a href=\"https://profiles.wordpress.org/nikunj8866/\">Nikunj Hatkar</a> · <a href=\"https://profiles.wordpress.org/nimeshatxecurify/\">Nimesh</a> · <a href=\"https://profiles.wordpress.org/ninomiho/\">Nino Mihovilic</a> · <a href=\"https://profiles.wordpress.org/ninos-ego/\">Ninos</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/othernoel/\">Noel Santos</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/oceantober/\">oceantober</a> · <a href=\"https://profiles.wordpress.org/oferlaor/\">oferlaor</a> · <a href=\"https://profiles.wordpress.org/okat/\">okat</a> · <a href=\"https://profiles.wordpress.org/yasunocco/\">Okawa Yasuno</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/gabertronic/\">Ophelia Rose</a> · <a href=\"https://profiles.wordpress.org/optimizingmatters/\">Optimizing Matters</a> · <a href=\"https://profiles.wordpress.org/owi/\">owi</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/palak678/\">Palak Patel</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/techpartho/\">Partho Hore</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/pateljaymin/\">Patel Jaymin</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/patpiwo/\">Patrick Piwowarczyk</a> · <a href=\"https://profiles.wordpress.org/pryley/\">Paul</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulbonneau/\">Paul Bonneau</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/paulstanos/\">paulstanos</a> · <a href=\"https://profiles.wordpress.org/pcarvalho/\">pcarvalho</a> · <a href=\"https://profiles.wordpress.org/pedrofigueroa1989/\">Pedro Figueroa</a> · <a href=\"https://profiles.wordpress.org/peroks/\">Per Egil Roksvaag</a> · <a href=\"https://profiles.wordpress.org/peteringersoll/\">Peter Ingersoll</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/philipjohn/\">Philip John</a> · <a href=\"https://profiles.wordpress.org/philsola/\">Philip Sola</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/phillsav/\">Phill</a> · <a href=\"https://profiles.wordpress.org/piskvorky/\">piskvorky</a> · <a href=\"https://profiles.wordpress.org/poojabhimani/\">Pooja Bhimani</a> · <a href=\"https://profiles.wordpress.org/poojapadamad/\">poojapadamad</a> · <a href=\"https://profiles.wordpress.org/porg/\">porg</a> · <a href=\"https://profiles.wordpress.org/prab18hat/\">prab18hat</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/pranjalpratapsingh/\">Pranjal Pratap Singh</a> · <a href=\"https://profiles.wordpress.org/prasadkarmalkar/\">Prasad Karmalkar</a> · <a href=\"https://profiles.wordpress.org/prasadgupte/\">prasadgupte</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/prettyboymp/\">prettyboymp</a> · <a href=\"https://profiles.wordpress.org/puggan/\">puggan</a> · <a href=\"https://profiles.wordpress.org/quentinr64600/\">quentinr64600</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiqul Islam</a> · <a href=\"https://profiles.wordpress.org/ralucastn/\">Raluca</a> · <a href=\"https://profiles.wordpress.org/superpoincare/\">Ramanan</a> · <a href=\"https://profiles.wordpress.org/ramiy/\">Rami Yushuvaev</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ravichudasama01/\">Ravi Chudasama</a> · <a href=\"https://profiles.wordpress.org/ravigadhiyawp/\">Ravi Gadhiya</a> · <a href=\"https://profiles.wordpress.org/rcrdortiz/\">rcrdortiz</a> · <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/tabrisrp/\">Remy Perona</a> · <a href=\"https://profiles.wordpress.org/espellcaste/\">Renato Alves</a> · <a href=\"https://profiles.wordpress.org/renishsurani/\">renishsurani</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/rezwanshiblu1952/\">Rezwan Shiblu</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/riadev/\">riadev</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rockfire/\">Richard Korthuis</a> · <a href=\"https://profiles.wordpress.org/riddhidave/\">Riddhi Dave</a> · <a href=\"https://profiles.wordpress.org/rinatkhaziev/\">Rinat</a> · <a href=\"https://profiles.wordpress.org/rinkalpagdar/\">Rinkal Pagdar</a> · <a href=\"https://profiles.wordpress.org/rishabhwp/\">Rishabh Gupta</a> · <a href=\"https://profiles.wordpress.org/rishavdutta/\">Rishav Dutta</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/ristojovanovic/\">Risto Jovanovic</a> · <a href=\"https://profiles.wordpress.org/devrito/\">Ritoban</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/miqrogroove/\">Robert Chapin</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/sanchothefat/\">Robert O’Rourke</a> · <a href=\"https://profiles.wordpress.org/robmcclel/\">Robmcclel</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/roelof/\">roelof</a> · <a href=\"https://profiles.wordpress.org/rollybueno/\">Rolly Bueno</a> · <a href=\"https://profiles.wordpress.org/ronak44/\">Ronak prajapati</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/costasovo/\">Rostislav Wolný</a> · <a href=\"https://profiles.wordpress.org/rotemg/\">Rotem Gelbart</a> · <a href=\"https://profiles.wordpress.org/rayhatron/\">Rufaro Madamombe</a> · <a href=\"https://profiles.wordpress.org/rutvikbhambhi2004/\">Rutvik Bhambhi</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/skierpage/\">S Page</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sabbir1991/\">Sabbir Ahmed</a> · <a href=\"https://profiles.wordpress.org/devsabbirahmed/\">Sabbir Sam</a> · <a href=\"https://profiles.wordpress.org/sachinrajcp123/\">SACHINRAJ CP</a> · <a href=\"https://profiles.wordpress.org/sahiljadhav1617/\">Sahil Jadhav</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sajjad67/\">Sajjad Hossain Sagor</a> · <a href=\"https://profiles.wordpress.org/sakibmoon/\">sakibmoon</a> · <a href=\"https://profiles.wordpress.org/samueljseay/\">Sam</a> · <a href=\"https://profiles.wordpress.org/sam_a/\">sam_a</a> · <a href=\"https://profiles.wordpress.org/samirmalpande/\">Samir Malpande</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/sjapaget/\">Samuel Paget</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/sandeepdahiya/\">Sandeep Dahiya</a> · <a href=\"https://profiles.wordpress.org/sandipsinh007/\">Sandip Sinh</a> · <a href=\"https://profiles.wordpress.org/ourvalley/\">Sandy McFadden</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/tinkerbelly/\">sarah semark</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/saurabhdhariwal/\">saurabh.dhariwal</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/scholdstrom/\">scholdstrom</a> · <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shsajalchowdhury/\">SH Sajal Chowdhury</a> · <a href=\"https://profiles.wordpress.org/shadialaghbari/\">Shadi G شادي جـ</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/shanemuir/\">Shane Muirhead</a> · <a href=\"https://profiles.wordpress.org/iamshashank/\">Shashank Jain</a> · <a href=\"https://profiles.wordpress.org/shekh0109/\">Shashank Shekhar</a> · <a href=\"https://profiles.wordpress.org/sajib1223/\">Shazzad Hossain Khan</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">Sheri Grey</a> · <a href=\"https://profiles.wordpress.org/shiponkarmakar/\">Shipon Karmakar</a> · <a href=\"https://profiles.wordpress.org/shreya0shrivastava/\">Shreya Shrivastava</a> · <a href=\"https://profiles.wordpress.org/iamshubhamsp/\">Shubham Patil</a> · <a href=\"https://profiles.wordpress.org/shyamgadde/\">Shyamsundar Gadde</a> · <a href=\"https://profiles.wordpress.org/sidharthpandita/\">sidharthpandita</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/shilpaashokan94/\">Silpa TA</a> · <a href=\"https://profiles.wordpress.org/simonefontana/\">simonefontana</a> · <a href=\"https://profiles.wordpress.org/slaffik/\">Slava Abakumov</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/maia12345/\">Sophie Dimitrov</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/soyebsalar01/\">Soyeb Salar</a> · <a href=\"https://profiles.wordpress.org/spenserhale/\">Spenser Hale</a> · <a href=\"https://profiles.wordpress.org/spstrap/\">spstrap</a> · <a href=\"https://profiles.wordpress.org/srikat/\">Sridhar Katakam</a> · <a href=\"https://profiles.wordpress.org/stankea/\">stankea</a> · <a href=\"https://profiles.wordpress.org/metodiew/\">Stanko Metodiev</a> · <a href=\"https://profiles.wordpress.org/staurand/\">staurand</a> · <a href=\"https://profiles.wordpress.org/hubersen/\">Stefan Pasch</a> · <a href=\"https://profiles.wordpress.org/stefanvelthuys/\">Stefan Velthuys</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stephenharris/\">Stephen Harris</a> · <a href=\"https://profiles.wordpress.org/dufresnesteven/\">Steve Dufresne</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sudipatel007/\">Sudip Dadhaniya</a> · <a href=\"https://profiles.wordpress.org/sujansarkar/\">Sujan Sarkar</a> · <a href=\"https://profiles.wordpress.org/sukhendu2002/\">Sukhendu Sekhar Guria</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/sunnykasera/\">sunnykasera</a> · <a href=\"https://profiles.wordpress.org/sunyatasattva/\">sunyatasattva (a11n)</a> · <a href=\"https://profiles.wordpress.org/supernovia/\">supernovia</a> · <a href=\"https://profiles.wordpress.org/suzukube/\">SuzuKube</a> · <a href=\"https://profiles.wordpress.org/svedish/\">svedish</a> · <a href=\"https://profiles.wordpress.org/lordspace/\">Svetoslav Marinov</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/syhussaini/\">syhussaini</a> · <a href=\"https://profiles.wordpress.org/schwipps/\">T4ng</a> · <a href=\"https://profiles.wordpress.org/tacoverdo/\">Taco Verdonschot</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/takuword/\">Takuro</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/tatof/\">tatof</a> · <a href=\"https://profiles.wordpress.org/tecnogaming/\">tecnogaming</a> · <a href=\"https://profiles.wordpress.org/mecaota/\">Tetsuro Higuchi</a> · <a href=\"https://profiles.wordpress.org/tharsheblows/\">tharsheblows</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/tsquez/\">ThemeAWESOME</a> · <a href=\"https://profiles.wordpress.org/themiked/\">theMikeD</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/tfrommen/\">Thorsten Frommen</a> · <a href=\"https://profiles.wordpress.org/tillkruess/\">Till Krüss</a> · <a href=\"https://profiles.wordpress.org/timhavinga/\">Tim Havinga</a> · <a href=\"https://profiles.wordpress.org/dontfeedthecode/\">Tim Sheehan</a> · <a href=\"https://profiles.wordpress.org/timotijhof/\">Timo Tijhof</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a> · <a href=\"https://profiles.wordpress.org/timotheemoulin/\">Timothée Moulin</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tjarrett/\">TJarrett</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">Tobias Bäthge</a> · <a href=\"https://profiles.wordpress.org/tz-media/\">Tobias Zimpel</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn “Tobi” Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomdevisser/\">Tom de Visser</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/wpsmith/\">Travis Smith</a> · <a href=\"https://profiles.wordpress.org/traxus/\">traxus</a> · <a href=\"https://profiles.wordpress.org/sllimrovert/\">Trevor Mills</a> · <a href=\"https://profiles.wordpress.org/tristanleboss/\">tristanleboss</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/tsteel/\">tsteel</a> · <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a> · <a href=\"https://profiles.wordpress.org/tusharbharti/\">Tushar Bharti</a> · <a href=\"https://profiles.wordpress.org/tusharaddweb/\">Tushar Patel</a> · <a href=\"https://profiles.wordpress.org/tussendoor/\">Tussendoor B.V.</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umeshnevase/\">Umesh Nevase</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/unsalkorkmaz/\">Unsal Korkmaz</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utsavladani/\">Utsav Ladani</a> · <a href=\"https://profiles.wordpress.org/utsav72640/\">Utsav tilava</a> · <a href=\"https://profiles.wordpress.org/valentingrenier/\">Valentin Grenier</a> · <a href=\"https://profiles.wordpress.org/tsimshatsui/\">Vape tsimshatsui</a> · <a href=\"https://profiles.wordpress.org/vbbp/\">vbbp</a> · <a href=\"https://profiles.wordpress.org/sheldorofazeroth/\">Vedansh Mishra</a> · <a href=\"https://profiles.wordpress.org/vevas/\">Vegard S.</a> · <a href=\"https://profiles.wordpress.org/vgnavada/\">vgnavada</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vidugupta/\">vidugupta</a> · <a href=\"https://profiles.wordpress.org/vijendrajat/\">Vijendra Jat</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/ghorivipul97/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">Vipul Patil</a> · <a href=\"https://profiles.wordpress.org/vishitshah/\">Vishit Shah</a> · <a href=\"https://profiles.wordpress.org/vladimiraus/\">vladimiraus</a> · <a href=\"https://profiles.wordpress.org/vortfu/\">vortfu</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">Vrishabh Jasani</a> · <a href=\"https://profiles.wordpress.org/walterebert/\">Walter Ebert</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/websupporter/\">websupporter</a> · <a href=\"https://profiles.wordpress.org/webwrotter/\">webwrotter</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whaze/\">whaze</a> · <a href=\"https://profiles.wordpress.org/widhy980/\">widhy980</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">wplmillet</a> · <a href=\"https://profiles.wordpress.org/xate/\">xate</a> · <a href=\"https://profiles.wordpress.org/xavilc/\">xavilc</a> · <a href=\"https://profiles.wordpress.org/xerpa43/\">xerpa43</a> · <a href=\"https://profiles.wordpress.org/xipasduarte/\">xipasduarte</a> · <a href=\"https://profiles.wordpress.org/yagniksangani/\">Yagnik Sangani</a> · <a href=\"https://profiles.wordpress.org/yashyadav247/\">Yash</a> · <a href=\"https://profiles.wordpress.org/getsyash/\">Yash B</a> · <a href=\"https://profiles.wordpress.org/yashjawale/\">Yash Jawale</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/yogieanamcara/\">YogieAnamCara</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">Zeel Thakkar</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/lstraczynski/\">Łukasz Strączyński</a> · <a href=\"https://profiles.wordpress.org/haozi/\">耗子</a></p>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress&nbsp;6.9 en français</h3>\n\n\n\n<p>WordPress est un projet international et la version 6.9 est déjà complètement disponible dans plus de 30 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress&nbsp;6.9 en français&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Bénard</a>, <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a>, <a href=\"https://profiles.wordpress.org/wplmillet/\">wplmillet</a>, <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a>, <a href=\"https://profiles.wordpress.org/marineevain/\">Marine EVAIN</a>, <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a>, <a href=\"https://profiles.wordpress.org/virgar/\">Virginie Garnier</a>, <a href=\"https://profiles.wordpress.org/barnemax/\">Maxime ETCHEBARNE</a>, <a href=\"https://profiles.wordpress.org/nuryko/\">Marianna</a>, <a href=\"https://profiles.wordpress.org/gaellebesson/\">gaellebesson</a>, <a href=\"https://profiles.wordpress.org/emillet/\">Elisabeth</a> et <a href=\"https://profiles.wordpress.org/bishoya/\">Bishoy.A</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-dots\" />\n\n\n\n<p class=\"has-small-font-size\">Article rédigé par&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>. Merci à&nbsp;<a href=\"https://profiles.wordpress.org/wolforg/\">Didier Demory</a>&nbsp;et&nbsp;<a href=\"https://profiles.wordpress.org/nlegagneur/\">xxx</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3411\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n\n\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 26 Nov 2025 12:31:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3383\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:431:\"Temps de lecture estimé&#160;:&#160; WordPress 6.9 comprend la résolution de plus de&#160;400 tickets sur Trac, dont&#160;125 améliorations et nouvelles fonctionnalités,&#160;plus de 250 corrections de bogues. Cette version comprend 35 tickets focalisés sur l’éditeur, 15 tickets focalisés sur l’admin WP et 45 sur les performances. Les modifications de la version 6.9 concernent&#160;55 composants du cœur du [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:3:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:56:\"https://make.wordpress.org/core/files/2025/10/drag-3.mp4\";s:6:\"length\";s:7:\"4330080\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://make.wordpress.org/test/files/2025/10/Hide-Block.mov\";s:6:\"length\";s:8:\"23505066\";s:4:\"type\";s:15:\"video/quicktime\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:56:\"https://make.wordpress.org/core/files/2025/10/drag-2.mp4\";s:6:\"length\";s:7:\"5447134\";s:4:\"type\";s:9:\"video/mp4\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:60265:\"\n<figure class=\"wp-block-image alignfull size-full\"><a href=\"https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques.png\"><img decoding=\"async\" width=\"1804\" height=\"962\" src=\"https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques.png\" alt=\"\" class=\"wp-image-3384\" srcset=\"https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques.png 1804w, https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques-300x160.png 300w, https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques-1024x546.png 1024w, https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques-768x410.png 768w, https://fr.wordpress.org/files/2025/11/wordpress-69-guide-changements-techniques-1536x819.png 1536w\" sizes=\"(max-width: 1804px) 100vw, 1804px\" /></a></figure>\n\n\n\n<div class=\"wp-block-group has-small-font-size is-content-justification-right is-nowrap is-layout-flex wp-container-core-group-is-layout-b315634e wp-block-group-is-layout-flex\">\n<p>Temps de lecture estimé&nbsp;:&nbsp;</p>\n\n\n<div class=\"wp-block-post-time-to-read\">12–17 minutes</div></div>\n\n\n\n<p>WordPress 6.9 comprend la résolution de plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=priority&amp;order=priority&amp;max=500\">400 tickets sur Trac</a>, dont&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.9&amp;group=component&amp;max=200&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">125 améliorations et nouvelles fonctionnalités</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.9&amp;group=component&amp;max=500&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">plus de 250 corrections de bogues</a>. Cette version comprend <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;component=Editor&amp;milestone=6.9&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">35 tickets focalisés sur l’éditeur</a>, <a href=\"https://core.trac.wordpress.org/query?component=Administration&amp;milestone=6.9&amp;or&amp;focuses=~administration&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">15 tickets focalisés sur l’admin WP</a> et <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.9&amp;or&amp;status=closed&amp;component=Script+Loader&amp;milestone=6.9&amp;or&amp;status=closed&amp;component=Query&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">45 sur les performances</a>. Les modifications de la version 6.9 concernent&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.9&amp;group=component&amp;max=9999&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">55 composants du cœur du CMS</a>, dont deux nouveaux composants (AI et Notes).</p>\n\n\n\n<p>Cette version comprend aussi&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=(label%3A%22%5BType%5D%20Enhancement%22%20AND%20is%3Aclosed)%20AND%20(milestone%3A%22Gutenberg%2020.4%22%20OR%20milestone%3A%22Gutenberg%2020.5%22%20OR%20milestone%3A%22Gutenberg%2020.6%22%20OR%20milestone%3A%22Gutenberg%2020.7%22%20OR%20milestone%3A%22Gutenberg%2020.8%22%20OR%20milestone%3A%22Gutenberg%2020.9%22%20OR%20milestone%3A%22Gutenberg%2021.0%22%20OR%20milestone%3A%22Gutenberg%2021.1%22%20OR%20milestone%3A%22Gutenberg%2021.2%22%20OR%20milestone%3A%22Gutenberg%2021.3%22%20OR%20milestone%3A%22Gutenberg%2021.4%22%20OR%20milestone%3A%22Gutenberg%2021.5%22%20OR%20milestone%3A%22Gutenberg%2021.6%22%20OR%20milestone%3A%22Gutenberg%2021.7%22%20OR%20milestone%3A%22Gutenberg%2021.8%22%20OR%20milestone%3A%22Gutenberg%2021.9%22%20OR%20milestone%3A%22Gutenberg%2022.0%22%20OR%20milestone%3A%22Gutenberg%2022.1%22)\">440 améliorations</a> et&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=(label%3A%22%5BType%5D%20Bug%22%20AND%20is%3Aclosed)%20AND%20(milestone%3A%22Gutenberg%2020.4%22%20OR%20milestone%3A%22Gutenberg%2020.5%22%20OR%20milestone%3A%22Gutenberg%2020.6%22%20OR%20milestone%3A%22Gutenberg%2020.7%22%20OR%20milestone%3A%22Gutenberg%2020.8%22%20OR%20milestone%3A%22Gutenberg%2020.9%22%20OR%20milestone%3A%22Gutenberg%2021.0%22%20OR%20milestone%3A%22Gutenberg%2021.1%22%20OR%20milestone%3A%22Gutenberg%2021.2%22%20OR%20milestone%3A%22Gutenberg%2021.3%22%20OR%20milestone%3A%22Gutenberg%2021.4%22%20OR%20milestone%3A%22Gutenberg%2021.5%22%20OR%20milestone%3A%22Gutenberg%2021.6%22%20OR%20milestone%3A%22Gutenberg%2021.7%22%20OR%20milestone%3A%22Gutenberg%2021.8%22%20OR%20milestone%3A%22Gutenberg%2021.9%22%20OR%20milestone%3A%22Gutenberg%2022.0%22%20OR%20milestone%3A%22Gutenberg%2022.1%22)\">570 corrections de bogues</a>&nbsp;sur l’éditeur (projet Gutenberg).</p>\n\n\n\n<p class=\"is-style-serif has-light-grey-2-color has-text-color has-background has-link-color wp-elements-cad2a17e334a7de448f5bc24abac31cd\" style=\"background:linear-gradient(135deg,rgb(53,10,128) 67%,rgb(244,237,234) 100%)\">Ce guide décrit les principaux changements techniques qui arrivent sur WordPress&nbsp;6.9, dont la sortie est prévue le 2 décembre 2025.</p>\n\n\n\n<p>Pour la première fois, cette version majeure sera rendue publique en <em>live</em> lors de l&rsquo;événement annuel <em>State of the Word</em> qui se tiendra cette année à San Francisco le 2 décembre.</p>\n\n\n\n<p class=\"has-purple-2-color has-text-color has-link-color wp-elements-414d58c89e9217ac699c7ae039abebf9\"><a href=\"https://make.wordpress.org/core/2025/11/26/6-9-release-day-timeline-shift-for-state-of-the-word/\">En savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.9</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-dots\" />\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p>Table des matières : </p>\n\n\n\n<nav aria-label=\"Table des matières\" class=\"wp-block-table-of-contents\"><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#de-nouvelles-facons-de-collaborer\">De nouvelles façons de collaborer</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#les-notes-font-leur-entree\">Les Notes font leur entrée</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#updates-to-field-api-dataviews-and-dataforms-components\">Mise à jour de l’API « Field » et des composants « DataViews » et « DataForms »</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#improved-editing-tools-and-architecture\">Amélioration des outils d’édition</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#direct-drag-and-drop\">Glisser-déposer en direct</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#ability-to-hide-blocks-1\">Possibilité de masquer des blocs</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#iframe-integration-in-post-editor-1\">Intégration iframe de l’éditeur de contenu</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#streaming-block-parser\">Un nouvel outil pour traiter les blocs</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#new-blocks-and-block-improvements\">Nouveau blocs et améliorations des blocs existants</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#perform-calculations-using-π-in-the-math-block\">Un bloc d&rsquo;affichage des formules mathématiques</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#accordion-block-now-supports-anchors\">Du contenu repliable avec le bloc Accordéon</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#heading-block-css-specificity-fix\">Correction de la spécificité CSS du bloc Titre</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#new-improved-apis\">Nouvelles API et modifications des API existantes</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#meet-the-abilities-api\">Découvrez l’API « Abilities »</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#updates-to-interactivity-api\">Mise à jour de l’API « Interactivity »</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#html-api-updatesimproved-blocks-binding-api\">Mise à jour de l’API « HTML »</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#improved-block-binding-api\">Amélioration de l’API « Block Binding »</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#optimized-performance\">Optimisations des performances</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#modernizing-utf-8-support\">Modernisation du support d’UTF-8</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#updated-query-cache-handling\">Mise à jour de la gestion du cache des requêtes</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#remove-support-for-loading-assets-conditionally-for-ie\">Suppression du support du chargement conditionnel des ressources pour Internet Explorer</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#accessibility-updates\">Accessibilité</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#php-8-5-support\">Support de PHP 8.5</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#miscellaneous-developer-changes\">Autres changements techniques</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#miscellaneous-editor-changes\">Changements divers concernant l&rsquo;éditeur</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#updated-admin-menu-search-query\">Modification des requêtes de recherche du menu d&rsquo;administration</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#additional-support-for-https-in-url-escaping-functions\">Un support complémentaire de HTTPS dans les fonctions d&rsquo;échappement d&rsquo;URL</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#improved-email-handling-and-inline-image-support\">Amélioration de la gestion des e-mails et du support des images en ligne</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#travaux-lies-a-l-implementation-des-outils-ia-dans-wp-6-9\">Travaux liés à l&rsquo;implémentation des outils IA dans WP 6.9</a><ol><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#php-ai-client\">Client PHP pour l&rsquo;implémentation d&rsquo;outils IA</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#mcp-adapter\">Adaptateur MCP</a></li></ol></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#but-wait-there-is-more\">Attendez, ce n’est pas fini !</a></li><li><a class=\"wp-block-table-of-contents__entry\" href=\"https://fr.wordpress.org/2025/11/26/guide-des-changements-techniques-de-wordpress-6-9/#other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</a></li></ol></nav>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-dots\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"de-nouvelles-facons-de-collaborer\">De nouvelles façons de collaborer</h2>\n\n\n\n<p>Créer et gérer du contenu avec WordPress 6.9 sera encore plus efficace grâce à de nouveaux outils et fonctionnalités qui encouragent la collaboration et simplifient l&rsquo;utilisation. Vous pouvez désormais ajouter des notes aux blocs et profiter de vues de données optimisées ainsi que d&rsquo;une palette de commandes intégrée à l’admin WP.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"les-notes-font-leur-entree\">Les Notes font leur entrée</h3>\n\n\n\n<p>Dans WordPress 6.9, les rédacteur·ices peuvent rédiger des notes et répondre directement aux notes ajoutées par d’autres au niveau de chaque bloc, ce qui permet aux équipes de collaborer, de suivre les modifications et de donner leur avis pendant le processus d&rsquo;édition. Les notes peuvent être résolues, modifiées et supprimées. Une notification par e-mail est envoyée à l&rsquo;auteur·ice de l&rsquo;article lorsqu&rsquo;une nouvelle note est ajoutée.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"s60Ci2rnYH\"><a href=\"https://make.wordpress.org/core/2025/11/15/notes-feature-in-wordpress-6-9/\">Notes feature in WordPress 6.9</a></blockquote><iframe class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Notes feature in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/15/notes-feature-in-wordpress-6-9/embed/#?secret=DP6kJwS0eP#?secret=s60Ci2rnYH\" data-secret=\"s60Ci2rnYH\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"updates-to-field-api-dataviews-and-dataforms-components\">Mise à jour de l’API «&nbsp;Field&nbsp;» et des composants «&nbsp;DataViews&nbsp;» et «&nbsp;DataForms&nbsp;»</h3>\n\n\n\n<p>Cette version propose aussi une mise à jour de l’API «&nbsp;Field&nbsp;» et des composants «&nbsp;DataViews&nbsp;» et «&nbsp;DataForms&nbsp;»</p>\n\n\n\n<p>Dans l’<a href=\"https://make.wordpress.org/core/2025/11/11/dataviews-dataform-et-al-in-wordpress-6-9/#field-api\">API Field (champs)</a>,&nbsp;le&nbsp;paramètre <code>type</code>&nbsp;permet désormais d&rsquo;inclure 10 nouveaux types de champs, 11 contrôleurs de type <code>edit</code> qui permettent d&rsquo;indiquer des types de validation, plus de 16 opérateurs de filtrage, une option <code>readOnly</code> pour désactiver l&rsquo;édition des champs, et bien plus encore.</p>\n\n\n\n<p>Les modifications des fonctions du composant&nbsp;<a href=\"https://make.wordpress.org/core/2025/11/11/dataviews-dataform-et-al-in-wordpress-6-9/#dataviews\">DataViews (vues de données)</a>&nbsp;concernent des améliorations des modales et des actions basées sur l&rsquo;utilisation du texte, un défilement infini et la possibilité de construire des mises en page utilisant la fonctionnalité <code>children</code> pour tirer profit de la gestion interne des états des vues de données et de la logique de gestion des données. Les vues de données sont maintenant persistantes et sont gérées via le paquet&nbsp;<a href=\"https://make.wordpress.org/core/2025/11/11/dataviews-dataform-et-al-in-wordpress-6-9/#dataviews-persistence\"><code>@wordpress/views</code></a>. Le panneau de gestion des <code>DataForms</code> (formulaires de données) a été amélioré et d&rsquo;autres éléments ont été améliorés comme les mises en page <code>card</code> et <code>row</code> ainsi que la gestion des validations.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"0aGWCGMOJD\"><a href=\"https://make.wordpress.org/core/2025/11/11/dataviews-dataform-et-al-in-wordpress-6-9/\">DataViews, DataForm, et al. in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;DataViews, DataForm, et al. in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/11/dataviews-dataform-et-al-in-wordpress-6-9/embed/#?secret=XkaN1RVWhq#?secret=0aGWCGMOJD\" data-secret=\"0aGWCGMOJD\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"improved-editing-tools-and-architecture\">Amélioration des outils d’édition</h2>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"direct-drag-and-drop\">Glisser-déposer en direct</h3>\n\n\n\n<p>Le <a href=\"https://make.wordpress.org/core/2025/10/28/gutenberg-21-9-october-22/#direct-drag-and-drop\">glisser-déposer</a>&nbsp;a été amélioré, avec la possibilité de <a href=\"https://github.com/WordPress/gutenberg/pull/67470\">directement déplacer des blocs à l&rsquo;intérieur de l&rsquo;éditeur</a> au lieu de devoir sélectionner le contrôleur de glisser-déposer.</p>\n\n\n\n<figure class=\"wp-block-video\"><video controls src=\"https://make.wordpress.org/core/files/2025/10/drag-3.mp4\"></video><figcaption class=\"wp-element-caption\">Ci-dessus une vidéo de démonstration du glisser-déposer dans l&rsquo;éditeur.</figcaption></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"ability-to-hide-blocks-1\">Possibilité de masquer des blocs</h3>\n\n\n\n<p>WordPress 6.9 permet de masquer et afficher des blocs d&rsquo;un simple clic.</p>\n\n\n\n<figure class=\"wp-block-video\"><video controls src=\"https://make.wordpress.org/test/files/2025/10/Hide-Block.mov\"></video><figcaption class=\"wp-element-caption\">Ci-dessus une vidéo de démonstration du masquage de blocs dans l&rsquo;éditeur.</figcaption></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"iframe-integration-in-post-editor-1\">Intégration iframe de l’éditeur de contenu</h3>\n\n\n\n<p>Il y a&nbsp;une <a href=\"https://make.wordpress.org/core/2021/06/29/blocks-in-an-iframed-template-editor/\">initiative en cours</a>&nbsp;pour placer l&rsquo;éditeur de contenu au sein d&rsquo;une&nbsp;<code>iframe</code>, et plusieurs modifications servent à préparer cette future implémentation&nbsp;:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li>Le&nbsp;<a href=\"https://github.com/WordPress/gutenberg/blob/trunk/schemas/json/block.json\">schéma <code>block.json</code></a>&nbsp;ne permet plus que d&rsquo;utiliser l’<code>apiVersion</code>&nbsp;<code>3</code>&nbsp;pour les nouveaux blocs ou les blocs modifiés</li>\n\n\n\n<li>Un avertissement sera affiché dans la console du navigateur lorsqu&rsquo;un bloc utilise les <code>apiVersion</code>&nbsp;<code>1</code>&nbsp;ou&nbsp;<code>2</code></li>\n</ol>\n\n\n\n<p>Ces modifications visent à aider les développeur·euses à migrer leurs blocs vers <code>apiVersion</code>&nbsp;3. L&rsquo;objectif est de complètement déplacer l’éditeur dans une <code>iframe</code> à partir de WordPress 7.0. Même si cette grosse modification est déjà prête, nous laissons donc un peu de temps aux personnes qui proposent des extensions WP pour mettre à niveau leurs développements.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"t6qkBt4uZq\"><a href=\"https://make.wordpress.org/core/2025/11/12/preparing-the-post-editor-for-full-iframe-integration/\">Preparing the Post Editor for Full iframe Integration</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Preparing the Post Editor for Full iframe Integration&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/12/preparing-the-post-editor-for-full-iframe-integration/embed/#?secret=iVv6lZOGtJ#?secret=t6qkBt4uZq\" data-secret=\"t6qkBt4uZq\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"streaming-block-parser\">Un nouvel outil pour traiter les blocs</h3>\n\n\n\n<p>WordPress 6.9 comprend un nouvel outil&nbsp;<code>WP_Block_Processor</code>&nbsp;pour scanner les structures des blocs contenus dans des documents HTML. Cette nouvelle classe permet de parcourir un document HTML pour analyser et ajuster les structures de ses blocs sans affecter le texte, de convertir des documents en un tableau imbriqué d&rsquo;informations concernant les blocs utilisés et d&rsquo;obtenir des tableaux JSON d&rsquo;attributs.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"dlxl4wHiYQ\"><a href=\"https://make.wordpress.org/core/2025/11/19/introducing-the-streaming-block-parser-in-wordpress-6-9/\">Introducing the streaming block parser in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Introducing the streaming block parser in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/19/introducing-the-streaming-block-parser-in-wordpress-6-9/embed/#?secret=dbr2Knuzma#?secret=dlxl4wHiYQ\" data-secret=\"dlxl4wHiYQ\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"new-blocks-and-block-improvements\">Nouveau blocs et améliorations des blocs existants</h2>\n\n\n\n<p>La bibliothèque de blocs natifs a été enrichie de plusieurs nouveaux blocs&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Un bloc d&rsquo;affichage de formules mathématiques</li>\n\n\n\n<li>Un <a href=\"https://github.com/WordPress/gutenberg/pull/70720\">bloc de requête portant sur les termes de taxonomies</a></li>\n\n\n\n<li>Un bloc de lien vers les commentaires</li>\n\n\n\n<li>Un bloc servant à afficher un compteur des commentaires d&rsquo;un article</li>\n\n\n\n<li>Des améliorations des blocs Titre et Temps de lecture</li>\n</ul>\n\n\n\n<p>WP 6.9 contient aussi de nouvelles fonctionnalités d&rsquo;édition de texte comme le support de <code>fitText</code> qui permet de définir automatiquement la taille du texte en fonction des limites du conteneur dans lequel il s&rsquo;inscrit.</p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"perform-calculations-using-π-in-the-math-block\">Un bloc d&rsquo;affichage des formules mathématiques</h3>\n\n\n\n<p>Le&nbsp;<a href=\"https://github.com/WordPress/gutenberg/pull/72182\">nouveau bloc Math</a>&nbsp;ajoute le support du standard MathML et du rendu LaTeX pour l&rsquo;affichage de formules mathématiques, soit en tant que bloc indépendant, soit dans du texte en ligne pouvant être ajouté dans n&rsquo;importe quel champs de texte enrichi comme les tableaux, les titres ou encore les listes.</p>\n\n\n\n<figure class=\"wp-block-video\"><video controls src=\"https://make.wordpress.org/core/files/2025/10/drag-2.mp4\"></video><figcaption class=\"wp-element-caption\">Ci-dessus une vidéo de démonstration du bloc de d&rsquo;affichage des formules mathématiques.</figcaption></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"accordion-block-now-supports-anchors\">Du contenu repliable avec le bloc Accordéon</h3>\n\n\n\n<p>Le <a href=\"https://github.com/WordPress/gutenberg/issues/21584\">nouveau bloc Accordéon</a>&nbsp;de WP 6.9 peut être personnalisé à volonté. Un article dédié explique&nbsp;<a href=\"https://developer.wordpress.org/news/2025/10/styling-accordions-in-wordpress-6-9/\">comment mettre en forme le bloc Accordéon</a>.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://developer.wordpress.org/news/files/2025/10/accordion-toggle-styled-1536x795.webp\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"heading-block-css-specificity-fix\">Correction de la spécificité CSS du bloc Titre</h3>\n\n\n\n<p>WP 6.9 comprend une&nbsp;<a href=\"https://make.wordpress.org/core/2025/11/12/heading-block-css-specificity-fix-in-wordpress-6-9\">modification du sélecteur CSS utilisé pour les marges internes (<code>padding</code>) sur les titres avec arrière-plan</a>, qui est dorénavant ciblé avec les deux classes <code><strong>.</strong>wp-block-heading</code>&nbsp;et <code>.has-background</code>&nbsp;pour garantir que les personnalisations des marges n&rsquo;affectent que le bloc souhaité.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"4s3vlJO0cL\"><a href=\"https://make.wordpress.org/core/2025/11/12/heading-block-css-specificity-fix-in-wordpress-6-9/\">Heading Block CSS Specificity Fix in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Heading Block CSS Specificity Fix in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/12/heading-block-css-specificity-fix-in-wordpress-6-9/embed/#?secret=zG5lJIgvUv#?secret=4s3vlJO0cL\" data-secret=\"4s3vlJO0cL\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"new-improved-apis\">Nouvelles API et modifications des API existantes</h2>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"meet-the-abilities-api\">Découvrez l’API «&nbsp;Abilities&nbsp;»</h3>\n\n\n\n<p>L’API «&nbsp;Abilities&nbsp;» permet au cœur de WordPress mais aussi aux développeur·euses de thèmes et d&rsquo;extensions d&rsquo;enregistrer leur fonctionnalités de façon unifiée, standardisée et dans un format programmatiquement lisible. L’API «&nbsp;Abilities&nbsp;» fait partie de l&rsquo;initiative plus large visant à&nbsp;<a href=\"https://make.wordpress.org/ai/2025/07/17/ai-building-blocks\">permettre la construction de blocs en passant par l’IA</a>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"TOUP8yZWH0\"><a href=\"https://make.wordpress.org/core/2025/11/10/abilities-api-in-wordpress-6-9/\">Abilities API in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Abilities API in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/10/abilities-api-in-wordpress-6-9/embed/#?secret=5HIq07RelF#?secret=TOUP8yZWH0\" data-secret=\"TOUP8yZWH0\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"updates-to-interactivity-api\">Mise à jour de l’API «&nbsp;Interactivity&nbsp;»</h3>\n\n\n\n<p>Dans WordPress 6.9, l’API de gestion des interactions offre désormais une manière standard d&rsquo;assigner des identifiants uniques aux directives de l’API, ce qui permet aux éléments du site de disposer de multiples directives similaires sans conflit.</p>\n\n\n\n<p>Les fonctions <code>getServerState(</code>) et&nbsp;<code>getServerContext()</code>&nbsp;ont été mises à jour et un nouvel algorithme optimise la gestion des scripts et des styles, offre une meilleure prise en charge des régions de routage dans les éléments interactifs, et ajoute un nouveau paramètre <code>attachTo</code>&nbsp;property qui agit comme un sélecteur CSS pointant sur l&rsquo;élément parent pour le rendu.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"HncJjhFChJ\"><a href=\"https://make.wordpress.org/core/2025/11/12/changes-to-the-interactivity-api-in-wordpress-6-9/\">Changes to the Interactivity API in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Changes to the Interactivity API in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/12/changes-to-the-interactivity-api-in-wordpress-6-9/embed/#?secret=Y7kVvTbuT1#?secret=HncJjhFChJ\" data-secret=\"HncJjhFChJ\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"html-api-updatesimproved-blocks-binding-api\">Mise à jour de l’API «&nbsp;HTML&nbsp;»</h3>\n\n\n\n<p>L’API HTML a été fignolée, avec plusieurs corrections de bogues et améliorations. La méthode&nbsp;<code>WP_HTML_Processor::serialize_token()</code>est désormais publique, ce qui étend la sécurité de l’API au delà de la seule modification de code et la combinaison de code HTML, tandis que&nbsp;<code>set_modifiable_text()</code>&nbsp;rejette désormais les contenus des éléments <code>SCRIPT</code> qui pourraient compromettre sa fermeture normale.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"plqVJwX0cB\"><a href=\"https://make.wordpress.org/core/2025/11/21/updates-to-the-html-api-in-6-9/\">Updates to the HTML API in 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to the HTML API in 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/21/updates-to-the-html-api-in-6-9/embed/#?secret=0EQBKJN8hF#?secret=plqVJwX0cB\" data-secret=\"plqVJwX0cB\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"improved-block-binding-api\">Amélioration de l’API «&nbsp;Block Binding&nbsp;»</h3>\n\n\n\n<p>L’interface de l’API Block Bindings a été rendue plus simple d&rsquo;utilisation avec la possibilité nouvelle de basculer entre les sources, et de rattacher ou détacher des attributs d&rsquo;un simple clic. Le nouveau filtre <code>block_bindings_supported_attributes_{$block_type}</code> facilite quant à lui la personnalisation de la manière dont les attributs des blocs se connectent à une source liée.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"7HOG5iwH71\"><a href=\"https://make.wordpress.org/core/2025/11/12/block-bindings-improvements-in-wordpress-6-9/\">Block Bindings improvements in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Block Bindings improvements in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/12/block-bindings-improvements-in-wordpress-6-9/embed/#?secret=Shct73Aisv#?secret=7HOG5iwH71\" data-secret=\"7HOG5iwH71\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"optimized-performance\">Optimisations des performances</h2>\n\n\n\n<p>WordPress 6.9 offre des améliorations significatives en termes de performances, ce qui optimise l&rsquo;expérience de chargement des sites pour les internautes. L&rsquo;amélioration du LCP (<em>Largest Contentful Paint</em>) est obtenue grâce à la mise en place des styles de blocs à la demande pour les thèmes classiques, la minification des styles de blocs et l&rsquo;augmentation de la limite des styles en ligne, réduisant ainsi le blocage du rendu. Le chemin de rendu critique («&nbsp;critical path&nbsp;») est décongestionné par la dépriorisation des scripts non critiques (par exemple, ceux des blocs interactifs ou de la détection des émojis) qui entraient en conflit avec le chargement de ressources comme l&rsquo;image de l&rsquo;élément considéré comme étant l&rsquo;élément LCP. La stabilité des pages est également améliorée en empêchant le bloc Vidéo de provoquer des décalages de mise en page (ce qui améliore la métrique CLS).</p>\n\n\n\n<p>Beaucoup d&rsquo;autres améliorations ont été faites, par exemple sur les requêtes en base de données, la gestion du cache, une meilleure gestion du CRON WP et des améliorations du tampon de rendu des modèles qui ouvre la porte à de nombreuses améliorations de performances qui étaient auparavant impossibles.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"ijQE6fAipJ\"><a href=\"https://make.wordpress.org/core/2025/11/18/wordpress-6-9-frontend-performance-field-guide/\">WordPress 6.9 Frontend Performance Field Guide</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress 6.9 Frontend Performance Field Guide&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/18/wordpress-6-9-frontend-performance-field-guide/embed/#?secret=1athSDczWJ#?secret=ijQE6fAipJ\" data-secret=\"ijQE6fAipJ\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"modernizing-utf-8-support\">Modernisation du support d’UTF-8</h3>\n\n\n\n<p>Un nouveau tunnel de repli écrit en PHP permet à WordPress 6.9 de traiter l’encodage du texte et la gestion d&rsquo;UTF-8 indépendamment de l&rsquo;environnement sur lequel tourne le site, ce qui apporte plus de cohérence entre les différents environnements sur lesquels votre site peut être installé, ce qui est notamment utile aux thèmes et extensions qui travaillent avec du contenu internationnalisé, ou avec les émojis.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"ikru7pjb4g\"><a href=\"https://make.wordpress.org/core/2025/11/18/modernizing-utf-8-support-in-wordpress-6-9/\">Modernizing UTF-8 support in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Modernizing UTF-8 support in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/18/modernizing-utf-8-support-in-wordpress-6-9/embed/#?secret=ggNMEISTIZ#?secret=ikru7pjb4g\" data-secret=\"ikru7pjb4g\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"updated-query-cache-handling\">Mise à jour de la gestion du cache des requêtes</h3>\n\n\n\n<p>La version 6.9 modifie la façon dont les clés de cache sont créées lorsque les requêtes mises en cache sont traitées dans <code>WP_Query</code>. Le cache objet persistant ne devrait pas être affecté, mais les développeurs et développeuses ainsi que les entreprises fournissant des services d&rsquo;hébergements sont invités à prendre en compte les modifications décrites dans cette note de développement, et à tirer parti des 4 nouvelles fonctions disponibles.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"hbBdeytkdI\"><a href=\"https://make.wordpress.org/core/2025/11/17/consistent-cache-keys-for-query-groups-in-wordpress-6-9/\">Consistent Cache Keys for Query Groups in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Consistent Cache Keys for Query Groups in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/17/consistent-cache-keys-for-query-groups-in-wordpress-6-9/embed/#?secret=CGHgD2wunF#?secret=hbBdeytkdI\" data-secret=\"hbBdeytkdI\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"remove-support-for-loading-assets-conditionally-for-ie\">Suppression du support du chargement conditionnel des ressources pour Internet Explorer</h3>\n\n\n\n<p>WordPress 6.9 supprime le support du <a href=\"https://core.trac.wordpress.org/ticket/63821\">chargement conditionnel des scripts et styles pour IE avec les anciennes structures conditionnelles</a>. Tous les restes de cette ancienne manière de faire <a href=\"https://core.trac.wordpress.org/ticket/58836\">ont été supprimés du code des thèmes natifs</a>. Le code lié à <a href=\"https://core.trac.wordpress.org/ticket/62128\">Genericons a aussi été modifié</a>&nbsp;sur les thèmes qui utilisent cette police web.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"HBt3XMYVWY\"><a href=\"https://make.wordpress.org/core/2025/11/19/legacy-internet-explorer-code-removed/\">Legacy Internet Explorer Code Removed</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Legacy Internet Explorer Code Removed&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/19/legacy-internet-explorer-code-removed/embed/#?secret=sxUtkYszkF#?secret=HBt3XMYVWY\" data-secret=\"HBt3XMYVWY\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"accessibility-updates\">Accessibilité</h2>\n\n\n\n<p>WordPress 6.9 comprend&nbsp;<a href=\"https://core.trac.wordpress.org/query?focuses=~accessibility&amp;milestone=6.9&amp;group=type&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">10 améliorations et 23 corrections de bogues</a>&nbsp;focalisées sur l&rsquo;accessibilité. Il y a par exemple des améliorations des notifications destinées aux technologies d&rsquo;assistance, des améliorations de la sémantique du code et de la gestion du focus clavier, et une mise à niveau du contenu généré via CSS pour éviter que du contenu non pertinent ne soit interprété par les outils d&rsquo;assistance.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"oVjH0GCizX\"><a href=\"https://make.wordpress.org/core/2025/11/19/accessibility-improvements-in-wordpress-6-9/\">Accessibility Improvements in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Accessibility Improvements in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/19/accessibility-improvements-in-wordpress-6-9/embed/#?secret=446JdlkqcD#?secret=oVjH0GCizX\" data-secret=\"oVjH0GCizX\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"php-8-5-support\">Support de PHP 8.5</h2>\n\n\n\n<p>WordPress 6.9 propose un support en version beta de PHP 8.5. Toutes les incompatibilités connues, les avertissements et notifications ont été corrigées. Le support des anciennes versions (pour l&rsquo;instant jusqu&rsquo;à PHP 7.2) a été maintenu. Pour rappel, lorsque nous parlons de support en version beta, nous parlons des <a href=\"https://make.wordpress.org/core/2025/07/07/proposal-remove-the-beta-support-label-from-php-8-3-for-wordpress-6-8/\">versions de PHP qui sont utilisées par moins de 10% des sites web</a>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"HHsVP4QXlf\"><a href=\"https://make.wordpress.org/core/2025/11/21/php-8-5-support-in-wordpress-6-9/\">PHP 8.5 support in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;PHP 8.5 support in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/21/php-8-5-support-in-wordpress-6-9/embed/#?secret=S9UuaRYhKT#?secret=HHsVP4QXlf\" data-secret=\"HHsVP4QXlf\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<p>D&rsquo;autres modifications concernent différentes facettes du cœur du CMS, comme les médias, la gestion multisite, de nouveaux crochets et filtres, etc.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"1N55zTf5W3\"><a href=\"https://make.wordpress.org/core/2025/11/17/miscellaneous-developer-focused-changes-in-6-9/\">Miscellaneous Developer-focused Changes in 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Developer-focused Changes in 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/17/miscellaneous-developer-focused-changes-in-6-9/embed/#?secret=ArJDoGk5Vd#?secret=1N55zTf5W3\" data-secret=\"1N55zTf5W3\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"miscellaneous-editor-changes\">Changements divers concernant l&rsquo;éditeur</h3>\n\n\n\n<p>WP 6.9 apporte aussi un grand nombre de petites modifications de l&rsquo;éditeur de blocs.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"nHqf9JJVdo\"><a href=\"https://make.wordpress.org/core/2025/11/25/miscellaneous-editor-changes-in-wordpress-6-9/\">Miscellaneous Editor Changes in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Editor Changes in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/25/miscellaneous-editor-changes-in-wordpress-6-9/embed/#?secret=sSj6Lr777I#?secret=nHqf9JJVdo\" data-secret=\"nHqf9JJVdo\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"updated-admin-menu-search-query\">Modification des requêtes de recherche du menu d&rsquo;administration</h3>\n\n\n\n<p>Avec WordPress 6.9, la requête de recherche proposée par le menu d&rsquo;administration a changé, passant de&nbsp;<code>$_SERVER[\'QUERY_STRING\']</code>&nbsp;à&nbsp;<code>$_GET</code>. Cela rend le comportement de recherche plus prévisible et évite les problèmes liés à certaines chaines de requêtes. Les extensions qui surchargent cette recherche devront revoir leur façon de fonctionner pour prendre en compte ces changements.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"DC2ukqUl8S\"><a href=\"https://make.wordpress.org/core/2025/11/19/admin-menu-search-query-changed/\">Admin menu search query changed</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Admin menu search query changed&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/19/admin-menu-search-query-changed/embed/#?secret=yuPvIQjESb#?secret=DC2ukqUl8S\" data-secret=\"DC2ukqUl8S\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"additional-support-for-https-in-url-escaping-functions\">Un support complémentaire de HTTPS&nbsp;dans les fonctions d&rsquo;échappement d&rsquo;URL</h3>\n\n\n\n<p>Les fonctions&nbsp;<code>esc_url()</code>,&nbsp;<code>esc_url_raw()</code>&nbsp;et&nbsp;<code>sanitize_url()</code>&nbsp;peuvent maintenant être configurées pour préfixer par <code>https://</code>&nbsp;les URL qui ne proposent pas de schéma par défaut, lorsque le paramètre&nbsp;<code>$protocols</code>&nbsp;contient&nbsp;<code>\'https\'</code>.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"0MhD0ifthp\"><a href=\"https://make.wordpress.org/core/2025/11/19/url-escaping-functions-can-support-https-as-the-default-protocol-in-wordpress-6-9/\">URL-escaping functions can support HTTPS as the default protocol in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;URL-escaping functions can support HTTPS as the default protocol in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/19/url-escaping-functions-can-support-https-as-the-default-protocol-in-wordpress-6-9/embed/#?secret=jGf9jBhCeM#?secret=0MhD0ifthp\" data-secret=\"0MhD0ifthp\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"improved-email-handling-and-inline-image-support\">Amélioration de la gestion des e-mails et du support des images en ligne</h3>\n\n\n\n<p>WordPress 6.9 introduit plusieurs modifications rendant le système d&rsquo;envoi d&rsquo;e-mails plus fiable et flexible. La fonction&nbsp;<code>wp_mail()</code>&nbsp;met maintenant en place l&rsquo;adresse d&rsquo;expédition de manière extensible, les en-têtes sont mieux protégés et l&rsquo;ensemble se repose davantage sur PHPMailer pour la prise en charge des types de contenus. De nombreux autres petits soucis présents depuis quelques temps ont aussi été résolus.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"xd0Bpq88VA\"><a href=\"https://make.wordpress.org/core/2025/11/18/more-reliable-email-in-wordpress-6-9/\">More-reliable email in WordPress 6.9</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;More-reliable email in WordPress 6.9&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/11/18/more-reliable-email-in-wordpress-6-9/embed/#?secret=y21eGjb1ze#?secret=xd0Bpq88VA\" data-secret=\"xd0Bpq88VA\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p>Cette version ajoute aussi la prise en charge des images en ligne et embarquées dans les e-mails HTML, ce qui permet d&rsquo;envoyer des messages enrichis de médias sans avoir à utiliser des URL de sources externes. Les contenus e-mail qui utilisent des références basées sur <code>cid:</code>&nbsp;peuvent désormais afficher des images directement dans le corps de l&rsquo;e-mail.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"wZZMOBpIHQ\"><a href=\"https://make.wordpress.org/core/2025/09/04/prettier-emails-supporting-inline-embedded-images/\">Prettier Emails: Supporting Inline Embedded Images</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Prettier Emails: Supporting Inline Embedded Images&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/09/04/prettier-emails-supporting-inline-embedded-images/embed/#?secret=n7ruDqZVQJ#?secret=wZZMOBpIHQ\" data-secret=\"wZZMOBpIHQ\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"travaux-lies-a-l-implementation-des-outils-ia-dans-wp-6-9\">Travaux liés à l&rsquo;implémentation des outils IA dans WP 6.9</h2>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"php-ai-client\">Client PHP pour l&rsquo;implémentation d&rsquo;outils IA</h3>\n\n\n\n<p>Le <a href=\"https://github.com/WordPress/php-ai-client\">nouveau SDK client PHP destiné aux outils IA</a> facilite l&rsquo;intégration d&rsquo;IA dans les extensions WordPress et les projets PHP. L&rsquo;interface fonctionne avec tous les fournisseurs d&rsquo;IA et les développeurs et développeuses peuvent spécifier les fonctionnalités IA à inclure, leur fournisseur et le modèle à utiliser. Les identifiants sont centralisés et fonctionnent avec toutes les extensions compatibles.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-wordpress-ai wp-block-embed-wordpress-ai\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"e4MhX2H9Gt\"><a href=\"https://make.wordpress.org/ai/2025/07/17/php-ai-api/\">PHP AI Client</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;PHP AI Client&#8221; &#8212; WordPress AI\" src=\"https://make.wordpress.org/ai/2025/07/17/php-ai-api/embed/#?secret=n4QeTroMUh#?secret=e4MhX2H9Gt\" data-secret=\"e4MhX2H9Gt\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"mcp-adapter\">Adaptateur MCP</h3>\n\n\n\n<p>Le nouvel&nbsp;<a href=\"https://github.com/WordPress/mcp-adapter\">adaptateur MCP</a>&nbsp;utilise le&nbsp;<a href=\"https://modelcontextprotocol.io/\">Model Context Protocol</a>&nbsp;(MCP) pour standardiser les interactions de l&rsquo;applicatif WP avec les LLM, pour exposer les fonctionnalités de WordPress aux assistants IA et pour se connecter à d&rsquo;autres serveurs MCP. Cela permet à WordPress d&rsquo;agir à la fois comme serveur et comme client, en enregistrant ses fonctionnalités à travers l&rsquo;API «&nbsp;Abilities&nbsp;» ce qui permet aux assistants IA de les comprendre et de les utiliser, tout en intégrant cela avec d&rsquo;autres serveurs MCP ce qui rend possible de tirer parti d&rsquo;autres outils IA dans WordPress.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-wordpress-ai wp-block-embed-wordpress-ai\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"e6borTD1aD\"><a href=\"https://make.wordpress.org/ai/2025/07/17/mcp-adapter/\">MCP Adapter</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;MCP Adapter&#8221; &#8212; WordPress AI\" src=\"https://make.wordpress.org/ai/2025/07/17/mcp-adapter/embed/#?secret=CmJsm2zJFL#?secret=e6borTD1aD\" data-secret=\"e6borTD1aD\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"but-wait-there-is-more\">Attendez, ce n’est pas fini&nbsp;!</h2>\n\n\n\n<p>6.9 apporte bien plus encore&nbsp;!&nbsp;Plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">250 bogues ont été corrigés</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">123 améliorations et nouvelles fonctionnalités ont été implémentées</a>, et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">22 tâches diverses</a>&nbsp;ont été <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.9&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">marquées comme résolues dans WP 6.9</a>.</p>\n\n\n\n<p>Mentionnons notamment les tickets suivants&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>API «&nbsp;Abilities&nbsp;» : feuille de route pour WP 6.9 (<a href=\"https://github.com/WordPress/abilities-api/issues/83\">AI-83</a>)</li>\n\n\n\n<li>Accessibilité : correction du comportement des sous menus du bloc navigation (<a href=\"https://github.com/WordPress/gutenberg/issues/69834\">GB-69834</a>)</li>\n\n\n\n<li>Éditeur : bloc bouton &#8211; ajout de la section Élément HTML dans les réglages avancés (<a href=\"https://github.com/WordPress/gutenberg/pull/70139\">GB-70139</a>)</li>\n\n\n\n<li>Éditeur : activation de la Palette de Commandes partout sur le tableau de bord (<a href=\"https://github.com/WordPress/gutenberg/issues/58218\">GB-58218</a>)</li>\n\n\n\n<li>Éditeur : nouveaux blocs ajoutés dans la bibliothèque de blocs (<a href=\"https://github.com/WordPress/gutenberg/issues/71026\">GB-71026</a>)</li>\n\n\n\n<li>Éditeur : barre d&rsquo;outils &#8211;  ajustement des couleurs pour la prise en charge du mode sombre (<a href=\"https://github.com/WordPress/gutenberg/issues/66454\">GB-66454</a>)</li>\n\n\n\n<li>Accessibilité : remplacement des règles CSS dépréciées <code>speak</code>&nbsp;et&nbsp;<code>aural</code>&nbsp;(<a href=\"https://github.com/WordPress/gutenberg/pull/63603\">GB-63603</a>)</li>\n\n\n\n<li>Styles globaux : déplacement du bouton&nbsp;<code>Couleurs aléatoires</code>&nbsp;dans le panneau d&rsquo;édition de la palette de couleurs (<a href=\"https://github.com/WordPress/gutenberg/issues/66169\">GB-66169</a>)</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que la version 6.9 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.9.0/\">https://developer.wordpress.org/reference/since/6.9.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-style-serif has-light-grey-2-color has-text-color has-background has-link-color wp-elements-e19b82be4e2290f9a4720996c21421a5 is-layout-constrained wp-block-group-is-layout-constrained\" style=\"background:linear-gradient(135deg,rgb(53,10,128) 67%,rgb(244,237,234) 100%);padding-top:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50)\">\n<p class=\"is-style-serif has-light-grey-2-color has-text-color has-link-color wp-elements-bdd3ef48864355ea6c49d0c39359deba\">Que vous développiez des thèmes ou des extensions, pensez à <strong>tester et retester votre code</strong> pour vous assurer de sa compatibilité avec ces changements.<br><br>Vous pouvez utiliser&nbsp;<a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em>&nbsp;»</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2025/11/wordpress-6-9-release-candidate-1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em>&nbsp;de WordPress 6.9</a>.&nbsp;<br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du&nbsp;<a href=\"https://make.wordpress.org/core/2025/11/25/wordpress-6-9-field-guide/\">Field Guide&nbsp;de WP 6.9 (en anglais)</a>&nbsp;par&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci à <a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a> pour sa relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3383\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"Arrêt des mises à jour de sécurité pour les versions 4.1 à 4.6 de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:112:\"https://fr.wordpress.org/2025/07/11/arret-des-mises-a-jour-de-securite-pour-les-versions-4-1-a-4-6-de-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 11 Jul 2025 09:26:12 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Securité\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3375\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:346:\"À compter de mi-juillet 2025, l&#8217;équipe de sécurité de WordPress ne fournira plus de mises à jour de sécurité pour les versions 4.1 à 4.6 de WordPress. Ces versions ont été initialement publiées il y a plus de neuf ans et plus de 99 % des installations WordPress utilisent une version plus récente. La probabilité que [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1368:\"\n<p>À compter de mi-juillet 2025, l&rsquo;équipe de sécurité de WordPress ne fournira plus de mises à jour de sécurité pour les versions 4.1 à 4.6 de WordPress.</p>\n\n\n\n<p>Ces versions ont été initialement publiées il y a plus de neuf ans et plus de 99 % des installations WordPress utilisent une version plus récente. La probabilité que cela affecte votre site est très faible.</p>\n\n\n\n<p>Pour vérifier que votre version de WordPress est à jour, connectez-vous au tableau de bord de votre site. Si votre version n&rsquo;est pas à jour, vous devriez voir un message proposant sa mise à jour. La version que vous utilisez est indiquée dans le widget « D&rsquo;un coup d&rsquo;œil » présent sur le tableau de bord.</p>\n\n\n\n<p>Pour rappel, <strong>la seule version de WordPress activement maintenue est la version majeure la plus récente</strong>. Les correctifs de sécurité ne sont portés vers les anciennes branches que par « courtoisie », les anciennes versions ne faisant pas l&rsquo;objet de corrections autres que de sécurité.</p>\n\n\n\n<p>Le blog « <bdo lang=\"en\" dir=\"ltr\">Make WordPress Security</bdo> » fournit plus de détails sur la <a href=\"https://make.wordpress.org/security/2025/06/18/security-updates-will-cease-for-wordpress-versions-4-1-through-4-6/\">procédure de fin de support de ces versions (en anglais)</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3375\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"Rendez-vous à Bâle pour le WordCamp Europe 2025 !\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:84:\"https://fr.wordpress.org/2025/04/28/rendez-vous-a-bale-pour-le-wordcamp-europe-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Apr 2025 08:39:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Évènement\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3362\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:364:\"Le WordCamp Europe 2025 se tiendra du 5 au 7 juin dans la magnifique ville de Bâle, en Suisse. Il réunira les passionné·e·s de WordPress et du logiciel libre, des développeuses et développeurs et des professionnels de notre écosystème provenant de tout le continent et même du monde entier ! Venez découvrir de nouvelles perspectives, engagez [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6355:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image.jpg\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"538\" src=\"https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-1024x538.jpg\" alt=\"\" class=\"wp-image-3363\" srcset=\"https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-1024x538.jpg 1024w, https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-300x158.jpg 300w, https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-768x403.jpg 768w, https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image-1536x806.jpg 1536w, https://fr.wordpress.org/files/2025/04/wceu2025-Featured-Image.jpg 1800w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Le WordCamp Europe 2025 se tiendra du 5 au 7 juin dans la magnifique ville de Bâle, en Suisse. Il réunira les passionné·e·s de WordPress et du logiciel libre, des développeuses et développeurs et des professionnels de notre écosystème provenant de tout le continent et même du monde entier !</p>\n\n\n\n<p>Venez découvrir de nouvelles perspectives, engagez des conversations avec les membres de la communauté WordPress, les entreprises et acteurs économiques innovants de notre écosystème au cours de trois jours de conférences, de réseautage et de contribution à WordPress.</p>\n\n\n\n<div class=\"wp-block-group has-off-white-background-color has-background is-layout-constrained wp-container-core-group-is-layout-8503c47b wp-block-group-is-layout-constrained\">\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center has-large-font-size\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Les places sont limitées : réservez la vôtre dès aujourd&rsquo;hui !</strong></p>\n\n\n\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-align-center wp-element-button\" href=\"https://europe.wordcamp.org/2025/tickets/\">Réservez votre place (en anglais)</a></div>\n</div>\n\n\n\n<div style=\"height:50px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Conférences et tables rondes</h2>\n\n\n\n<p>Cet évènement qui se tiendra les 6 et 7 juin 2025 proposera une <a href=\"https://europe.wordcamp.org/2025/schedule/\">série de conférences (en anglais)</a> qui porteront notamment sur des états des lieux de la stratégie des entreprise de l&rsquo;écosystème WordPress, le développement des nouvelles fonctionnalités du CMS, la défense du logiciel libre, l&rsquo;accessibilité, et bien plus encore.</p>\n\n\n\n<p>Pour celles et ceux qui souhaitent perfectionner leurs compétences, les présentations aborderont en profondeur des sujets tels que le SEO pour WordPress, l&rsquo;optimisation des performances, ou encore la conception et la production de sites assistée par l&rsquo;IA.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Séance de questions-réponses avec la direction du projet WordPress</h2>\n\n\n\n<p>Vous pourrez retrouver Mary Hubbard, directrice exécutive du projet WordPress, et Matt Mullenweg, co-fondateur de WordPress le 7 juin pour discuter de WordPress et de sa communauté.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Découvrez Bâle</h2>\n\n\n\n<p>Bâle est la troisième plus grande ville de Suisse. Elle est <a href=\"https://europe.wordcamp.org/2025/location/\">remplie de monuments historiques et culturels à découvrir (en anglais)</a>. Vous pouvez vous déplacer à Bâle et en faire l&rsquo;expérience par vous-même grâce à votre «&nbsp;<bdo lang=\"en\" dir=\"ltr\">BaselCard</bdo>&nbsp;», qui vous permet de monter dans tous les transports en commun de la ville. L&rsquo;équipe d&rsquo;organisation du WordCamp vous recommande fortement d’en profiter pour vous promener le long du Rhin&nbsp;!</p>\n\n\n\n<p><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f6cf.png\" alt=\"🛏\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><a href=\"https://europe.wordcamp.org/2025/location/accommodation/\"> Trouver des logements à Bâle (en anglais)<br></a><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f68c.png\" alt=\"🚌\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><a href=\"https://europe.wordcamp.org/2025/location/getting-around-in-basel/\"> En savoir plus sur la « <bdo lang=\"en\" dir=\"ltr\">BaselCard</bdo> » (en anglais)</a><br><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f4c5.png\" alt=\"📅\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Organisez votre WordCamp Europe !</strong> Découvrez le <a href=\"https://europe.wordcamp.org/2025/schedule/\">programme complet (en anglais)</a> et organisez votre séjour à Bâle !<br><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f39f.png\" alt=\"🎟\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /> <strong>Assurez-vous de réserver votre <a href=\"https://europe.wordcamp.org/2025/tickets/\">ticket pour le WordCamp Europe 2025</a></strong> si vous ne l&rsquo;avez pas déjà fait !</p>\n\n\n\n<p>Suivez l&rsquo;actualité du WordCamp Europe sur <a href=\"https://bsky.app/profile/wordpress.org\">Bluesky</a>, <a href=\"https://instagram.com/wordpress/\">Instagram</a>, <a href=\"https://www.facebook.com/WordPress\">Facebook</a>, <a href=\"https://www.linkedin.com/company/wordpress/\">LinkedIn</a>, <a href=\"https://www.threads.net/@wordpress\">Threads</a>, <a href=\"https://mastodon.world/@wordpress\">Mastodon</a>  et <a href=\"https://twitter.com/WordPress\">X/Twitter</a> pour avoir des nouvelles en temps réel&nbsp;!</p>\n\n\n\n<p>N&rsquo;hésitez pas à relayer le message sur vos réseaux sociaux favoris : que vous soyez là le jour-J à Bâle ou que vous nous suiviez en ligne, partagez vos expériences avec les mots-dièse #WCEU et #WordPress sur tous les réseaux sociaux !</p>\n\n\n\n<p>Rendez-vous à Bâle pour le WordCamp Europe 2025&nbsp;! <img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f1e8-1f1ed.png\" alt=\"🇨🇭\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3362\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"WordPress 6.8 « Cecil »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://fr.wordpress.org/2025/04/15/wordpress-6-8-cecil/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 15 Apr 2025 17:02:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3335\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:390:\"Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde de la musique. WordPress 6.8 «&#160;Cecil&#160;» rend hommage au légendaire pianiste et pionnier du jazz Cecil Taylor. De formation classique mais résolument anticonformiste, Cecil Taylor a ré-imaginé le piano comme un instrument de percussion, superposant les sons, explorant la [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:80564:\"\n<figure class=\"wp-block-image size-large\"><a href=\"https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"535\" src=\"https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-1024x535.png\" alt=\"\" class=\"wp-image-3338\" srcset=\"https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-1024x535.png 1024w, https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-300x157.png 300w, https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-768x401.png 768w, https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil-1536x803.png 1536w, https://fr.wordpress.org/files/2025/04/WordPress-6-8-Cecil.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde de la musique. WordPress 6.8 «&nbsp;Cecil&nbsp;» rend hommage au légendaire pianiste et pionnier du jazz Cecil Taylor.</p>\n\n\n\n<p>De formation classique mais résolument anticonformiste, Cecil Taylor a ré-imaginé le piano comme un instrument de percussion, superposant les sons, explorant la polyphonie et associant différents rythmes pour créer un son à la fois chaotique et précis. Sa musique a été révolutionnaire, formant de l&rsquo;ordre dans le désordre et de l&rsquo;harmonie dans la dissonance.</p>\n\n\n\n<p>Cet esprit anime WordPress 6.8. Adoptez ses nouvelles fonctionnalités audacieuses avec la même curiosité et la même expérimentation qui ont défini la création musicale de Cecil.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue sur WordPress&nbsp;6.8&nbsp;!</h2>\n\n\n\n<p>WordPress 6.8 peaufine et optimise les outils que vous utilisez au quotidien, ce qui rend votre site plus rapide, plus sécurisé et plus facile à gérer. Le guide de styles propose désormais une mise en page structurée et fonctionne avec les thèmes classiques, vous offrant ainsi un meilleur contrôle sur les styles globaux. Le chargement spéculatif accélère la navigation en préchargeant les liens avant même que les internautes n&rsquo;y accèdent, tandis que le hachage <code>bcrypt</code> renforce automatiquement la sécurité des mots de passe. En coulisses, les optimisations de la base de données améliorent les performances, et un nouveau système d&rsquo;alerte de sécurité permet de prévenir les vulnérabilités avant qu&rsquo;elles ne deviennent problématiques.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/latest-fr_FR.zip\">Télécharger WordPress 6.8 «&nbsp;Cecil&nbsp;» en français (ZIP – 20 Mo)</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Une version peaufinée à la perfection</h2>\n\n\n\n<p>WordPress 6.8 améliore et affine les outils que vous utilisez tous les jours, rendant votre site plus rapide, plus sûr et plus facile à gérer.</p>\n\n\n\n<p>Le guide de styles a maintenant une mise en page structurée et fonctionne désormais avec les thèmes classiques, ce qui vous apporte plus de contrôle sur les styles globaux de votre site.</p>\n\n\n\n<p>Le chargement spéculatif accélère la navigation en préchargeant les liens avant que les internautes ne naviguent vers ceux-ci, tandis que le hachage via bcrypt renforce automatiquement la sécurité des mots de passe.</p>\n\n\n\n<p>Parallèlement, des optimisations de la base de données améliorent les performances, et un nouveau système d’avertissement de sécurité aide à prévenir les vulnérabilités avant qu’elles ne deviennent un problème.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Le guide de style fait peau neuve et s’enrichit de quelques nouvelles fonctionnalités</h3>\n\n\n\n<p>Le guide de styles présente une nouvelle mise en page structurée et des libellés plus clairs, pour faciliter encore plus la modification des couleurs, de la typographie et de presque tous les styles de votre site, en un seul endroit.</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2025/04/feature-01.png\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"300\" src=\"https://fr.wordpress.org/files/2025/04/feature-01-300x300.png\" alt=\"\" class=\"wp-image-3339\" srcset=\"https://fr.wordpress.org/files/2025/04/feature-01-300x300.png 300w, https://fr.wordpress.org/files/2025/04/feature-01-150x150.png 150w, https://fr.wordpress.org/files/2025/04/feature-01-768x768.png 768w, https://fr.wordpress.org/files/2025/04/feature-01.png 900w\" sizes=\"auto, (max-width: 300px) 100vw, 300px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Amélioration de l’éditeur</h3>\n\n\n\n<p>Visualisez plus facilement vos options dans les vues de données et excluez les publications épinglées de la boucle de requête. De plus, l’éditeur propose de nombreuses améliorations qui simplifient la création de contenu.</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2025/04/feature-02.png\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"300\" src=\"https://fr.wordpress.org/files/2025/04/feature-02-300x300.png\" alt=\"\" class=\"wp-image-3340\" srcset=\"https://fr.wordpress.org/files/2025/04/feature-02-300x300.png 300w, https://fr.wordpress.org/files/2025/04/feature-02-150x150.png 150w, https://fr.wordpress.org/files/2025/04/feature-02-768x768.png 768w, https://fr.wordpress.org/files/2025/04/feature-02.png 900w\" sizes=\"auto, (max-width: 300px) 100vw, 300px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Chargement quasi instantané des pages, grâce au chargement spéculatif</h3>\n\n\n\n<p>Dans WordPress 6.8, les pages se chargent plus rapidement que jamais. Lorsque vous ou tout internaute survolez ou cliquez sur un lien, WordPress peut précharger la page suivante pour une expérience plus fluide et quasi instantanée. Le système équilibre vitesse et efficacité, et vous pouvez contrôler son fonctionnement avec une extension ou votre propre code. Cette fonctionnalité fonctionne uniquement dans les navigateurs modernes&nbsp;; les anciens l’ignoreront simplement sans aucun impact.</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2025/04/feature-03.png\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"300\" src=\"https://fr.wordpress.org/files/2025/04/feature-03-300x300.png\" alt=\"\" class=\"wp-image-3341\" srcset=\"https://fr.wordpress.org/files/2025/04/feature-03-300x300.png 300w, https://fr.wordpress.org/files/2025/04/feature-03-150x150.png 150w, https://fr.wordpress.org/files/2025/04/feature-03-768x768.png 768w, https://fr.wordpress.org/files/2025/04/feature-03.png 900w\" sizes=\"auto, (max-width: 300px) 100vw, 300px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Sécurité renforcée des mots de passe avec bcrypt</h3>\n\n\n\n<p>Les mots de passe sont désormais plus difficiles à déchiffrer grâce au hachage bcrypt, qui nécessite beaucoup plus de puissance de calcul pour être cassé. Cela renforce la sécurité globale, tout comme d‘autres améliorations de chiffrement dans WordPress. Vous n’avez rien à faire&nbsp;: tout se met à jour automatiquement.</p>\n\n\n\n<figure class=\"wp-block-image size-medium\"><a href=\"https://fr.wordpress.org/files/2025/04/feature-04.png\"><img loading=\"lazy\" decoding=\"async\" width=\"300\" height=\"300\" src=\"https://fr.wordpress.org/files/2025/04/feature-04-300x300.png\" alt=\"\" class=\"wp-image-3342\" srcset=\"https://fr.wordpress.org/files/2025/04/feature-04-300x300.png 300w, https://fr.wordpress.org/files/2025/04/feature-04-150x150.png 150w, https://fr.wordpress.org/files/2025/04/feature-04-768x768.png 768w, https://fr.wordpress.org/files/2025/04/feature-04.png 900w\" sizes=\"auto, (max-width: 300px) 100vw, 300px\" /></a></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Plus de 100 correctifs et améliorations en matière d’accessibilité touchent un large champ de l’expérience WordPress. Cette version inclut des correctifs pour chaque thème natif, des améliorations de la gestion des menus de navigation, de l’outil de personnalisation, et un étiquetage simplifié. L’éditeur de blocs bénéficie de plus de 70 améliorations concernant les blocs, les vues de données, et l’expérience globale des utilisateurs et utilisatrices.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Allégement de la base de données</h3>\n\n\n\n<p>Le travail se poursuit sur l‘optimisation de la génération des clés de cache dans la classe&nbsp;<code>WP_Query</code>. L‘objectif est, comme toujours, d‘améliorer les performances de votre site, dans ce cas en réduisant davantage la charge de votre base de données. Cela est particulièrement utile si vous avez beaucoup de trafic.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>WordPress&nbsp;6.8 propose de nombreuses corrections et améliorations de performances pour accélérer l’ensemble de votre site, de l’administration aux temps de chargement ressentis par les personnes qui visitent votre site. Au-delà du chargement spéculatif désormais intégré nativement, WordPress&nbsp;6.8 accorde une attention particulière à l’éditeur de blocs, à l’enregistrement des types de blocs et à la mise en cache des requêtes. N’attendez jamais plus de 50&nbsp;millisecondes entre chaque interaction. Dans WordPress&nbsp;6.8, l’API de gestion de l’interactivité constitue un premier pas vers cet objectif.</p>\n\n\n\n<h2 class=\"wp-block-heading\">En savoir plus sur WordPress 6.8</h2>\n\n\n\n<p>Pour une vision complète de toutes les nouvelles fonctionnalités et améliorations de WordPress 6.8, vous pouvez <a href=\"https://wordpress.org/download/releases/6-8/\">consulter le site de démonstration des fonctionnalités (en anglais)</a>.</p>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em><bdo lang=\"en\" dir=\"ltr\">Learn WordPress</bdo></em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Learn</bdo></em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;évènements interactifs&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Notes de version de WordPress 6.8</h4>\n\n\n\n<p><a href=\"https://wordpress.org/support/wordpress-version/version-6-8/\">Lisez les notes de version de WordPress 6.8</a> pour obtenir des informations sur l’installation, les améliorations, les problèmes corrigés, les contributeurs et contributrices de la version, les ressources d’apprentissage et la liste des modifications apportées aux fichiers.</p>\n\n\n\n<h4 class=\"wp-block-heading\">Guide technique de WordPress 6.8 en français</h4>\n\n\n\n<p><a href=\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\">Explorez le guide des changements techniques de WordPress 6.8</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous permettent de construire votre site avec WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.8</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale :&nbsp;<a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination de la version :&nbsp;<a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a>&nbsp;and&nbsp;<a href=\"https://profiles.wordpress.org/michelleames/\">Michelle Frechette</a></li>\n\n\n\n<li>Direction technique :&nbsp;<a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>,&nbsp;<a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, and&nbsp;<a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a></li>\n\n\n\n<li>Gestion de projet :&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a></li>\n\n\n\n<li>Direction artistique :&nbsp;<a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a></li>\n\n\n\n<li>Responsable des performances :&nbsp;<a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a></li>\n\n\n\n<li>Direction des tests :&nbsp;<a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.8 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>900 personnes provenant de près de 70 pays différents</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les plus de 250 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.8 <img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<div class=\"wp-block-group alignwide is-style-default is-content-justification-left is-nowrap is-layout-flex wp-container-core-group-is-layout-fc9f69e7 wp-block-group-is-layout-flex\">\n<p class=\"has-dark-blueberry-color has-lemon-3-background-color has-text-color has-background has-link-color has-extra-small-font-size wp-elements-70a077000b3aff2481eb0decd1e70b5e\"><a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/thehercules/\">Aashish Sharma</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/hiabhaykulkarni/\">Abhay Kulkarni</a> · <a href=\"https://profiles.wordpress.org/abhi3315/\">abhi3315</a> · <a href=\"https://profiles.wordpress.org/adakaleh/\">AdaKaleh</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adhun/\">Adhun Anand</a> · <a href=\"https://profiles.wordpress.org/adityab98/\">Aditya Bansode</a> · <a href=\"https://profiles.wordpress.org/stromhalm/\">Adrian Jagusch</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/hemant-ahir/\">Ahir Hemant</a> · <a href=\"https://profiles.wordpress.org/ahmarzaidi/\">Ahmar Zaidi</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ahsankhan316/\">Ahsan Khan</a> · <a href=\"https://profiles.wordpress.org/aishwarryapande/\">Aishwarrya Pande</a> · <a href=\"https://profiles.wordpress.org/ajayghaghretiya1/\">Ajay Ghaghretiya</a> · <a href=\"https://profiles.wordpress.org/ajmaurya/\">Ajay Maurya</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akanshusingh/\">Akanshu Singh</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/aks30498/\">aks30498</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/akshaydhere/\">Akshay Dhere</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a> · <a href=\"https://profiles.wordpress.org/ralessio/\">Alessio</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/alexflorisca/\">Alex Florisca</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/albigdd/\">Alexander Bigga</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/alexus450/\">Alexei Samarschi</a> · <a href=\"https://profiles.wordpress.org/alexschmitz/\">alexschmitz</a> · <a href=\"https://profiles.wordpress.org/alireyad/\">Ali Akbar Reyad</a> · <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a> · <a href=\"https://profiles.wordpress.org/alpipego/\">alpipego</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro Gómez</a> · <a href=\"https://profiles.wordpress.org/akrocks/\">Amaan Khan</a> · <a href=\"https://profiles.wordpress.org/alh0319/\">Amber Hinds</a> · <a href=\"https://profiles.wordpress.org/amimulihsanmahdi/\">Amimul Ihsan</a> · <a href=\"https://profiles.wordpress.org/amin7/\">Amin</a> · <a href=\"https://profiles.wordpress.org/amitbhosale/\">Amit Bhosale</a> · <a href=\"https://profiles.wordpress.org/amitraj2203/\">Amit Raj</a> · <a href=\"https://profiles.wordpress.org/ammarmassoud/\">Ammar Mohamed Fath Allah Abd-Elaaty Massoud</a> · <a href=\"https://profiles.wordpress.org/amolebonde/\">amolebonde</a> · <a href=\"https://profiles.wordpress.org/anandraj346/\">Anand Raj</a> · <a href=\"https://profiles.wordpress.org/anlino/\">Anders Norén</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/bowedk/\">Andreas Pedersen</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/andrewssanya/\">Andrew Ssanya</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey “Rarst” Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/rilwis/\">Anh Tran</a> · <a href=\"https://profiles.wordpress.org/wpgurudev/\">Ankit Gade</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/ankitmaru/\">Ankit Panchal</a> · <a href=\"https://profiles.wordpress.org/ankitpatel1578/\">Ankit Patel</a> · <a href=\"https://profiles.wordpress.org/anmolverma404/\">Anmol Verma</a> · <a href=\"https://profiles.wordpress.org/annchichi/\">annchichi</a> · <a href=\"https://profiles.wordpress.org/annebovelett/\">Anne-Mieke Bovelett</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">annezazu</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/anujrathore24/\">Anuj Singh</a> · <a href=\"https://profiles.wordpress.org/anveshika/\">Anveshika Srivastava</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/arielmaidana/\">Ariel Maidana</a> · <a href=\"https://profiles.wordpress.org/arnaudbroes/\">arnaudbroes</a> · <a href=\"https://profiles.wordpress.org/arnoutblueshell/\">arnoutblueshell</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/mohonchandra/\">Asish Chandra Mohon</a> · <a href=\"https://profiles.wordpress.org/auareyou/\">Au</a> · <a href=\"https://profiles.wordpress.org/autotutorial/\">autotutorial</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/neo2k23/\">BackuPs</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/barry/\">Barry</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/benharri/\">ben</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/bsutcliffe/\">Ben Sutcliffe</a> · <a href=\"https://profiles.wordpress.org/benazeer/\">Benazeer</a> · <a href=\"https://profiles.wordpress.org/benniledl/\">Benedikt Ledl</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/berislavgrgicak/\">Bero</a> · <a href=\"https://profiles.wordpress.org/bgermann/\">bgermann</a> · <a href=\"https://profiles.wordpress.org/albatross10/\">Bhavik Kalpesh</a> · <a href=\"https://profiles.wordpress.org/bijit027/\">Bijit Deb</a> · <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/rainynewt/\">Bishal Shrestha</a> · <a href=\"https://profiles.wordpress.org/bjornw/\">BjornW</a> · <a href=\"https://profiles.wordpress.org/bluantinoo/\">bluantinoo</a> · <a href=\"https://profiles.wordpress.org/bogdanungureanu/\">BogdanUngureanu</a> · <a href=\"https://profiles.wordpress.org/bor0/\">Boro Sitnikovski</a> · <a href=\"https://profiles.wordpress.org/veryard/\">Brad</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/bradleyt/\">Bradley Taylor</a> · <a href=\"https://profiles.wordpress.org/bhubbard/\">Brandon Hubbard</a> · <a href=\"https://profiles.wordpress.org/bpayton/\">Brandon Payton</a> · <a href=\"https://profiles.wordpress.org/brettsmason/\">brettsmason</a> · <a href=\"https://profiles.wordpress.org/brevilo/\">brevilo</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/masteradhoc/\">Brian Haas</a> · <a href=\"https://profiles.wordpress.org/bronsonquick/\">Bronson Quick</a> · <a href=\"https://profiles.wordpress.org/bschneidewind/\">Bryan Schneidewind</a> · <a href=\"https://profiles.wordpress.org/burakkaptan/\">burak</a> · <a href=\"https://profiles.wordpress.org/burnuser/\">burnuser</a> · <a href=\"https://profiles.wordpress.org/snicco/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/calvinalkan/\">Calvin Alkan</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/cgastrell/\">cgastrell</a> · <a href=\"https://profiles.wordpress.org/charleslf/\">charleslf</a> · <a href=\"https://profiles.wordpress.org/mel_cha/\">chiilog (Chiaki Okamoto)</a> · <a href=\"https://profiles.wordpress.org/chintanmachhi207/\">chintanmachhi207</a> · <a href=\"https://profiles.wordpress.org/chrico/\">ChriCo</a> · <a href=\"https://profiles.wordpress.org/chriscct7/\">chriscct7</a> · <a href=\"https://profiles.wordpress.org/chrisdotdotdot/\">chrisdotdotdot</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/claimableperch/\">claimableperch</a> · <a href=\"https://profiles.wordpress.org/claudiulodro/\">Claudiu Lodromanean</a> · <a href=\"https://profiles.wordpress.org/codebymikey/\">codebymikey</a> · <a href=\"https://profiles.wordpress.org/codersantosh/\">codersantosh</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/colind/\">ColinD</a> · <a href=\"https://profiles.wordpress.org/colinleroy/\">colinleroy</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/cbusquets1989/\">Cris Busquets</a> · <a href=\"https://profiles.wordpress.org/mitogh/\">Crisoforo Gaspar</a> · <a href=\"https://profiles.wordpress.org/ctienshi/\">ctienshi</a> · <a href=\"https://profiles.wordpress.org/cweiske/\">cweiske</a> · <a href=\"https://profiles.wordpress.org/didierjm/\">cybeardjm</a> · <a href=\"https://profiles.wordpress.org/coquardcyr/\">Cyrille</a> · <a href=\"https://profiles.wordpress.org/css31/\">Cyrille Sanson</a> · <a href=\"https://profiles.wordpress.org/daedalon/\">Daedalon</a> · <a href=\"https://profiles.wordpress.org/acketon/\">Dakota Chichester</a> · <a href=\"https://profiles.wordpress.org/dalleyne/\">Damien Alleyne</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/dpknauss/\">Dan Knauss</a> · <a href=\"https://profiles.wordpress.org/danht/\">danht</a> · <a href=\"https://profiles.wordpress.org/daniguardiola/\">Dani Guardiola</a> · <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a> · <a href=\"https://profiles.wordpress.org/danielpost/\">Daniel Post</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/danielpataki/\">danielpataki</a> · <a href=\"https://profiles.wordpress.org/danielvann/\">danielvann</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/dhewercorus/\">Darren Hewer</a> · <a href=\"https://profiles.wordpress.org/davelo/\">Dave Loodts</a> · <a href=\"https://profiles.wordpress.org/davilera/\">David Aguilera</a> · <a href=\"https://profiles.wordpress.org/darnado/\">David Arnado</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/davidabowman/\">David Bowman</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/dafargier/\">David FARGIER</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/david-innes/\">David Innes</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/daymobrew/\">daymobrew</a> · <a href=\"https://profiles.wordpress.org/deadduck169/\">deadduck169</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/dkarfa/\">Debabrata Karfa</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/deeppatel8950/\">Deep Patel</a> · <a href=\"https://profiles.wordpress.org/deepakrohilla/\">Deepak Rohilla</a> · <a href=\"https://profiles.wordpress.org/realloc/\">Dennis Ploetner</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/densinakum/\">Densi Nakum</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/devansh2002/\">Devansh Chaudhary</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhavalkapadane/\">Dhaval Kapadane</a> · <a href=\"https://profiles.wordpress.org/dheeraj2995/\">Dheeraj Bhosale</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dhruvishah2203/\">Dhruvi Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvik18/\">Dhruvik Malaviya</a> · <a href=\"https://profiles.wordpress.org/dilipom13/\">dilip</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/diliphingarajiya/\">Dilip Hingarajiya</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dingguodong/\">DingGuodong</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divyeshk71/\">Divyesh_kakrecha</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/mediaformat/\">Django</a> · <a href=\"https://profiles.wordpress.org/dnnsjsk/\">dnnsjsk</a> · <a href=\"https://profiles.wordpress.org/doekenorg/\">Doeke Norg</a> · <a href=\"https://profiles.wordpress.org/dogee/\">dogee</a> · <a href=\"https://profiles.wordpress.org/domenicdenicola/\">domenicdenicola</a> · <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a> · <a href=\"https://profiles.wordpress.org/donalirl/\">donalirl</a> · <a href=\"https://profiles.wordpress.org/dooperweb/\">dooperweb</a> · <a href=\"https://profiles.wordpress.org/dougwollison/\">Doug Wollison</a> · <a href=\"https://profiles.wordpress.org/dretzlaff/\">dretzlaff</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/dwainm/\">Dwain Maralack</a> · <a href=\"https://profiles.wordpress.org/earthman100/\">Earthman Media</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/eddystile/\">Eddy</a> · <a href=\"https://profiles.wordpress.org/cais/\">Edward Caissie</a> · <a href=\"https://profiles.wordpress.org/eceleste/\">efc</a> · <a href=\"https://profiles.wordpress.org/talksina/\">Elena Brescacin</a> · <a href=\"https://profiles.wordpress.org/elizaan36/\">elizaan36</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/codex-m/\">Emerson Maningo</a> · <a href=\"https://profiles.wordpress.org/emlebrun/\">Emilie LEBRUN</a> · <a href=\"https://profiles.wordpress.org/eatse/\">Emmanuel Atsé</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/ericdye/\">Eric Dye</a> · <a href=\"https://profiles.wordpress.org/ethitter/\">Erick Hitter</a> · <a href=\"https://profiles.wordpress.org/codekraft/\">Erik</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/im3dabasia1/\">Eshaan Dabasiya</a> · <a href=\"https://profiles.wordpress.org/estelaris/\">Estela Rueda</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/etobiesen/\">Even Tobiesen</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/gaambo/\">Fabian Todt</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fazyshah/\">Faizan Nabi</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/finntown/\">finntown</a> · <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a> · <a href=\"https://profiles.wordpress.org/francina/\">Francesca Marano</a> · <a href=\"https://profiles.wordpress.org/franciscabusas22/\">Francis Cabusas</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/frankbiganski/\">Frank B.</a> · <a href=\"https://profiles.wordpress.org/frank-klein/\">Frank Klein</a> · <a href=\"https://profiles.wordpress.org/franz00/\">Fransisca H</a> · <a href=\"https://profiles.wordpress.org/frkly/\">frkly</a> · <a href=\"https://profiles.wordpress.org/fushar/\">fushar</a> · <a href=\"https://profiles.wordpress.org/fxbenard/\">fxbenard</a> · <a href=\"https://profiles.wordpress.org/gaellebesson/\">gaellebesson</a> · <a href=\"https://profiles.wordpress.org/gajendrasingh/\">Gajendra Singh</a> · <a href=\"https://profiles.wordpress.org/galibh/\">Galib Hayder</a> · <a href=\"https://profiles.wordpress.org/ecgan/\">Gan Eng Chin</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/ghinamt/\">ghinamt</a> · <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a> · <a href=\"https://profiles.wordpress.org/giuriani/\">giuriani</a> · <a href=\"https://profiles.wordpress.org/glendaviesnz/\">Glen Davies</a> · <a href=\"https://profiles.wordpress.org/glynnquelch/\">Glynn Quelch</a> · <a href=\"https://profiles.wordpress.org/ingeniumed/\">Gopal Krishnan</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/gregbenz/\">gregbenz</a> · <a href=\"https://profiles.wordpress.org/grgarside/\">grgarside</a> · <a href=\"https://profiles.wordpress.org/guido07111975/\">Guido</a> · <a href=\"https://profiles.wordpress.org/guillaumeturpin/\">Guillaume TURPIN</a> · <a href=\"https://profiles.wordpress.org/gulamdastgir04/\">Gulamdastgir Momin</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/gencmedya/\">Halil Kaya</a> · <a href=\"https://profiles.wordpress.org/yahaly/\">Halyna Yampolska</a> · <a href=\"https://profiles.wordpress.org/hameem1102/\">Hameem Mahdad Kader</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">Hannes Leismann</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/harrym/\">harrym</a> · <a href=\"https://profiles.wordpress.org/harshalkadu/\">Harshal Kadu</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/hekuranredev/\">hekuranredev</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/hdkothari81/\">Hemant Kothari</a> · <a href=\"https://profiles.wordpress.org/iamarinoh/\">Henrique Iamarino</a> · <a href=\"https://profiles.wordpress.org/henrywright/\">Henry Wright</a> · <a href=\"https://profiles.wordpress.org/rvouill/\">Herve THOMAS</a> · <a href=\"https://profiles.wordpress.org/hideishi/\">hideishi</a> · <a href=\"https://profiles.wordpress.org/kurudrive/\">Hidekazu Ishikawa</a> · <a href=\"https://profiles.wordpress.org/hilayt24/\">Hilay Trivedi</a> · <a href=\"https://profiles.wordpress.org/panchalhimani711/\">Himani Panchal</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/hiteshhuptechweb/\">Hitesh Dhokai</a> · <a href=\"https://profiles.wordpress.org/hovhanneshovakimyan/\">Hovhannes Hovakimyan</a> · <a href=\"https://profiles.wordpress.org/hueitan/\">hueitan</a> · <a href=\"https://profiles.wordpress.org/humanify/\">humanify</a> · <a href=\"https://profiles.wordpress.org/hussain896/\">hussain896</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a> · <a href=\"https://profiles.wordpress.org/ilovecats7/\">ilovecats7</a> · <a href=\"https://profiles.wordpress.org/imranhasanraaz/\">Imran</a> · <a href=\"https://profiles.wordpress.org/imranh920/\">Imran Hossain (a11n)</a> · <a href=\"https://profiles.wordpress.org/indirabiswas27/\">Indira Biswas</a> · <a href=\"https://profiles.wordpress.org/indithemes/\">indithemes</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/iseulde/\">iseulde</a> · <a href=\"https://profiles.wordpress.org/isuke01/\">Isu</a> · <a href=\"https://profiles.wordpress.org/ivankristianto/\">Ivan Kristianto</a> · <a href=\"https://profiles.wordpress.org/moxie/\">Jack</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">Jagir Bahesh</a> · <a href=\"https://profiles.wordpress.org/jainil07/\">Jainil Shah</a> · <a href=\"https://profiles.wordpress.org/whyisjake/\">Jake Spurlock</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/jhmonroe/\">James Monroe</a> · <a href=\"https://profiles.wordpress.org/jopdop30/\">James Payne</a> · <a href=\"https://profiles.wordpress.org/imaginarymedia/\">James Robinson</a> · <a href=\"https://profiles.wordpress.org/q0rban/\">James Sansbury</a> · <a href=\"https://profiles.wordpress.org/jamieblomerus/\">Jamie Blomerus</a> · <a href=\"https://profiles.wordpress.org/jammycakes/\">jammycakes</a> · <a href=\"https://profiles.wordpress.org/lysyjan87/\">Jan Lysý</a> · <a href=\"https://profiles.wordpress.org/janak007/\">janak Kaneriya</a> · <a href=\"https://profiles.wordpress.org/janusdev/\">janusdev</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/boogah/\">Jason Cosper</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/jasonsa19/\">Jason Sauerwald</a> · <a href=\"https://profiles.wordpress.org/javiercasares/\">Javier Casares</a> · <a href=\"https://profiles.wordpress.org/shovan_jaya/\">Jayaram</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">JD Ahir</a> · <a href=\"https://profiles.wordpress.org/jdnd/\">jdnd</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/maverick3x6/\">Jeff Golenski</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a> · <a href=\"https://profiles.wordpress.org/jeflopodev/\">jeflopo</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jepperask/\">jepperask</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeremy80/\">jeremy80</a> · <a href=\"https://profiles.wordpress.org/jeremyroman/\">jeremyroman</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">jeryj</a> · <a href=\"https://profiles.wordpress.org/jessedyck/\">jessedyck</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jigar-bhanushali/\">Jigar Bhanushali</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jnweaver/\">jnweaver</a> · <a href=\"https://profiles.wordpress.org/jartes/\">Joan Artes</a> · <a href=\"https://profiles.wordpress.org/jodamo5/\">jodamo5</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joecsmalley/\">joecsmalley</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/timse201/\">Johannes Jülg</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/arrcorona/\">Jomar Jay</a> · <a href=\"https://profiles.wordpress.org/jomonthomaslobo1/\">Jomon Thomas Lobo</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/jongycastillo/\">Jong</a> · <a href=\"https://profiles.wordpress.org/n2erjo00/\">Joni Erkkilä</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonnyauk/\">jonnyauk</a> · <a href=\"https://profiles.wordpress.org/joomskys/\">joomskys</a> · <a href=\"https://profiles.wordpress.org/joostdevalk/\">Joost de Valk</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josvelasco/\">Jos Velasco</a> · <a href=\"https://profiles.wordpress.org/josevarghese/\">Jose Varghese</a> · <a href=\"https://profiles.wordpress.org/blogitsolutions/\">Josef Seidl</a> · <a href=\"https://profiles.wordpress.org/josephscott/\">Joseph Scott</a> · <a href=\"https://profiles.wordpress.org/joshuawold/\">Joshua Wold</a> · <a href=\"https://profiles.wordpress.org/jottevanger/\">jottevanger</a> · <a href=\"https://profiles.wordpress.org/jokanane/\">Jouni Kananen</a> · <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanbuis/\">juanbuis</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/juanwp22/\">juanwp22</a> · <a href=\"https://profiles.wordpress.org/jules-colle/\">Jules Colle</a> · <a href=\"https://profiles.wordpress.org/julianmar/\">julianmar</a> · <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/juliobox/\">Julio Potier</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/juzar/\">Juzar</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kaitohm/\">Kaito Hanamori</a> · <a href=\"https://profiles.wordpress.org/ikamal/\">Kamal Hosen</a> · <a href=\"https://profiles.wordpress.org/kapasias/\">KAP ASIAs</a> · <a href=\"https://profiles.wordpress.org/kapilpaul/\">Kapil Paul</a> · <a href=\"https://profiles.wordpress.org/karlgroves/\">karlgroves</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/karthickmurugan/\">Karthick Murugan</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/karthikeya01/\">Karthikeya Bethu</a> · <a href=\"https://profiles.wordpress.org/kasparsd/\">Kaspars</a> · <a href=\"https://profiles.wordpress.org/zoonini/\">Kathryn Presner</a> · <a href=\"https://profiles.wordpress.org/kausaralm/\">Kausar Alam</a> · <a href=\"https://profiles.wordpress.org/keithdevon/\">keithdevon</a> · <a href=\"https://profiles.wordpress.org/kel-dc/\">Kel Santiago-Pilarski</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/tinypixel/\">Kelly Mears</a> · <a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a> · <a href=\"https://profiles.wordpress.org/ketanniruke/\">Ketan Niruke</a> · <a href=\"https://profiles.wordpress.org/patelketan/\">Ketan Patel</a> · <a href=\"https://profiles.wordpress.org/kevinlearynet/\">Kevinleary.net</a> · <a href=\"https://profiles.wordpress.org/kharisblank/\">Kharis Sulistiyono</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kjroelke/\">KJ Roelke</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/kohheepeace/\">kohheepeace</a> · <a href=\"https://profiles.wordpress.org/kmgalanakis/\">Konstantinos Galanakis</a> · <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a> · <a href=\"https://profiles.wordpress.org/kristastevens/\">kristastevens</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupaly2k/\">Krupal Lakhia</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/wplmillet/\">Laurent MILLET</a> · <a href=\"https://profiles.wordpress.org/lakshmananphp/\">Lax Mariappan</a> · <a href=\"https://profiles.wordpress.org/laxman-prajapati/\">Laxman Prajapati</a> · <a href=\"https://profiles.wordpress.org/lcarevic/\">lcarevic</a> · <a href=\"https://profiles.wordpress.org/leecollings/\">Lee</a> · <a href=\"https://profiles.wordpress.org/leewillis77/\">Lee Willis</a> · <a href=\"https://profiles.wordpress.org/leedxw/\">leedxw</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lenasterg/\">lenasterg</a> · <a href=\"https://profiles.wordpress.org/leszeks/\">leszeks</a> · <a href=\"https://profiles.wordpress.org/leup/\">leup</a> · <a href=\"https://profiles.wordpress.org/levskipg/\">levskipg</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/louislaugesen/\">Louis</a> · <a href=\"https://profiles.wordpress.org/louwie17/\">Lourens</a> · <a href=\"https://profiles.wordpress.org/lovesoni1999/\">Love Soni</a> · <a href=\"https://profiles.wordpress.org/thelovekesh/\">Lovekesh Kumar</a> · <a href=\"https://profiles.wordpress.org/lovewpmu/\">lovewpmu</a> · <a href=\"https://profiles.wordpress.org/lovor/\">Lovro Hrust</a> · <a href=\"https://profiles.wordpress.org/dreadlox/\">Lox</a> · <a href=\"https://profiles.wordpress.org/ltrihan/\">ltrihan</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/wpfed/\">Lukasz</a> · <a href=\"https://profiles.wordpress.org/lukecavanagh/\">Luke Cavanagh</a> · <a href=\"https://profiles.wordpress.org/gadelhas/\">Mário Santos</a> · <a href=\"https://profiles.wordpress.org/maciejmackowiak/\">maciejmackowiak</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madpeter/\">madpeter</a> · <a href=\"https://profiles.wordpress.org/magdarogier/\">Magda Rogier</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/mp518/\">Mahesh Prajapati</a> · <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a> · <a href=\"https://profiles.wordpress.org/maikelraow/\">maikelraow</a> · <a href=\"https://profiles.wordpress.org/travel_girl/\">Maja Benke</a> · <a href=\"https://profiles.wordpress.org/mkrndmane/\">Makarand G. Mane</a> · <a href=\"https://profiles.wordpress.org/tomdxw/\">mallorydxw-old</a> · <a href=\"https://profiles.wordpress.org/manfcarlo/\">manfcarlo</a> · <a href=\"https://profiles.wordpress.org/manojmaharrshi/\">Manoj Maharrshi</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani (a11n)</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/marchalyoan/\">marchalyoan</a> · <a href=\"https://profiles.wordpress.org/afmarchetti/\">Marchetti Design</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/mariayohana/\">Maria Yohana</a> · <a href=\"https://profiles.wordpress.org/marian1/\">marian1</a> · <a href=\"https://profiles.wordpress.org/nuryko/\">Marianna</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/marineevain/\">Marine EVAIN</a> · <a href=\"https://profiles.wordpress.org/nofearinc/\">Mario Peshev</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/mapk/\">Mark Uraine</a> · <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> · <a href=\"https://profiles.wordpress.org/immasud/\">Masud Rana</a> · <a href=\"https://profiles.wordpress.org/paapst/\">Mathieu Paapst</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/iammattthomas/\">Matt (Thomas) Miklic</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattwest/\">Matt West</a> · <a href=\"https://profiles.wordpress.org/kinggmobb/\">Matthew</a> · <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a> · <a href=\"https://profiles.wordpress.org/mattryanwalker/\">mattryanwalker</a> · <a href=\"https://profiles.wordpress.org/azouamauriac/\">Mauriac AZOUA</a> · <a href=\"https://profiles.wordpress.org/maximemeganck/\">Maxime Meganck</a> · <a href=\"https://profiles.wordpress.org/maximebj/\">maximebj</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/faithcoder/\">Md Abdullah Al Arif</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/itsmhrahman/\">Md Hafijur Rahman</a> · <a href=\"https://profiles.wordpress.org/kawsar007/\">MD Kawsar Chowdhury</a> · <a href=\"https://profiles.wordpress.org/mehdi01/\">Md Mahdi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdibrahimk48/\">Md. Ibrahim Khalil</a> · <a href=\"https://profiles.wordpress.org/najmulsaju/\">Md. Najmul Islam</a> · <a href=\"https://profiles.wordpress.org/mehedi_csit/\">Md.Mehedi Hasan</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/leeseoftbc/\">MelissaH</a> · <a href=\"https://profiles.wordpress.org/metropolis_john/\">metropolis_john</a> · <a href=\"https://profiles.wordpress.org/mdawaffe/\">Michael Adams (mdawaffe)</a> · <a href=\"https://profiles.wordpress.org/mburridge/\">Michael Burridge</a> · <a href=\"https://profiles.wordpress.org/websiteredev/\">Michael Willman</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/michelleames/\">Michelle Frechette</a> · <a href=\"https://profiles.wordpress.org/micromadness/\">micromadness</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/mmtr86/\">Miguel Torres</a> · <a href=\"https://profiles.wordpress.org/mijotj/\">Mijo T J</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mbijon/\">Mike Bijon</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikinc860/\">Mikin Chauhan</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/milindmore22/\">Milind More</a> · <a href=\"https://profiles.wordpress.org/mimitips/\">mimi</a> · <a href=\"https://profiles.wordpress.org/369work/\">miroku</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/modi2918/\">Modi Sahil</a> · <a href=\"https://profiles.wordpress.org/antwortzeit/\">modulbuero</a> · <a href=\"https://profiles.wordpress.org/aboelfotoh/\">Mohamed Aboelfotoh Mohamed</a> · <a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a> · <a href=\"https://profiles.wordpress.org/mojorob/\">mojorob</a> · <a href=\"https://profiles.wordpress.org/jucaduca/\">Morais Junior</a> · <a href=\"https://profiles.wordpress.org/mosescursor/\">Moses Cursor Ssebunya</a> · <a href=\"https://profiles.wordpress.org/mosne/\">Mosne / Paolo Tesei</a> · <a href=\"https://profiles.wordpress.org/mr660/\">mr660</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/mrwweb/\">mrwweb</a> · <a href=\"https://profiles.wordpress.org/mtdkei/\">mt</a> · <a href=\"https://profiles.wordpress.org/muddassirnasim/\">Muddassir Rahman Nasim</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/mukulsingh27/\">Mukul Singh</a> · <a href=\"https://profiles.wordpress.org/my1xt/\">My1</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">n8finch</a> · <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir</a> · <a href=\"https://profiles.wordpress.org/nandow/\">nandow</a> · <a href=\"https://profiles.wordpress.org/nanisamireddy/\">NANI SAMIREDDY</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/nataliat2004/\">Natalia T</a> · <a href=\"https://profiles.wordpress.org/nathanatmoz/\">Nathan Johnson</a> · <a href=\"https://profiles.wordpress.org/navneet/\">navneet</a> · <a href=\"https://profiles.wordpress.org/navi161/\">Navneet Kaur</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/greatislander/\">Ned Zimmerman</a> · <a href=\"https://profiles.wordpress.org/neotrope/\">neotrope</a> · <a href=\"https://profiles.wordpress.org/mcqueen22/\">NerQuiles</a> · <a href=\"https://profiles.wordpress.org/krstarica/\">net</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/nickgalvez/\">nickgalvez</a> · <a href=\"https://profiles.wordpress.org/undefinedfr/\">Nicolas RIVIERE</a> · <a href=\"https://profiles.wordpress.org/nicolasleroy/\">nicolasleroy</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/smushytaco/\">Nikan Radan</a> · <a href=\"https://profiles.wordpress.org/nikitasolanki1812/\">Nikita Solanki</a> · <a href=\"https://profiles.wordpress.org/nikunj8866/\">Nikunj Hatkar</a> · <a href=\"https://profiles.wordpress.org/snilesh/\">Nilesh Shiragave</a> · <a href=\"https://profiles.wordpress.org/nirajgirixd/\">Niraj Giri</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/mrtortai/\">Noam Eppel</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nosilver4u/\">nosilver4u</a> · <a href=\"https://profiles.wordpress.org/oceantober/\">oceantober</a> · <a href=\"https://profiles.wordpress.org/finalwebsites/\">Olaf Lederer</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/jbkkd/\">Omer Korner</a> · <a href=\"https://profiles.wordpress.org/arzola/\">Oscar Arzola</a> · <a href=\"https://profiles.wordpress.org/groenroos/\">Oskari Groenroos</a> · <a href=\"https://profiles.wordpress.org/othernoel/\">othernoel</a> · <a href=\"https://profiles.wordpress.org/ov3rfly/\">Ov3rfly</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/pampfelimetten/\">pampfelimetten</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/dparthj/\">Parth Dodiya</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/casiepa/\">Pascal Casier</a> · <a href=\"https://profiles.wordpress.org/pateljaymin/\">Patel Jaymin</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/eartboard/\">Paul</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/bbpaule/\">Paul English</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paullb/\">paullb</a> · <a href=\"https://profiles.wordpress.org/psrpinto/\">Paulo Pinto</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/creadordev/\">Pawan Kumar</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/westi/\">Peter Westwood</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/peter8nss/\">peter8nss</a> · <a href=\"https://profiles.wordpress.org/peterdavehello/\">peterdavehello</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/philliproth/\">philliproth</a> · <a href=\"https://profiles.wordpress.org/philwebs/\">philwebs</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pixlpirate/\">pixlpirate</a> · <a href=\"https://profiles.wordpress.org/podpirate/\">podpirate</a> · <a href=\"https://profiles.wordpress.org/poojabhimani/\">Pooja Bhimani</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja Killekar (Muchandikar)</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/prasadkarmalkar/\">Prasad Karmalkar</a> · <a href=\"https://profiles.wordpress.org/prashant/\">prashant</a> · <a href=\"https://profiles.wordpress.org/pmbaldha/\">Prashant Baldha</a> · <a href=\"https://profiles.wordpress.org/contactprashantpp/\">Prashant Patil</a> · <a href=\"https://profiles.wordpress.org/prathamesh24/\">Prathamesh Shirke</a> · <a href=\"https://profiles.wordpress.org/prathameshbhagat1511/\">prathameshbhagat1511</a> · <a href=\"https://profiles.wordpress.org/pkbhatt/\">Pratik Bhatt</a> · <a href=\"https://profiles.wordpress.org/pratikgandhi/\">Pratik Gandhi</a> · <a href=\"https://profiles.wordpress.org/pratiklondhe/\">Pratik Londhe</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/priyank9033/\">Priyank</a> · <a href=\"https://profiles.wordpress.org/pushpenderindia/\">Pushpender Singh</a> · <a href=\"https://profiles.wordpress.org/itsjonq/\">Q</a> · <a href=\"https://profiles.wordpress.org/qhaensler/\">qhaensler</a> · <a href=\"https://profiles.wordpress.org/rfischmann/\">Rafael Fischmann</a> · <a href=\"https://profiles.wordpress.org/rahulsprajapati/\">Rahul Prajapati</a> · <a href=\"https://profiles.wordpress.org/imrraaj/\">Raj Patel</a> · <a href=\"https://profiles.wordpress.org/rajat1192/\">Rajat Patel</a> · <a href=\"https://profiles.wordpress.org/raj198/\">Rajendra Patel</a> · <a href=\"https://profiles.wordpress.org/rajendrapatilraj/\">Rajendra Patil</a> · <a href=\"https://profiles.wordpress.org/rkradadiya/\">Rajesh Radadiya</a> · <a href=\"https://profiles.wordpress.org/rajeshrathodwp/\">Rajesh Rathod</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ravigadhiyawp/\">Ravi Gadhiya</a> · <a href=\"https://profiles.wordpress.org/redkite/\">redkite</a> · <a href=\"https://profiles.wordpress.org/rehanali/\">Rehan Ali</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/rembem/\">Remco</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho</a> · <a href=\"https://profiles.wordpress.org/ooraiser69/\">Renz Jay Sanchez</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/riddhidave/\">Riddhi Dave</a> · <a href=\"https://profiles.wordpress.org/rinkalpagdar/\">Rinkal Pagdar</a> · <a href=\"https://profiles.wordpress.org/rishavdutta/\">Rishav Dutta</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/rkyburz/\">rkyburz</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/miqrogroove/\">Robert Chapin</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/harmr/\">Robert Seyfriedsberger</a> · <a href=\"https://profiles.wordpress.org/robertstaddon/\">robertstaddon</a> · <a href=\"https://profiles.wordpress.org/robinmartijn/\">Robin Martijn</a> · <a href=\"https://profiles.wordpress.org/kreppar/\">Rodrigo Arias</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/rogierlankhorst/\">Rogier Lankhorst</a> · <a href=\"https://profiles.wordpress.org/geekofshire/\">Rohan Jha</a> · <a href=\"https://profiles.wordpress.org/rohitmathur7/\">rohitmathur7</a> · <a href=\"https://profiles.wordpress.org/rohjay/\">rohjay</a> · <a href=\"https://profiles.wordpress.org/room34/\">room34</a> · <a href=\"https://profiles.wordpress.org/rotemg/\">Rotem Gelbart</a> · <a href=\"https://profiles.wordpress.org/lev0/\">Roy Orbitson</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/roybellingan/\">roybellingan</a> · <a href=\"https://profiles.wordpress.org/rseigel/\">rseigel</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/rudrakshigupta/\">Rudrakshi Gupta</a> · <a href=\"https://profiles.wordpress.org/rupesh5438/\">Rupesh Patil</a> · <a href=\"https://profiles.wordpress.org/rupw/\">rupw</a> · <a href=\"https://profiles.wordpress.org/ruturajraval2305/\">Ruturaj Raval</a> · <a href=\"https://profiles.wordpress.org/rvoigt/\">rvoigt</a> · <a href=\"https://profiles.wordpress.org/bookdude13/\">Ryan Fredlund</a> · <a href=\"https://profiles.wordpress.org/ryanhellyer/\">Ryan Hellyer</a> · <a href=\"https://profiles.wordpress.org/rmccue/\">Ryan McCue</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/looswebstudio/\">Ryo</a> · <a href=\"https://profiles.wordpress.org/sppramodh/\">S P Pramodh</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">Sérgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sabbir1991/\">Sabbir Ahmed</a> · <a href=\"https://profiles.wordpress.org/sabrineg/\">sabrineg</a> · <a href=\"https://profiles.wordpress.org/isaeedam/\">Saeed Piri</a> · <a href=\"https://profiles.wordpress.org/sagarlakhani/\">Sagar Lakhani</a> · <a href=\"https://profiles.wordpress.org/sagarprajapati/\">Sagar Prajapati</a> · <a href=\"https://profiles.wordpress.org/mi5t4n/\">Sagar Tamang</a> · <a href=\"https://profiles.wordpress.org/sailpete/\">sailpete</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sallyruchman/\">sally</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/ranafge/\">Samsul Islam Rana</a> · <a href=\"https://profiles.wordpress.org/otto42/\">Samuel Wood (Otto)</a> · <a href=\"https://profiles.wordpress.org/codexdemon/\">Sanyogg Shelar</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarathar/\">Sarath AR</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiya Venkatesan</a> · <a href=\"https://profiles.wordpress.org/sfougnier/\">Saul Fougnier</a> · <a href=\"https://profiles.wordpress.org/saurabhdhariwal/\">saurabh.dhariwal</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/infosatech/\">Sayan Datta</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/sbathompson/\">sbathompson</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Scott Arciszewski</a> · <a href=\"https://profiles.wordpress.org/scribu/\">scribu</a> · <a href=\"https://profiles.wordpress.org/sean212/\">Sean Fisher</a> · <a href=\"https://profiles.wordpress.org/seanlanglands/\">seanlanglands</a> · <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/sergiogutierrez/\">sergiogutierrez</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shadialaghbari/\">Shadi G شادي جـ</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/shanemuir/\">Shane Muirhead</a> · <a href=\"https://profiles.wordpress.org/spdft/\">Shoe</a> · <a href=\"https://profiles.wordpress.org/shraddhagore/\">Shraddha Gore</a> · <a href=\"https://profiles.wordpress.org/shreyashd21/\">shreyashd21</a> · <a href=\"https://profiles.wordpress.org/shub07/\">Shubham Kumar Bansal</a> · <a href=\"https://profiles.wordpress.org/iamshubhamsp/\">Shubham Patil</a> · <a href=\"https://profiles.wordpress.org/shulard/\">shulard</a> · <a href=\"https://profiles.wordpress.org/shyamkariya/\">Shyam Kariya</a> · <a href=\"https://profiles.wordpress.org/nomnom99/\">Siddharth Thevaril</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/simo_m/\">Simone Maranzana</a> · <a href=\"https://profiles.wordpress.org/sirlouen/\">SirLouen</a> · <a href=\"https://profiles.wordpress.org/sjefen6/\">sjefen6</a> · <a href=\"https://profiles.wordpress.org/slaffik/\">Slava Abakumov</a> · <a href=\"https://profiles.wordpress.org/mslavco/\">Slavco Mihajloski</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/soyebsalar/\">soyeb salar</a> · <a href=\"https://profiles.wordpress.org/spencerfinnell/\">Spencer Finnell</a> · <a href=\"https://profiles.wordpress.org/spenserhale/\">Spenser Hale</a> · <a href=\"https://profiles.wordpress.org/spmultidots/\">spmultidots</a> · <a href=\"https://profiles.wordpress.org/spncr/\">spncr</a> · <a href=\"https://profiles.wordpress.org/srikat/\">Sridhar Katakam</a> · <a href=\"https://profiles.wordpress.org/stefahn/\">Stefan Seidner-Britting</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stein2nd/\">stein2nd</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a> · <a href=\"https://profiles.wordpress.org/dufresnesteven/\">Steve Dufresne</a> · <a href=\"https://profiles.wordpress.org/stimul/\">stimul</a> · <a href=\"https://profiles.wordpress.org/strarsis/\">strarsis</a> · <a href=\"https://profiles.wordpress.org/stuartmcalpine/\">Stuart McAlpine</a> · <a href=\"https://profiles.wordpress.org/subodhrajpopat/\">Subodh Rajpopat</a> · <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a> · <a href=\"https://profiles.wordpress.org/sketchboy/\">SUHAS SUTAR</a> · <a href=\"https://profiles.wordpress.org/sukhendu2002/\">Sukhendu Sekhar Guria</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/csesumonpro/\">Sumon Sarker</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">SunilPrajapati</a> · <a href=\"https://profiles.wordpress.org/surajswalstar/\">Suraj Sutar</a> · <a href=\"https://profiles.wordpress.org/swalkinshaw/\">swalkinshaw</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/synchro/\">Synchro</a> · <a href=\"https://profiles.wordpress.org/tschwarz-1/\">t.schwarz</a> · <a href=\"https://profiles.wordpress.org/tacoverdo/\">Taco Verdonschot</a> · <a href=\"https://profiles.wordpress.org/gonom9/\">Taegon Kim</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/inc2734/\">Takashi Kitajima</a> · <a href=\"https://profiles.wordpress.org/takayukister/\">Takayuki Miyoshi</a> · <a href=\"https://profiles.wordpress.org/takuword/\">takuword</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/th23/\">th23</a> · <a href=\"https://profiles.wordpress.org/thakordarshil/\">Thakor Darshil</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/thomaswm/\">thomaswm</a> · <a href=\"https://profiles.wordpress.org/thrijith/\">Thrijith Thankachan</a> · <a href=\"https://profiles.wordpress.org/tiagogoncalves/\">tiago</a> · <a href=\"https://profiles.wordpress.org/tigriweb/\">TigriWeb</a> · <a href=\"https://profiles.wordpress.org/tillkruess/\">Till Krüss</a> · <a href=\"https://profiles.wordpress.org/tb1909/\">Tim Brathärig</a> · <a href=\"https://profiles.wordpress.org/dontfeedthecode/\">Tim Sheehan</a> · <a href=\"https://profiles.wordpress.org/timwhitlock/\">Tim W</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/spaceshipone/\">Timothée Brosille</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tkama/\">Timur Kamaev</a> · <a href=\"https://profiles.wordpress.org/tirth03/\">Tirth Doshi</a> · <a href=\"https://profiles.wordpress.org/tjarrett/\">TJarrett</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">Tobias Bäthge</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn “Tobi” Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tgsrvrs/\">Tom Gugel</a> · <a href=\"https://profiles.wordpress.org/tommusrhodus/\">Tom Rhodes</a> · <a href=\"https://profiles.wordpress.org/shimotomoki/\">Tomoki Shimomura</a> · <a href=\"https://profiles.wordpress.org/skithund/\">Toni Viemerö</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/trushaamin/\">Trusha</a> · <a href=\"https://profiles.wordpress.org/tunetheweb/\">tunetheweb</a> · <a href=\"https://profiles.wordpress.org/dinhtungdu/\">Tung Du</a> · <a href=\"https://profiles.wordpress.org/tusharaddweb/\">Tushar Patel</a> · <a href=\"https://profiles.wordpress.org/tyb/\">Ty</a> · <a href=\"https://profiles.wordpress.org/tysonlmao/\">tysonlmao</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/unsalkorkmaz/\">Unsal Korkmaz</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/upadalavipul/\">upadalavipul</a> · <a href=\"https://profiles.wordpress.org/utrenkner/\">utrenkner</a> · <a href=\"https://profiles.wordpress.org/eboxnet/\">Vagelis</a> · <a href=\"https://profiles.wordpress.org/vaibhavsweb/\">Vaibhav Singh Web</a> · <a href=\"https://profiles.wordpress.org/vaibhav2527/\">Vaibhav Tukaram Nawale</a> · <a href=\"https://profiles.wordpress.org/twvania/\">Vania</a> · <a href=\"https://profiles.wordpress.org/okvee/\">vee</a> · <a href=\"https://profiles.wordpress.org/vevas/\">Vegard S.</a> · <a href=\"https://profiles.wordpress.org/vgnavada/\">vgnavada</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/fylgjur/\">Victoria – a11n</a> · <a href=\"https://profiles.wordpress.org/gvgvgvijayan/\">Vijayan</a> · <a href=\"https://profiles.wordpress.org/vijaysinh9094/\">Vijaysinh Zala</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">Vipul Patil</a> · <a href=\"https://profiles.wordpress.org/virgildia/\">Virgildia</a> · <a href=\"https://profiles.wordpress.org/virgar/\">Virginie Garnier</a> · <a href=\"https://profiles.wordpress.org/virginienacci/\">virginienacci</a> · <a href=\"https://profiles.wordpress.org/vishy-moghan/\">Vishy Moghan</a> · <a href=\"https://profiles.wordpress.org/vivekawsm/\">vivekawsm</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">Vrishabh Jasani</a> · <a href=\"https://profiles.wordpress.org/vykesmac/\">vykesmac</a> · <a href=\"https://profiles.wordpress.org/wadowad/\">wadowad</a> · <a href=\"https://profiles.wordpress.org/pctevree/\">Web-Pepper</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/west7/\">Wes Theron</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/whaze/\">whaze</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a> · <a href=\"https://profiles.wordpress.org/wongjn/\">wongjn</a> · <a href=\"https://profiles.wordpress.org/worldweb/\">World Web Technology</a> · <a href=\"https://profiles.wordpress.org/wpgerd/\">wpgerd</a> · <a href=\"https://profiles.wordpress.org/wwdes/\">wwdes</a> · <a href=\"https://profiles.wordpress.org/xate/\">xate</a> · <a href=\"https://profiles.wordpress.org/xavilc/\">xavilc</a> · <a href=\"https://profiles.wordpress.org/xpurichan/\">xpurichan</a> · <a href=\"https://profiles.wordpress.org/yahil/\">Yahil Madakiya</a> · <a href=\"https://profiles.wordpress.org/yaniiliev/\">Yani</a> · <a href=\"https://profiles.wordpress.org/yashrocz/\">Yash Kukreja</a> · <a href=\"https://profiles.wordpress.org/yellowafterlife/\">yellowafterlife</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yuliyan/\">Yuliyan Slavchev</a> · <a href=\"https://profiles.wordpress.org/omaeyusuke/\">yuu</a> · <a href=\"https://profiles.wordpress.org/zaoyao/\">zaoyao</a> · <a href=\"https://profiles.wordpress.org/zargarov/\">Zargarov</a> · <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a> · <a href=\"https://profiles.wordpress.org/haozi/\">耗子</a></p>\n</div>\n\n\n\n<h3 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress&nbsp;6.8 en français</h3>\n\n\n\n<p>WordPress est un projet international et la version 6.8 est déjà complètement disponible dans plus de 40 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress&nbsp;6.8 en français&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/fxbenard\">FX Benard</a>, <a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>,&nbsp;<a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>,&nbsp;<a href=\"https://profiles.wordpress.org/karine-wendling\">karine wendling</a>,&nbsp;<a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>,&nbsp;<a href=\"https://profiles.wordpress.org/mumuu000\">mumuu000</a>,&nbsp;<a href=\"https://profiles.wordpress.org/pasglop\">pasglop</a>,&nbsp;<a href=\"https://profiles.wordpress.org/rodrigoq\">rodrigoq</a>,&nbsp;<a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>,&nbsp;<a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>,&nbsp;<a href=\"https://profiles.wordpress.org/translationsbyautomattic\">Translations by Automattic</a>, et&nbsp;<a href=\"https://profiles.wordpress.org/wptranslationsorg\">WP-Translations</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-small-font-size\">Article rédigé par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>. Merci à <a href=\'https://profiles.wordpress.org/jdy68/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jdy68</a> et <a href=\'https://profiles.wordpress.org/nlegagneur/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>nlegagneur</a> pour leur relecture.</p>\n\n\n\n<p><br></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3335\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.8\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2025/03/28/guide-des-changements-techniques-de-wordpress-6-8/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 28 Mar 2025 07:53:21 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3310\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"Découvrez les changements techniques qui arrivent le 15 avril 2025 avec la version 6.8 de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:35094:\"\n<figure class=\"wp-block-image alignfull size-full\"><a href=\"https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques.png\"><img loading=\"lazy\" decoding=\"async\" width=\"2156\" height=\"1084\" src=\"https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques.png\" alt=\"\" class=\"wp-image-3312\" srcset=\"https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques.png 2156w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-300x151.png 300w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-1024x515.png 1024w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-768x386.png 768w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-1536x772.png 1536w, https://fr.wordpress.org/files/2025/03/wordpress-6-8-guide-changements-techniques-2048x1030.png 2048w\" sizes=\"auto, (max-width: 2156px) 100vw, 2156px\" /></a></figure>\n\n\n\n<div class=\"wp-block-group has-small-font-size is-content-justification-right is-nowrap is-layout-flex wp-container-core-group-is-layout-b315634e wp-block-group-is-layout-flex\">\n<p>Temps de lecture estimé&nbsp;:&nbsp;</p>\n\n\n<div class=\"wp-block-post-time-to-read\">6–9 minutes</div></div>\n\n\n\n<p>WordPress 6.8 comprend la résolution de plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">300 tickets sur Trac</a>, dont&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">104 améliorations et nouvelles fonctionnalités</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">plus de 170 corrections de bogues</a>. Cette version comprend&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">23 tickets focalisés sur les performances</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">34 sur l’accessibilité</a>&nbsp;et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.8&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">16 sur la modernisation du code et la conformité aux standards de code</a>. Les modifications de la version 6.8 concernent&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.8&amp;group=component&amp;max=9999&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">43 composants du cœur du CMS</a>.</p>\n\n\n\n<p>Cette version comprend aussi&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.4%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.5%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.6%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.7%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.8%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.9%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.0%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.1%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.2%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.3%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.4%22%20\">387 améliorations</a>,&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.4%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.5%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.6%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.7%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.8%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.9%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.0%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.1%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.2%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.3%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.4%22%20\">525 corrections de bogues</a>&nbsp;et&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.4%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.5%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.6%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.7%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.8%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.9%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.0%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.1%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.2%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.3%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2020.4%22%20\">70 améliorations d’accessibilité</a>&nbsp;sur l’éditeur (projet Gutenberg).</p>\n\n\n\n<p class=\"is-style-serif has-charcoal-0-color has-text-color has-background has-link-color wp-elements-37003aee4fdc33a177f14a048ba187af\" style=\"background:linear-gradient(135deg,rgb(242,255,240) 0%,rgb(255,252,223) 50%,rgb(255,211,218) 100%)\">Ce guide décrit les principaux changements techniques qui arrivent sur WordPress&nbsp;6.8, dont la sortie est prévue le 15 avril 2025.</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p class=\"has-pomegrade-1-color has-text-color has-link-color wp-elements-25a8d26d528a99d7724a8a001a372b5a\"><a href=\"https://make.wordpress.org/core/6-8/\">En savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.8</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Changements concernant l’éditeur et le projet Gutenberg</h2>\n\n\n\n<p>Une vaste gamme d&rsquo;améliorations concerne les performances, l&rsquo;expérience de développement et l’interface d&rsquo;édition générale. Cette version introduit de nouveaux outils comme le filtre <code>should_load_block_assets_on_demand</code> pour optimiser le chargement des ressources, un système d&rsquo;avertissement utilisable lorsque vous employez <code>useSelect</code>, et un système d&rsquo;enregistrement des blocs plus efficace. Elle contient aussi une mise à jour des outils de design disponibles pour chaque bloc, affine les composants de l&rsquo;interface et propose une série de changements divers qui améliorent la cohérence et l&rsquo;extensibilité de l&rsquo;éditeur. Ces changements contribuent à un flux de travail de développement plus fluide et à un environnement d&rsquo;édition plus adaptatif.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Performances et chargement des ressources</h3>\n\n\n\n<p>De nouveaux outils aident les développeuses et les développeurs à créer des expériences d&rsquo;utilisation des blocs plus performantes. Un avertissement dans le crochet <code>useSelect</code> alerte lorsque les sélecteurs sont définis en ligne, un problème courant qui peut entraîner un recalcul du rendu inutile. Le filtre <code>should_load_block_assets_on_demand</code> offre un contrôle précis sur le fait que les ressources de bloc soient mises en file d&rsquo;attente globalement ou uniquement en cas de besoin, ce qui permet de réduire le CSS et le JavaScript inutilisés sur l&rsquo;interface <em>front</em>. Tous ces changements favorisent des flux de travail de développement plus efficaces et optimisés.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"fhFlkFOCIl\"><a href=\"https://make.wordpress.org/core/2025/03/12/data-a-helpful-performance-warning-for-developers-in-the-useselect-hook/\">Data: A helpful performance warning for developers in the &#8216;useSelect&#8217; hook</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Data: A helpful performance warning for developers in the &#8216;useSelect&#8217; hook&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/12/data-a-helpful-performance-warning-for-developers-in-the-useselect-hook/embed/#?secret=450zF7Nret#?secret=fhFlkFOCIl\" data-secret=\"fhFlkFOCIl\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"hB2FZegD7B\"><a href=\"https://make.wordpress.org/core/2025/03/24/new-filter-should_load_block_assets_on_demand-in-6-8/\">New filter should_load_block_assets_on_demand in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New filter &lt;code&gt;should_load_block_assets_on_demand&lt;/code&gt; in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/24/new-filter-should_load_block_assets_on_demand-in-6-8/embed/#?secret=YjASEVzB2H#?secret=hB2FZegD7B\" data-secret=\"hB2FZegD7B\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"block-and-design-tool-registration\">Gestion des blocs et outils de personnalisation disponibles pour chaque bloc</h3>\n\n\n\n<p>Les améliorations apportées à l&rsquo;enregistrement des blocs et à la visibilité des outils de conception simplifient le développement pour l&rsquo;éditeur de blocs. Une approche plus efficace de l&rsquo;enregistrement des types de blocs réduit la surcharge liée au chargement des métadonnées des blocs, en particulier dans les environnements comportant de nombreux blocs personnalisés. En complément, nous avons sorti une nouvelle version de la liste des outils de personnalisation disponibles pour chaque bloc afin d’indiquer&nbsp;<strong>pour chaque outil de personnalisation les blocs qui le prennent en charge</strong>, offrant ainsi aux développeur·euses une vision plus claire des options disponibles.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"a3N8ljSVe9\"><a href=\"https://make.wordpress.org/core/2025/03/13/more-efficient-block-type-registration-in-6-8/\">More efficient block type registration in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;More efficient block type registration in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/13/more-efficient-block-type-registration-in-6-8/embed/#?secret=QzNxSOMj2W#?secret=a3N8ljSVe9\" data-secret=\"a3N8ljSVe9\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"DOAiQNo1bl\"><a href=\"https://make.wordpress.org/core/2025/03/12/roster-of-design-tools-per-block-wordpress-6-8-edition/\">Roster of design tools per block (WordPress 6.8 edition)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Roster of design tools per block (WordPress 6.8 edition)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/12/roster-of-design-tools-per-block-wordpress-6-8-edition/embed/#?secret=dsWOhWCruy#?secret=DOAiQNo1bl\" data-secret=\"DOAiQNo1bl\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"editor-ui-and-component-updates\">Interface de l’éditeur et mise à jour des composants</h3>\n\n\n\n<p>Des modifications apportées à l&rsquo;interface de l&rsquo;éditeur améliorent la cohérence, la convivialité et l&rsquo;ergonomie des différents éléments qui le composent. Les mises à jour des composants d&rsquo;interface d&rsquo;utilisation de base, tels que les boutons et les principes de mise en page, alignent le style et les comportements sur la base du nouveau système de design de WordPress. D&rsquo;autres changements concernent une meilleure cohérence du balisage dans le bloc Navigation, une prévisualisation de contenu améliorée pour le bloc Groupe et une meilleure accessibilité pour les éléments d&rsquo;interface. Ces modifications contribuent à une expérience d&rsquo;édition plus soignée et prévisible.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"hCtw3Sfz1F\"><a href=\"https://make.wordpress.org/core/2025/03/25/updates-to-user-interface-components-in-wordpress-6-8/\">Updates to user-interface components in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to user-interface components in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/25/updates-to-user-interface-components-in-wordpress-6-8/embed/#?secret=wgcNFOWlm3#?secret=hCtw3Sfz1F\" data-secret=\"hCtw3Sfz1F\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"KihoQxj7Gw\"><a href=\"https://make.wordpress.org/core/2025/03/25/miscellaneous-block-editor-changes-in-wordpress-6-8/\">Miscellaneous Block Editor Changes in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Block Editor Changes in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/25/miscellaneous-block-editor-changes-in-wordpress-6-8/embed/#?secret=H0oRlXN4zs#?secret=KihoQxj7Gw\" data-secret=\"KihoQxj7Gw\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"accessibility\">Accessibilité</h2>\n\n\n\n<p>Un large éventail d&rsquo;améliorations de l&rsquo;accessibilité de WordPress arrive avec la version&nbsp;6.8&nbsp;: amélioration de la navigation, de la clarté du balisage et de la prise en charge des lecteurs d&rsquo;écran dans l&rsquo;ensemble de l&rsquo;éditeur de blocs&nbsp;; amélioration de la classe <code>.screen-reader-text</code> qui offre désormais un comportement de focus plus cohérent entre les composants&nbsp;; tandis que des dizaines d&rsquo;autres améliorations concernent les structures de menu, les libellés des blocs, les infobulles et la sémantique de l&rsquo;interface. Ces changements créent une expérience d’utilisation plus inclusive et rapprochent WordPress des meilleures pratiques en matière d&rsquo;accessibilité.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"lLtdPQgH11\"><a href=\"https://make.wordpress.org/core/2025/03/25/accessibility-improvements-in-wordpress-6-8/\">Accessibility Improvements in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Accessibility Improvements in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/25/accessibility-improvements-in-wordpress-6-8/embed/#?secret=ByVi2u33L9#?secret=lLtdPQgH11\" data-secret=\"lLtdPQgH11\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"MY8vUHKQ6W\"><a href=\"https://make.wordpress.org/core/2025/03/20/changes-to-the-screen-reader-text-class-in-wordpress-6-8/\">Changes to the .screen-reader-text class in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Changes to the .screen-reader-text class in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/20/changes-to-the-screen-reader-text-class-in-wordpress-6-8/embed/#?secret=ip8giZeKP4#?secret=MY8vUHKQ6W\" data-secret=\"MY8vUHKQ6W\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"internationalization\">Internationalisation</h2>\n\n\n\n<p>Plusieurs améliorations ont été apportées aux outils et à l&rsquo;infrastructure d&rsquo;internationalisation afin d&rsquo;améliorer l&rsquo;expérience de traduction et de localisation. Les mises à jour comprennent l&rsquo;arrivée de nouvelles fonctions de traduction, des corrections de cohérence et une meilleure prise en charge des formes plurielles, ce qui facilite la création d&rsquo;extensions, de thèmes et d&rsquo;interfaces entièrement traduisibles.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"NqvcibLyGF\"><a href=\"https://make.wordpress.org/core/2025/03/12/i18n-improvements-6-8/\">Internationalization improvements in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Internationalization improvements in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/12/i18n-improvements-6-8/embed/#?secret=NBUGYYmhDo#?secret=NqvcibLyGF\" data-secret=\"NqvcibLyGF\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"performance\">Performances</h2>\n\n\n\n<p>De nouveaux outils et des conseils aident les développeurs et développeuses à créer des interfaces plus rapides. La fonctionnalité de chargement spéculatif utilise l&rsquo;API <code>Speculation Rules</code> pour précharger ou pré-afficher les cibles des liens de navigation, améliorant ainsi la performance perçue par les utilisateurs finaux lors du clic sur un lien. De plus, des modifications de l&rsquo;API <code>Interactivity</code> permettront d&rsquo;écrire du code <em>front-end</em> plus efficace et plus évolutif.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"HRsy4J27Eb\"><a href=\"https://make.wordpress.org/core/2025/03/06/speculative-loading-in-6-8/\">Speculative Loading in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Speculative Loading in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/06/speculative-loading-in-6-8/embed/#?secret=d8v7ZXJwkZ#?secret=HRsy4J27Eb\" data-secret=\"HRsy4J27Eb\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"49PtIbJHVl\"><a href=\"https://make.wordpress.org/core/2025/03/24/interactivity-api-best-practices-in-6-8/\">Interactivity API best practices in 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Interactivity API best practices in 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/24/interactivity-api-best-practices-in-6-8/embed/#?secret=CslBN8jmlU#?secret=49PtIbJHVl\" data-secret=\"49PtIbJHVl\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"rest-api\">API REST</h2>\n\n\n\n<p>Les améliorations apportées à l&rsquo;API REST étendent sa flexibilité et son utilité pour les applications WordPress <em>headless</em> et découplées. Un nouveau filtre, <code>rest_menu_read_access</code>, permet aux développeur·euses de contrôler l&rsquo;accès public aux menus de navigation, aux éléments de menu et aux emplacements de menu via l&rsquo;API REST. Ce changement permet un contrôle plus précis des données de menu exposées via l&rsquo;API, ce qui permet de prendre en charge une gamme plus large de cas d&rsquo;utilisation.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"eCrEpoAbgB\"><a href=\"https://make.wordpress.org/core/2025/03/27/new-rest-api-filter-for-exposing-menus-publicly-in-wordpress-6-8/\">New REST API Filter for Exposing Menus Publicly in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New REST API Filter for Exposing Menus Publicly in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/27/new-rest-api-filter-for-exposing-menus-publicly-in-wordpress-6-8/embed/#?secret=TmRv4OhCL7#?secret=eCrEpoAbgB\" data-secret=\"eCrEpoAbgB\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"security\">Sécurité</h2>\n\n\n\n<p>La sécurité des mots de passe a été renforcée grâce à l&rsquo;introduction de <code>bcrypt</code> comme nouvel algorithme de hachage par défaut. Ce changement modernise le stockage des mots de passe de WordPress, offrant une meilleure résistance aux attaques par force brute et s&rsquo;alignant sur les meilleures pratiques actuelles de l&rsquo;industrie. Les mots de passe existants restent valides et seront re-hachés avec <code>bcrypt</code> lors de la prochaine connexion réussie de l&rsquo;utilisateur·ice.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"qVqP1W6BMg\"><a href=\"https://make.wordpress.org/core/2025/02/17/wordpress-6-8-will-use-bcrypt-for-password-hashing/\">WordPress 6.8 will use bcrypt for password hashing</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress 6.8 will use bcrypt for password hashing&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/02/17/wordpress-6-8-will-use-bcrypt-for-password-hashing/embed/#?secret=avMfXAbxDn#?secret=qVqP1W6BMg\" data-secret=\"qVqP1W6BMg\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<p>Un ensemble de modifications plus petites améliore la cohérence, l&rsquo;extensibilité et l&rsquo;expérience de développement générale. Ces changements couvrent divers domaines du cœur WordPress, notamment la gestion des médias, le rendu de certains codes courts (<em>shortcodes</em>), l&rsquo;enregistrement des types de publications, la gestion des thèmes. Bien qu&rsquo;individuellement mineures, ces modifications reflètent les efforts continus pour moderniser notre CMS.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"6yMViHGi0o\"><a href=\"https://make.wordpress.org/core/2025/03/25/miscellaneous-developer-changes-in-wordpress-6-8/\">Miscellaneous developer changes in WordPress 6.8</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous developer changes in WordPress 6.8&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2025/03/25/miscellaneous-developer-changes-in-wordpress-6-8/embed/#?secret=8nTjG46eRo#?secret=6yMViHGi0o\" data-secret=\"6yMViHGi0o\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"but-wait-there-is-more\">Attendez, ce n’est pas fini&nbsp;!</h2>\n\n\n\n<p>WordPress 6.8 offre encore bien davantage&nbsp;!&nbsp;Plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">170 bogues</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">104 améliorations et nouvelles fonctionnalités</a>, et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=task+(blessed)&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=type&amp;col=owner&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">21 tâches diverses</a>&nbsp;ont été&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.8&amp;group=component&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">clôturés dans WordPress 6.8</a>.&nbsp; Cette version va par exemple permettre d&rsquo;afficher les nouveaux emojis de la version 15.1 de la bibliothèque Twemoji pour les internautes qui ne peuvent pas les afficher nativement dans leur navigateur (exemple de nouvel emoji&nbsp;: <img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/1f426-200d-1f525.png\" alt=\"🐦‍🔥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" />).</p>\n\n\n\n<p>Voici quelques modifications notables&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Remplacement des chaînes « Add New {Item} » par « Add {Item} » partout sur l&rsquo;administration (<a href=\"https://core.trac.wordpress.org/ticket/61219\">ticket #61219</a>)</li>\n\n\n\n<li>Amélioration des chaînes traduisibles sur le thème Twenty Twenty-Five (<a href=\"https://core.trac.wordpress.org/ticket/62482\">ticket #62482</a>)</li>\n\n\n\n<li>Thèmes natifs&nbsp;: amélioration de l&rsquo;accessibilité du lien du titre du site (<a href=\"https://core.trac.wordpress.org/ticket/62895\">ticket #62895</a>)</li>\n\n\n\n<li>Gestion des dates&nbsp;: les réglages des dates obtiennent deux nouvelles options, <code>j.n.Y</code> et <code>d.m.Y</code> (<a href=\"https://core.trac.wordpress.org/ticket/55685\">#55685</a>)</li>\n\n\n\n<li>Contenus embarqués&nbsp;: ajout de Canva en tant que fournisseur oEmbed (<a href=\"https://core.trac.wordpress.org/ticket/58840\">ticket #58840</a>)</li>\n\n\n\n<li>API des métadonnées&nbsp;: renommage de l’action <code>setted_transient</code>&nbsp;en&nbsp;<code>set_transient</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/62849\">ticket #62849</a>)</li>\n\n\n\n<li>API REST&nbsp;: gestion des barres obliques de fin de chaînes dans&nbsp;<code>rest_preload_api_request</code>&nbsp;(<a href=\"https://core.trac.wordpress.org/ticket/57048\">ticket #57048</a>)</li>\n\n\n\n<li>Sécurité&nbsp;: assurance explicite du caractère requis du module PHP&nbsp;<code>hash</code>&nbsp;et ajout de vérifications des prérequis lors de l&rsquo;installation et de la mise à jour (<a href=\"https://core.trac.wordpress.org/ticket/56017\">ticket #56017</a>)</li>\n\n\n\n<li>Mises à jour&nbsp;: suppression d&rsquo;une vérification inutile lors de la vérification des mises à jour lorsque la donnée est à jour (<a href=\"https://core.trac.wordpress.org/ticket/44118\">ticket #44118</a>)</li>\n\n\n\n<li>Widgets&nbsp;: ajout de la prise en charge des types de publications dans la fonction&nbsp;<code>get_calendar()</code>. Ces modifications introduisent également un nouveau filtre&nbsp;<code>get_calendar_args</code> (<a href=\"https://core.trac.wordpress.org/ticket/34093\">ticket #34093</a>)</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que WP 6.8 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.8.0/\">https://developer.wordpress.org/reference/since/6.8.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-style-serif has-charcoal-0-color has-text-color has-background has-link-color wp-elements-b65007937b1cf3a6c667456985c6a68f is-layout-constrained wp-block-group-is-layout-constrained\" style=\"background:linear-gradient(135deg,rgb(242,255,240) 0%,rgb(255,252,223) 50%,rgb(255,211,218) 100%);padding-top:1em;padding-bottom:1em\">\n<p class=\"is-style-serif has-black-color has-text-color has-link-color wp-elements-acf16339b7757858691a26a725321228\">Que vous développiez des thèmes ou des extensions, pensez à <strong>tester et retester votre code</strong> pour vous assurer de sa compatibilité avec ces changements.<br><br>Vous pouvez utiliser&nbsp;<a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension «&nbsp;<em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em>&nbsp;»</a>&nbsp;sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2024/10/wordpress-6-7-release-candidate-1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em>&nbsp;de WordPress 6.8</a>.&nbsp;<br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/?php=8.0&amp;wp=beta&amp;networking=no&amp;language=&amp;multisite=no&amp;random=y4q1rn88xn\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress&nbsp;<img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du&nbsp;<a href=\"https://make.wordpress.org/core/2025/03/28/wordpress-6-8-field-guide/\">Field Guide&nbsp;de WP 6.8 (en anglais)</a>&nbsp;par&nbsp;<a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci <a href=\'https://profiles.wordpress.org/clementpolito/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>clementpolito</a>, <a href=\'https://profiles.wordpress.org/rainbowgeek/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rainbowgeek</a>, <a href=\'https://profiles.wordpress.org/reskatorfr/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>reskatorfr</a>, <a href=\'https://profiles.wordpress.org/jdy68/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>jdy68</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3310\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"WordPress 6.7 « Rollins »\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://fr.wordpress.org/2024/11/12/wordpress-6-7-rollins/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 12 Nov 2024 23:14:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3255\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:385:\"Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde la musique. WordPress 6.7 «&#160;Rollins&#160;» rend hommage au saxophoniste de jazz Sonny Rollins. Connu comme l’un des plus grands improvisateurs du jazz, Rollins a influencé des générations de musiciens avec sa technique, son esprit d&#8217;innovation et son approche de [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:69268:\"\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://wordpress.org/news/files/2024/11/Release-Edition-Featured-Image-1024x535.png\" alt=\"\" class=\"wp-image-18085\" /></figure>\n\n\n\n<p>Chaque version de WordPress célèbre un ou une artiste ayant posé son empreinte sur le monde la musique. WordPress 6.7 «&nbsp;Rollins&nbsp;» rend hommage au saxophoniste de jazz Sonny Rollins. Connu comme l’un des plus grands improvisateurs du jazz, Rollins a influencé des générations de musiciens avec sa technique, son esprit d&rsquo;innovation et son approche de l&rsquo;expression musicale.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Bienvenue sur WordPress&nbsp;6.7&nbsp;!</h2>\n\n\n\n<p>WordPress 6.7 introduit le nouveau thème <bdo lang=\"en\" dir=\"ltr\"><em>Twenty Twenty-Five</em></bdo>, qui offre une flexibilité de conception ultime pour tous les sites et blogs. Vous pourrez gérer la typographie de votre site comme jamais auparavant. Les nouvelles fonctionnalités de zoom arrière vous permettront de concevoir votre site avec une vue macroscopique pour prendre du recul sur les détails de votre projet.</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://fr.wordpress.org/latest-fr_FR.zip\" target=\"_blank\" rel=\"noreferrer noopener\">Télécharger WordPress 6.7 «&nbsp;Rollins&nbsp;» en français (ZIP – 19,1 Mo)</a></div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">Présentation du nouveau thème <bdo lang=\"en\" dir=\"ltr\">Twenty Twenty-Five</bdo></h2>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Une infinité de possibilités sans complexité</p>\n</blockquote>\n\n\n\n<p><bdo lang=\"en\" dir=\"ltr\">Twenty Twenty-Five</bdo> est un thème polyvalent, axé sur le design, qui vous permet de créer des sites époustouflants en toute simplicité. Personnalisez votre esthétisme grâce à un éventail d‘options de style, de compositions de blocs et de palettes de couleurs. Réduit à l‘essentiel, c‘est un thème qui peut vraiment évoluer avec vous.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-tt5-2.webp\" alt=\"\" style=\"object-fit:cover\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Obtenez une vue d’ensemble en dézoomant</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Explorez votre contenu sous un nouvel angle</p>\n</blockquote>\n\n\n\n<p>Modifiez et organisez des sections entières de votre contenu comme jamais auparavant. Une vue plus large de votre site vous permet d‘ajouter, de modifier, de mélanger ou de supprimer des compositions à votre guise. Laissez s‘exprimer l‘architecte qui est en vous.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-zoom-2.webp\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Connectez des blocs et des champs personnalisés sans souci (et sans coder)</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Une manière simplifiée de créer du contenu dynamique</p>\n</blockquote>\n\n\n\n<p>Cette fonctionnalité introduit une nouvelle interface pour connecter des blocs à des champs personnalisés. Cela vous donne le contrôle d’éléments dynamiques directement dans l’éditeur. Vous pouvez relier des blocs à des champs en quelques clics, ce qui améliore la flexibilité et l’efficacité de ces actions. Vos clients vont adorer ça.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-block-bindings-2.webp\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Laissez s’exprimer votre passion pour la typographie</h3>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>Nouvelle section de styles, nouvelles possibilités</p>\n</blockquote>\n\n\n\n<p>Créez, modifiez, retirez et appliquez des préréglages de taille de police avec le dernier apport à l’interface des Styles. Surchargez le thème par défaut ou créez votre propre taille de police personnalisée, avec une typographie dynamique pour un redimensionnement responsive des polices. Prenez soin des détails&nbsp;!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://s.w.org/images/core/6.7/feature-font-presets-2.png\" alt=\"\" /></figure>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations des performances</h3>\n\n\n\n<p>WordPress 6.7 propose d’importantes mises à jour en matière de performances, notamment un chargement plus rapide des compositions, des aperçus optimisés pour le composant des vues de données, une meilleure prise en charge de PHP 8 et plus, la suppression du code obsolète, des tailles automatiques pour les images en chargement différé, ainsi qu’un traitement plus efficace des balises dans l’API HTML.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Améliorations de l’accessibilité</h3>\n\n\n\n<p>Plus de 65 correctifs et améliorations d’accessibilité focalisées sur les aspects fondamentaux de l’expérience de WordPress, de l’amélioration des composants d’interface d’administration à la navigation clavier dans l’éditeur, en passant par des niveaux de titres plus accessibles dans les écrans de connexion et de meilleurs libellés.</p>\n\n\n\n<h2 class=\"wp-block-heading\">En savoir plus sur WordPress 6.7</h2>\n\n\n\n<p><a href=\"https://learn.wordpress.org/\"><em>Learn WordPress</em></a>&nbsp;est une ressource gratuite pour les personnes qui utilisent WordPress, qu’elles soient débutantes ou expérimentées.&nbsp;<em>Learn</em>&nbsp;contient des vidéos pratiques sur l’utilisation de diverses fonctionnalités de WordPress, des&nbsp;<a href=\"https://learn.wordpress.org/online-workshops/\">évènements interactifs</a>&nbsp;pour explorer des sujets en profondeur, et des plans de cours pour approfondir des domaines spécifiques de WordPress.</p>\n\n\n\n<p>Lisez les <a href=\"https://wordpress.org/support/wordpress-version/version-6-7/\">notes de version de WordPress 6.7</a> pour obtenir des informations sur l’installation, les améliorations, les problèmes corrigés, les contributeurs et contributrices de la version, les ressources d’apprentissage et la liste des modifications apportées aux fichiers.</p>\n\n\n\n<p>Explorez le <a href=\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\">guide des changements techniques de WordPress 6.7</a>. Découvrez les changements de cette version avec les notes détaillées des développeurs et développeuses qui vous permettent de construire votre site avec WordPress.</p>\n\n\n\n<h2 class=\"wp-block-heading\">L’équipe de direction de WordPress&nbsp;6.7</h2>\n\n\n\n<p>Voici l’équipe qui a coordonné le développement et la sortie de cette nouvelle version de WordPress&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Direction générale&nbsp;: <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a></li>\n\n\n\n<li>Coordination de la version&nbsp;: <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a></li>\n\n\n\n<li>Direction technique&nbsp;cœur&nbsp;: <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a></li>\n\n\n\n<li>Direction technique côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>,&nbsp;<a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a>,&nbsp;<a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a></li>\n\n\n\n<li>Gestion de projet côté cœur&nbsp;: <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a>, <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a></li>\n\n\n\n<li>Gestion de projet côté Gutenberg&nbsp;: <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a>,&nbsp;<a href=\"https://wordpress.org/support/users/colorful-tones/\">Damon Cook</a></li>\n\n\n\n<li>Direction de la documentation&nbsp;: <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a>,&nbsp;<a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a></li>\n\n\n\n<li>Direction des tests&nbsp;: <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K. Gupta</a></li>\n\n\n\n<li>Direction artistique&nbsp;: <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a></li>\n\n\n\n<li>Direction des performances&nbsp;: <a href=\"https://profiles.wordpress.org/adamsilverstein/\"></a><a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a></li>\n\n\n\n<li>Direction du design du nouveau thème&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li>\n\n\n\n<li>Direction du développement du nouveau thème&nbsp;:&nbsp;<a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a>,&nbsp;<a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a></li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux contributeurs et contributrices</h2>\n\n\n\n<p>WordPress 6.7 n’aurait pas pu sortir sans la contribution passionnée de plus de&nbsp;<strong>780 personnes provenant de tous les pays du monde</strong>.</p>\n\n\n\n<p>Un remerciement tout spécial pour les plus de 230 personnes qui ont contribué au cœur de WordPress pour la première fois avec WP&nbsp;6.7 <img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n\n\n\n<p class=\"is-style-wporg-props-long alignfull is-style-short-text has-lemon-3-background-color has-background\" style=\"font-size:12px\"><a href=\"https://profiles.wordpress.org/benniledl/\">!Benni</a> · <a href=\"https://profiles.wordpress.org/75thtrombone/\">75thtrombone</a> · <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a> · <a href=\"https://profiles.wordpress.org/aaronrobertshaw/\">Aaron Robertshaw</a> · <a href=\"https://profiles.wordpress.org/aware/\">Aaron Ware</a> · <a href=\"https://profiles.wordpress.org/aatanasov/\">aatanasov</a> · <a href=\"https://profiles.wordpress.org/webcommsat/\">Abha Thakor</a> · <a href=\"https://profiles.wordpress.org/abhi3315/\">abhi3315</a> · <a href=\"https://profiles.wordpress.org/fitehal/\">Abhishek Deshpande</a> · <a href=\"https://profiles.wordpress.org/ababir/\">Abir</a> · <a href=\"https://profiles.wordpress.org/acafourek/\">acafourek</a> · <a href=\"https://profiles.wordpress.org/adamkheckler/\">Adam Heckler</a> · <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a> · <a href=\"https://profiles.wordpress.org/adamwood/\">Adam Wood</a> · <a href=\"https://profiles.wordpress.org/zieladam/\">Adam Zieliński</a> · <a href=\"https://profiles.wordpress.org/adarshposimyth/\">Adarsh Akshat</a> · <a href=\"https://profiles.wordpress.org/adrian2k7/\">Adrian</a> · <a href=\"https://profiles.wordpress.org/aduth/\">aduth</a> · <a href=\"https://profiles.wordpress.org/ah72king/\">ah72king</a> · <a href=\"https://profiles.wordpress.org/ahmarzaidi/\">Ahmar Zaidi</a> · <a href=\"https://profiles.wordpress.org/chaion07/\">Ahmed Kabir Chaion</a> · <a href=\"https://profiles.wordpress.org/engahmeds3ed/\">Ahmed Saeed</a> · <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a> · <a href=\"https://profiles.wordpress.org/akashdhawade/\">Akash Dhawade</a> · <a href=\"https://profiles.wordpress.org/wildworks/\">Aki Hamano</a> · <a href=\"https://profiles.wordpress.org/atachibana/\">Akira Tachibana</a> · <a href=\"https://profiles.wordpress.org/akshat2802/\">Akshat Kakkad</a> · <a href=\"https://profiles.wordpress.org/alaminfirdows/\">Al-Amin Firdows</a> · <a href=\"https://profiles.wordpress.org/alanfuller/\">Alan Fuller</a> · <a href=\"https://profiles.wordpress.org/aljullu/\">Albert Juhé Lluveras</a> · <a href=\"https://profiles.wordpress.org/alessandrotesoro/\">Alessandro Tesoro</a> · <a href=\"https://profiles.wordpress.org/ralessio/\">Alessio</a> · <a href=\"https://profiles.wordpress.org/xknown/\">Alex Concha</a> · <a href=\"https://profiles.wordpress.org/ajlende/\">Alex Lende</a> · <a href=\"https://profiles.wordpress.org/alexstine/\">Alex Stine</a> · <a href=\"https://profiles.wordpress.org/alex27/\">alex27</a> · <a href=\"https://profiles.wordpress.org/digitalex11/\">Alexander Frank</a> · <a href=\"https://profiles.wordpress.org/alexandrebuffet/\">Alexandre Buffet</a> · <a href=\"https://profiles.wordpress.org/harlet7/\">Alexandru Horeanu</a> · <a href=\"https://profiles.wordpress.org/alexcu21/\">alexcu21</a> · <a href=\"https://profiles.wordpress.org/ali7ali/\">Ali Ali</a> · <a href=\"https://profiles.wordpress.org/aliaghdam/\">aliaghdam</a> · <a href=\"https://profiles.wordpress.org/firewatch/\">allilevine</a> · <a href=\"https://profiles.wordpress.org/mrfoxtalbot/\">Alvaro Gómez</a> · <a href=\"https://profiles.wordpress.org/alvitazwar052/\">Alvi Tazwar</a> · <a href=\"https://profiles.wordpress.org/amincharoliya/\">Amin Charoliya</a> · <a href=\"https://profiles.wordpress.org/amirthepiper/\">Amir Abbas</a> · <a href=\"https://profiles.wordpress.org/amitraj2203/\">Amit Raj</a> · <a href=\"https://profiles.wordpress.org/amjadr360/\">Amjad Ali</a> · <a href=\"https://profiles.wordpress.org/anthakkar08/\">Anand Thakkar</a> · <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a> · <a href=\"https://profiles.wordpress.org/awetz583/\">Andrea Roenning</a> · <a href=\"https://profiles.wordpress.org/andraganescu/\">Andrei Draganescu</a> · <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a> · <a href=\"https://profiles.wordpress.org/andreiglingeanu/\">andreiglingeanu</a> · <a href=\"https://profiles.wordpress.org/andrewhayward/\">Andrew Hayward</a> · <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a> · <a href=\"https://profiles.wordpress.org/andrewserong/\">Andrew Serong</a> · <a href=\"https://profiles.wordpress.org/rarst/\">Andrey “Rarst” Savchenko</a> · <a href=\"https://profiles.wordpress.org/oandregal/\">André Maneiro</a> · <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a> · <a href=\"https://profiles.wordpress.org/la-geek/\">Angelika Reisiger</a> · <a href=\"https://profiles.wordpress.org/aniketpatel/\">Aniket Patel</a> · <a href=\"https://profiles.wordpress.org/ankit-k-gupta/\">Ankit K Gupta</a> · <a href=\"https://profiles.wordpress.org/ankit k gupta/\">Ankit K. Gupta</a> · <a href=\"https://profiles.wordpress.org/ankitkumarshah/\">Ankit Kumar Shah</a> · <a href=\"https://profiles.wordpress.org/the-ank/\">Ankur Vishwakarma</a> · <a href=\"https://profiles.wordpress.org/annezazu/\">Anne McCarthy</a> · <a href=\"https://profiles.wordpress.org/antpb/\">Anthony Burchell</a> · <a href=\"https://profiles.wordpress.org/ahortin/\">Anthony Hortin</a> · <a href=\"https://profiles.wordpress.org/ant1busted/\">Antoine</a> · <a href=\"https://profiles.wordpress.org/antonvlasenko/\">Anton Vlasenko</a> · <a href=\"https://profiles.wordpress.org/antoniosejas/\">Antonio Sejas</a> · <a href=\"https://profiles.wordpress.org/apmeyer/\">apmeyer</a> · <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a> · <a href=\"https://profiles.wordpress.org/perezcarreno/\">Armando J. Perez Carreno</a> · <a href=\"https://profiles.wordpress.org/armandsdz/\">Armands</a> · <a href=\"https://profiles.wordpress.org/arnaudbroes/\">arnaudbroes</a> · <a href=\"https://profiles.wordpress.org/ambrosiawt/\">Art Smith</a> · <a href=\"https://profiles.wordpress.org/artemiosans/\">Artemio Morales</a> · <a href=\"https://profiles.wordpress.org/arthur791004/\">Arthur Chu</a> · <a href=\"https://profiles.wordpress.org/arypneta/\">arypneta</a> · <a href=\"https://profiles.wordpress.org/asafm7/\">asafm7</a> · <a href=\"https://profiles.wordpress.org/aslamdoctor/\">Aslam Doctor</a> · <a href=\"https://profiles.wordpress.org/nmutua/\">Autumn</a> · <a href=\"https://profiles.wordpress.org/ayeshrajans/\">Ayesh Karunaratne</a> · <a href=\"https://profiles.wordpress.org/bjerke-johannessen/\">Bård Bjerke Johannessen</a> · <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> · <a href=\"https://profiles.wordpress.org/balub/\">Balu B</a> · <a href=\"https://profiles.wordpress.org/barryceelen/\">Barry Ceelen</a> · <a href=\"https://profiles.wordpress.org/bartkalisz/\">Bart Kalisz</a> · <a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a> · <a href=\"https://profiles.wordpress.org/scruffian/\">Ben Dwyer</a> · <a href=\"https://profiles.wordpress.org/rainbowgeek/\">Benjamin Denis</a> · <a href=\"https://profiles.wordpress.org/benjamin_zekavica/\">Benjamin Zekavica</a> · <a href=\"https://profiles.wordpress.org/benoitchantre/\">Benoit Chantre</a> · <a href=\"https://profiles.wordpress.org/kau-boy/\">Bernhard Kau</a> · <a href=\"https://profiles.wordpress.org/bernhard reiter/\">Bernhard Reiter</a> · <a href=\"https://profiles.wordpress.org/neoxx/\">Bernhard Riedl</a> · <a href=\"https://profiles.wordpress.org/bernhard-reiter/\">bernhard-reiter</a> · <a href=\"https://profiles.wordpress.org/berubenic/\">berubenic</a> · <a href=\"https://profiles.wordpress.org/bhaveshdesai13/\">Bhavesh</a> · <a href=\"https://profiles.wordpress.org/bijit027/\">bijit027</a> · <a href=\"https://profiles.wordpress.org/bph/\">Birgit Pauli-Haack</a> · <a href=\"https://profiles.wordpress.org/blindmikey/\">blindmikey</a> · <a href=\"https://profiles.wordpress.org/bobbyleenoblestudios/\">bobbyleenoblestudios</a> · <a href=\"https://profiles.wordpress.org/bogdannikolic/\">Bogdan Nikolic</a> · <a href=\"https://profiles.wordpress.org/veryard/\">Brad</a> · <a href=\"https://profiles.wordpress.org/bradley2083/\">brad hogan</a> · <a href=\"https://profiles.wordpress.org/bjorsch/\">Brad Jorsch</a> · <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a> · <a href=\"https://profiles.wordpress.org/brentjettgmailcom/\">Brent Jett</a> · <a href=\"https://profiles.wordpress.org/brettshumaker/\">Brett Shumaker</a> · <a href=\"https://profiles.wordpress.org/ironprogrammer/\">Brian Alexander</a> · <a href=\"https://profiles.wordpress.org/bacoords/\">Brian Coords</a> · <a href=\"https://profiles.wordpress.org/bgardner/\">Brian Gardner</a> · <a href=\"https://profiles.wordpress.org/bgosnell/\">Brian Gosnell</a> · <a href=\"https://profiles.wordpress.org/brianhenryie/\">Brian Henry</a> · <a href=\"https://profiles.wordpress.org/bridgetwes/\">bridgetwes</a> · <a href=\"https://profiles.wordpress.org/brobken/\">brobken</a> · <a href=\"https://profiles.wordpress.org/freibergergarcia/\">Bruno Freiberger Garcia</a> · <a href=\"https://profiles.wordpress.org/cambabutonono/\">Cambabutonono</a> · <a href=\"https://profiles.wordpress.org/cbravobernal/\">Carlos Bravo</a> · <a href=\"https://profiles.wordpress.org/carlosgprim/\">Carlos G. P.</a> · <a href=\"https://profiles.wordpress.org/poena/\">Carolina Nymark</a> · <a href=\"https://profiles.wordpress.org/carstenbach/\">Carsten Bach</a> · <a href=\"https://profiles.wordpress.org/cbirdsong/\">cbirdsong</a> · <a href=\"https://profiles.wordpress.org/mchirag2002/\">Chirag Mathur</a> · <a href=\"https://profiles.wordpress.org/chrico/\">ChriCo</a> · <a href=\"https://profiles.wordpress.org/jazzs3quence/\">Chris Reynolds</a> · <a href=\"https://profiles.wordpress.org/eclare/\">Chris Trynkiewicz (Sukces Strony)</a> · <a href=\"https://profiles.wordpress.org/apermo/\">Christoph Daum</a> · <a href=\"https://profiles.wordpress.org/cfinke/\">Christopher Finke</a> · <a href=\"https://profiles.wordpress.org/ckanitz/\">Christopher Kanitz</a> · <a href=\"https://profiles.wordpress.org/nyiriland/\">Christy Nyiri</a> · <a href=\"https://profiles.wordpress.org/butterflymedia/\">Ciprian</a> · <a href=\"https://profiles.wordpress.org/codersantosh/\">codersantosh</a> · <a href=\"https://profiles.wordpress.org/costdev/\">Colin Stewart</a> · <a href=\"https://profiles.wordpress.org/coreyw/\">Corey Worrell</a> · <a href=\"https://profiles.wordpress.org/courane01/\">Courtney Robertson</a> · <a href=\"https://profiles.wordpress.org/craynor/\">craynor</a> · <a href=\"https://profiles.wordpress.org/creativethemeshq/\">creativethemeshq</a> · <a href=\"https://profiles.wordpress.org/cwhitmore/\">Cullen Whitmore</a> · <a href=\"https://profiles.wordpress.org/cu121/\">Cupid Chakma</a> · <a href=\"https://profiles.wordpress.org/cweiske/\">cweiske</a> · <a href=\"https://profiles.wordpress.org/coquardcyr/\">Cyrille</a> · <a href=\"https://profiles.wordpress.org/da5f656f/\">da5f656f</a> · <a href=\"https://profiles.wordpress.org/xendo/\">Dademaru</a> · <a href=\"https://profiles.wordpress.org/daleharrison/\">daleharrison</a> · <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/colorful tones/\">Damon Cook</a> · <a href=\"https://profiles.wordpress.org/daniguardiola/\">Dani Guardiola</a> · <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a> · <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a> · <a href=\"https://profiles.wordpress.org/itsdanny/\">Danny</a> · <a href=\"https://profiles.wordpress.org/dannyreaktiv/\">dannyreaktiv</a> · <a href=\"https://profiles.wordpress.org/darerodz/\">darerodz</a> · <a href=\"https://profiles.wordpress.org/d-signed/\">Dareth NHANG</a> · <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier (nerrad)</a> · <a href=\"https://profiles.wordpress.org/darshitrajyaguru97/\">Darshit Rajyaguru</a> · <a href=\"https://profiles.wordpress.org/daveagp/\">daveagp</a> · <a href=\"https://profiles.wordpress.org/fac3less/\">David</a> · <a href=\"https://profiles.wordpress.org/dballari/\">David Ballarin Prunera</a> · <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a> · <a href=\"https://profiles.wordpress.org/davidbinda/\">David Biňovec</a> · <a href=\"https://profiles.wordpress.org/davidabowman/\">David Bowman</a> · <a href=\"https://profiles.wordpress.org/davidhbrown/\">David Brown</a> · <a href=\"https://profiles.wordpress.org/dpcalhoun/\">David Calhoun</a> · <a href=\"https://profiles.wordpress.org/davidgodleman10up/\">David Godleman</a> · <a href=\"https://profiles.wordpress.org/dhenriet/\">David Henriet</a> · <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a> · <a href=\"https://profiles.wordpress.org/justlevine/\">David Levine</a> · <a href=\"https://profiles.wordpress.org/daviedr/\">David Rozando</a> · <a href=\"https://profiles.wordpress.org/dshanske/\">David Shanske</a> · <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a> · <a href=\"https://profiles.wordpress.org/ddewan/\">ddewan</a> · <a href=\"https://profiles.wordpress.org/dsas/\">Dean Sas</a> · <a href=\"https://profiles.wordpress.org/debarghyabanerjee/\">DEBARGHYA BANERJEE</a> · <a href=\"https://profiles.wordpress.org/deepakrohilla/\">Deepak Rohilla</a> · <a href=\"https://profiles.wordpress.org/deepakvijayan/\">Deepak Vijayan</a> · <a href=\"https://profiles.wordpress.org/dekadinious/\">Dekadinious</a> · <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a> · <a href=\"https://profiles.wordpress.org/dsmart/\">Derek Smart</a> · <a href=\"https://profiles.wordpress.org/deryck/\">Deryck</a> · <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a> · <a href=\"https://profiles.wordpress.org/devansh2002/\">Devansh Chaudhary</a> · <a href=\"https://profiles.wordpress.org/devspace/\">devspace</a> · <a href=\"https://profiles.wordpress.org/dhananjaykuber/\">Dhananjay Kuber</a> · <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a> · <a href=\"https://profiles.wordpress.org/dhrumilk/\">Dhrumil Kumbhani</a> · <a href=\"https://profiles.wordpress.org/dhruval04/\">Dhruval Shah</a> · <a href=\"https://profiles.wordpress.org/dhruvang21/\">Dhruvang21</a> · <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a> · <a href=\"https://profiles.wordpress.org/dilip2615/\">Dilip Modhavadiya</a> · <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a> · <a href=\"https://profiles.wordpress.org/divibanks/\">Divi Banks</a> · <a href=\"https://profiles.wordpress.org/djcowan/\">dj.cowan</a> · <a href=\"https://profiles.wordpress.org/djennez/\">djennez</a> · <a href=\"https://profiles.wordpress.org/cyberorca/\">Doni Kuntoro</a> · <a href=\"https://profiles.wordpress.org/dorzki/\">Dor Zuberi</a> · <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a> · <a href=\"https://profiles.wordpress.org/drivingralle/\">Drivingralle</a> · <a href=\"https://profiles.wordpress.org/drzraf/\">drzraf</a> · <a href=\"https://profiles.wordpress.org/elrae/\">Earle Davies</a> · <a href=\"https://profiles.wordpress.org/eballeste/\">eballeste</a> · <a href=\"https://profiles.wordpress.org/eclev91/\">eclev91</a> · <a href=\"https://profiles.wordpress.org/beckej/\">Ed Beck</a> · <a href=\"https://profiles.wordpress.org/ejnwebmaster/\">ejnwebmaster</a> · <a href=\"https://profiles.wordpress.org/elfu98/\">elfu98</a> · <a href=\"https://profiles.wordpress.org/eliorivero/\">Elio Rivero</a> · <a href=\"https://profiles.wordpress.org/ellatrix/\">Ella van&nbsp;Durpe</a> · <a href=\"https://profiles.wordpress.org/erichmond/\">Elliott Richmond</a> · <a href=\"https://profiles.wordpress.org/eatse/\">Emmanue ATSÉ</a> · <a href=\"https://profiles.wordpress.org/manooweb/\">Emmanuel Hesry</a> · <a href=\"https://profiles.wordpress.org/emmanuel78/\">emmanuel78</a> · <a href=\"https://profiles.wordpress.org/lopo/\">Enrico Battocchi</a> · <a href=\"https://profiles.wordpress.org/nrqsnchz/\">Enrique Sánchez</a> · <a href=\"https://profiles.wordpress.org/ericdye/\">Eric Dye</a> · <a href=\"https://profiles.wordpress.org/kebbet/\">Erik</a> · <a href=\"https://profiles.wordpress.org/erikiva/\">erikiva</a> · <a href=\"https://profiles.wordpress.org/erikyo/\">erikyo</a> · <a href=\"https://profiles.wordpress.org/eherman24/\">Evan Herman</a> · <a href=\"https://profiles.wordpress.org/circlecube/\">Evan Mullins</a> · <a href=\"https://profiles.wordpress.org/fabiankaegy/\">Fabian Kägy</a> · <a href=\"https://profiles.wordpress.org/fabiorubioglio/\">Fabio Rubioglio</a> · <a href=\"https://profiles.wordpress.org/fahimmurshed/\">FahimMurshed</a> · <a href=\"https://profiles.wordpress.org/faisalahammad/\">Faisal Ahammad</a> · <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a> · <a href=\"https://profiles.wordpress.org/fazyshah/\">Faizan Nabi</a> · <a href=\"https://profiles.wordpress.org/iamfarhan09/\">Farhan Ahmed</a> · <a href=\"https://profiles.wordpress.org/fayyazfayzi/\">Fayyaz</a> · <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a> · <a href=\"https://profiles.wordpress.org/ffffelix/\">Felix Renicks</a> · <a href=\"https://profiles.wordpress.org/fjorgemota/\">Fernando Jorge Mota (a11n)</a> · <a href=\"https://profiles.wordpress.org/firoz2456/\">Firoz Sabaliya</a> · <a href=\"https://profiles.wordpress.org/fcoveram/\">Francisco</a> · <a href=\"https://profiles.wordpress.org/franz00/\">Fransisca H</a> · <a href=\"https://profiles.wordpress.org/fullworks/\">fullworks</a> · <a href=\"https://profiles.wordpress.org/gwallace87/\">Gale Wallace</a> · <a href=\"https://profiles.wordpress.org/gansbrest/\">gansbrest</a> · <a href=\"https://profiles.wordpress.org/garethelwell/\">Gareth Elwell</a> · <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a> · <a href=\"https://profiles.wordpress.org/pento/\">Gary Pendergast</a> · <a href=\"https://profiles.wordpress.org/gauravtiwari/\">Gaurav Tiwari</a> · <a href=\"https://profiles.wordpress.org/gauravsingh7/\">gauravsingh7</a> · <a href=\"https://profiles.wordpress.org/georgwordpress/\">Georg</a> · <a href=\"https://profiles.wordpress.org/mamaduka/\">George Mamadashvili</a> · <a href=\"https://profiles.wordpress.org/geriux/\">Gerardo Pacheco</a> · <a href=\"https://profiles.wordpress.org/germanfrelo/\">Germán Freixinós</a> · <a href=\"https://profiles.wordpress.org/gmariani405/\">gmariani405</a> · <a href=\"https://profiles.wordpress.org/graemef/\">GraemeF</a> · <a href=\"https://profiles.wordpress.org/grantmkin/\">Grant M. Kinney</a> · <a href=\"https://profiles.wordpress.org/greentreefrog/\">greentreefrog</a> · <a href=\"https://profiles.wordpress.org/greenworld/\">GreenWorld</a> · <a href=\"https://profiles.wordpress.org/gziolo/\">Greg Ziółkowski</a> · <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a> · <a href=\"https://profiles.wordpress.org/gyurmey/\">Gyurmey</a> · <a href=\"https://profiles.wordpress.org/priethor/\">Héctor Prieto</a> · <a href=\"https://profiles.wordpress.org/halilesen/\">Halil ESEN</a> · <a href=\"https://profiles.wordpress.org/hanneslsm/\">hanneslsm</a> · <a href=\"https://profiles.wordpress.org/hage/\">Hans-Gerd Gerhards</a> · <a href=\"https://profiles.wordpress.org/hardipparmar/\">Hardip Parmar</a> · <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh S</a> · <a href=\"https://profiles.wordpress.org/plaidharper/\">Harper Holsinger</a> · <a href=\"https://profiles.wordpress.org/harshgajipara/\">Harsh Gajipara</a> · <a href=\"https://profiles.wordpress.org/harshvaishnav/\">harshvaishnav</a> · <a href=\"https://profiles.wordpress.org/hazdiego/\">Haz</a> · <a href=\"https://profiles.wordpress.org/hectorjarquin/\">hectorjarquin</a> · <a href=\"https://profiles.wordpress.org/hedgefield/\">hedgefield</a> · <a href=\"https://profiles.wordpress.org/helen/\">Helen Hou-Sandi</a> · <a href=\"https://profiles.wordpress.org/iamarinoh/\">Henrique Iamarino</a> · <a href=\"https://profiles.wordpress.org/abcd95/\">Himanshu Pathak</a> · <a href=\"https://profiles.wordpress.org/hirschferkel/\">hirschferkel</a> · <a href=\"https://profiles.wordpress.org/hbhalodia/\">Hit Bhalodia</a> · <a href=\"https://profiles.wordpress.org/h71/\">Hossein</a> · <a href=\"https://profiles.wordpress.org/htmgarcia/\">htmgarcia</a> · <a href=\"https://profiles.wordpress.org/huubl/\">huubl</a> · <a href=\"https://profiles.wordpress.org/huzaifaalmesbah/\">Huzaifa Al Mesbah</a> · <a href=\"https://profiles.wordpress.org/kardi420/\">Ibrahim</a> · <a href=\"https://profiles.wordpress.org/ibrahimriaz/\">Ibrahim Riaz</a> · <a href=\"https://profiles.wordpress.org/imranh920/\">Imran Hossain (a11n)</a> · <a href=\"https://profiles.wordpress.org/isabel_brison/\">Isabel Brison</a> · <a href=\"https://profiles.wordpress.org/itpathsolutions/\">IT Path Solutions</a> · <a href=\"https://profiles.wordpress.org/itapress/\">itapress</a> · <a href=\"https://profiles.wordpress.org/ivanottinger/\">Ivan Ottinger</a> · <a href=\"https://profiles.wordpress.org/jpstevens/\">Jack Stevens</a> · <a href=\"https://profiles.wordpress.org/jacobcassidy/\">Jacob Cassidy</a> · <a href=\"https://profiles.wordpress.org/smithjw1/\">Jacob Smith</a> · <a href=\"https://profiles.wordpress.org/jagirbahesh/\">jagirbahesh</a> · <a href=\"https://profiles.wordpress.org/jainil07/\">Jainil Shah</a> · <a href=\"https://profiles.wordpress.org/jtgreyd/\">Jakob Trost</a> · <a href=\"https://profiles.wordpress.org/jameskoster/\">James Koster</a> · <a href=\"https://profiles.wordpress.org/jamesosborne/\">James Osborne</a> · <a href=\"https://profiles.wordpress.org/jamesros161/\">James Rosado</a> · <a href=\"https://profiles.wordpress.org/jwgoedert/\">James Wesley Goedert</a> · <a href=\"https://profiles.wordpress.org/janpfeil/\">Jan Pfeil</a> · <a href=\"https://profiles.wordpress.org/janak007/\">janak Kaneriya</a> · <a href=\"https://profiles.wordpress.org/jsnajdr/\">Jarda Snajdr</a> · <a href=\"https://profiles.wordpress.org/jarekmorawski/\">jarekmorawski</a> · <a href=\"https://profiles.wordpress.org/ipajen/\">Jarko Piironen</a> · <a href=\"https://profiles.wordpress.org/jasonbahl/\">Jason Bahl</a> · <a href=\"https://profiles.wordpress.org/madtownlems/\">Jason LeMahieu (MadtownLems)</a> · <a href=\"https://profiles.wordpress.org/javad2000/\">javad2000</a> · <a href=\"https://profiles.wordpress.org/javiarce/\">Javier Arce</a> · <a href=\"https://profiles.wordpress.org/jawadwp/\">Jawad Malik</a> · <a href=\"https://profiles.wordpress.org/topdownjimmy/\">Jay</a> · <a href=\"https://profiles.wordpress.org/jayadevankbh/\">Jayadevan k</a> · <a href=\"https://profiles.wordpress.org/drjosh07/\">jbrya029</a> · <a href=\"https://profiles.wordpress.org/jdahir0789/\">JD Ahir</a> · <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a> · <a href=\"https://profiles.wordpress.org/krokodok/\">Jeff Chi</a> · <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a> · <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a> · <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeffrey Paul</a> · <a href=\"https://profiles.wordpress.org/jenilk/\">Jenil Kanani</a> · <a href=\"https://profiles.wordpress.org/jennifarhat/\">Jennifer Farhat</a> · <a href=\"https://profiles.wordpress.org/jdy68/\">Jenny Dupuy</a> · <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a> · <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a> · <a href=\"https://profiles.wordpress.org/jeryj/\">Jerry Jones</a> · <a href=\"https://profiles.wordpress.org/skobe/\">Jesko Bendmann</a> · <a href=\"https://profiles.wordpress.org/luminuu/\">Jessica Lyschik</a> · <a href=\"https://profiles.wordpress.org/jetaldobariya1/\">jetaldobariya1</a> · <a href=\"https://profiles.wordpress.org/jigar9998/\">Jigar Panchal</a> · <a href=\"https://profiles.wordpress.org/jimmyh61/\">jimmyh61</a> · <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a> · <a href=\"https://profiles.wordpress.org/joehoyle/\">Joe Hoyle</a> · <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a> · <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a> · <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a> · <a href=\"https://profiles.wordpress.org/johnillo/\">John Espiritu</a> · <a href=\"https://profiles.wordpress.org/johnny5/\">John Godley</a> · <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a> · <a href=\"https://profiles.wordpress.org/johnregan3/\">John Regan</a> · <a href=\"https://profiles.wordpress.org/lwangaman/\">JohnRDOrazio</a> · <a href=\"https://profiles.wordpress.org/jonsurrell/\">Jon Surrell</a> · <a href=\"https://profiles.wordpress.org/elbsegler/\">Jonas</a> · <a href=\"https://profiles.wordpress.org/psykro/\">Jonathan Bossenger</a> · <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a> · <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a> · <a href=\"https://profiles.wordpress.org/jonnywatersbb/\">Jonny Waters</a> · <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a> · <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a> · <a href=\"https://profiles.wordpress.org/josklever/\">Jos Klever</a> · <a href=\"https://profiles.wordpress.org/josevarghese/\">Jose Varghese</a> · <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a> · <a href=\"https://profiles.wordpress.org/verygoode/\">Joshua Goode</a> · <a href=\"https://profiles.wordpress.org/jossnaz/\">Jossnaz</a> · <a href=\"https://profiles.wordpress.org/juanfra/\">Juan Aldasoro</a> · <a href=\"https://profiles.wordpress.org/juanmaguitar/\">JuanMa Garrido</a> · <a href=\"https://profiles.wordpress.org/julianoe/\">julianoe</a> · <a href=\"https://profiles.wordpress.org/juliemoynat/\">Julie Moynat</a> · <a href=\"https://profiles.wordpress.org/jrf/\">Juliette Reinders Folmer</a> · <a href=\"https://profiles.wordpress.org/junedsabaliya/\">Juned Sabaliya</a> · <a href=\"https://profiles.wordpress.org/greenshady/\">Justin Tadlock</a> · <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a> · <a href=\"https://profiles.wordpress.org/kaavyaiyer/\">Kaavya Iyer (woo-hc)</a> · <a href=\"https://profiles.wordpress.org/arkenon/\">Kadim Gültekin</a> · <a href=\"https://profiles.wordpress.org/kafleg/\">KafleG</a> · <a href=\"https://profiles.wordpress.org/kevin940726/\">Kai Hao</a> · <a href=\"https://profiles.wordpress.org/kajalgohel/\">Kajal Gohel</a> · <a href=\"https://profiles.wordpress.org/ikamal/\">Kamal Hosen</a> · <a href=\"https://profiles.wordpress.org/kamran8176/\">Kamran Hussen</a> · <a href=\"https://profiles.wordpress.org/karan4word/\">Karan Gupta</a> · <a href=\"https://profiles.wordpress.org/karolmanijak/\">Karol Manijak</a> · <a href=\"https://profiles.wordpress.org/thekt12/\">Karthik Thayyil</a> · <a href=\"https://profiles.wordpress.org/kartikmehta/\">Kartik Mehta</a> · <a href=\"https://profiles.wordpress.org/kartik-suthar/\">Kartik Suthar</a> · <a href=\"https://profiles.wordpress.org/kbrownkd/\">kbrownkd (a11n)</a> · <a href=\"https://profiles.wordpress.org/keffr3n/\">Keffr3n</a> · <a href=\"https://profiles.wordpress.org/kel-dc/\">Kel Santiago-Pilarski</a> · <a href=\"https://profiles.wordpress.org/kellenmace/\">Kellen Mace</a> · <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/keoshi/\">keoshi</a> · <a href=\"https://profiles.wordpress.org/kevinb/\">Kevin Behrens</a> · <a href=\"https://profiles.wordpress.org/ktaron/\">Kevin Taron</a> · <a href=\"https://profiles.wordpress.org/kevinswalsh/\">kevinswalsh</a> · <a href=\"https://profiles.wordpress.org/khokansardar/\">Khokan Sardar</a> · <a href=\"https://profiles.wordpress.org/kirasong/\">Kira Schroder</a> · <a href=\"https://profiles.wordpress.org/kishanjasani/\">Kishan Jasani</a> · <a href=\"https://profiles.wordpress.org/kisquian/\">kisquian</a> · <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a> · <a href=\"https://profiles.wordpress.org/kkmuffme/\">kkmuffme</a> · <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a> · <a href=\"https://profiles.wordpress.org/kowsar89/\">Kowsar Hossain</a> · <a href=\"https://profiles.wordpress.org/kracked888/\">kracked888</a> · <a href=\"https://profiles.wordpress.org/krishneup/\">Krishna Neupane</a> · <a href=\"https://profiles.wordpress.org/kristastevens/\">kristastevens</a> · <a href=\"https://profiles.wordpress.org/krupajnanda/\">Krupa Nanda</a> · <a href=\"https://profiles.wordpress.org/krupalpanchal/\">Krupal Panchal</a> · <a href=\"https://profiles.wordpress.org/kmadhak/\">Kunal Madhak</a> · <a href=\"https://profiles.wordpress.org/gohelkunjan/\">Kunjan Gohel</a> · <a href=\"https://profiles.wordpress.org/kurtpayne/\">Kurt Payne</a> · <a href=\"https://profiles.wordpress.org/kushang78/\">Kushang Tailor</a> · <a href=\"https://profiles.wordpress.org/mlaetitia/\">Lae</a> · <a href=\"https://profiles.wordpress.org/notlaura/\">Lara Schenck</a> · <a href=\"https://profiles.wordpress.org/lastsplash/\">lastsplash (a11n)</a> · <a href=\"https://profiles.wordpress.org/newyorkerlaura/\">Laura Byrne</a> · <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a> · <a href=\"https://profiles.wordpress.org/oncecoupled/\">Lauren</a> · <a href=\"https://profiles.wordpress.org/laranz/\">Lawrence Joe</a> · <a href=\"https://profiles.wordpress.org/leemon/\">leemon</a> · <a href=\"https://profiles.wordpress.org/0mirka00/\">Lena Morita</a> · <a href=\"https://profiles.wordpress.org/lgladdy/\">Liam Gladdy</a> · <a href=\"https://profiles.wordpress.org/lifelightweb/\">lifelightweb</a> · <a href=\"https://profiles.wordpress.org/rudlinkon/\">Linkon Miyan</a> · <a href=\"https://profiles.wordpress.org/linsoftware/\">Linnea Huxford</a> · <a href=\"https://profiles.wordpress.org/liviopv/\">liviopv</a> · <a href=\"https://profiles.wordpress.org/louiswol94/\">Louis Wolmarans</a> · <a href=\"https://profiles.wordpress.org/louwie17/\">Lourens</a> · <a href=\"https://profiles.wordpress.org/lovesoni1999/\">Love Soni</a> · <a href=\"https://profiles.wordpress.org/crixu/\">Lucas</a> · <a href=\"https://profiles.wordpress.org/gigitux/\">Luigi Teschio</a> · <a href=\"https://profiles.wordpress.org/zaguiini/\">Luis Felipe Zaguini</a> · <a href=\"https://profiles.wordpress.org/luisherranz/\">luisherranz</a> · <a href=\"https://profiles.wordpress.org/lukasbesch/\">lukasbesch</a> · <a href=\"https://profiles.wordpress.org/lukecarbis/\">Luke Carbis</a> · <a href=\"https://profiles.wordpress.org/madhudollu/\">Madhu Dollu</a> · <a href=\"https://profiles.wordpress.org/madpeter/\">madpeter</a> · <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> · <a href=\"https://profiles.wordpress.org/nadimcse/\">Mahmudul Haque Nadim</a> · <a href=\"https://profiles.wordpress.org/mai21/\">Mai</a> · <a href=\"https://profiles.wordpress.org/mkrndmane/\">Makarand G. Mane</a> · <a href=\"https://profiles.wordpress.org/manbo/\">manbo</a> · <a href=\"https://profiles.wordpress.org/maneshtimilsina/\">Manesh Timilsina</a> · <a href=\"https://profiles.wordpress.org/targz-1/\">Manuel Schmalstieg</a> · <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani (a11n)</a> · <a href=\"https://profiles.wordpress.org/marianguas/\">María Anguas</a> · <a href=\"https://profiles.wordpress.org/mdxfr/\">Marc</a> · <a href=\"https://profiles.wordpress.org/marc4/\">Marc Armengou</a> · <a href=\"https://profiles.wordpress.org/mardroid/\">Marcel Tannich</a> · <a href=\"https://profiles.wordpress.org/fullofcaffeine/\">Marcelo de Moraes Serpa</a> · <a href=\"https://profiles.wordpress.org/iworks/\">Marcin Pietrzak</a> · <a href=\"https://profiles.wordpress.org/mciampini/\">Marco Ciampini</a> · <a href=\"https://profiles.wordpress.org/pereirinha/\">Marco Pereirinha</a> · <a href=\"https://profiles.wordpress.org/marcwieland95/\">marcwieland95</a> · <a href=\"https://profiles.wordpress.org/igreenie/\">Marek Železný</a> · <a href=\"https://profiles.wordpress.org/margolisj/\">margolisj</a> · <a href=\"https://profiles.wordpress.org/mariayohana/\">Maria Yohana</a> · <a href=\"https://profiles.wordpress.org/plari/\">Marie</a> · <a href=\"https://profiles.wordpress.org/tyxla/\">Marin Atanasov</a> · <a href=\"https://profiles.wordpress.org/santosguillamot/\">Mario Santos</a> · <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a> · <a href=\"https://profiles.wordpress.org/marius84/\">mariushosting</a> · <a href=\"https://profiles.wordpress.org/markhowellsmead/\">Mark Howells-Mead</a> · <a href=\"https://profiles.wordpress.org/markparnell/\">Mark Parnell</a> · <a href=\"https://profiles.wordpress.org/mark-k/\">Mark-k</a> · <a href=\"https://profiles.wordpress.org/mhkuu/\">Martijn van der Klis</a> · <a href=\"https://profiles.wordpress.org/martinkrcho/\">martin.krcho</a> · <a href=\"https://profiles.wordpress.org/marybaum/\">marybaum</a> · <a href=\"https://profiles.wordpress.org/mat_/\">mat_</a> · <a href=\"https://profiles.wordpress.org/mmaattiiaass/\">Matias Benedetto</a> · <a href=\"https://profiles.wordpress.org/matveb/\">Matias Ventura</a> · <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a> · <a href=\"https://profiles.wordpress.org/mattyrob/\">Matt Robinson</a> · <a href=\"https://profiles.wordpress.org/mattormeeple/\">Matt Sherman</a> · <a href=\"https://profiles.wordpress.org/matteoenna/\">Matteo Enna</a> · <a href=\"https://profiles.wordpress.org/mboynes/\">Matthew Boynes</a> · <a href=\"https://profiles.wordpress.org/lonelyvegan/\">Matthew Riley MacPherson</a> · <a href=\"https://profiles.wordpress.org/kittmedia/\">Matthias Kittsteiner</a> · <a href=\"https://profiles.wordpress.org/mattraines/\">mattraines</a> · <a href=\"https://profiles.wordpress.org/maurodf/\">maurodf</a> · <a href=\"https://profiles.wordpress.org/mayanktripathi32/\">Mayank Tripathi</a> · <a href=\"https://profiles.wordpress.org/mayur8991/\">Mayur Prajapati</a> · <a href=\"https://profiles.wordpress.org/mcrisp1972/\">mcrisp1972</a> · <a href=\"https://profiles.wordpress.org/hmbashar/\">Md Abul Bashar</a> · <a href=\"https://profiles.wordpress.org/mhshohel/\">Md Hossain Shohel</a> · <a href=\"https://profiles.wordpress.org/istiaqhossain/\">Md. Istiaq Hossain</a> · <a href=\"https://profiles.wordpress.org/mdviralsampat/\">mdviralsampat</a> · <a href=\"https://profiles.wordpress.org/megane9988/\">megane9988</a> · <a href=\"https://profiles.wordpress.org/iammehedi1/\">Mehedi Hassan</a> · <a href=\"https://profiles.wordpress.org/mehulkaklotar/\">Mehul Kaklotar</a> · <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce-Dwan</a> · <a href=\"https://profiles.wordpress.org/meteorlxy/\">meteorlxy</a> · <a href=\"https://profiles.wordpress.org/mfgmicha/\">Micha Krapp</a> · <a href=\"https://profiles.wordpress.org/tw2113/\">Michael Beckwith</a> · <a href=\"https://profiles.wordpress.org/michaelbourne/\">Michael Bourne</a> · <a href=\"https://profiles.wordpress.org/hrkhal/\">Michael James Ilett</a> · <a href=\"https://profiles.wordpress.org/michaelpick/\">michaelpick</a> · <a href=\"https://profiles.wordpress.org/michaelwp85/\">michaelwp85</a> · <a href=\"https://profiles.wordpress.org/czapla/\">Michal Czaplinski</a> · <a href=\"https://profiles.wordpress.org/mielbu/\">Michelle Bulloch</a> · <a href=\"https://profiles.wordpress.org/miguelaxcar/\">Miguel Axcar</a> · <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a> · <a href=\"https://profiles.wordpress.org/migueluy/\">Miguel Lezama</a> · <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a> · <a href=\"https://profiles.wordpress.org/mmcalister/\">Mike McAlister</a> · <a href=\"https://profiles.wordpress.org/ritterml/\">Mike Ritter</a> · <a href=\"https://profiles.wordpress.org/mikeb8s/\">mikeb8s</a> · <a href=\"https://profiles.wordpress.org/mikeybinns/\">Mikey Binns</a> · <a href=\"https://profiles.wordpress.org/milamj/\">milamj</a> · <a href=\"https://profiles.wordpress.org/milana_cap/\">Milana Cap</a> · <a href=\"https://profiles.wordpress.org/presstoke/\">Mitchell Austin</a> · <a href=\"https://profiles.wordpress.org/mklusak/\">mklusak</a> · <a href=\"https://profiles.wordpress.org/mleathem/\">mleathem</a> · <a href=\"https://profiles.wordpress.org/mlf20/\">mlf20</a> · <a href=\"https://profiles.wordpress.org/mobarak/\">Mobarak Ali</a> · <a href=\"https://profiles.wordpress.org/mohitdadhich10/\">Mohit Dadhich</a> · <a href=\"https://profiles.wordpress.org/morganestes/\">Morgan Estes</a> · <a href=\"https://profiles.wordpress.org/mosne/\">Mosne / Paolo Tesei</a> · <a href=\"https://profiles.wordpress.org/mossy2100/\">mossy2100</a> · <a href=\"https://profiles.wordpress.org/mreishus/\">mreishus</a> · <a href=\"https://profiles.wordpress.org/devmuhib/\">Muhibul Haque</a> · <a href=\"https://profiles.wordpress.org/mujuonly/\">mujuonly</a> · <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a> · <a href=\"https://profiles.wordpress.org/faguni22/\">Mumtahina Faguni</a> · <a href=\"https://profiles.wordpress.org/assassinateur/\">Nadir Seghir a11n</a> · <a href=\"https://profiles.wordpress.org/naeemhaque/\">Naeem Haque</a> · <a href=\"https://profiles.wordpress.org/nagpai/\">Nagesh Pai</a> · <a href=\"https://profiles.wordpress.org/narenin/\">Narendra Sishodiya</a> · <a href=\"https://profiles.wordpress.org/nareshbheda/\">Naresh Bheda</a> · <a href=\"https://profiles.wordpress.org/n8finch/\">Nate Finch</a> · <a href=\"https://profiles.wordpress.org/nateinaction/\">Nate Gay</a> · <a href=\"https://profiles.wordpress.org/nhrrob/\">Nazmul Hasan Robin</a> · <a href=\"https://profiles.wordpress.org/nebojsajurcic/\">Nebojša Jurčić</a> · <a href=\"https://profiles.wordpress.org/nek285/\">nek285</a> · <a href=\"https://profiles.wordpress.org/nendeb55/\">nendeb</a> · <a href=\"https://profiles.wordpress.org/neo2k23/\">neo2k23</a> · <a href=\"https://profiles.wordpress.org/neotrope/\">neotrope</a> · <a href=\"https://profiles.wordpress.org/eidolonnight/\">Nicholas Garofalo</a> · <a href=\"https://profiles.wordpress.org/nickbohle/\">Nick Bohle</a> · <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a> · <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a> · <a href=\"https://profiles.wordpress.org/nick_thegeek/\">Nick the Geek</a> · <a href=\"https://profiles.wordpress.org/nicolefurlan/\">Nicole Furlan</a> · <a href=\"https://profiles.wordpress.org/nidhidhandhukiya/\">nidhidhandhukiya</a> · <a href=\"https://profiles.wordpress.org/nihar007/\">Nihar Ranjan Das</a> · <a href=\"https://profiles.wordpress.org/ntsekouras/\">Nik Tsekouras</a> · <a href=\"https://profiles.wordpress.org/nikitasolanki1812/\">Nikita Solanki</a> · <a href=\"https://profiles.wordpress.org/nirajgirixd/\">Niraj Giri</a> · <a href=\"https://profiles.wordpress.org/niravsherasiya7707/\">Nirav Sherasiya</a> · <a href=\"https://profiles.wordpress.org/nithi22/\">Nithin John</a> · <a href=\"https://profiles.wordpress.org/nithins53/\">Nithin SreeRaj</a> · <a href=\"https://profiles.wordpress.org/noahtallen/\">Noah Allen</a> · <a href=\"https://profiles.wordpress.org/noruzzaman/\">Noruzzaman</a> · <a href=\"https://profiles.wordpress.org/nurielmeni/\">nurielmeni</a> · <a href=\"https://profiles.wordpress.org/obliviousharmony/\">obliviousharmony</a> · <a href=\"https://profiles.wordpress.org/finalwebsites/\">Olaf Lederer</a> · <a href=\"https://profiles.wordpress.org/oglekler/\">Olga Gleckler</a> · <a href=\"https://profiles.wordpress.org/domainsupport/\">Oliver Campion</a> · <a href=\"https://profiles.wordpress.org/olivierlafleur/\">Olivier Lafleur</a> · <a href=\"https://profiles.wordpress.org/alshakero/\">Omar Alshaker</a> · <a href=\"https://profiles.wordpress.org/oscarhugopaz/\">Oscar Hugo Paz</a> · <a href=\"https://profiles.wordpress.org/prestonwordsworth/\">p15h</a> · <a href=\"https://profiles.wordpress.org/paaljoachim/\">Paal Joachim Romdahl</a> · <a href=\"https://profiles.wordpress.org/otakupahp/\">Pablo Hernández</a> · <a href=\"https://profiles.wordpress.org/pablohoneyhoney/\">Pablo Honey</a> · <a href=\"https://profiles.wordpress.org/pamprn/\">Pamela Ribeiro</a> · <a href=\"https://profiles.wordpress.org/pander/\">pander</a> · <a href=\"https://profiles.wordpress.org/pls78/\">Paolo L. Scala</a> · <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Paragon Initiative Enterprises</a> · <a href=\"https://profiles.wordpress.org/parinpanjari/\">Parin Panjari</a> · <a href=\"https://profiles.wordpress.org/parthvataliya/\">Parth vataliya</a> · <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a> · <a href=\"https://profiles.wordpress.org/obrienlabs/\">Pat O’Brien</a> · <a href=\"https://profiles.wordpress.org/patricia70/\">Patricia BT</a> · <a href=\"https://profiles.wordpress.org/lumiblog/\">Patrick Lumumba</a> · <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a> · <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a> · <a href=\"https://profiles.wordpress.org/paulkevan/\">Paul Kevan</a> · <a href=\"https://profiles.wordpress.org/paulschreiber/\">Paul Schreiber</a> · <a href=\"https://profiles.wordpress.org/paulwilde/\">Paul Wilde</a> · <a href=\"https://profiles.wordpress.org/paulcline/\">paulcline</a> · <a href=\"https://profiles.wordpress.org/paulopmt1/\">Paulo Trentin</a> · <a href=\"https://profiles.wordpress.org/pavanpatil1/\">Pavan Patil</a> · <a href=\"https://profiles.wordpress.org/pcarvalho/\">pcarvalho</a> · <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a> · <a href=\"https://profiles.wordpress.org/perryrylance/\">perryrylance</a> · <a href=\"https://profiles.wordpress.org/provenself/\">Peter Rubin</a> · <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a> · <a href=\"https://profiles.wordpress.org/petitphp/\">petitphp</a> · <a href=\"https://profiles.wordpress.org/pevogam/\">pevogam</a> · <a href=\"https://profiles.wordpress.org/mr2p/\">Phi Phan</a> · <a href=\"https://profiles.wordpress.org/johnstonphilip/\">Phil Johnston</a> · <a href=\"https://profiles.wordpress.org/tyrannous/\">Philipp Bammes</a> · <a href=\"https://profiles.wordpress.org/philwebs/\">philwebs</a> · <a href=\"https://profiles.wordpress.org/nekojonez/\">Pieterjan Deneys</a> · <a href=\"https://profiles.wordpress.org/boniu91/\">Piotrek Boniu</a> · <a href=\"https://profiles.wordpress.org/pitamdey/\">Pitam Dey</a> · <a href=\"https://profiles.wordpress.org/pgeorgiev/\">Plamen Georgiev</a> · <a href=\"https://profiles.wordpress.org/pooja1210/\">Pooja N Muchandikar</a> · <a href=\"https://profiles.wordpress.org/pooja9712/\">pooja9712</a> · <a href=\"https://profiles.wordpress.org/porg/\">porg</a> · <a href=\"https://profiles.wordpress.org/ppolo99/\">ppolo99</a> · <a href=\"https://profiles.wordpress.org/praful2111/\">Praful Patel</a> · <a href=\"https://profiles.wordpress.org/pranitdugad/\">Pranit Dugad</a> · <a href=\"https://profiles.wordpress.org/pratikkry/\">Pratik Kumar</a> · <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a> · <a href=\"https://profiles.wordpress.org/prettyboymp/\">prettyboymp</a> · <a href=\"https://profiles.wordpress.org/prionkor/\">prionkor</a> · <a href=\"https://profiles.wordpress.org/pwtyler/\">pwtyler</a> · <a href=\"https://profiles.wordpress.org/rachelbaker/\">Rachel Baker</a> · <a href=\"https://profiles.wordpress.org/spanglishwebs/\">Rachel Winspear</a> · <a href=\"https://profiles.wordpress.org/rfischmann/\">Rafael Fischmann</a> · <a href=\"https://profiles.wordpress.org/rafaelgalani/\">Rafael Gallani</a> · <a href=\"https://profiles.wordpress.org/rafiq91/\">Rafiqul Islam</a> · <a href=\"https://profiles.wordpress.org/rahmatgumilar/\">Rahmat Gumilar</a> · <a href=\"https://profiles.wordpress.org/rahulharpal/\">rahulharpal</a> · <a href=\"https://profiles.wordpress.org/imrraaj/\">Raj Patel</a> · <a href=\"https://profiles.wordpress.org/rajinsharwar/\">Rajin Sharwar</a> · <a href=\"https://profiles.wordpress.org/shashwatahalder01/\">rajkumar shashwata halder</a> · <a href=\"https://profiles.wordpress.org/rahmohn/\">Ramon Ahnert</a> · <a href=\"https://profiles.wordpress.org/rcorrales/\">Ramon Corrales</a> · <a href=\"https://profiles.wordpress.org/ramon-fincken/\">ramon fincken</a> · <a href=\"https://profiles.wordpress.org/ramonopoly/\">Ramon James</a> · <a href=\"https://profiles.wordpress.org/ramswarup/\">Ramswarup Rathod</a> · <a href=\"https://profiles.wordpress.org/xyulex/\">Raul Martinez</a> · <a href=\"https://profiles.wordpress.org/rcneil/\">rcneil</a> · <a href=\"https://profiles.wordpress.org/realthemes/\">realthemes</a> · <a href=\"https://profiles.wordpress.org/rejaulalomkhan/\">Rejaul Alom Khan</a> · <a href=\"https://profiles.wordpress.org/renathoc/\">Renatho (a11n)</a> · <a href=\"https://profiles.wordpress.org/reputeinfosystems/\">reputeinfosystems</a> · <a href=\"https://profiles.wordpress.org/retrofox/\">retrofox</a> · <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a> · <a href=\"https://profiles.wordpress.org/richtabor/\">Rich Tabor</a> · <a href=\"https://profiles.wordpress.org/rhellewellgmailcom/\">Rick Hellewell</a> · <a href=\"https://profiles.wordpress.org/riddhipatel/\">Riddhi Patel</a> · <a href=\"https://profiles.wordpress.org/rcreators/\">Rishi Mehta</a> · <a href=\"https://profiles.wordpress.org/rishishah/\">Rishi Shah</a> · <a href=\"https://profiles.wordpress.org/rishit30g/\">Rishit Gupta</a> · <a href=\"https://profiles.wordpress.org/rithik56/\">rithik56</a> · <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a> · <a href=\"https://profiles.wordpress.org/robert-biswas/\">Robert Biswas</a> · <a href=\"https://profiles.wordpress.org/robertghetau/\">Robert Ghetau</a> · <a href=\"https://profiles.wordpress.org/rocketworks/\">rocket.works – Dominik Friedrich</a> · <a href=\"https://profiles.wordpress.org/rodelgc/\">Rodel Calasagsag a11n</a> · <a href=\"https://profiles.wordpress.org/rghedin/\">Rodrigo</a> · <a href=\"https://profiles.wordpress.org/rodrigosprimo/\">Rodrigo Primo</a> · <a href=\"https://profiles.wordpress.org/geekofshire/\">Rohan Jha</a> · <a href=\"https://profiles.wordpress.org/rohitmathur7/\">rohitmathur7</a> · <a href=\"https://profiles.wordpress.org/costasovo/\">Rostislav Wolný</a> · <a href=\"https://profiles.wordpress.org/roytanck/\">Roy Tanck</a> · <a href=\"https://profiles.wordpress.org/roygbyte/\">roygbyte</a> · <a href=\"https://profiles.wordpress.org/royho/\">royho</a> · <a href=\"https://profiles.wordpress.org/rpf5573/\">rpf5573</a> · <a href=\"https://profiles.wordpress.org/rslee/\">rslee</a> · <a href=\"https://profiles.wordpress.org/ruchirj/\">Ruchir Goswami</a> · <a href=\"https://profiles.wordpress.org/rayhatron/\">Rufaro Madamombe</a> · <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a> · <a href=\"https://profiles.wordpress.org/rleeson/\">Ryan Leeson</a> · <a href=\"https://profiles.wordpress.org/ryancurban/\">Ryan Urban</a> · <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a> · <a href=\"https://profiles.wordpress.org/sppramodh/\">S P Pramodh</a> · <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a> · <a href=\"https://profiles.wordpress.org/sergiomdgomes/\">Sérgio Gomes</a> · <a href=\"https://profiles.wordpress.org/soean/\">Sören Wünsch</a> · <a href=\"https://profiles.wordpress.org/sadmansh/\">sadmansh</a> · <a href=\"https://profiles.wordpress.org/isaeedam/\">Saeed Piri</a> · <a href=\"https://profiles.wordpress.org/mi5t4n/\">Sagar Tamang</a> · <a href=\"https://profiles.wordpress.org/sahiladit/\">sahiladit</a> · <a href=\"https://profiles.wordpress.org/sainathpoojary/\">Sainath Poojary</a> · <a href=\"https://profiles.wordpress.org/sakibmd/\">Sakib Mohammed</a> · <a href=\"https://profiles.wordpress.org/samtoohey93/\">Sam Toohey</a> · <a href=\"https://profiles.wordpress.org/samiamnot/\">samiamnot</a> · <a href=\"https://profiles.wordpress.org/viralsampat/\">Sampat Viral</a> · <a href=\"https://profiles.wordpress.org/samuelsidler/\">Samuel Sidler</a> · <a href=\"https://profiles.wordpress.org/samuelsilvapt/\">Samuel Silva</a> · <a href=\"https://profiles.wordpress.org/sannevndrmeulen/\">Sanne van der Meulen</a> · <a href=\"https://profiles.wordpress.org/mikachan/\">Sarah Norris</a> · <a href=\"https://profiles.wordpress.org/sarahricker/\">sarahricker</a> · <a href=\"https://profiles.wordpress.org/sarthaknagoshe2002/\">Sarthak Nagoshe</a> · <a href=\"https://profiles.wordpress.org/sathyapulse/\">Sathiya Venkatesan</a> · <a href=\"https://profiles.wordpress.org/satishprajapati/\">Satish Prajapati</a> · <a href=\"https://profiles.wordpress.org/sfougnier/\">Saul Fougnier</a> · <a href=\"https://profiles.wordpress.org/sauliusv/\">Saulius Vikerta</a> · <a href=\"https://profiles.wordpress.org/saxonafletcher/\">Saxon Fletcher</a> · <a href=\"https://profiles.wordpress.org/sayedulsayem/\">Sayedul Sayem</a> · <a href=\"https://profiles.wordpress.org/scholdstrom/\">scholdstrom</a> · <a href=\"https://profiles.wordpress.org/swb1192/\">Scott Buscemi</a> · <a href=\"https://profiles.wordpress.org/sc0ttkclark/\">Scott Kingsley Clark</a> · <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a> · <a href=\"https://profiles.wordpress.org/wonderboymusic/\">Scott Taylor</a> · <a href=\"https://profiles.wordpress.org/scottculverhouse/\">scottculverhouse</a> · <a href=\"https://profiles.wordpress.org/seanavers/\">seanavers</a> · <a href=\"https://profiles.wordpress.org/seifradwane/\">Seif Radwane</a> · <a href=\"https://profiles.wordpress.org/kuuuzya/\">Sergey</a> · <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a> · <a href=\"https://profiles.wordpress.org/zahardoc/\">Serhiy Zakharchenko</a> · <a href=\"https://profiles.wordpress.org/smrubenstein/\">Seth Rubenstein</a> · <a href=\"https://profiles.wordpress.org/shailu25/\">Shail Mehta</a> · <a href=\"https://profiles.wordpress.org/sh4lin/\">Shalin Shah</a> · <a href=\"https://profiles.wordpress.org/sharonaustin/\">Sharon Austin</a> · <a href=\"https://profiles.wordpress.org/sheulyshila/\">sheulyshila</a> · <a href=\"https://profiles.wordpress.org/spdft/\">Shoe</a> · <a href=\"https://profiles.wordpress.org/showravhasan/\">Showrav Hasan</a> · <a href=\"https://profiles.wordpress.org/shreya0204/\">Shreya Agarwal</a> · <a href=\"https://profiles.wordpress.org/silaskoehler/\">Silas Köhler</a> · <a href=\"https://profiles.wordpress.org/siliconforks/\">siliconforks</a> · <a href=\"https://profiles.wordpress.org/simo_m/\">Simone Maranzana</a> · <a href=\"https://profiles.wordpress.org/siobhyb/\">Siobhan</a> · <a href=\"https://profiles.wordpress.org/smerriman/\">smerriman</a> · <a href=\"https://profiles.wordpress.org/snehapatil02/\">Sneha Patil</a> · <a href=\"https://profiles.wordpress.org/sophiegy/\">Sophie – a11n</a> · <a href=\"https://profiles.wordpress.org/souptik/\">Souptik Datta</a> · <a href=\"https://profiles.wordpress.org/sourabhjain/\">Sourabh Jain</a> · <a href=\"https://profiles.wordpress.org/sourav08/\">Sourav Pahwa</a> · <a href=\"https://profiles.wordpress.org/staurand/\">staurand</a> · <a href=\"https://profiles.wordpress.org/ryokuhi/\">Stefano Minoia</a> · <a href=\"https://profiles.wordpress.org/stein2nd/\">stein2nd</a> · <a href=\"https://profiles.wordpress.org/sabernhardt/\">Stephen Bernhardt</a> · <a href=\"https://profiles.wordpress.org/stevenlinx/\">Steven Lin</a> · <a href=\"https://profiles.wordpress.org/thompsonsj/\">Steven Thompson</a> · <a href=\"https://profiles.wordpress.org/stoyangeorgiev/\">Stoyan Georgiev</a> · <a href=\"https://profiles.wordpress.org/styleshit/\">styleshit</a> · <a href=\"https://profiles.wordpress.org/sudipatel007/\">Sudip Dadhaniya</a> · <a href=\"https://profiles.wordpress.org/sumitbagthariya16/\">Sumit Bagthariya</a> · <a href=\"https://profiles.wordpress.org/sumitsingh/\">Sumit Singh</a> · <a href=\"https://profiles.wordpress.org/sunil25393/\">Sunil Prajapati</a> · <a href=\"https://profiles.wordpress.org/quadthemes/\">Sunny</a> · <a href=\"https://profiles.wordpress.org/superchlorine/\">superchlorine</a> · <a href=\"https://profiles.wordpress.org/cybr/\">Sybre Waaijer</a> · <a href=\"https://profiles.wordpress.org/jannathsyeda/\">Syeda Fahima Jannath</a> · <a href=\"https://profiles.wordpress.org/takahashi_fumiki/\">Takahashi Fumiki</a> · <a href=\"https://profiles.wordpress.org/iamtakashi/\">Takashi Irie</a> · <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a> · <a href=\"https://profiles.wordpress.org/devtanbir/\">Tanbir Ahmod</a> · <a href=\"https://profiles.wordpress.org/tanvirul/\">Tanvirul Haque</a> · <a href=\"https://profiles.wordpress.org/voboghure/\">Tapan Kumer Das</a> · <a href=\"https://profiles.wordpress.org/taylorgorman/\">Taylor Gorman</a> · <a href=\"https://profiles.wordpress.org/tdrayson/\">tdrayson</a> · <a href=\"https://profiles.wordpress.org/iamjaydip/\">thejaydip</a> · <a href=\"https://profiles.wordpress.org/thelmachido/\">thelmachido a11n</a> · <a href=\"https://profiles.wordpress.org/themes-1/\">them.es</a> · <a href=\"https://profiles.wordpress.org/kraftner/\">Thomas Kräftner</a> · <a href=\"https://profiles.wordpress.org/thrijith/\">Thrijith Thankachan</a> · <a href=\"https://profiles.wordpress.org/sippis/\">Timi Wahalahti</a> · <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a> · <a href=\"https://profiles.wordpress.org/tirth03/\">Tirth Doshi</a> · <a href=\"https://profiles.wordpress.org/tmanoilov/\">tmanoilov</a> · <a href=\"https://profiles.wordpress.org/toastercookie/\">toastercookie</a> · <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a> · <a href=\"https://profiles.wordpress.org/tobifjellner/\">tobifjellner (Tor-Bjorn “Tobi” Fjellner)</a> · <a href=\"https://profiles.wordpress.org/tomjcafferkey/\">Tom Cafferkey</a> · <a href=\"https://profiles.wordpress.org/thomasdevisser/\">Tom de Visser</a> · <a href=\"https://profiles.wordpress.org/tjnowell/\">Tom J Nowell</a> · <a href=\"https://profiles.wordpress.org/tomhine/\">tomhine</a> · <a href=\"https://profiles.wordpress.org/tomllobet/\">tomllobet</a> · <a href=\"https://profiles.wordpress.org/hellofromtonya/\">Tonya Mork</a> · <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a> · <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a> · <a href=\"https://profiles.wordpress.org/tropicalista/\">tropicalista</a> · <a href=\"https://profiles.wordpress.org/areziaal/\">Troy Chaplin</a> · <a href=\"https://profiles.wordpress.org/truptikanzariya/\">Trupti Kanzariya</a> · <a href=\"https://profiles.wordpress.org/tunetheweb/\">tunetheweb</a> · <a href=\"https://profiles.wordpress.org/twstokes/\">twstokes</a> · <a href=\"https://profiles.wordpress.org/ugyensupport/\">Ugyen Dorji</a> · <a href=\"https://profiles.wordpress.org/umesh84/\">Umesh Gupta</a> · <a href=\"https://profiles.wordpress.org/umeshsinghin/\">Umesh Singh</a> · <a href=\"https://profiles.wordpress.org/up1512001/\">up1512001</a> · <a href=\"https://profiles.wordpress.org/ukdrahul/\">Uttam Kumar Dash</a> · <a href=\"https://profiles.wordpress.org/valer1e/\">valer1e</a> · <a href=\"https://profiles.wordpress.org/vertisoft/\">vertisoft</a> · <a href=\"https://profiles.wordpress.org/vcanales/\">Vicente Canales</a> · <a href=\"https://profiles.wordpress.org/vijaysinh9094/\">Vijaysinh Zala</a> · <a href=\"https://profiles.wordpress.org/szepeviktor/\">Viktor Szépe</a> · <a href=\"https://profiles.wordpress.org/vineet2003/\">Vinit</a> · <a href=\"https://profiles.wordpress.org/ghorivipul97/\">Vipul Ghori</a> · <a href=\"https://profiles.wordpress.org/vipulgupta003/\">Vipul Gupta</a> · <a href=\"https://profiles.wordpress.org/vipulpatil/\">vipulpatil</a> · <a href=\"https://profiles.wordpress.org/vrajadas/\">Vraja Das</a> · <a href=\"https://profiles.wordpress.org/vrishabhsk/\">vrishabhsk</a> · <a href=\"https://profiles.wordpress.org/wbdv/\">wbdv</a> · <a href=\"https://profiles.wordpress.org/webmandesign/\">WebMan Design | Oliver Juhas</a> · <a href=\"https://profiles.wordpress.org/webwurm/\">webwurm</a> · <a href=\"https://profiles.wordpress.org/wesrapyd/\">wesrapyd</a> · <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a> · <a href=\"https://profiles.wordpress.org/skorasaurus/\">Will Skora</a> · <a href=\"https://profiles.wordpress.org/williamalexander/\">William Alexander</a> · <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a> · <a href=\"https://profiles.wordpress.org/wongjn/\">wongjn</a> · <a href=\"https://profiles.wordpress.org/wpeople/\">WPeople</a> · <a href=\"https://profiles.wordpress.org/wpsoul/\">wpsoul</a> · <a href=\"https://profiles.wordpress.org/wzieba/\">wzieba</a> · <a href=\"https://profiles.wordpress.org/xipasduarte/\">xipasduarte</a> · <a href=\"https://profiles.wordpress.org/yaniiliev/\">Yani</a> · <a href=\"https://profiles.wordpress.org/collet/\">Yann</a> · <a href=\"https://profiles.wordpress.org/yguyon/\">Yannis Guyon</a> · <a href=\"https://profiles.wordpress.org/yogeshbhutkar/\">Yogesh Bhutkar</a> · <a href=\"https://profiles.wordpress.org/ytfeldrawkcab/\">ytfeLdrawkcaB</a> · <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a> · <a href=\"https://profiles.wordpress.org/yukinobu/\">Yukinobu Asakawa</a> · <a href=\"https://profiles.wordpress.org/yuvrajsinh2211/\">Yuvrajsinh Sisodiya</a> · <a href=\"https://profiles.wordpress.org/zackkrida/\">Zack Krida</a> · <a href=\"https://profiles.wordpress.org/zeelthakkar/\">zeelthakkar</a> · <a href=\"https://profiles.wordpress.org/zitaruksergij/\">zitaruksergij</a> · <a href=\"https://profiles.wordpress.org/zunaid321/\">Zunaid Amin</a></p>\n\n\n\n<h2 class=\"wp-block-heading\">Merci aux personnes ayant contribué à traduire WordPress&nbsp;6.7 en français</h2>\n\n\n\n<p>WordPress est un projet international et la version 6.7 est déjà complètement disponible dans plus de 40 langues différentes.</p>\n\n\n\n<p>Nous souhaitons remercier ici les personnes ayant participé à la traduction de WordPress&nbsp;6.7 en français&nbsp;:</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/jdy68\">Jenny Dupuy</a>, <a href=\"https://profiles.wordpress.org/audrasjb\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/fxbenard\">fxbenard</a>, <a href=\"https://profiles.wordpress.org/xibe\">Xavier Borderie</a>, <a href=\"https://profiles.wordpress.org/amebref\">amebref</a>, <a href=\"https://profiles.wordpress.org/beryldlg\">Béryl de La Grandière</a>, <a href=\"https://profiles.wordpress.org/chris-kns\">chris-kns</a>, <a href=\"https://profiles.wordpress.org/clementpolito\">Clément Polito</a>, <a href=\"https://profiles.wordpress.org/dfi42\">dfi42</a>, <a href=\"https://profiles.wordpress.org/eddystile\">Eddy</a>, <a href=\"https://profiles.wordpress.org/emlebrun\">Emilie LEBRUN</a>, <a href=\"https://profiles.wordpress.org/florientinneo\">Florient DELAFOY</a>, <a href=\"https://profiles.wordpress.org/karine-wendling\">karine wendling</a>, <a href=\"https://profiles.wordpress.org/laeti972\">Laetitia de Perthuis</a>, <a href=\"https://profiles.wordpress.org/wplmillet\">Laurent MILLET</a>, <a href=\"https://profiles.wordpress.org/marineevain\">Marine EVAIN</a>, <a href=\"https://profiles.wordpress.org/lymx\">Maxime LEROY</a>, <a href=\"https://profiles.wordpress.org/firestar300\">Milan Ricoul</a>, <a href=\"https://profiles.wordpress.org/momo-fr\">momo-fr</a>, <a href=\"https://profiles.wordpress.org/pasglop\">pasglop</a>, <a href=\"https://profiles.wordpress.org/phoenix13\">phoenix13</a>, <a href=\"https://profiles.wordpress.org/pierrelannoy\">Pierre Lannoy</a>, <a href=\"https://profiles.wordpress.org/sebastienserre\">Sébastien SERRE</a>, et <a href=\"https://profiles.wordpress.org/spaceshipone\">Timothée Brosille</a>.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<p class=\"has-small-font-size\">Article traduit par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>. Merci à <a href=\"https://profiles.wordpress.org/laboiteare/\">Renaud Pacouil</a> pour sa relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3255\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"Guide des changements techniques de WordPress 6.7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://fr.wordpress.org/2024/10/28/guide-des-changements-techniques-de-wordpress-6-7/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 28 Oct 2024 10:49:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:5:\"Guide\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:31:\"Nouvelles versions de WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3243\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:436:\"WordPress 6.7 comprend la résolution de plus de&#160;300 tickets sur Trac, dont&#160;87 améliorations et nouvelles fonctionnalités, plus de 200 corrections de bogues. cette version comprend&#160;23 tickets focalisés sur les performances,&#160;21 sur l’accessibilité et&#160;12 sur la modernisation du code et la conformité aux standards de code. Les modifications de 6.7 s’étalent sur&#160;38 composants du cœur du [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jb Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:28154:\"\n<figure class=\"wp-block-image alignfull size-large is-style-serif wp-elements-f590cfee42cfa860d05ec74ddea8b4ef\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\"><a href=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"515\" src=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1024x515.png\" alt=\"\" class=\"wp-image-3244\" srcset=\"https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1024x515.png 1024w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-300x151.png 300w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-768x386.png 768w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-1536x772.png 1536w, https://fr.wordpress.org/files/2024/10/wp-6-7-changements-techniques-2048x1029.png 2048w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p>WordPress 6.7 comprend la résolution de plus de&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=owner&amp;col=type&amp;col=priority&amp;col=milestone&amp;order=priority\">300 tickets sur Trac</a>, dont&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=enhancement&amp;type=feature+request&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">87 améliorations et nouvelles fonctionnalités</a>, <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;type=defect+(bug)&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">plus de 200 corrections de bogues</a>. cette version comprend&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~performance&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;order=priority\">23 tickets focalisés sur les performances</a>,&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~accessibility&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">21 sur l’accessibilité</a> et&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;focuses=~coding-standards&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">12 sur la modernisation du code et la conformité aux standards de code</a>. Les modifications de 6.7 s’étalent sur&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=6.7&amp;group=component&amp;max=9999&amp;col=id&amp;col=summary&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=priority&amp;order=priority\">38 composants du cœur du CMS</a>.</p>\n\n\n\n<p>Cette version comprend aussi <a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BType%5D%20Enhancement%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">445 améliorations</a>,&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BType%5D%20Bug%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">464 corrections de bogues</a> et&nbsp;<a href=\"https://github.com/WordPress/gutenberg/issues?q=label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.6%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.7%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.8%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2018.9%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.0%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.1%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.2%22%20OR%20label%3A%22%5BFocus%5D%20Accessibility%20(a11y)%22%20AND%20state%3Aclosed%20AND%20milestone%3A%22Gutenberg%2019.3%22%20\">55 améliorations d’accessibilité</a>&nbsp;sur l’éditeur (projet Gutenberg).</p>\n\n\n\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-ca39a6cbb68f24eb2fca5cc30331b23f\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\">Ce guide décrit les principaux changements techniques que vous trouverez sur WordPress&nbsp;6.7, dont la sortie est prévue le 12 novembre 2024.</p>\n\n\n\n<p>Tous les liens de cet article pointent vers des notes de développement rédigées en anglais. L’objectif est de fournir un panorama général des changements techniques apportés par cette version, en français, puis de diriger les personnes qui souhaitent en savoir plus vers les notes de développement en anglais.</p>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/6-7/\">Pour en savoir plus sur la feuille de route et le calendrier de sortie de WP&nbsp;6.7, consultez cette page.</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h2 class=\"wp-block-heading\" id=\"Block-Editor\">Changements concernant l’éditeur et le projet Gutenberg</h2>\n\n\n\n<p>WordPress 6.7 implémente 8 versions de Gutenberg &#8211; <a href=\"https://make.wordpress.org/core/2024/06/20/whats-new-in-gutenberg-18-6/\">18.6</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/04/whats-new-in-gutenberg-18-7-03-july/\">18.7</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/17/whats-new-in-gutenberg-18-8-17-july/\">18.8</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/07/31/whats-new-in-gutenberg-18-9-31-july/#:~:text=In%20a%20recurring%20effort%20to,Links%2C%20and%20Term%20Description%20blocks.\">18.9</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/08/14/whats-new-in-gutenberg-19-0-14-august/\">19.0</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/08/28/whats-new-in-gutenberg-19-1-28-august/\">19.1</a>,&nbsp;<a href=\"https://make.wordpress.org/core/2024/09/12/what-is-new-in-gutenberg-19-2-11-september/\">19.2</a> et&nbsp;<a href=\"https://make.wordpress.org/core/2024/09/25/whats-new-in-gutenberg-19-3-25-september/\">19.3</a>.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Changements techniques</h3>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"UyWJ3kHEmz\"><a href=\"https://make.wordpress.org/core/2024/10/18/post-editor-iframing-with-meta-boxes-in-wordpress-6-7/\">Post Editor iframing with meta boxes in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Post Editor iframing with meta boxes in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/post-editor-iframing-with-meta-boxes-in-wordpress-6-7/embed/#?secret=tSMGBJfYjQ#?secret=UyWJ3kHEmz\" data-secret=\"UyWJ3kHEmz\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"jF8mPpPXlS\"><a href=\"https://make.wordpress.org/core/2024/10/21/block-bindings-improvements-to-the-editor-experience-in-6-7/\">Block Bindings: Improvements to the Editor Experience in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Block Bindings: Improvements to the Editor Experience in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/block-bindings-improvements-to-the-editor-experience-in-6-7/embed/#?secret=LyXnzsvvCL#?secret=jF8mPpPXlS\" data-secret=\"jF8mPpPXlS\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"G8lRmWqAor\"><a href=\"https://make.wordpress.org/core/2024/10/21/updates-to-block-hooks-in-wordpress-6-7/\">Updates to Block Hooks in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to Block Hooks in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/updates-to-block-hooks-in-wordpress-6-7/embed/#?secret=J4XDYs3pSJ#?secret=G8lRmWqAor\" data-secret=\"G8lRmWqAor\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"h00792iEep\"><a href=\"https://make.wordpress.org/core/2024/10/18/editor-components-updates-in-wordpress-6-7/\">Updates to user-interface components in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to user-interface components in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/editor-components-updates-in-wordpress-6-7/embed/#?secret=TCajqUjanO#?secret=h00792iEep\" data-secret=\"h00792iEep\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"react\">Changements concernant les outils de design dans l’éditeur</h3>\n\n\n\n<p>Nous avons poursuivi l’effort de consolidation des outils de design et plusieurs blocs prennent désormais en charge davantage de fonctionnalités de mise en page et de mise en forme.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"obfs4hTFIv\"><a href=\"https://make.wordpress.org/core/2024/10/17/roster-of-design-tools-per-block-wordpress-6-6-edition-2/\">Roster of design tools per block (WordPress 6.7 edition)</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Roster of design tools per block (WordPress 6.7 edition)&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/roster-of-design-tools-per-block-wordpress-6-6-edition-2/embed/#?secret=3D3EUMW9w6#?secret=obfs4hTFIv\" data-secret=\"obfs4hTFIv\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\" id=\"miscellaneous-block-editor-changes\">Autres modifications concernant l’éditeur</h3>\n\n\n\n<p>D&rsquo;autres modifications diverses ont été listées dans des notes de développement dédiées&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"Mh1YE1VTiU\"><a href=\"https://make.wordpress.org/core/2024/10/18/extending-the-preview-dropdown-menu-in-wordpress-6-7/\">Extending the Preview Dropdown Menu in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Extending the Preview Dropdown Menu in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/extending-the-preview-dropdown-menu-in-wordpress-6-7/embed/#?secret=ViTZEpwoUq#?secret=Mh1YE1VTiU\" data-secret=\"Mh1YE1VTiU\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"5T9ubgS9pA\"><a href=\"https://make.wordpress.org/core/2024/10/20/miscellaneous-block-editor-changes-in-wordpress-6-7/\">Miscellaneous Block Editor Changes in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Miscellaneous Block Editor Changes in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/20/miscellaneous-block-editor-changes-in-wordpress-6-7/embed/#?secret=45jLTa4za3#?secret=5T9ubgS9pA\" data-secret=\"5T9ubgS9pA\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\">API de gestion des interactions et modules de script</h2>\n\n\n\n<p>WordPress 6.7 comprend des mises à jour de l’API <code>Interactivity</code>, comme par exemple une nouvelle façon d’interagir avec les changements d’état côté serveur dans la navigation côté client. Les mises à jour des modules <code>Script</code>s comprennent des améliorations du chargement des scripts existants en tant que dépendances.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"N7suow7aP5\"><a href=\"https://make.wordpress.org/core/2024/10/15/subscribe-to-changes-in-the-interactivity-api-state-and-context-on-client-side-navigation-in-6-7/\">Subscribe to changes in the Interactivity API state and context on client-side navigation in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Subscribe to changes in the Interactivity API state and context on client-side navigation in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/15/subscribe-to-changes-in-the-interactivity-api-state-and-context-on-client-side-navigation-in-6-7/embed/#?secret=XXyFFljgkB#?secret=N7suow7aP5\" data-secret=\"N7suow7aP5\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"64ynOvr7Ew\"><a href=\"https://make.wordpress.org/core/2024/10/14/updates-to-script-modules-in-6-7/\">Updates to Script Modules in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to Script Modules in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/14/updates-to-script-modules-in-6-7/embed/#?secret=6Cxd5rFVoy#?secret=64ynOvr7Ew\" data-secret=\"64ynOvr7Ew\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"html-api\">API HTML</h2>\n\n\n\n<p>WordPress 6.7 comprend plusieurs mises à jour de l&rsquo;API <code>HTML</code>. Plusieurs fonctionnalités majeures sont sorties ainsi qu&rsquo;un amélioration conséquente de l&rsquo;utilisabilité du processeur HTML.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"kbJtxPGfqW\"><a href=\"https://make.wordpress.org/core/2024/10/17/updates-to-the-html-api-in-6-7/\">Updates to the HTML API in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Updates to the HTML API in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/updates-to-the-html-api-in-6-7/embed/#?secret=34UZ0w1coA#?secret=kbJtxPGfqW\" data-secret=\"kbJtxPGfqW\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"i18n\">Internationalisation</h2>\n\n\n\n<p><a href=\"https://core.trac.wordpress.org/query?component=I18N&amp;milestone=6.7&amp;col=id&amp;col=summary&amp;col=milestone&amp;col=owner&amp;col=type&amp;col=status&amp;col=priority&amp;order=priority\">Diverses améliorations de l&rsquo;internationalisation</a> sont disponibles avec WordPress 6.7&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"hQXSqWJGem\"><a href=\"https://make.wordpress.org/core/2024/10/21/i18n-improvements-6-7/\">Internationalization improvements in 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Internationalization improvements in 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/21/i18n-improvements-6-7/embed/#?secret=eFPqVd4tTO#?secret=hQXSqWJGem\" data-secret=\"hQXSqWJGem\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"performance\">Performances</h2>\n\n\n\n<p>WordPress 6.7 apporte aussi plusieurs améliorations focalisées sur les performances, telles qu&rsquo;une nouvelle façon de déclarer les blocs utilisant des fichiers PHP générés pour contrecarrer les goulots d&rsquo;étranglement liés au chargement et au parcours des fichiers JSON.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"8oQC5S3C02\"><a href=\"https://make.wordpress.org/core/2024/10/17/new-block-type-registration-apis-to-improve-performance-in-wordpress-6-7/\">New block type registration APIs to improve performance in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New block type registration APIs to improve performance in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/17/new-block-type-registration-apis-to-improve-performance-in-wordpress-6-7/embed/#?secret=XzjPRUchA9#?secret=8oQC5S3C02\" data-secret=\"8oQC5S3C02\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"7r05WrUm18\"><a href=\"https://make.wordpress.org/core/2024/10/18/auto-sizes-for-lazy-loaded-images-in-wordpress-6-7/\">Auto Sizes for Lazy Loaded Images in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Auto Sizes for Lazy Loaded Images in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/18/auto-sizes-for-lazy-loaded-images-in-wordpress-6-7/embed/#?secret=wpQMBPVn0N#?secret=7r05WrUm18\" data-secret=\"7r05WrUm18\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"miscellaneous-developer-changes\">Autres changements techniques</h2>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"fmwVz6LB0l\"><a href=\"https://make.wordpress.org/core/2024/10/20/new-plugin-template-registration-api-in-wordpress-6-7/\">New Plugin Template Registration API in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;New Plugin Template Registration API in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/10/20/new-plugin-template-registration-api-in-wordpress-6-7/embed/#?secret=rHnFsEBoL1#?secret=fmwVz6LB0l\" data-secret=\"fmwVz6LB0l\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<figure class=\"wp-block-embed is-type-wp-embed is-provider-make-wordpress-core wp-block-embed-make-wordpress-core\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"zeZlu13TM1\"><a href=\"https://make.wordpress.org/core/2024/08/15/automatic-conversion-of-heic-images-to-jpeg-in-wordpress-6-7/\">Automatic conversion of HEIC images to JPEG in WordPress 6.7</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;Automatic conversion of HEIC images to JPEG in WordPress 6.7&#8221; &#8212; Make WordPress Core\" src=\"https://make.wordpress.org/core/2024/08/15/automatic-conversion-of-heic-images-to-jpeg-in-wordpress-6-7/embed/#?secret=9ECwfO9e5P#?secret=zeZlu13TM1\" data-secret=\"zeZlu13TM1\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"other-updates\">Nouvelles fonctions, crochets, filtres, classes et méthodes</h2>\n\n\n\n<p>Pour obtenir la liste de toutes les nouvelles fonctions, crochets, filtres, classes et méthodes, vous pourrez vous rendre – une fois que WP 6.7 sera sortie – sur cette page&nbsp;: <a href=\"https://developer.wordpress.org/reference/since/6.7.0/\">https://developer.wordpress.org/reference/since/6.7.0/</a>.</p>\n\n\n\n<div class=\"wp-block-group alignfull is-layout-flow wp-block-group-is-layout-flow\">\n<p class=\"is-style-serif has-white-color has-text-color has-background has-link-color wp-elements-87f312e26bd4a386f9cdeec66ae58d52\" style=\"background:linear-gradient(135deg,rgb(7,125,194) 0%,rgb(134,54,209) 100%)\">Que vous développiez des thèmes ou des extensions, pensez à tester et retester votre code pour vous assurer de sa compatibilité avec ces changements.<br><br>Vous pouvez utiliser <a href=\"https://fr.wordpress.org/plugins/wordpress-beta-tester/\" target=\"_blank\" rel=\"noreferrer noopener\">l’extension « <em><bdo lang=\"en\" dir=\"ltr\">Beta Tester</bdo></em> »</a> sur un site de test pour vérifier la compatibilité de vos développements avec la <a href=\"https://wordpress.org/news/2024/10/wordpress-6-7-release-candidate-1/\">version <em><bdo lang=\"en\" dir=\"ltr\">release candidate</bdo></em> de WordPress 6.7</a>. <br>Vous pouvez aussi tester cette nouvelle version directement dans votre navigateur en utilisant <em><a href=\"https://playground.wordpress.net/#%7B%20%22preferredVersions%22:%20%7B%20%22php%22:%20%228.0%22,%20%22wp%22:%20%22beta%22%20%7D,%20%22features%22:%20%7B%20%22networking%22:%20true%20%7D,%20%22steps%22:%20[%20%7B%20%22step%22:%20%22login%22,%20%22username%22:%20%22admin%22,%20%22password%22:%20%22password%22%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/wpaccessibility/a11y-theme-unit-test/master/a11y-theme-unit-test-data.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22importFile%22,%20%22file%22:%20%7B%20%22resource%22:%20%22url%22,%20%22url%22:%20%22https://raw.githubusercontent.com/WordPress/theme-test-data/master/themeunittestdata.wordpress.xml%22%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22query-monitor%22%20%7D,%20%22options%22:%20%7B%20%22activate%22:%20false%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22create-block-theme%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22debug-bar%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22health-check%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22test-reports%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D,%20%7B%20%22step%22:%20%22installPlugin%22,%20%22pluginZipFile%22:%20%7B%20%22resource%22:%20%22wordpress.org/plugins%22,%20%22slug%22:%20%22user-switching%22%20%7D,%20%22progress%22:%20%7B%20%22weight%22:%202%20%7D%20%7D%20]%20%7D\"><bdo lang=\"en\" dir=\"ltr\">WordPress Playground</bdo></a></em>.<br><br>Nous comptons sur vous pour vérifier que votre code fonctionne correctement avec le cœur du CMS, pour le bien des millions d’utilisateurs et utilisatrices de WordPress <img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/2665.png\" alt=\"♥\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></p>\n</div>\n\n\n\n<p class=\"has-small-font-size\">Ce guide a été traduit et réadapté à partir du <a href=\"https://make.wordpress.org/core/2024/10/23/wordpress-6-7-field-guide/\">Field Guide de WP 6.7 (en anglais)</a> par <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>.<br>Merci à <a href=\"https://profiles.wordpress.org/fxbenard/\">FX Benard</a> et <a href=\"https://profiles.wordpress.org/beryldlg/\">Béryl de La Grandière</a> pour leur relecture.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3243\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:66:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"Nouveau programme de mentorat pour la contribution à WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:99:\"https://fr.wordpress.org/2024/08/21/nouveau-programme-de-mentorat-pour-la-contribution-a-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 21 Aug 2024 09:34:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:10:\"Contribuer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:13:\"Documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:10:\"Traduction\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:18:\"mentorship program\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fr.wordpress.org/?p=3204\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:389:\"Le 7 octobre 2024, un nouveau programme de mentorat pour la contribution à WordPress ou « WordPress Contributor Mentorship » va débuter pour une durée de 6 semaines, il s’achèvera donc avec la sortie de la version 6.7 mi-novembre. Mais c’est quoi exactement ce programme&#160;? Il s’agit du troisième programme organisé par l’équipe Community afin de faciliter [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6506:\"\n<p>Le 7 octobre 2024, un nouveau programme de mentorat pour la contribution à WordPress ou « WordPress Contributor Mentorship » va débuter pour une durée de 6 semaines, il s’achèvera donc avec la sortie de la version 6.7 mi-novembre.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Mais c’est quoi exactement ce programme&nbsp;?</h2>\n\n\n\n<p>Il s’agit du troisième programme organisé par l’équipe <a href=\"https://make.wordpress.org/community/\">Community</a> afin de faciliter l’intégration de nouvelles personnes aux <a href=\"https://make.wordpress.org/\">diverses équipe de contribution</a>.</p>\n\n\n\n<p>Ce programme met en place de petites équipes avec un mentor et des mentoré·e·s qui travaillent ensemble sur un projet proposé par le mentor lors de sa candidature.</p>\n\n\n\n<p>Les organisateurs répartissent donc les contributeurs/contributrices selon les souhaits qu&rsquo;ils/elles ont définis lors de leur candidature.</p>\n\n\n\n<p>Tout au long du programme, le/la mentor prend en charge l&rsquo;équipe de mentoré·e·s pour avancer le projet qu&rsquo;il/elle a proposé, et quelques réunions en visio sont proposées par les organisateurs.</p>\n\n\n\n<p>Si vous souhaitez débuter la contribution à WordPress mais ne savez pas comment, ni par où commencer, alors ce programme est parfait pour vous en tant que mentoré·e.&nbsp; Vous serez guidé·e tout au long du programme par des mentors et pourrez ainsi obtenir toutes les informations nécessaires à une contribution efficace.<br>Et si vous contribuez déjà et souhaitez transmettre vos connaissances à d’autres personnes alors participez au programme en tant que mentor ! Ce sera l’occasion d’accueillir de nouvelles personnes dans vos équipes respectives.</p>\n\n\n\n<p>Cette cohorte est synchronisée avec la sortie de la version 6.7 afin de permettre aux participants, qui rejoignent l’équipe Core ou celle du développement du thème Twenty Twenty-Five, de contribuer spécifiquement à cette version de WordPress. Mais, la contribution à WordPress ne se résumant pas à son code, vous avez aussi l’opportunité de rejoindre des équipes de contribution non liées au code telles que Communauté (organisation d’évènements et encadrement des équipes), Design, Documentation, Formation, etc.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Qui peut candidater ?</h2>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Pour les mentoré·e·s : toute personne souhaitant débuter la contribution à WordPress, ou encore contribuer à d’autres équipes que celle(s) où il/elle contribue déjà.</li>\n\n\n\n<li>Pour les mentors : toute personne ayant déjà un peu d’expérience dans la contribution WordPress.</li>\n</ul>\n\n\n\n<h2 class=\"wp-block-heading\">Comment rejoindre le programme ?</h2>\n\n\n\n<p>Pour rejoindre le programme, il faut remplir un petit formulaire :</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://docs.google.com/forms/d/e/1FAIpQLSd6faivlMZzyiq1sx_78fvnw7-JOshZMZcIO6BTp-B7TuM2ww/viewform\" target=\"_blank\" rel=\"noreferrer noopener\">Candidater en tant que mentoré·e</a></div>\n\n\n\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://docs.google.com/forms/d/e/1FAIpQLSfDzRRrIDJcQcVF0m3I16-RfwrjmXBHboxCC5Rx0OHatK_EBQ/viewform\" target=\"_blank\" rel=\"noreferrer noopener\">Candidater en tant que mentor</a></div>\n</div>\n\n\n\n<p>Mais <strong>attention date limite des candidatures</strong> : </p>\n\n\n\n<p class=\"has-text-align-center has-light-grey-2-color has-vivid-red-background-color has-text-color has-background has-link-color wp-elements-18846e5805f4ed69ba3dc19961036bd1\" style=\"margin-top:var(--wp--preset--spacing--10);margin-right:var(--wp--preset--spacing--10);margin-bottom:var(--wp--preset--spacing--10);margin-left:var(--wp--preset--spacing--10);padding-top:var(--wp--preset--spacing--10);padding-right:var(--wp--preset--spacing--10);padding-bottom:var(--wp--preset--spacing--10);padding-left:var(--wp--preset--spacing--10)\">le 26 août 2024</p>\n\n\n\n<p>Vous serez ensuite recontacté·e.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Contribuer dans votre langue</h2>\n\n\n\n<p>Ce 3<sup>e</sup> programme propose une nouveauté : selon le projet auquel vous participerez, vous aurez peut être l’opportunité de contribuer en français, puisque des équipes par locale vont être constituées.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Plus d&rsquo;informations</h2>\n\n\n\n<p>Retrouvez plus d&rsquo;informations sur le programme dans cet article (en anglais) :</p>\n\n\n\n<figure class=\"wp-block-embed aligncenter is-type-wp-embed is-provider-wordpress-org-project wp-block-embed-wordpress-org-project\"><div class=\"wp-block-embed__wrapper\">\n<blockquote class=\"wp-embedded-content\" data-secret=\"TOusFk6YKX\"><a href=\"https://make.wordpress.org/project/2024/08/16/wordpress-contributor-mentorship-program-cohort-3-2024-q4-call-for-mentees-mentors/\">WordPress Contributor Mentorship Program Cohort #3 (2024 Q4): Call for Mentees &amp; Mentors</a></blockquote><iframe loading=\"lazy\" class=\"wp-embedded-content\" sandbox=\"allow-scripts\" security=\"restricted\"  title=\"&#8220;WordPress Contributor Mentorship Program Cohort #3 (2024 Q4): Call for Mentees &amp; Mentors&#8221; &#8212; WordPress.org Project\" src=\"https://make.wordpress.org/project/2024/08/16/wordpress-contributor-mentorship-program-cohort-3-2024-q4-call-for-mentees-mentors/embed/#?secret=93CdKWMRfW#?secret=TOusFk6YKX\" data-secret=\"TOusFk6YKX\" width=\"500\" height=\"282\" frameborder=\"0\" marginwidth=\"0\" marginheight=\"0\" scrolling=\"no\"></iframe>\n</div></figure>\n\n\n\n<p class=\"has-text-align-center has-light-grey-2-color has-purple-2-background-color has-text-color has-background has-link-color has-extra-large-font-size wp-elements-ce3e97f8976a3a3f44d47b605fc66a4f\" style=\"margin-top:var(--wp--preset--spacing--30);margin-right:var(--wp--preset--spacing--30);margin-bottom:var(--wp--preset--spacing--30);margin-left:var(--wp--preset--spacing--30);padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)\">On compte sur vous pour vous inscrire nombreux et nombreuses à ce programme !<br>Si vous n’avez jamais contribué c’est l’occasion rêvée de commencer, si vous contribuez déjà et souhaitez rejoindre de nouvelles équipes ce programme est fait pour vous !</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"3204\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://fr.wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"13096031\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 20 Jan 2026 15:50:29 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Sat, 10 Jan 2026 23:18:11 GMT\";s:4:\"link\";s:61:\"<https://fr.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}s:5:\"build\";i:1768923973;s:21:\"cache_expiration_time\";i:1768967429;s:23:\"__cache_expiration_time\";i:1768967429;}", "off");
INSERT INTO `dev_options` VALUES("147", "_site_transient_timeout_feed_mod_0d2db5fea5a8633b56992c916819b198", "1768967429", "off");
INSERT INTO `dev_options` VALUES("148", "_site_transient_feed_mod_0d2db5fea5a8633b56992c916819b198", "1768924229", "off");
INSERT INTO `dev_options` VALUES("149", "_site_transient_timeout_feed_b0b1001e5bc3fbacad8b49ec075d19a5", "1768967429", "off");
INSERT INTO `dev_options` VALUES("150", "_site_transient_feed_b0b1001e5bc3fbacad8b49ec075d19a5", "a:6:{s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"feed\";a:1:{i:0;a:6:{s:4:\"data\";s:126:\"\n    \n    \n    \n    \n    \n    \n\n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Planet WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"subtitle\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Planet WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:43:\"https://fluxplanet.wpfr.net/feed/wp-planet/\";s:3:\"rel\";s:4:\"self\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"https://fluxplanet.wpfr.net/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"2026-01-20T15:50:22+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"\n        WP RSS Aggregator\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"uri\";s:27:\"https://wprssaggregator.com\";s:7:\"version\";s:7:\"4.23.13\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"entry\";a:10:{i:0;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://blog.o2switch.fr/sante-du-site-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Vous avez un message dans l’outil Santé du site de votre site WordPress : que faire ?\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:49:\"https://blog.o2switch.fr/sante-du-site-wordpress/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-19T07:30:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-19T07:30:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:259:\"L’outil Santé du site WordPress affiche des messages, recommandations et avertissements qui peuvent inquiéter. Faut-il tous les corriger ? Comment les interpréter ? Cet article vous aide à comprendre leur rôle et à savoir quand agir… ou relativiser.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:273:\"\n        L’outil Santé du site WordPress affiche des messages, recommandations et avertissements qui peuvent inquiéter. Faut-il tous les corriger ? Comment les interpréter ? Cet article vous aide à comprendre leur rôle et à savoir quand agir… ou relativiser.\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Éric Martin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://blog.o2switch.fr/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"O2switch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:1;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://wpmarmite.com/bilan-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Retour sur l’année 2025 de WPMarmite\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:33:\"https://wpmarmite.com/bilan-2025/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-13T06:40:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-13T06:40:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:364:\"Salut les cuistots et bonne année 2026 ! Comme chaque mois de janvier, je prends le temps de faire le point sur l’année écoulée pour vous partager l’évolution de nos projets. Comptez sur moi pour vous partager le bilan complet...\nRetour sur l’année 2025 de WPMarmite est un article de WPMarmite, le blog qui vous aide à tirer le meilleur de WordPress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:685:\"\n        <p><img width=\"1500\" height=\"830\" src=\"https://wpmarmite.com/wp-content/uploads/2026/01/cover-bilan-2025.jpg\" class=\"attachment-full size-full wp-post-image\" alt=\"Bilan 2025 de WPMarmite\" //></p>\n<p>Salut les cuistots et bonne année 2026 ! Comme chaque mois de janvier, je prends le temps de faire le point sur l&#8217;année écoulée pour vous partager l&#8217;évolution de nos projets. Comptez sur moi pour vous partager le bilan complet...</p>\n<p><a href=\"https://wpmarmite.com/bilan-2025/\">Retour sur l&#8217;année 2025 de WPMarmite</a> est un article de <a href=\"https://wpmarmite.com\">WPMarmite</a>, le blog qui vous aide à tirer le meilleur de WordPress.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alex Borto\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"http://feedpress.me/WPMarmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"WP Marmite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:2;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://www.youtube.com/watch?v=aT9VnptqDvE\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"Les bonnes résolutions WordPress pour 2026\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:43:\"https://www.youtube.com/watch?v=aT9VnptqDvE\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-12T14:21:06.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-12T14:21:06.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:426:\"Bonne année 2026 ! Dans cette première vidéo de l’année, on fait le point sur les bonnes résolutions de WordPress après le State of the World du 2 décembre dernier à San Francisco. Au programme : ✅ Les chiffres clés de WordPress en 2026 (43% du web !) ✅ WordPress 6.9 : notes collaboratives, bloc […]\nL’article Les bonnes résolutions WordPress pour 2026 est apparu en premier sur Agence WordPress Whodunit.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:559:\"\n        <p>Bonne année 2026 ! Dans cette première vidéo de l&#8217;année, on fait le point sur les bonnes résolutions de WordPress après le State of the World du 2 décembre dernier à San Francisco. Au programme : ✅ Les chiffres clés de WordPress en 2026 (43% du web !) ✅ WordPress 6.9 : notes collaboratives, bloc [&#8230;]</p>\n<p>L’article <a href=\"https://www.youtube.com/watch?v=aT9VnptqDvE\">Les bonnes résolutions WordPress pour 2026</a> est apparu en premier sur <a href=\"https://www.whodunit.fr\">Agence WordPress Whodunit</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Eddy BOELS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://www.whodunit.fr/videos/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Whodunit Videos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:3;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://whodunit.consulting/tout-savoir-sur-le-bloc-accordeon-de-wordpress-6-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"Tout savoir sur le bloc Accordéon de WordPress 6.9\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:79:\"https://whodunit.consulting/tout-savoir-sur-le-bloc-accordeon-de-wordpress-6-9/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-08T07:29:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-08T07:29:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:288:\"WordPress 6.9 introduit un nouveau bloc Accordéon, suite à une forte demande des usagers du CMS. Voici un article en mode question-réponse sur cette nouvelle fonctionnalité.\nL’article Tout savoir sur le bloc Accordéon de WordPress 6.9 est apparu en premier sur Whodunit Consulting.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:26507:\"\n        <figure class=\"wp-block-post-featured-image\"><img width=\"1600\" height=\"960\" src=\"https://whodunit.consulting/wp-content/uploads/2025/10/bloc-accordeon-wordpress-6.9.png\" class=\"attachment-post-thumbnail size-post-thumbnail wp-post-image\" alt=\"\" style=\"object-fit:cover\" //></figure>\n\n\n<h2 class=\"wp-block-heading\">À quoi ressemble le bloc accordéon de WP 6.9&nbsp;?</h2>\n\n\n\n<p>Petite mise en abîme ici, puisque pour vous montrer à quoi ressemble ce nouveau bloc accordéon, autant l&rsquo;utiliser directement&nbsp;!</p>\n\n\n\n<p>Les sections qui suivent montrent le rendu par défaut du bloc accordéon. La section d&rsquo;après montre quant à elle un exemple de bloc accordéon mis en forme via CSS.</p>\n\n\n\n<p>Mais ce ne sont pas de faux contenus de démo. C&rsquo;est tout simplement le contenu de cet article qui est rangé dans ces blocs, alors n&rsquo;hésitez pas à déplier ces éléments pour en voir les contenus&nbsp;<code>:-)</code></p>\n\n\n\n<div data-wp-context=\"{ &quot;autoclose&quot;: true, &quot;accordionItems&quot;: [] }\" data-wp-interactive=\"core/accordion\" role=\"group\" class=\"wp-block-accordion is-layout-flow wp-block-accordion-is-layout-flow\">\n<div data-wp-class--is-open=\"state.isOpen\" data-wp-context=\"{ &quot;id&quot;: &quot;accordion-item-1&quot;, &quot;openByDefault&quot;: false }\" data-wp-init=\"callbacks.initAccordionItems\" class=\"wp-block-accordion-item is-layout-flow wp-block-accordion-item-is-layout-flow\">\n<h3 class=\"wp-block-accordion-heading has-medium-font-size\"><button aria-expanded=\"false\" aria-controls=\"accordion-item-1-panel\" data-wp-bind--aria-expanded=\"state.isOpen\" data-wp-on--click=\"actions.toggle\" data-wp-on--keydown=\"actions.handleKeyDown\" id=\"accordion-item-1\" class=\"wp-block-accordion-heading__toggle\"><span class=\"wp-block-accordion-heading__toggle-title\">Pourquoi WordPress 6.9 ajoute un nouveau bloc accordéon&nbsp;?</span><span class=\"wp-block-accordion-heading__toggle-icon\" aria-hidden=\"true\">+</span></button></h3>\n\n\n\n<div aria-labelledby=\"accordion-item-1\" data-wp-bind--inert=\"!state.isOpen\" id=\"accordion-item-1-panel\" role=\"region\" class=\"wp-block-accordion-panel is-layout-flow wp-block-accordion-panel-is-layout-flow\">\n<p>C&rsquo;est vrai qu&rsquo;il existe déjà le bloc «&nbsp;Détails&nbsp;» qui permet de générer des panneaux de contenus masqués puis dépliables au clic sur leur intitulé.</p>\n\n\n\n<p>Mais un composant de type «&nbsp;Accordéon&nbsp;» est assez différent&nbsp;: le principe c&rsquo;est que les panneaux de l&rsquo;accordéon sont liés ensembles à l&rsquo;intérieur d&rsquo;un groupe, à l&rsquo;inverse du composant «&nbsp;Détail&nbsp;» où chaque panneau est totalement indépendant des autres.</p>\n\n\n\n<p>Souvent, on fera d&rsquo;ailleurs en sorte que lorsqu&rsquo;un élément est sélectionné, les autres sections vont se replier, ce qui donne à ce composant son aspect d&rsquo;accordéon.</p>\n</div>\n</div>\n\n\n\n<div data-wp-class--is-open=\"state.isOpen\" data-wp-context=\"{ &quot;id&quot;: &quot;accordion-item-2&quot;, &quot;openByDefault&quot;: false }\" data-wp-init=\"callbacks.initAccordionItems\" class=\"wp-block-accordion-item is-layout-flow wp-block-accordion-item-is-layout-flow\">\n<h3 class=\"wp-block-accordion-heading has-medium-font-size\"><button aria-expanded=\"false\" aria-controls=\"accordion-item-2-panel\" data-wp-bind--aria-expanded=\"state.isOpen\" data-wp-on--click=\"actions.toggle\" data-wp-on--keydown=\"actions.handleKeyDown\" id=\"accordion-item-2\" class=\"wp-block-accordion-heading__toggle\"><span class=\"wp-block-accordion-heading__toggle-title\">Le bloc accordéon de WP 6.9 est il accessible&nbsp;?</span><span class=\"wp-block-accordion-heading__toggle-icon\" aria-hidden=\"true\">+</span></button></h3>\n\n\n\n<div aria-labelledby=\"accordion-item-2\" data-wp-bind--inert=\"!state.isOpen\" id=\"accordion-item-2-panel\" role=\"region\" class=\"wp-block-accordion-panel is-layout-flow wp-block-accordion-panel-is-layout-flow\">\n<p>Oui. Des rôles ARIA ont été ajoutées à ce composant afin de standardiser le code source généré.</p>\n\n\n\n<p>Le conteneur global dispose d&rsquo;un rôle <code>group</code> et les panneaux du bloc portent un rôle <code>region</code>. Des attributs ARIA permettent également de faciliter l&rsquo;usage de ce bloc pour les technologies d&rsquo;assistance. Ainsi, le titre de section comprend des attributs <code>aria-expanded</code>, <code>aria-controls</code> se rapportant au panneau dépliable et à son état, tandis que celui-ci comprend un attribut <code>aria-labelledby</code> permettant de le rattacher à son titre.</p>\n\n\n\n<p>On y retrouve donc finalement toutes les recommandations du motif de conception «&nbsp;accordion&nbsp;» proposé par le W3C <sup data-fn=\"892f0416-b38a-49d9-94f5-8963b9352748\" class=\"fn\"><a id=\"892f0416-b38a-49d9-94f5-8963b9352748-link\" href=\"#892f0416-b38a-49d9-94f5-8963b9352748\">1</a></sup>.</p>\n</div>\n</div>\n\n\n\n<div data-wp-class--is-open=\"state.isOpen\" data-wp-context=\"{ &quot;id&quot;: &quot;accordion-item-3&quot;, &quot;openByDefault&quot;: false }\" data-wp-init=\"callbacks.initAccordionItems\" class=\"wp-block-accordion-item is-layout-flow wp-block-accordion-item-is-layout-flow\">\n<h3 class=\"wp-block-accordion-heading has-medium-font-size\"><button aria-expanded=\"false\" aria-controls=\"accordion-item-3-panel\" data-wp-bind--aria-expanded=\"state.isOpen\" data-wp-on--click=\"actions.toggle\" data-wp-on--keydown=\"actions.handleKeyDown\" id=\"accordion-item-3\" class=\"wp-block-accordion-heading__toggle\"><span class=\"wp-block-accordion-heading__toggle-title\">Quels sont les réglages du bloc accordéon&nbsp;?</span><span class=\"wp-block-accordion-heading__toggle-icon\" aria-hidden=\"true\">+</span></button></h3>\n\n\n\n<div aria-labelledby=\"accordion-item-3\" data-wp-bind--inert=\"!state.isOpen\" id=\"accordion-item-3-panel\" role=\"region\" class=\"wp-block-accordion-panel is-layout-flow wp-block-accordion-panel-is-layout-flow\">\n<p>Il est possible de définir les niveaux de titres à utiliser pour les titres de section de votre accordéon. C&rsquo;est cependant un poil caché&nbsp;: ne cherchez pas ce réglage au niveau de chaque titre de section, il faut se positionner au niveau du bloc accordéon lui même et le réglage de niveau de titre à utiliser est disponible dans la barre de formatage du bloc&nbsp;:</p>\n\n\n\n<figure class=\"wp-block-image size-full has-custom-border is-style-default\"><img width=\"888\" height=\"718\" src=\"https://whodunit.consulting/wp-content/uploads/2025/10/wordpress-6.9-bloc-accordeon.png\" alt=\"Au niveau de la barre de formatage du bloc accordéon de WordPress 6.9, la quatrième option de la barre permet de définir le niveau de titre à appliquer aux titres de sections du bloc\" class=\"wp-image-4719\" style=\"border-width:1px;border-top-left-radius:5px;border-top-right-radius:5px;border-bottom-left-radius:5px;border-bottom-right-radius:5px\" //></figure>\n\n\n\n<p>Il est aussi possible de définir les comportements généraux du bloc&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Le réglage «&nbsp;Fermer automatiquement&nbsp;» permet de fermer automatiquement les autres panneaux lorsque l&rsquo;un des panneaux est affiché.</li>\n\n\n\n<li>Le réglage «&nbsp;Afficher l’icône&nbsp;» permet d&rsquo;afficher l’icône proposée nativement (et surchargeable en CSS) dans le bouton de dépliement.</li>\n\n\n\n<li>Le réglage «&nbsp;Position de l&rsquo;icône&nbsp;» permet d&rsquo;afficher l&rsquo;icône à droite ou à gauche du titre.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-full has-custom-border\"><img width=\"538\" height=\"570\" src=\"https://whodunit.consulting/wp-content/uploads/2025/11/Capture-decran-2025-11-20-a-23.40.02.png\" alt=\"Sur le bloc Accordéon disponible avec WordPress 6.9, 3 réglages sont disponibles. Ceux-ci sont décrits dans le texte qui précède cette image.\" class=\"has-border-color wp-image-4855\" style=\"border-color:#6D3AB0;border-width:1px;border-top-left-radius:5px;border-top-right-radius:5px;border-bottom-left-radius:5px;border-bottom-right-radius:5px\" //></figure>\n</div>\n</div>\n\n\n\n<div data-wp-class--is-open=\"state.isOpen\" data-wp-context=\"{ &quot;id&quot;: &quot;accordion-item-4&quot;, &quot;openByDefault&quot;: false }\" data-wp-init=\"callbacks.initAccordionItems\" class=\"wp-block-accordion-item is-layout-flow wp-block-accordion-item-is-layout-flow\">\n<h3 class=\"wp-block-accordion-heading has-medium-font-size\"><button aria-expanded=\"false\" aria-controls=\"accordion-item-4-panel\" data-wp-bind--aria-expanded=\"state.isOpen\" data-wp-on--click=\"actions.toggle\" data-wp-on--keydown=\"actions.handleKeyDown\" id=\"accordion-item-4\" class=\"wp-block-accordion-heading__toggle\"><span class=\"wp-block-accordion-heading__toggle-title\">Peut-on facilement modifier les styles du bloc accordéon de WordPress&nbsp;?</span><span class=\"wp-block-accordion-heading__toggle-icon\" aria-hidden=\"true\">+</span></button></h3>\n\n\n\n<div aria-labelledby=\"accordion-item-4\" data-wp-bind--inert=\"!state.isOpen\" id=\"accordion-item-4-panel\" role=\"region\" class=\"wp-block-accordion-panel is-layout-flow wp-block-accordion-panel-is-layout-flow\">\n<p>Pour pouvoir styler correctement un bloc, il est important de connaître sa structure.</p>\n\n\n\n<p>Voici à quoi ressemble notre bloc accordéon lors de l&rsquo;enregistrement de la page en base de données&nbsp;:</p>\n\n\n\n<pre class=\"wp-block-code\" style=\"font-size:0.75rem\"><code>&lt;!-- wp:accordion --&gt;\n&lt;div role=\"group\" class=\"wp-block-accordion\"&gt;\n	&lt;!-- wp:accordion-item --&gt;\n	&lt;div class=\"wp-block-accordion-item\"&gt;\n		&lt;!-- wp:accordion-heading --&gt;\n		&lt;h3 class=\"wp-block-accordion-heading\"&gt;\n			&lt;button class=\"wp-block-accordion-heading__toggle\"&gt;\n				&lt;span class=\"wp-block-accordion-heading__toggle-title\"&gt;\n					Un titre de section\n				&lt;/span&gt;\n				&lt;span class=\"wp-block-accordion-heading__toggle-icon\" aria-hidden=\"true\"&gt;+&lt;/span&gt;\n			&lt;/button&gt;\n		&lt;/h3&gt;\n		&lt;!-- /wp:accordion-heading --&gt;\n\n		&lt;!-- wp:accordion-panel --&gt;\n		&lt;div role=\"region\" class=\"wp-block-accordion-panel\"&gt;\n			&lt;!-- wp:paragraph --&gt;\n			&lt;p&gt;Mon texte.&lt;/p&gt;\n			&lt;!-- /wp:paragraph --&gt;\n		&lt;/div&gt;\n		&lt;!-- /wp:accordion-panel --&gt;\n	&lt;/div&gt;\n	&lt;!-- /wp:accordion-item --&gt;\n&lt;/div&gt;\n&lt;!-- /wp:accordion --&gt;</code></pre>\n\n\n\n<p>Si l&rsquo;on décortique un peu ce code, on voit que les classes suivantes sont utilisées pour la structuration du bloc&nbsp;:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><code>wp-block-accordion</code> : le conteneur principal du bloc</li>\n\n\n\n<li><code>wp-block-accordion-item</code> : le conteneur de chaque élément de notre accordéon, puis à l&rsquo;intérieur : \n<ul class=\"wp-block-list\">\n<li><code>wp-block-accordion-heading</code> : le titre de section de l&rsquo;élément</li>\n\n\n\n<li><code>wp-block-accordion-heading__toggle</code> : le bouton qui contient le texte du titre de section\n<ul class=\"wp-block-list\">\n<li><code>wp-block-accordion-heading__toggle-title</code> : un wrapper autour du titre textuel seul</li>\n\n\n\n<li><code>wp-block-accordion-heading__toggle-icon</code> : le wrapper autour du petit élément «&nbsp;+&nbsp;» affiché par défaut à droite du titre, afin de pouvoir le cibler et le modifier</li>\n</ul>\n</li>\n</ul>\n</li>\n</ul>\n\n\n\n<p>Cette structure claire permet de cibler assez précisemment chaque item via CSS afin d&rsquo;appliquer des styles personnalisés.</p>\n</div>\n</div>\n</div>\n\n\n\n<p>Dans la section suivante, nous verrons les limites actuelles de ce bloc dans la version Beta 1 de WordPress 6.9, mises en forme au sein d&rsquo;un exemple de bloc accordéon stylé via CSS.</p>\n\n\n\n<h2 class=\"wp-block-heading\">Limites actuelles du bloc Accordéon dans WP 6.9</h2>\n\n\n\n<p>Dans cette section, nous abordons les limites du bloc tel qu&rsquo;il est prévu pour WOrdPress 6.9 dont la sortie a eu lieu le 2 décembre 2025.</p>\n\n\n\n<p>Le bloc accordéon utilisé dans cette section est surchargé en CSS afin de proposer une implémentation visuelle différente du bloc, à titre d&rsquo;exemple.</p>\n\n\n\n<div data-wp-context=\"{ &quot;autoclose&quot;: true, &quot;accordionItems&quot;: [] }\" data-wp-interactive=\"core/accordion\" role=\"group\" class=\"wp-block-accordion customized-accordion is-layout-flow wp-block-accordion-is-layout-flow\">\n<div data-wp-class--is-open=\"state.isOpen\" data-wp-context=\"{ &quot;id&quot;: &quot;accordion-item-5&quot;, &quot;openByDefault&quot;: false }\" data-wp-init=\"callbacks.initAccordionItems\" class=\"wp-block-accordion-item is-layout-flow wp-block-accordion-item-is-layout-flow\">\n<h3 class=\"wp-block-accordion-heading\"><button aria-expanded=\"false\" aria-controls=\"accordion-item-5-panel\" data-wp-bind--aria-expanded=\"state.isOpen\" data-wp-on--click=\"actions.toggle\" data-wp-on--keydown=\"actions.handleKeyDown\" id=\"accordion-item-5\" class=\"wp-block-accordion-heading__toggle\"><span class=\"wp-block-accordion-heading__toggle-icon\" aria-hidden=\"true\">+</span><span class=\"wp-block-accordion-heading__toggle-title\">Le bloc accordéon de WP 6.9 demande un peu de pratique avant de savoir bien l&rsquo;utiliser en <bdo lang=\"en\" dir=\"ltr\">back-office</bdo></span></button></h3>\n\n\n\n<div aria-labelledby=\"accordion-item-5\" data-wp-bind--inert=\"!state.isOpen\" id=\"accordion-item-5-panel\" role=\"region\" class=\"wp-block-accordion-panel is-layout-flow wp-block-accordion-panel-is-layout-flow\">\n<p>Si le bloc est dès aujourd&rsquo;hui fonctionnel, son utilisation demande une petite montée en compétence avant de pouvoir le manier avec dextérité en back-office.</p>\n\n\n\n<p>C&rsquo;est globalement le cas de tous les blocs imbriqués (<em><bdo lang=\"en\" dir=\"ltr\">nested blocks</bdo></em>)&nbsp;: l&rsquo;insertion de blocs à l&rsquo;intérieur du conteneur nécessite souvent de revenir au bloc parent avant de pouvoir insérer le contenu que l&rsquo;on souhaite.</p>\n\n\n\n<p>Idem lorsque l&rsquo;on souhaite accéder aux réglages généraux du bloc, il faut revenir au bloc parent ce qui n&rsquo;est pas spécialement évident en cliquant sur les éléments du bloc.</p>\n\n\n\n<p>Pour revenir facilement au bloc parent, pensez à utiliser un maximum le fil d&rsquo;ariane des blocs disponibles en pied de page de l&rsquo;écran de l&rsquo;éditeur. Il est très utile pour remonter dans la hiérarchie d&rsquo;un ensemble de blocs imbriqués.</p>\n\n\n\n<p>À noter que l&rsquo;utilisation du bloc via un lecteur d&rsquo;écran est presque un poil plus aisée que visuellement, car l&rsquo;éditeur propose pas mal de raccourcis destinés à faciliter son usage pour les gens qui utilisent des technologies d&rsquo;assistance.</p>\n</div>\n</div>\n\n\n\n<div data-wp-class--is-open=\"state.isOpen\" data-wp-context=\"{ &quot;id&quot;: &quot;accordion-item-6&quot;, &quot;openByDefault&quot;: false }\" data-wp-init=\"callbacks.initAccordionItems\" class=\"wp-block-accordion-item is-layout-flow wp-block-accordion-item-is-layout-flow\">\n<h3 class=\"wp-block-accordion-heading\"><button aria-expanded=\"false\" aria-controls=\"accordion-item-6-panel\" data-wp-bind--aria-expanded=\"state.isOpen\" data-wp-on--click=\"actions.toggle\" data-wp-on--keydown=\"actions.handleKeyDown\" id=\"accordion-item-6\" class=\"wp-block-accordion-heading__toggle\"><span class=\"wp-block-accordion-heading__toggle-icon\" aria-hidden=\"true\">+</span><span class=\"wp-block-accordion-heading__toggle-title\">Le support des ancres demande un peu de code <bdo lang=\"en\" dir=\"ltr\">custom</bdo></span></button></h3>\n\n\n\n<div aria-labelledby=\"accordion-item-6\" data-wp-bind--inert=\"!state.isOpen\" id=\"accordion-item-6-panel\" role=\"region\" class=\"wp-block-accordion-panel is-layout-flow wp-block-accordion-panel-is-layout-flow\">\n<p>Il n&rsquo;est pas facilement possible de faire un lien ancre vers une section de l&rsquo;accordéon qui mène vers son contenu déplié. Enfin si, c&rsquo;est techniquement possible évidemment, mais cela nécessite un peu de JS pour déplier le panneau de section correspondant dans le cas où le lien contient une ancre vers l&rsquo;élément de l&rsquo;accordéon.</p>\n\n\n\n<p>Par défaut, les ancres fonctionnent correctement puisqu&rsquo;elles renvoient bien vers la section courante. Mais le panneau reste replié. Ce serait bien qu&rsquo;un comportement JS natif puisse s&rsquo;assurer de déplier le contenu correspondant.</p>\n\n\n\n<p>C&rsquo;est par exemple le cas si je fais un lien vers un critère sur le site officiel du Référentiel Général d&rsquo;Amélioration de l&rsquo;Accessibilité. Exemple avec <a href=\"https://accessibilite.numerique.gouv.fr/methode/criteres-et-tests/#fr-9.1\">un lien vers le test 9.1.1 du critère 9.1</a>&nbsp;: la section correspondante est bien dépliée automatiquement.</p>\n\n\n\n<p>Pour cela, il faudra (pour l&rsquo;instant) ajouter un peu de JS à votre thème&nbsp;!</p>\n\n\n\n<p>Dans cet article, j&rsquo;ai mis en œuvre un petit script qui permet de déplier le panneau s&rsquo;il est ciblé dans l&rsquo;URL : <a href=\"https://whodunit.consulting/?p=4697#accordion-item-7-panel\" target=\"_blank\" rel=\"noreferrer noopener\">cliquer sur ce lien pour tester une ancre (cela rechargera la page dans un nouvel onglet et dépliera le panneau ciblé)</a>.</p>\n\n\n\n<p>Voici le code JS associé&nbsp;: </p>\n\n\n\n<pre class=\"wp-block-code\" style=\"font-size:0.6rem\"><code>&lt;script&gt;\n(function() {\n	function highlightAndOpenAccordion() {\n		const previouslyHighlighted = document.querySelector(\'.accordion-item-highlighted\');\n		if (previouslyHighlighted) {\n			previouslyHighlighted.classList.remove(\'accordion-item-highlighted\');\n		}\n		const hash = window.location.hash;\n		if (!hash) return;\n	 		try {\n				const targetPanel = document.querySelector(hash);\n				if (targetPanel &amp;&amp; targetPanel.matches(\'.wp-block-accordion-panel\')) {\n					const targetSection = targetPanel.closest(\'.wp-block-accordion-item\');\n					if (!targetSection) return;\n						targetSection.classList.add(\'accordion-item-highlighted\');\n						const button = targetSection.querySelector(\'.wp-block-accordion-heading__toggle\');\n						if (button) {\n							const isExpanded = button.getAttribute(\'aria-expanded\') === \'true\';\n							if (!isExpanded) {\n								button.setAttribute(\'aria-expanded\', true);\n							}\n						}\n					setTimeout(() =&gt; {\n						targetPanel.removeAttribute( \'inert\' );\n						targetSection.scrollIntoView({ behavior: \'smooth\', block: \'start\' });\n					}, 100); \n				}\n			} catch (e) {\n				console.warn(\"Anchor not found:\", e);\n		}\n	}\n	document.addEventListener(\'DOMContentLoaded\', highlightAndOpenAccordion);\n	window.addEventListener(\'hashchange\', highlightAndOpenAccordion);\n})();\n&lt;/script&gt;</code></pre>\n</div>\n</div>\n\n\n\n<div data-wp-class--is-open=\"state.isOpen\" data-wp-context=\"{ &quot;id&quot;: &quot;accordion-item-7&quot;, &quot;openByDefault&quot;: false }\" data-wp-init=\"callbacks.initAccordionItems\" class=\"wp-block-accordion-item is-layout-flow wp-block-accordion-item-is-layout-flow\">\n<h3 class=\"wp-block-accordion-heading\"><button aria-expanded=\"false\" aria-controls=\"accordion-item-7-panel\" data-wp-bind--aria-expanded=\"state.isOpen\" data-wp-on--click=\"actions.toggle\" data-wp-on--keydown=\"actions.handleKeyDown\" id=\"accordion-item-7\" class=\"wp-block-accordion-heading__toggle\"><span class=\"wp-block-accordion-heading__toggle-icon\" aria-hidden=\"true\">+</span><span class=\"wp-block-accordion-heading__toggle-title\">Le support des notes de bas de page ne fonctionne pas vraiment</span></button></h3>\n\n\n\n<div aria-labelledby=\"accordion-item-7\" data-wp-bind--inert=\"!state.isOpen\" id=\"accordion-item-7-panel\" role=\"region\" class=\"wp-block-accordion-panel is-layout-flow wp-block-accordion-panel-is-layout-flow\">\n<p>C&rsquo;est un corrolaire du point précédent&nbsp;: si l&rsquo;on souhaite faire un lien-ancre vers un texte situé à l&rsquo;intérieur du contenu d&rsquo;un panneau de notre accordéon, alors le lien est bien fonctionnel, mais si le panneau est fermé, alors on ne voit pas ce texte.</p>\n\n\n\n<p>Pour illustrer ce bug, descendez en bas de cet article et cliquez sur n&rsquo;importe quelle note de bas de page&nbsp;: vous arriverez sur une section refermée sans avoir moyen de l&rsquo;ouvrir si vous utilisez par exemple la navigation clavier ou n&rsquo;importe quelle technologie d&rsquo;assistance. Cela est aussi gênant si vous utiliser la navigation visuelle classique bien entendu.</p>\n</div>\n</div>\n\n\n\n<div data-wp-class--is-open=\"state.isOpen\" data-wp-context=\"{ &quot;id&quot;: &quot;accordion-item-8&quot;, &quot;openByDefault&quot;: false }\" data-wp-init=\"callbacks.initAccordionItems\" class=\"wp-block-accordion-item is-layout-flow wp-block-accordion-item-is-layout-flow\">\n<h3 class=\"wp-block-accordion-heading\"><button aria-expanded=\"false\" aria-controls=\"accordion-item-8-panel\" data-wp-bind--aria-expanded=\"state.isOpen\" data-wp-on--click=\"actions.toggle\" data-wp-on--keydown=\"actions.handleKeyDown\" id=\"accordion-item-8\" class=\"wp-block-accordion-heading__toggle\"><span class=\"wp-block-accordion-heading__toggle-icon\" aria-hidden=\"true\">+</span><span class=\"wp-block-accordion-heading__toggle-title\">Point SEO&nbsp;: le bloc accordéon n&rsquo;est pas un bloc FAQ</span></button></h3>\n\n\n\n<div aria-labelledby=\"accordion-item-8\" data-wp-bind--inert=\"!state.isOpen\" id=\"accordion-item-8-panel\" role=\"region\" class=\"wp-block-accordion-panel is-layout-flow wp-block-accordion-panel-is-layout-flow\">\n<p>Le bloc Accordéon est un bloc intéressant lorsque l&rsquo;on a une longue liste de questions-réponses qu&rsquo;on souhaite pouvoir déplier-replier facilement. Cela permet d&rsquo;avoir plus facilement une vue globale de la page lorsque les questions sont toutes repliées.</p>\n\n\n\n<p>Cependant, le bloc accordéon ne contient aucun balisage sémantique, comme par exemple les schémas standards FAQpage <sup data-fn=\"92bf14e0-6ce2-40d3-8ae7-7e12fb5ba494\" class=\"fn\"><a id=\"92bf14e0-6ce2-40d3-8ae7-7e12fb5ba494-link\" href=\"#92bf14e0-6ce2-40d3-8ae7-7e12fb5ba494\">2</a></sup> ou QApage <sup data-fn=\"3e8c05d1-1855-4042-a417-b9467951bfdf\" class=\"fn\"><a id=\"3e8c05d1-1855-4042-a417-b9467951bfdf-link\" href=\"#3e8c05d1-1855-4042-a417-b9467951bfdf\">3</a></sup> proposés sur schema.org.</p>\n\n\n\n<p>Ces schémas (ou «&nbsp;données structurées&nbsp;») ont pour objectif de proposer un balisage sémantique interprétable par les agents utilisateurs tels que les technologies d&rsquo;assistance, mais ils sont plus connus pour leur capacité à aider les moteurs d&rsquo;indexation à correctement interpréter votre contenu.</p>\n\n\n\n<p>Google en est friand et recommande leur implémentation <sup data-fn=\"d3426e02-7b7d-47f2-914f-46d8a51676c0\" class=\"fn\"><a href=\"#d3426e02-7b7d-47f2-914f-46d8a51676c0\" id=\"d3426e02-7b7d-47f2-914f-46d8a51676c0-link\">4</a></sup>, et c&rsquo;est aussi le cas des moteurs d&rsquo;indexation utilisés par les IA.</p>\n\n\n\n<p>Dans une optique GEO (pour <em><bdo lang=\"en\" dir=\"ltr\">Generative Engine Optimization</bdo></em>, soit optimisation pour les moteurs d&rsquo;indexation des IA génératives), les pages contenant des FAQ sont hyper importantes. C&rsquo;est une évidence puisque les IA ont globalement pour objectif de répondre à des questions en langage naturel. Quoi de mieux qu&rsquo;une page présentant un balisage sémantique en mode questions-réponses pour cela&nbsp;?</p>\n\n\n\n<p>Tout cela n&rsquo;est pas prévu par le bloc natif Accordéon pour une bonne et simple raison&nbsp;: il s&rsquo;agit d&rsquo;un bloc générique qui n&rsquo;a pas vocation à ajouter la moindre sémantique sur vos contenus&nbsp;: il doit être utilisable pour n&rsquo;importe quel contenu même s&rsquo;il ne s&rsquo;agit pas de questions-réponses.</p>\n\n\n\n<p>Il est cependant tout à fait possible d&rsquo;ajouter ces données structurées au bloc Accordéon natif. Ça demande cependant un peu de développement et je propose d&rsquo;en parler dans un prochain article.</p>\n</div>\n</div>\n</div>\n\n\n\n<p>Voilà, j&rsquo;espère que cet article vous en aura appris un peu plus sur le fonctionnement du bloc Accordéon qui est arrivé avec WordPress&nbsp;6.9.</p>\n\n\n\n<p>Si vous voulez suivre les dernières étapes du développement de cette nouvelle version de WP, vous pouvez <a href=\"https://make.wordpress.org/core/\">consulter le blog officiel <bdo lang=\"en\" dir=\"ltr\">Make/Core</bdo></a> sur lequel nous partageons régulièrement les avancées techniques du CMS. </p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" //>\n\n\n\n<h2 class=\"wp-block-heading has-small-font-size\">Notes et références</h2>\n\n\n<ol class=\"wp-block-footnotes\"><li id=\"892f0416-b38a-49d9-94f5-8963b9352748\">Voir <a href=\"https://www.w3.org/WAI/ARIA/apg/patterns/accordion/examples/accordion/\">l&rsquo;exemple d&rsquo;implémentation du motif « accordion » sur le site « ARIA Authoring Practices Guide (APG) » du W3C</a> <a href=\"#892f0416-b38a-49d9-94f5-8963b9352748-link\" aria-label=\"Aller à la note de bas de page 1\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/21a9.png\" alt=\"↩\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //>︎</a></li><li id=\"92bf14e0-6ce2-40d3-8ae7-7e12fb5ba494\">Voir le <a href=\"https://schema.org/FAQPage\">schéma FAQpage sur schema.org</a> <a href=\"#92bf14e0-6ce2-40d3-8ae7-7e12fb5ba494-link\" aria-label=\"Aller à la note de bas de page 2\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/21a9.png\" alt=\"↩\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //>︎</a></li><li id=\"3e8c05d1-1855-4042-a417-b9467951bfdf\">Voir le <a href=\"https://schema.org/QAPage\">schéma QApage sur schema.org</a> <a href=\"#3e8c05d1-1855-4042-a417-b9467951bfdf-link\" aria-label=\"Aller à la note de bas de page 3\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/21a9.png\" alt=\"↩\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //>︎</a></li><li id=\"d3426e02-7b7d-47f2-914f-46d8a51676c0\">Voir par exemple la <a href=\"https://developers.google.com/search/docs/appearance/structured-data/faqpage?hl=fr\">documentation de Google concernant la mise en place de données structurées pour les pages de FAQ</a> <a href=\"#d3426e02-7b7d-47f2-914f-46d8a51676c0-link\" aria-label=\"Aller à la note de bas de page 4\"><img src=\"https://s.w.org/images/core/emoji/17.0.2/72x72/21a9.png\" alt=\"↩\" class=\"wp-smiley\" style=\"height: 1em;max-height: 1em\" //>︎</a></li></ol><p>L’article <a href=\"https://whodunit.consulting/tout-savoir-sur-le-bloc-accordeon-de-wordpress-6-9/\">Tout savoir sur le bloc Accordéon de WordPress 6.9</a> est apparu en premier sur <a href=\"https://whodunit.consulting\">Whodunit Consulting</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"Jean-Baptiste Audras\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://whodunit.consulting/category/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Whodunit Consulting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:4;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"https://wpfr.net/journee-de-contribution-du-wordcamp-nice-2026-presentation-des-tables-episode-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:83:\"Journée de Contribution Nice 2026 : présentation des tables – épisode n°1 !\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:97:\"https://wpfr.net/journee-de-contribution-du-wordcamp-nice-2026-presentation-des-tables-episode-1/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-07T07:30:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-07T07:30:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:373:\"Ça vous aura peut-être échappé, entre la fin des projets 2025, les diverses festivités de fin d’année, les congés de rigueur… mais les inscriptions sont ouvertes pour la journée de contribution du WordCamp Nice 2026 !  Après vous être bien reposés, nous vous invitons à vous projeter sur cette nouvelle année pleine de promesses, de nouveauxLire la suite\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:5111:\"\n        \n<p class=\"has-medium-font-size\">Ça vous aura peut-être échappé, entre la fin des projets 2025, les diverses festivités de fin d’année, les congés de rigueur… mais <a href=\"https://wpfr.net/journee-de-contribution-nice-2026-les-inscriptions-sont-ouvertes/\"><strong>les inscriptions sont ouvertes pour la journée de contribution du WordCamp Nice 2026</strong></a>&nbsp;!&nbsp;</p>\n\n\n\n<p class=\"has-medium-font-size\">Après vous être bien reposés, nous vous invitons à vous projeter sur cette nouvelle année pleine de promesses, de nouveaux événements, de retrouvailles… bref, pleine de WordPress !</p>\n\n\n\n<p class=\"has-medium-font-size\">Pour rappel, la Journée de Contribution a lieu <strong>la veille du WordCamp Nice</strong>, soit <strong>le 5 mars 2026</strong>.&nbsp;</p>\n\n\n\n<p class=\"has-medium-font-size\">Pour vous aider à vous projeter et finir de vous convaincre de nous rejoindre, nous allons publier ces prochains jours quelques informations sur les tables de contribution prévues… Préparez-vous !&nbsp;</p>\n\n\n\n<p class=\"has-medium-font-size\">Et pour commencer, deux premières tables pour ce teasing de début d’année !</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" //>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"table-contribution-a-la-pattern-library\"><strong>Table «&nbsp;Contribution à la Pattern library&nbsp;»</strong></h2>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p class=\"has-medium-font-size\">À cette table, pas besoin de connaître une langue étrangère, de savoir coder ou transférer des fichiers. On va créer ensemble des compositions Gutenberg et les soumettre via formulaire à <a href=\"http://wordpress.org/\">WordPress.org</a>.</p>\n\n\n\n<p class=\"has-medium-font-size\">Si vous ne maitrisez pas Gutenberg, ce n&rsquo;est pas grave, vous apprendrez et pourrez être force de proposition dans les choix de compositions à créer.</p>\n\n\n\n<p class=\"has-medium-font-size\">Vous apprendrez entre autres à créer une composition « passe-partout », responsive et utile.<br>Et si nos compositions ne sont pas acceptées, elles viendront pourquoi pas compléter une librairie française de compositions libre d&rsquo;accès.</p>\n<cite><strong>Eddy BOELS</strong></cite></blockquote>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" //>\n\n\n\n<h2 class=\"wp-block-heading\" id=\"table-coeur-de-wordpress\"><strong>Table «&nbsp;Cœur de WordPress&nbsp;»</strong></h2>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p class=\"has-medium-font-size\">Ta mission si tu l&rsquo;acceptes est d&rsquo;apprendre à contribuer au logiciel que tu utilises au quotidien. Nul besoin d&rsquo;être développeur ou développeuse pour contribuer&nbsp;! </p>\n\n\n\n<p class=\"has-medium-font-size\">Durant cette journée :</p>\n\n\n\n<ul class=\"wp-block-list has-medium-font-size\">\n<li>On te guidera sur l&rsquo;installation de l&rsquo;environement de développement.</li>\n\n\n\n<li>On te montrera comment proposer un correctif.</li>\n\n\n\n<li>On t&rsquo;expliquera comment fonctionne le Core (nul besoin d’être dev)</li>\n\n\n\n<li>Tu apprendras aussi à remonter un bug (ah ben la non plus !)</li>\n\n\n\n<li>Tu pourras même tester des correctifs déjà codés (et pour ça toujours pas besoin d&rsquo;être dev).</li>\n</ul>\n\n\n\n<p class=\"has-medium-font-size\">Surtout, tu auras la joie et le bonheur de partager une journée avec des gens cools (même si certains ou certaines sont développeurs ou développeuses :p )</p>\n<cite><strong>Sébastien SERRE et Antoine SIRVEN</strong></cite></blockquote>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" //>\n\n\n\n<p class=\"has-medium-font-size\">Alors ? Tenté ? <a href=\"https://framaforms.org/inscription-contributeur-journee-de-contribution-nice-1764833418\">Les inscriptions sont par ici</a>, et si tu ne trouves pas ta place dans ces 2 tables, reste à l’écoute car d’autres articles arrivent pour présenter les autres tables !&nbsp;</p>\n\n\n\n<div style=\"height:16px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-16018d1d wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button is-style-fill\"><a class=\"wp-block-button__link has-white-color has-vivid-cyan-blue-background-color has-text-color has-background has-link-color has-medium-font-size has-text-align-center has-custom-font-size wp-element-button\" href=\"https://framaforms.org/inscription-contributeur-journee-de-contribution-nice-1764833418\" target=\"_blank\" rel=\"noreferrer noopener\">Je m’inscris</a></div>\n</div>\n\n\n\n<div style=\"height:16px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-medium-font-size\">Tu souhaites proposer et animer une autre table ? C’est toujours possible, n’hésite pas à <a href=\"mailto:contribution@wpfr.net\">nous envoyer un mail pour en discuter</a>.&nbsp;</p>\n\n\n\n<p class=\"has-text-align-right has-medium-font-size\"><em>Les organisateurs de la Journée de Contribution</em></p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Jenny Dupuy\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"https://wpfr.net/actualites/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"WPFR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:5;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://kinsta.com/fr/blog/effets-magiques-wordpress-blocs-coeur/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"Comment créer des effets magiques dans WordPress avec des blocs du cœur\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:65:\"https://kinsta.com/fr/blog/effets-magiques-wordpress-blocs-coeur/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-06T07:51:58.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2026-01-06T07:51:58.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:277:\"La plupart des utilisateurs de WordPress ne réalisent pas à quel point l’éditeur de blocs a évolué. Les blocs de base tels que Couverture, Groupe, Colonnes ...\nThe post Comment créer des effets magiques dans WordPress avec des blocs du cœur appeared first on Kinsta®.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:426:\"\n        <p>La plupart des utilisateurs de WordPress ne réalisent pas à quel point l&#8217;éditeur de blocs a évolué. Les blocs de base tels que Couverture, Groupe, Colonnes ...</p>\n<p>The post <a href=\"https://kinsta.com/fr/blog/effets-magiques-wordpress-blocs-coeur/\">Comment créer des effets magiques dans WordPress avec des blocs du cœur</a> appeared first on <a href=\"https://kinsta.com/fr\">Kinsta®</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joel Olawanle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://kinsta.com/fr/sujets/developpement-wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Kinsta\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:6;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:89:\"https://beapi.fr/blog/securite-wordpress-comprendre-les-failles-pour-mieux-les-maitriser/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Sécurité WordPress : comprendre les failles pour mieux les maîtriser\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:89:\"https://beapi.fr/blog/securite-wordpress-comprendre-les-failles-pour-mieux-les-maitriser/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-12-10T10:59:20.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-12-10T10:59:20.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:497:\"1. Démystifier les failles : un phénomène parfois mal interprété « 8 millions de cyberattaques contre des sites WordPress », « Une faille critique dans un plugin populaire », «Cette vulnérabilité expose 400 000 sites »… Si vous suivez de l’actualité tech, vous avez forcément croisé ce type d’alertes. Le mot faille intervient dès qu’une vulnérabilité technique […]\nThe post Sécurité WordPress : comprendre les failles pour mieux les maîtriser appeared first on .\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:16726:\"\n        \n<h2 class=\"wp-block-heading\">1. Démystifier les failles : un phénomène parfois mal interprété</h2>\n\n\n\n<p>« <em>8 millions de cyberattaques contre des sites WordPress</em> », « <em>Une faille critique dans un plugin populaire</em> », «<em>Cette vulnérabilité expose 400 000 sites</em> »…</p>\n\n\n\n<p>Si vous suivez de l’actualité tech, vous avez forcément croisé ce type d’alertes.</p>\n\n\n\n<p>Le mot <em>faille</em> intervient dès qu’une vulnérabilité technique est identifiée. Un mot chargé, anxiogène, qui suggère souvent une menace imminente. Pourtant, la présence de failles n’a rien d’exceptionnel : c’est le fonctionnement naturel de tout écosystème numérique vivant.</p>\n\n\n\n<p>Les usages évoluent, les dépendances changent et les menaces progressent. Une faille n’est pas forcément un signe de faiblesse : <strong>c’est un signal, qui rappelle qu’une plateforme doit être maintenue, surveillée et régulièrement mise à jour.</strong></p>\n\n\n\n<p>Ce n’est donc pas exceptionnel, même si cela reste un sujet important ! En effet, une faille ignorée peut avoir des conséquences bien réelles qui dépassent le cadre technique, touchant directement à la performance et la réputation de l’entreprise et  pouvant entrainer :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>une interruption de service, </li>\n\n\n\n<li>une perte SEO si le site est compromis,</li>\n\n\n\n<li>des risques RGPD en cas de fuite de données,</li>\n\n\n\n<li>ou une atteinte durable à l’image de marque.</li>\n</ul>\n\n\n\n<p><strong>C’est précisément pour cela que la capacité à identifier, prioriser et corriger une faille est un enjeu déterminant.</strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">2. De quoi parle-t-on exactement ?</h2>\n\n\n\n<p>Une faille de sécurité correspond à une vulnérabilité dans le code, la configuration ou les accès d’un système. Elle signale qu’un point pourrait être exploité.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Une faille</strong> est une vulnérabilité potentielle ;</li>\n\n\n\n<li><strong>Un risque est une faille appréciée au regard du contexte réel</strong> (type de site, données traitées, exposition du service&#8230; ;</li>\n\n\n\n<li><strong>Un incident</strong> correspond à la situation dans laquelle cette faille est effectivement exploitée.</li>\n</ul>\n\n\n\n<p><strong>C’est là que la notion de contexte devient déterminante.</strong></p>\n\n\n\n<p>Pour évaluer la gravité réelle d’une vulnérabilité, les experts s’appuient sur le standard international CVSS, qui attribue une note selon la facilité d’exploitation et l’impact potentiel. Mais cette note reste théorique.</p>\n\n\n\n<p>Deux plateformes confrontées à la même faille n’auront pas le même niveau de risque &#8211; parfois certaines vulnérabilités pourtant sévèrement notées ne sont exploitables que dans des conditions très spécifiques (un contexte projet particulier, un paramétrage serveur précis…), ce qui rend leur exploitation réelle peu probable.</p>\n\n\n\n<h4 class=\"wp-block-heading\">La seule évaluation véritablement pertinente est celle qui croise la vulnérabilité avec la réalité opérationnelle du projet.</h4>\n\n\n\n<p>C&rsquo;est précisément cette lecture contextualisée qui évite les réactions intempestives, tout en garantissant que les failles réellement critiques soient identifiées et traitées en priorité.</p>\n\n\n\n<h2 class=\"wp-block-heading\">3. WordPress est-il moins sécurisé qu’une autre technologie ? Un mythe à déconstruire</h2>\n\n\n\n<p>La réputation de WordPress en matière de sécurité reste encore teintée par son histoire. À ses débuts, le CMS servait surtout à créer des blogs personnels, souvent installés sans hébergement adapté, sans maintenance et sans véritable gouvernance technique. Cette image lui colle encore à la peau, alors même que l’écosystème a profondément évolué.</p>\n\n\n\n<p>Aujourd’hui, WordPress propulse plus de 40 % du web, y compris des plateformes gouvernementales, des portails à fort trafic ou des projets aux exigences de sécurité élevées. Son code est examiné en continu, audité plus que n’importe quel autre CMS, et les correctifs sont publiés très vite (parfois en moins de 48 heures pour une faille critique.)</p>\n\n\n\n<h3 class=\"wp-block-heading\">Dans l’univers WordPress, les principales sources de vulnérabilité sont bien identifiées :</h3>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Le noyau WordPress</strong> </h4>\n\n\n\n<p>Les failles du core sont rares, et elles sont corrigées rapidement. Le CMS bénéficie d’une équipe sécurité dédiée et d’un code source totalement ouvert, analysé en continu par des milliers de développeurs.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Les extensions et les thèmes tiers</strong> </h4>\n\n\n\n<p>C’est ici que se concentre l’essentiel des vulnérabilités : plus de 96 % des failles recensées concernent des extensions tierces &#8211; projets abandonnés, dépendances non maintenues, qualité parfois douteuse…</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Les configurations serveur et administrateur</strong> </h4>\n\n\n\n<p>Une clé API laissée en clair, un accès FTP ouvert, un répertoire exposé… Ces erreurs de configuration, généralement invisibles, créent pourtant de véritables points d’entrée.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Le facteur humain</strong> </h4>\n\n\n\n<p>Mots de passe faibles, pas d’authentification à deux facteurs, multiplication des comptes administrateurs&#8230; Dans de nombreux incidents, la vulnérabilité ne vient pas du code, mais des usages.</p>\n\n\n\n<p></p>\n\n\n\n<p>Ainsi, dans la grande majorité des incidents, la responsabilité n’incombe pas au CMS lui-même, mais à l’écosystème dans lequel il évolue. Un dernier point, souvent mal compris, mérite d’être souligné :</p>\n\n\n\n<figure class=\"wp-block-pullquote\"><blockquote><p>Si l’on découvre tant de failles dans l’écosystème WordPress, ce n’est pas qu’il est moins sécurisé : c&rsquo;est qu’il est davantage étudié. Son code ouvert est inspecté et audité en continu par des milliers de développeurs.</p></blockquote></figure>\n\n\n\n<p>Le fameux « quand on cherche, on trouve » (ce qui est précisément un signe de bonne santé pour un projet open source.) Ce modèle de transparence crée un effort collectif permanent : détection précoce, documentation rapide, correctifs publiés publiquement et amélioration continue.</p>\n\n\n\n<p>Cette dynamique ne fragilise pas WordPress, <strong>elle renforce sa sécurité dans le temps</strong>.</p>\n\n\n\n<h2 class=\"wp-block-heading\">4. Le facteur déterminant : une gouvernance solide</h2>\n\n\n\n<p>La sécurité d’une plateforme ne dépend jamais uniquement de la technologie sur laquelle elle repose. Deux projets utilisant WordPress, Drupal ou une solution propriétaire peuvent proposer des niveaux de sécurité radicalement différents. La différence se joue <strong>dans la manière dont la plateforme est pilotée, entretenue et structurée dans le temps</strong>. </p>\n\n\n\n<figure class=\"wp-block-pullquote\"><blockquote><p>Une gouvernance solide n’empêche pas les failles d’exister. En revanche, elle crée les conditions pour les détecter tôt, les corriger vite et éviter qu’une vulnérabilité mineure ne devienne un incident majeur.</p></blockquote></figure>\n\n\n\n<p>Cette gouvernance repose sur plusieurs piliers complémentaires :</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Un cadre clair pour la maintenance et la prise de décision</strong></h4>\n\n\n\n<p>Revue de code régulière, TMA structurée, responsabilités définies, documentation mise à jour… Ces éléments évitent les angles morts et garantissent que les décisions techniques ne reposent jamais sur l’intuition ou l’urgence.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Une gestion rigoureuse des accès</strong></h4>\n\n\n\n<p>Rôles attribués avec précision, authentification à deux facteurs, rotation des mots de passe, procédures pour les comptes temporaires… Une bonne gestion des accès protège autant qu’un correctif de sécurité, et parfois davantage.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Une stack technique maîtrisée</strong></h4>\n\n\n\n<p>Un hébergement sécurisé, des sauvegardes fiables, une supervision active, un environnement de préproduction pour tester sereinement : ce socle technique conditionne la capacité d’une plateforme à résister, absorber, puis corriger un incident sans rupture.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>Une coordination fluide entre les équipes</strong></h4>\n\n\n\n<p>Développeurs, RUN et équipes métier partagent une vision commune du niveau de risque acceptable, des priorités et des actions à mener lorsqu’une alerte survient. Cette coopération est souvent la frontière entre un incident contenu et une crise durable.</p>\n\n\n\n<p>C’est cette culture, plus que la technologie en elle-même, qui fait la différence entre un site qui « fonctionne » et une plateforme réellement fiable.</p>\n\n\n\n<h2 class=\"wp-block-heading\">5. Anticiper, détecter, corriger : une sécurité pilotée</h2>\n\n\n\n<p>En matière de sécurité, tout se joue dans la méthode : repérer tôt, analyser correctement et agir sans précipitation.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Une veille active pour ne rien laisser passer</h3>\n\n\n\n<p>Une bonne pratique consiste à s’appuyer sur plusieurs niveaux :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>des outils spécialisés</strong> (Patchstack, WPScan, Wordfence), qui identifient et recensent les vulnérabilités et les classent selon leur criticité ;</li>\n\n\n\n<li><strong>la communauté open source</strong>, souvent la plus rapide à remonter un comportement suspect ou à proposer un correctif ;</li>\n\n\n\n<li><strong>une veille interne,</strong> où les équipes documentent les alertes et partagent leurs retours d’expérience.</li>\n</ul>\n\n\n\n<p>Cette approche croisée propose une vision étendue de l’écosystème, du plugin le plus répandu à la dépendance la plus discrète.</p>\n\n\n\n<h3 class=\"wp-block-heading\">Du signal à la correction</h3>\n\n\n\n<p>Lorsqu’une faille est détectée, l’objectif est d&rsquo;agir sans bloquer le reste du projet. C’est là qu&rsquo;un bon process devient essentiel. </p>\n\n\n\n<p>Chez Be API, une séquence éprouvée s’enclenche automatiquement :</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><strong>Détection automatisée via les outils de veille </strong></li>\n\n\n\n<li><strong>Création d’un ticket pour assurer la traçabilité </strong></li>\n\n\n\n<li><strong>Analyse et classification interne </strong></li>\n\n\n\n<li><strong>Évaluation technique : cause, impact, options possibles </strong></li>\n\n\n\n<li><strong>Information du client, avec un message clair et contextualisé </strong></li>\n\n\n\n<li><strong>Correctif et tests en préproduction</strong> </li>\n\n\n\n<li><strong>Déploiement et vérification finale</strong>.</li>\n</ol>\n\n\n\n<p>Cette méthodologie garantit une action rapide et proportionnée.</p>\n\n\n\n<h3 class=\"wp-block-heading\">L’importance de la contextualisation</h3>\n\n\n\n<p>Comme mentionné plus haut, aucune corrélation directe n&rsquo;existe entre le score théorique d’une faille et l’urgence d’agir. Une vulnérabilité classée « critique » peut s’avérer sans conséquence sur un site peu exposé, et une faille mineure peut devenir problématique selon son contexte réel d’usage.</p>\n\n\n\n<figure class=\"wp-block-pullquote\"><blockquote><p>D’où l’importance de ne jamais se fier uniquement à l’outil : ce sont les humains qui, en connaissant le projet, peuvent évaluer ce qui doit être traité immédiatement et ce qui relève du suivi classique.</p></blockquote></figure>\n\n\n\n<p>Chaque cas est discuté : faut-il patcher manuellement ou remplacer une extension obsolète ? Peut-on déployer immédiatement ou faut-il une recette complète ? La mise à jour est-elle compatible avec un contexte métier particulier ?</p>\n\n\n\n<p>Ces arbitrages se font en équipe, en croisant les expertises techniques, fonctionnelles et métier. </p>\n\n\n\n<h3 class=\"wp-block-heading\">La communication comme gage de confiance</h3>\n\n\n\n<p>Corriger une faille est une chose. Communiquer correctement autour de cet événement en est une autre. Une communication claire et factuelle évite les inquiétudes inutiles et crée un cadre de confiance avec le client.</p>\n\n\n\n<p>Les informations transmises sont :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Claires</strong> : pas de jargon technique sans explication.</li>\n\n\n\n<li><strong>Contextualisées</strong> : ce qui est concerné, ce qui ne l’est pas, ce qui a été fait.</li>\n\n\n\n<li><strong>Responsables</strong> : pas d&rsquo;alarmisme, pas de minimisation.</li>\n</ul>\n\n\n\n<p>Une faille bien encadrée n’abîme pas la relation client, et pour cause, <strong>la sécurité n’est pas un sujet tabou</strong>, mais un engagement assumé de transparence et de rigueur.</p>\n\n\n\n<h2 class=\"wp-block-heading\">6. Maintenance, mises à jour et prévention</h2>\n\n\n\n<p>La sécurité évolue, au même titre que les technologies, les usages, les dépendances, etc&#8230; Ce n&rsquo;est pas projet que l’on initie, puis clôture : <strong>c’est un processus continu, un engagement du quotidien.</strong></p>\n\n\n\n<p>Pour conserver un niveau de protection optimal, deux types de mises à jour doivent être mises en place :</p>\n\n\n\n<h4 class=\"wp-block-heading\">1. Les montées de version structurantes (souvent annuelles)</h4>\n\n\n\n<p>Elles modernisent le socle, intègrent les évolutions majeures du CMS, assurent la compatibilité avec les nouvelles API et permettent de remettre la plateforme à niveau.</p>\n\n\n\n<p>Elles sont essentielles pour éviter les écarts trop importants, qui finissent par bloquer l’accès à certains correctifs et évolutions.</p>\n\n\n\n<h4 class=\"wp-block-heading\"><strong>2. Les mises à jour de sécurité régulières</strong></h4>\n\n\n\n<p>Plus légères mais tout aussi indispensables, elles corrigent les vulnérabilités dès qu’elles sont publiées et évitent que les risques ne s’accumulent dans le temps. Ignorer ces mises à jour de sécurité, c’est comme négliger l’entretien d’une voiture : tout fonctionne… jusqu’au moment où un détail finit par provoquer l’incident que l’on aurait pu éviter.</p>\n\n\n\n<figure class=\"wp-block-pullquote\"><blockquote><p>Ces deux types de mises à jour s’inscrivent dans une approche plus large : la <strong>maintenance préventive</strong>. Elle repose sur une supervision globale de la plateforme, un suivi automatisé des anomalies et des interventions dès les premiers signaux faibles. </p></blockquote></figure>\n\n\n\n<p>Enfin, assurer la sécurité d’un site n’est pas le rôle d’une seule personne, ni même d’un seul métier. <strong>C’est une chaîne de responsabilités </strong>qui mobilise plusieurs expertises :</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>Les développeurs</strong>, qui produisent un code propre, auditable et maintenable.</li>\n\n\n\n<li><strong>Les équipes de maintenance</strong>, qui supervisent, maintiennent et documentent les évolutions dans le temps.</li>\n\n\n\n<li><strong>L’équipe métier</strong>, qui apporte le contexte nécessaire pour prendre les bonnes décisions.</li>\n</ul>\n\n\n\n<p>C&rsquo;est ce dialogue continu qui garantit un niveau de sécurité stable, sans freiner la capacité d’évolution.</p>\n\n\n\n<h2 class=\"wp-block-heading\">7. En conclusion : la sécurité est un engagement, partagé et continu</h2>\n\n\n\n<p><strong>Aucun site n’est totalement dépourvu de failles : l’enjeu n’est donc pas de viser l’infaillibilité, mais de s’assurer que la plateforme dispose de garde-fous solides, d’une gouvernance claire et d’une maintenance structurée</strong>.</p>\n\n\n\n<p>C’est un travail continu, qui repose autant sur des pratiques éprouvées que sur la coordination des équipes, la qualité du code et une culture commune de la vigilance. </p>\n\n\n\n<h3 class=\"wp-block-heading\">👉 Vous avez un doute sur le niveau de sécurité de votre plateforme WordPress ?</h3>\n\n\n\n<p>Prenez 30 minutes avec un expert sécurité Be API !</p>\n\n\n\n<div class=\"wp-block-buttons is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://beapi.fr/contact/\">Réserver un appel gratuit</a></div>\n</div>\n<p>The post <a href=\"https://beapi.fr/blog/securite-wordpress-comprendre-les-failles-pour-mieux-les-maitriser/\">Sécurité WordPress : comprendre les failles pour mieux les maîtriser</a> appeared first on <a href=\"https://beapi.fr\"></a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Alizée Ragoin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://beapi.fr/blog/categories/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"BeAPI\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:7;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://www.youtube.com/watch?v=r3ym5-pRxrk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"J’ai testé WordPress 6.9 pendant 2 heures : Voici ce que j’ai retenu.\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:43:\"https://www.youtube.com/watch?v=r3ym5-pRxrk\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-12-05T09:30:18.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-12-05T09:30:18.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:540:\"WordPress 6.9 est officiellement disponible depuis le 2 décembre 2024 ! Dans cette vidéo, je te fais découvrir TOUTES les nouveautés : les nouveaux blocs (accordéon, formules mathématiques, temps de lecture), les améliorations collaboratives, les optimisations de performance et bien plus encore. Tu vas pouvoir tester en direct chaque fonctionnalité et comprendre comment les intégrer […]\nL’article J’ai testé WordPress 6.9 pendant 2 heures : Voici ce que j’ai retenu. est apparu en premier sur Agence WordPress Whodunit.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:677:\"\n        <p>WordPress 6.9 est officiellement disponible depuis le 2 décembre 2024 ! Dans cette vidéo, je te fais découvrir TOUTES les nouveautés : les nouveaux blocs (accordéon, formules mathématiques, temps de lecture), les améliorations collaboratives, les optimisations de performance et bien plus encore. Tu vas pouvoir tester en direct chaque fonctionnalité et comprendre comment les intégrer [&#8230;]</p>\n<p>L’article <a href=\"https://www.youtube.com/watch?v=r3ym5-pRxrk\">J&rsquo;ai testé WordPress 6.9 pendant 2 heures : Voici ce que j&rsquo;ai retenu.</a> est apparu en premier sur <a href=\"https://www.whodunit.fr\">Agence WordPress Whodunit</a>.</p>\n\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Eddy BOELS\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://www.whodunit.fr/videos/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Whodunit Videos\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:8;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://holdmywp.com/benchmark-hosterra/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"Hosterra – Test de performance pour WordPress, Benchmark\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:40:\"https://holdmywp.com/benchmark-hosterra/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-11-20T11:09:32.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-11-20T11:09:32.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:147:\"Pour un avoir un aperçu clair des performances réelles d\'un hébergement Hosterra, j\'ai testé chaque offre avec l\'outil Hosting Benchmark Tools.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:16952:\"\n        \n<p>Hosterra est un hébergeur que j&rsquo;ai découvert au <a href=\"https://bretagne.wordcamp.org/2024/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Wordcamp Bretagne\">Wordcamp Bretagne</a> à Rennes en 2024, où j&rsquo;ai rencontré <a href=\"https://pierre.lannoy.fr/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Pierre Lannoy\">Pierre Lannoy</a> qui venait nous parler <a href=\"https://wordpress.tv/2024/11/02/dites-non-au-green-washing-hebergez-reellement-ecoresponsable/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"d\'hébergement écoresponsable\">d&rsquo;hébergement écoresponsable</a>. Aujourd&rsquo;hui, Hosterra est l&rsquo;hébergeur que je recommande à mes clients et avec lequel je travaille pour <a href=\"https://holdmywp.com/maintenance-wordpress/\" title=\"Maintenance WordPress\">mon service de maintenance et d&rsquo;hébergement WordPress</a>.</p>\n\n\n\n<p>Une seule offre d&rsquo;hébergement web testée ici pour le moment, celle que j&rsquo;utilise : l&rsquo;<strong>hébergement mutualisé Hosterra</strong>. Pour un avoir un aperçu clair des performances réelles, j&rsquo;ai testé l&rsquo;offre avec l&rsquo;outil <strong>Hosting Benchmark Tools</strong>. Comme pour les <a href=\"https://holdmywp.com/hebergement-wordpress/\" title=\"Hébergement WordPress\">autres benchmarks réalisés</a>, l&rsquo;instance WordPress testée est vierge avec le même thème, les mêmes extensions et seule sur son hébergement.</p>\n\n\n\n<p>La promesse : <a href=\"https://hosterra.eu/fr/store/shared-hosting/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"un hébergement performant et écoresponsable\"><em>un hébergement performant et tout en étant écoresponsable</em></a>. Voyons ça.</p>\n\n\n<h2 class=\"wp-block-heading\" id=\"approche-et-methodologie-devaluation-dun-hebergement-wordpress\">Approche et méthodologie d&rsquo;évaluation d&rsquo;un hébergement WordPress</h2>\n\n<h3 class=\"wp-block-heading\" id=\"objectif\">Objectif</h3>\n\n\n<p>Cette publication n&rsquo;est pas une énième copie des listes de caractéristiques longues comme le bras affichées sur les pages de vente des hébergeurs, mais un focus sur ce qui compte pour faire un <a href=\"https://holdmywp.com/maintenance-wordpress/\" title=\"Maintenance WordPress\">bon hébergement WordPress</a> : <strong>Performance</strong>, <strong>Efficience</strong>, <strong>Robustesse</strong>.</p>\n\n\n<h3 class=\"wp-block-heading\" id=\"unites-de-mesure\">Unités de mesure</h3>\n\n\n<p>Soyons honnêtes, quels que soient les hébergeurs, c&rsquo;est toujours la guerre des gros chiffres, quand on compare les offres, on jongle entre les Bytes, les Octets et les Bits (C&rsquo;est assez classique sur l&rsquo;affichage de la bande passante). Sur cette publication en français, <strong>je convertis les valeurs en Octets</strong> pour éviter les confusions.</p>\n\n\n<h3 class=\"wp-block-heading\" id=\"renouvellement\">Renouvellement</h3>\n\n\n<p>Les tarifs affichés reflètent le coût annuel en cas de renouvellement standard, sans tenir compte des promotions ponctuelles ou des réductions d’entrée. L&rsquo;objectif ici étant d’évaluer le coût réel de l’<strong>hébergement</strong> sur le moyen et long terme, après la première année. En optant pour un engagement pluriannuel (2, 3 ans ou plus), certains hébergeurs proposent des tarifs mensuels réduits, ce qui peut diminuer le coût global sur la durée. Le tarif annuel TTC indiqué, correspond dans cet article à un renouvellement effectué une fois par an.</p>\n\n\n<h3 class=\"wp-block-heading\" id=\"consommation-annoncee-efficacite-energetique\">Consommation annoncée / efficacité énergétique</h3>\n\n\n<p>Les hébergeurs web communiquent de plus en plus sur leurs <strong>démarches écologiques</strong>. Entre les promesses de compensation carbone, les datacenters « verts », les labels et touti quanti&#8230; on tombe vite dans le <strong>greenwashing</strong>. Les annonces se concentrent souvent sur l’empreinte carbone, l’utilisation d’énergies renouvelables ou l’optimisation des infrastructures, mais rarement sur l’impact réel d’un hébergement web au quotidien. <strong>Corréler les performances mesurées sur une instance WordPress avec sa consommation en eau et électricité</strong> (bien entendu, non produite par des énergies fossiles) me semble une bonne approche.</p>\n\n\n\n<div class=\"wp-block-group has-border-color has-yellow-border-color has-fg-2-color has-bg-1-background-color has-text-color has-background has-link-color has-small-font-size wp-elements-b292714650cbbe2c27f65af0a6b0ee6b has-global-padding is-layout-constrained wp-container-core-group-is-layout-52009084 wp-block-group-is-layout-constrained\" style=\"border-width:1px;border-radius:2px;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)\"><h4 class=\"wp-block-heading has-yellow-color has-text-color has-link-color wp-elements-1b6bd9551751042e5dbe4a9ce2cfa726\" id=\"a-propos-de-la-consommation-annoncee\"><strong>À propos de la consommation annoncée</strong></h4>\n\n\n<p class=\"has-link-color wp-elements-cdee002ef592420c9270a4ab43045d7a\">L&rsquo;hébergement étant mutualisé, les ressources sont partagées entre plusieurs instances. La consommation indiquée correspond à celle de l&rsquo;ensemble du serveur, qu&rsquo;elle soit utilisée seule ou partagée avec d&rsquo;autres comptes. En raison des ressources importantes du serveur, la consommation annuelle annoncée est plus élevée que <a href=\"https://hosterra.eu/fr/store/web-hosting/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"celle des VPS\">celle des VPS</a>. Il revient donc à Hosterra de gérer le nombre de comptes par serveur afin d&rsquo;optimiser l&rsquo;utilisation des ressources tout en maintenant de bonnes performances.</p>\n</div>\n\n\n<h3 class=\"wp-block-heading\" id=\"instance-wordpress-testee\">Instance WordPress testée</h3>\n\n\n<p>Un <strong>site WordPress</strong> sur une formule d&rsquo;hébergement web.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>Thème installé actif : <a href=\"https://wordpress.org/themes/generatepress/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"GeneratePress\">GeneratePress</a>.</li>\n\n\n\n<li>Extensions actives : <a href=\"https://wordpress.org/plugins/wpbenchmark/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Hosting Benchmark tool\">Hosting Benchmark tool</a> et <a href=\"https://wordpress.org/plugins/sqlite-object-cache/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"SQLite Object Cache\">SQLite Object Cache</a>.</li>\n\n\n\n<li>Cache objet testé : <a href=\"https://www.php.net/manual/fr/book.apcu.php\" target=\"_blank\" rel=\"noopener nofollow\" title=\"APCu\">APCu</a>.</li>\n\n\n\n<li>PHP : 8.3</li>\n</ul>\n\n\n<h2 class=\"wp-block-heading\" id=\"glossaire\">Glossaire</h2>\n\n\n<p>Petit <strong>glossaire</strong> de base du jargon des <strong>hébergeurs web</strong>.</p>\n\n\n\n<details id=\"glossaire\" class=\"wp-block-details relative has-border-color has-bg-2-border-color has-bg-0-color has-fg-0-background-color has-text-color has-background has-link-color has-medium-font-size wp-elements-6ed834d03b843f14565b81a28df5af88 is-layout-flow wp-container-core-details-is-layout-8a368f38 wp-block-details-is-layout-flow\" style=\"border-width:1px\" open><summary>Consulter le glossaire</summary>\n<div class=\"wp-block-group has-fg-1-color has-bg-1-background-color has-text-color has-background has-link-color has-small-font-size wp-elements-9c7e403135cbcea857d775f42012469b has-global-padding is-layout-constrained wp-container-core-group-is-layout-5bc31a47 wp-block-group-is-layout-constrained\" style=\"border-top-color:var(--wp--preset--color--bg-2);border-top-width:1px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--50)\">\n<ul class=\"wp-block-list\">\n<li><strong>RAM</strong> : Mémoire vive permettant de stocker temporairement les données utilisées par les applications pour un accès rapide.</li>\n\n\n\n<li><strong>CPU</strong> : Unité centrale de traitement, le cerveau du serveur qui exécute les instructions et traite les données.</li>\n\n\n\n<li><strong>vCPU</strong> : CPU virtuel, partie d’un processeur physique allouée à une machine virtuelle pour simuler un processeur dédié.</li>\n\n\n\n<li><strong>NVMe</strong> : Protocole de stockage haute performance pour les disques SSD, optimisé pour réduire la latence et augmenter le débit.</li>\n\n\n\n<li><strong>IO</strong> : Entrées/Sorties (Input/Output), mesure la capacité du serveur à lire/écrire des données sur le disque ou le réseau.</li>\n\n\n\n<li><strong>Bande passante</strong> : Volume maximal de données transférables entre le serveur et les utilisateurs sur une période donnée, souvent exprimé en Gbit/s ou Mo/s.</li>\n\n\n\n<li><strong>Hébergement mutualisé</strong> : Solution où plusieurs sites partagent les ressources d’un même serveur.</li>\n\n\n\n<li><strong>Hébergement VPS</strong> : Serveur privé virtuel offrant des ressources dédiées (CPU, RAM, stockage) au sein d’un serveur physique partagé.</li>\n</ul>\n</div>\n</details>\n\n\n<h2 class=\"wp-block-heading\" id=\"offre-dhebergement-testee\">Offre d&rsquo;hébergement testée</h2>\n\n<h3 class=\"wp-block-heading\" id=\"hosterra-one\">Hosterra One</h3>\n\n<h4 class=\"wp-block-heading\" id=\"informations-sur-loffre\">Informations sur l&rsquo;offre</h4>\n\n\n<ul class=\"wp-block-list\">\n<li>Type d&rsquo;hébergement : Mutualisé</li>\n\n\n\n<li>Tarif au renouvellement annuel (1 mois gratuit inclus) : 75,9€ HT | <strong> 91,08 € TTC</strong></li>\n\n\n\n<li>Consommation annuelle annoncée : <strong>⚡️Électricité &lt; 200 kWh/an</strong>, <strong>🫧Eau &lt; 6.5 l/an</strong></li>\n</ul>\n\n\n<h4 class=\"wp-block-heading\" id=\"ressources-annoncees\">Ressources annoncées</h4>\n\n\n<figure class=\"wp-block-flexible-table-block-table is-scroll-on-pc\"><table class=\"has-fixed-layout is-stacked-on-mobile\"><thead><tr><th>CPU</th><th>Mémoire vive</th><th>Stockage</th><th>Lecture/écriture</th><th>Bande passante</th></tr></thead><tbody><tr><td>8 vCPU</td><td>32 Go RAM</td><td>10 Go sur NVMe</td><td>I/O 256 Mo/s</td><td>125 Mo/s</td></tr></tbody></table></figure>\n\n\n<h4 class=\"wp-block-heading\" id=\"performances-mesurees\">Performances mesurées</h4>\n\n\n<figure class=\"wp-block-flexible-table-block-table is-scroll-on-pc is-scroll-on-mobile\"><table class=\"\"><thead><tr><th>Type</th><th>Fonction</th><th style=\"width:80px\">Score /10</th><th>Temps / Vitesse</th></tr></thead><tbody><tr><td rowspan=\"5\">CPU &amp; Memory</td><td>Operations with large text data</td><td style=\"background-color:#299c29;color:#ffffff\">10</td><td>2.2 sec</td></tr><tr><td>Random binary data operations</td><td style=\"background-color:#7dc516;color:#ffffff\">8.17</td><td>7.2 sec</td></tr><tr><td>Recursive mathematical calculations</td><td style=\"color:#ffffff;background-color:#f88d36\">4.71</td><td>10.9 sec</td></tr><tr><td>Iterative mathematical calculations</td><td style=\"background-color:#299c29;color:#ffffff\">9.34</td><td>1.8 sec</td></tr><tr><td>Floating point operations</td><td style=\"color:#ffffff;background-color:#c3d519\">6.37</td><td>3.6 sec</td></tr><tr><td rowspan=\"3\">Filesystem</td><td>Filesystem write ability</td><td style=\"color:#ffffff;background-color:#81d519\">7.1</td><td>2.9 sec<br>~351 Mo/s</td></tr><tr><td>Local file copy and access speed</td><td style=\"color:#ffffff;background-color:#81d519\">7.79</td><td>2.9 sec<br>~350 Mo/s</td></tr><tr><td>Small file IO test</td><td style=\"color:#ffffff;background-color:#299c29\">9.82</td><td>0.2 sec<br>~473 Mo/s</td></tr><tr><td rowspan=\"3\">Database</td><td>Importing large amount of data to database</td><td style=\"color:#ffffff;background-color:#7dc516\">8.23</td><td>2.4 sec</td></tr><tr><td>Simple queries on single table</td><td style=\"color:#ffffff;background-color:#299c29\">9.54</td><td>0.9 sec</td></tr><tr><td>Complex database queries on multiple tables</td><td style=\"background-color:#81d519;color:#ffffff\">7.59</td><td>3.4 sec</td></tr><tr><td rowspan=\"4\">Object cache</td><td>Persistent object cache enabled</td><td style=\"background-color:#299c29;color:#ffffff\">10</td><td>0 sec</td></tr><tr><td>Persistent object cache write</td><td style=\"color:#ffffff;background-color:#299c29\">10</td><td>0.5 sec</td></tr><tr><td>Persistent object cache read</td><td style=\"background-color:#81d519;color:#ffffff\">7.82</td><td>9.2 sec</td></tr><tr><td>Persistent object cache mixed usage</td><td style=\"color:#ffffff;background-color:#299c29\">10</td><td>1.3 sec</td></tr><tr><td rowspan=\"8\">WordPress core</td><td>Shortcode processing</td><td style=\"color:#ffffff;background-color:#81d519\">7.28</td><td>3.7 sec</td></tr><tr><td>WordPress Hooks</td><td style=\"color:#ffffff;background-color:#7dc516\">8.05</td><td>4.9 sec</td></tr><tr><td>WordPress option manipulation</td><td style=\"color:#ffffff;background-color:#299c29\">9.44</td><td>1.6 sec</td></tr><tr><td>REGEX string processing</td><td style=\"color:#ffffff;background-color:#7dc516\">8.2</td><td>4.6 sec</td></tr><tr><td>Taxonomy benchmark</td><td style=\"color:#ffffff;background-color:#81d519\">7.33</td><td>2.7 sec</td></tr><tr><td>Object capability benchmark</td><td style=\"color:#ffffff;background-color:#81d519\">7.03</td><td>3 sec</td></tr><tr><td>Content filtering</td><td style=\"color:#ffffff;background-color:#c3d519\">6.48</td><td>5 sec</td></tr><tr><td>JSON manipulations</td><td style=\"color:#ffffff;background-color:#7dc516\">8.71</td><td>2.1 sec</td></tr><tr><td>Network</td><td>Network download speed test</td><td style=\"color:#ffffff;background-color:#299c29\">10</td><td>0.9 sec<br>~84 Mo/s</td></tr></tbody><tfoot><tr><td colspan=\"2\">Your server score</td><td colspan=\"2\" style=\"text-align:center;color:#ffffff;background-color:#7dc516\">8.2</td></tr></tfoot></table><figcaption style=\"padding:10px 0;text-align:center\">Tableau des performances mesurées sur l&rsquo;offre <a href=\"https://hosterra.eu/fr/store/shared-hosting/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"Hosterra One\">Hosterra One</a> avec un cache objet APCu</figcaption></figure>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full\"><img width=\"1042\" height=\"1385\" src=\"https://holdmywp.com/wp-content/uploads/2025/11/benchmark-hosterra-one-min.webp\" alt=\"Capture d\'écran du test de mesure de performances sur l\'offre Hosterra One avec un cache objet APCu, le nom de domaine de l\'instance WordPress de test a été masqué.\" class=\"wp-image-6358\" //><figcaption class=\"wp-element-caption\">Capture d&rsquo;écran du test de mesure de performances sur l&rsquo;offre <strong>Hosterra One</strong> avec un cache objet <strong>APCu</strong>, le nom de domaine de l&rsquo;instance WordPress de test a été masqué.</figcaption></figure>\n\n\n<h2 class=\"wp-block-heading\" id=\"bilan-du-test\">Bilan du test</h2>\n\n\n<figure class=\"wp-block-flexible-table-block-table is-scroll-on-pc is-scroll-on-mobile\"><table class=\"is-stacked-on-mobile\"><thead><tr><th>Offre</th><th>Type hébergement</th><th>Tarif annuel TTC</th><th>Consommation annuelle annoncée</th><th>Meilleur Score/10</th></tr></thead><tbody><tr><td>Hosterra One</td><td>Mutualisé</td><td>91,08 € TTC</td><td>⚡️&lt; 200 kWh/an<br>🫧&lt; 6.5 l/an</td><td style=\"background-color:#7dc516;color:#ffffff\">8.2</td></tr></tbody><tfoot><tr><td colspan=\"5\" style=\"text-align:center;font-size:14px\">Source des informations : Fournisseur d&rsquo;hébergement + résultats des tests ci-dessus.<br>Dernière mise à jour : novembre 2025.</td></tr></tfoot></table><figcaption style=\"text-align:center;padding-top:10px;padding-bottom:10px\">Tableau comparatif des offres<br>		d&rsquo;hébergement Hosterra : type d&rsquo;hébergement, Tarif annuel TTC, consommation annuelle annoncée,  Meilleur score obtenu sur 10</figcaption></figure>\n\n\n<h2 class=\"wp-block-heading\" id=\"sources\">Sources</h2>\n\n\n<ul class=\"wp-block-list\">\n<li><a href=\"https://hosterra.eu/fr/store/shared-hosting/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"\">https://hosterra.eu/fr/store/shared-hosting/</a></li>\n\n\n\n<li><a href=\"https://wordpress.org/plugins/wpbenchmark/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"\">https://wordpress.org/plugins/wpbenchmark/</a></li>\n\n\n\n<li><a href=\"https://wpbenchmark.io/improve-wordpress-speed/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"\">https://wpbenchmark.io/improve-wordpress-speed/</a></li>\n\n\n\n<li><a href=\"https://kinsta.com/fr/blog/hebergement-mutualise-vs-hebergement-dedie/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"\">https://kinsta.com/fr/blog/hebergement-mutualise-vs-hebergement-dedie/</a></li>\n\n\n\n<li><a href=\"https://datacampus.fr/2023/01/24/technologies-stockage-donnees/\" target=\"_blank\" rel=\"noopener nofollow\" title=\"\">https://datacampus.fr/2023/01/24/technologies-stockage-donnees/</a></li>\n</ul>\n\n<p><a href=\"https://holdmywp.com/benchmark-hosterra/\">Source</a></p>\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Quentin Le Duff\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://holdmywp.com/tag/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"HoldMyWP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:9;a:6:{s:4:\"data\";s:70:\"\n    \n    \n    \n    \n    \n    \n    \n            \n                \n    \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:9:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://blog.o2switch.fr/ajouter-code-personnalise-wordpress-2025/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"Comment ajouter du code personnalisé dans WordPress (sans tout casser) en 2025\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:4:\"href\";s:66:\"https://blog.o2switch.fr/ajouter-code-personnalise-wordpress-2025/\";s:3:\"rel\";s:9:\"alternate\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"updated\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-11-12T07:30:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"published\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"2025-11-12T07:30:00.000+00:00\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"summary\";a:1:{i:0;a:5:{s:4:\"data\";s:264:\"Vous souhaitez ajouter un bout de code dans votre site WordPress sans risquer la fameuse page blanche ? Découvrez les bonnes pratiques pour personnaliser votre site en toute sécurité, avec les méthodes adaptées en 2025 : thème enfant, snippets et mu-plugins.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:5:{s:4:\"data\";s:278:\"\n        Vous souhaitez ajouter un bout de code dans votre site WordPress sans risquer la fameuse page blanche ? Découvrez les bonnes pratiques pour personnaliser votre site en toute sécurité, avec les méthodes adaptées en 2025 : thème enfant, snippets et mu-plugins.\n    \";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"author\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n            \n                                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"name\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Éric Martin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:6:\"source\";a:1:{i:0;a:6:{s:4:\"data\";s:67:\"\n                    \n                            \n                \";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:27:\"http://www.w3.org/2005/Atom\";a:2:{s:2:\"id\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://blog.o2switch.fr/wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"O2switch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}}}}}s:4:\"type\";i:512;s:7:\"headers\";a:11:{s:4:\"date\";s:29:\"Tue, 20 Jan 2026 15:50:28 GMT\";s:12:\"content-type\";s:20:\"application/atom+xml\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:4:\"link\";s:64:\"<https://fluxplanet.wpfr.net/wp-json/>; rel=\"https://api.w.org/\"\";s:13:\"cache-control\";s:35:\"no-cache, no-store, must-revalidate\";s:6:\"pragma\";s:8:\"no-cache\";s:7:\"expires\";s:1:\"0\";s:13:\"last-modified\";s:29:\"Tue, 22 Jul 2025 21:51:07 GMT\";s:4:\"etag\";s:36:\"W/\"072268436a8b47633210153ceb845bac\"\";s:6:\"server\";s:22:\"o2switch-PowerBoost-v3\";s:16:\"content-encoding\";s:4:\"gzip\";}s:5:\"build\";i:1768923973;s:21:\"cache_expiration_time\";i:1768967429;s:23:\"__cache_expiration_time\";i:1768967429;}", "off");
INSERT INTO `dev_options` VALUES("151", "_site_transient_timeout_feed_mod_b0b1001e5bc3fbacad8b49ec075d19a5", "1768967429", "off");
INSERT INTO `dev_options` VALUES("152", "_site_transient_feed_mod_b0b1001e5bc3fbacad8b49ec075d19a5", "1768924229", "off");
INSERT INTO `dev_options` VALUES("153", "_transient_timeout_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af", "1768967429", "off");
INSERT INTO `dev_options` VALUES("154", "_transient_dash_v2_bd94b8f41e74bae2f4dc72e9bd8379af", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://fr.wordpress.org/2026/01/10/arret-support-php-version-72-73/\'>Arrêt du support des versions 7.2 et 7.3 de PHP</a></li><li><a class=\'rsswidget\' href=\'https://fr.wordpress.org/2025/12/02/wordpress-6-9-gene/\'>WordPress 6.9 « Gene »</a></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'https://blog.o2switch.fr/sante-du-site-wordpress/\'>Vous avez un message dans l’outil Santé du site de votre site WordPress : que faire ?</a></li><li><a class=\'rsswidget\' href=\'https://wpmarmite.com/bilan-2025/\'>Retour sur l’année 2025 de WPMarmite</a></li><li><a class=\'rsswidget\' href=\'https://www.youtube.com/watch?v=aT9VnptqDvE\'>Les bonnes résolutions WordPress pour 2026</a></li></ul></div>", "off");
INSERT INTO `dev_options` VALUES("155", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `dev_options` VALUES("156", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1768935033", "off");
INSERT INTO `dev_options` VALUES("157", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:8018;}s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4959;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2800;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2795;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:2229;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:2155;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:2152;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1973;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1727;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1677;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1630;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1565;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1528;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1519;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1516;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:1451;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1380;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1317;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1296;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1186;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1163;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:1115;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:1114;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:1105;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:1096;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:1080;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:1071;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:1052;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:1022;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:1003;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:980;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:964;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:945;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:937;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:919;}s:2:\"ai\";a:3:{s:4:\"name\";s:2:\"AI\";s:4:\"slug\";s:2:\"ai\";s:5:\"count\";i:919;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:918;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:877;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:830;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:799;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:787;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:783;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:774;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:774;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:760;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:756;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:727;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:726;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:715;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:712;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:707;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:706;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:681;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:674;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:670;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:665;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:665;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:659;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:658;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:642;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:634;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:629;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:627;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:621;}s:6:\"blocks\";a:3:{s:4:\"name\";s:6:\"blocks\";s:4:\"slug\";s:6:\"blocks\";s:5:\"count\";i:621;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:615;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:612;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:603;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:600;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:598;}s:8:\"payments\";a:3:{s:4:\"name\";s:8:\"payments\";s:4:\"slug\";s:8:\"payments\";s:5:\"count\";i:597;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:581;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:579;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:577;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:571;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:567;}s:8:\"checkout\";a:3:{s:4:\"name\";s:8:\"checkout\";s:4:\"slug\";s:8:\"checkout\";s:5:\"count\";i:563;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:539;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:537;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:536;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:535;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:535;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:534;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:517;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:513;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:494;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:491;}s:7:\"gateway\";a:3:{s:4:\"name\";s:7:\"gateway\";s:4:\"slug\";s:7:\"gateway\";s:5:\"count\";i:491;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:486;}s:7:\"chatbot\";a:3:{s:4:\"name\";s:7:\"chatbot\";s:4:\"slug\";s:7:\"chatbot\";s:5:\"count\";i:486;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:472;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:471;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:463;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:459;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:459;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:447;}s:10:\"automation\";a:3:{s:4:\"name\";s:10:\"automation\";s:4:\"slug\";s:10:\"automation\";s:5:\"count\";i:442;}s:8:\"products\";a:3:{s:4:\"name\";s:8:\"products\";s:4:\"slug\";s:8:\"products\";s:5:\"count\";i:439;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:433;}s:11:\"integration\";a:3:{s:4:\"name\";s:11:\"integration\";s:4:\"slug\";s:11:\"integration\";s:5:\"count\";i:431;}}", "off");
INSERT INTO `dev_options` VALUES("162", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:63:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.9.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:63:\"https://downloads.wordpress.org/release/fr_FR/wordpress-6.9.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:3:\"6.9\";s:7:\"version\";s:3:\"6.9\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1768924248;s:15:\"version_checked\";s:3:\"6.9\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `dev_options` VALUES("163", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1768924248;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:3:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:3:\"5.6\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/akismet.5.6.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:60:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463\";s:2:\"1x\";s:60:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731\";s:2:\"1x\";s:62:\"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.8\";}s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:37:\"w.org/plugins/all-in-one-wp-migration\";s:4:\"slug\";s:23:\"all-in-one-wp-migration\";s:6:\"plugin\";s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";s:11:\"new_version\";s:5:\"7.101\";s:3:\"url\";s:54:\"https://wordpress.org/plugins/all-in-one-wp-migration/\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/plugin/all-in-one-wp-migration.7.101.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:76:\"https://ps.w.org/all-in-one-wp-migration/assets/icon-256x256.png?rev=2458334\";s:2:\"1x\";s:76:\"https://ps.w.org/all-in-one-wp-migration/assets/icon-128x128.png?rev=2458334\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:79:\"https://ps.w.org/all-in-one-wp-migration/assets/banner-1544x500.png?rev=3427096\";s:2:\"1x\";s:78:\"https://ps.w.org/all-in-one-wp-migration/assets/banner-772x250.png?rev=3427096\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.3\";}s:9:\"hello.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:5:\"1.7.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/hello-dolly.1.7.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=2052855\";s:2:\"1x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=2052855\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/hello-dolly/assets/banner-1544x500.jpg?rev=2645582\";s:2:\"1x\";s:66:\"https://ps.w.org/hello-dolly/assets/banner-772x250.jpg?rev=2052855\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";}}s:7:\"checked\";a:3:{s:19:\"akismet/akismet.php\";s:3:\"5.6\";s:51:\"all-in-one-wp-migration/all-in-one-wp-migration.php\";s:5:\"7.101\";s:9:\"hello.php\";s:5:\"1.7.2\";}}", "off");
INSERT INTO `dev_options` VALUES("164", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1768924248;s:7:\"checked\";a:4:{s:16:\"twentytwentyfive\";s:3:\"1.4\";s:16:\"twentytwentyfour\";s:3:\"1.4\";s:17:\"twentytwentythree\";s:3:\"1.6\";s:15:\"twentytwentytwo\";s:3:\"2.1\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:4:{s:16:\"twentytwentyfive\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfive\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfive/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfive.1.4.zip\";s:8:\"requires\";s:3:\"6.7\";s:12:\"requires_php\";s:3:\"7.2\";}s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.4.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.6.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:15:\"twentytwentytwo\";a:6:{s:5:\"theme\";s:15:\"twentytwentytwo\";s:11:\"new_version\";s:3:\"2.1\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentytwo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentytwo.2.1.zip\";s:8:\"requires\";s:3:\"5.9\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `dev_options` VALUES("165", "ai1wm_secret_key", "sd5wGPKmn7ZY", "auto");
INSERT INTO `dev_options` VALUES("166", "recently_activated", "a:0:{}", "off");
INSERT INTO `dev_options` VALUES("169", "finished_updating_comment_type", "1", "auto");
INSERT INTO `dev_options` VALUES("170", "_site_transient_timeout_wp_theme_files_patterns-973b70b9f47f338a5a7f6f959a917d14", "1768927968", "off");
INSERT INTO `dev_options` VALUES("171", "_site_transient_wp_theme_files_patterns-973b70b9f47f338a5a7f6f959a917d14", "a:2:{s:7:\"version\";s:3:\"1.4\";s:8:\"patterns\";a:98:{s:21:\"banner-about-book.php\";a:4:{s:5:\"title\";s:28:\"Banner with book description\";s:4:\"slug\";s:34:\"twentytwentyfive/banner-about-book\";s:11:\"description\";s:66:\"Banner with book description and accompanying image for promotion.\";s:10:\"categories\";a:1:{i:0;s:6:\"banner\";}}s:28:\"banner-cover-big-heading.php\";a:4:{s:5:\"title\";s:22:\"Cover with big heading\";s:4:\"slug\";s:41:\"twentytwentyfive/banner-cover-big-heading\";s:11:\"description\";s:82:\"A full-width cover section with a large background image and an oversized heading.\";s:10:\"categories\";a:3:{i:0;s:6:\"banner\";i:1;s:5:\"about\";i:2;s:8:\"featured\";}}s:22:\"banner-intro-image.php\";a:4:{s:5:\"title\";s:49:\"Short heading and paragraph and image on the left\";s:4:\"slug\";s:35:\"twentytwentyfive/banner-intro-image\";s:11:\"description\";s:68:\"A Intro pattern with Short heading, paragraph and image on the left.\";s:10:\"categories\";a:2:{i:0;s:6:\"banner\";i:1;s:8:\"featured\";}}s:16:\"banner-intro.php\";a:4:{s:5:\"title\";s:35:\"Intro with left-aligned description\";s:4:\"slug\";s:29:\"twentytwentyfive/banner-intro\";s:11:\"description\";s:66:\"A large left-aligned heading with a brand name emphasized in bold.\";s:10:\"categories\";a:1:{i:0;s:6:\"banner\";}}s:17:\"banner-poster.php\";a:4:{s:5:\"title\";s:19:\"Poster-like section\";s:4:\"slug\";s:30:\"twentytwentyfive/banner-poster\";s:11:\"description\";s:78:\"A section that can be used as a banner or a landing page to announce an event.\";s:10:\"categories\";a:2:{i:0;s:6:\"banner\";i:1;s:5:\"media\";}}s:43:\"banner-with-description-and-images-grid.php\";a:4:{s:5:\"title\";s:39:\"Banner with description and images grid\";s:4:\"slug\";s:47:\"twentytwentyfive/banner-description-images-grid\";s:11:\"description\";s:75:\"A banner with a short paragraph, and two images displayed in a grid layout.\";s:10:\"categories\";a:2:{i:0;s:6:\"banner\";i:1;s:8:\"featured\";}}s:18:\"binding-format.php\";a:4:{s:5:\"title\";s:16:\"Post format name\";s:4:\"slug\";s:31:\"twentytwentyfive/binding-format\";s:11:\"description\";s:75:\"Prints the name of the post format with the help of the Block Bindings API.\";s:10:\"categories\";a:1:{i:0;s:28:\"twentytwentyfive_post-format\";}}s:12:\"comments.php\";a:5:{s:5:\"title\";s:8:\"Comments\";s:4:\"slug\";s:25:\"twentytwentyfive/comments\";s:11:\"description\";s:63:\"Comments area with comments list, pagination, and comment form.\";s:10:\"categories\";a:1:{i:0;s:4:\"text\";}s:10:\"blockTypes\";a:1:{i:0;s:13:\"core/comments\";}}s:32:\"contact-centered-social-link.php\";a:5:{s:5:\"title\";s:30:\"Centered link and social links\";s:4:\"slug\";s:45:\"twentytwentyfive/contact-centered-social-link\";s:11:\"description\";s:73:\"Centered contact section with a prominent message and social media links.\";s:10:\"categories\";a:1:{i:0;s:7:\"contact\";}s:8:\"keywords\";a:3:{i:0;s:7:\"contact\";i:1;s:3:\"faq\";i:2;s:9:\"questions\";}}s:26:\"contact-info-locations.php\";a:6:{s:5:\"title\";s:27:\"Contact, info and locations\";s:4:\"slug\";s:39:\"twentytwentyfive/contact-info-locations\";s:11:\"description\";s:78:\"Contact section with social media links, email, and multiple location details.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:1:{i:0;s:7:\"contact\";}s:8:\"keywords\";a:2:{i:0;s:7:\"contact\";i:1;s:8:\"location\";}}s:29:\"contact-location-and-link.php\";a:4:{s:5:\"title\";s:25:\"Contact location and link\";s:4:\"slug\";s:42:\"twentytwentyfive/contact-location-and-link\";s:11:\"description\";s:89:\"Contact section with a location address, a directions link, and an image of the location.\";s:10:\"categories\";a:2:{i:0;s:7:\"contact\";i:1;s:8:\"featured\";}}s:18:\"cta-book-links.php\";a:4:{s:5:\"title\";s:30:\"Call to action with book links\";s:4:\"slug\";s:31:\"twentytwentyfive/cta-book-links\";s:11:\"description\";s:74:\"A call to action section with links to get the book in different websites.\";s:10:\"categories\";a:1:{i:0;s:14:\"call-to-action\";}}s:22:\"cta-book-locations.php\";a:4:{s:5:\"title\";s:29:\"Call to action with locations\";s:4:\"slug\";s:35:\"twentytwentyfive/cta-book-locations\";s:11:\"description\";s:82:\"A call to action section with links to get the book in the most popular locations.\";s:10:\"categories\";a:1:{i:0;s:14:\"call-to-action\";}}s:24:\"cta-centered-heading.php\";a:4:{s:5:\"title\";s:16:\"Centered heading\";s:4:\"slug\";s:37:\"twentytwentyfive/cta-centered-heading\";s:11:\"description\";s:53:\"A hero with a centered heading, paragraph and button.\";s:10:\"categories\";a:1:{i:0;s:14:\"call-to-action\";}}s:19:\"cta-events-list.php\";a:4:{s:5:\"title\";s:11:\"Events list\";s:4:\"slug\";s:32:\"twentytwentyfive/cta-events-list\";s:11:\"description\";s:37:\"A list of events with call to action.\";s:10:\"categories\";a:1:{i:0;s:14:\"call-to-action\";}}s:26:\"cta-grid-products-link.php\";a:5:{s:5:\"title\";s:54:\"Call to action with grid layout with products and link\";s:4:\"slug\";s:39:\"twentytwentyfive/cta-grid-products-link\";s:11:\"description\";s:42:\"A call to action featuring product images.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:2:{i:0;s:14:\"call-to-action\";i:1;s:8:\"featured\";}}s:22:\"cta-heading-search.php\";a:4:{s:5:\"title\";s:23:\"Heading and search form\";s:4:\"slug\";s:35:\"twentytwentyfive/cta-heading-search\";s:11:\"description\";s:54:\"Large heading with a search form for quick navigation.\";s:10:\"categories\";a:1:{i:0;s:14:\"call-to-action\";}}s:18:\"cta-newsletter.php\";a:5:{s:5:\"title\";s:18:\"Newsletter sign-up\";s:4:\"slug\";s:31:\"twentytwentyfive/cta-newsletter\";s:11:\"description\";s:0:\"\";s:10:\"categories\";a:1:{i:0;s:14:\"call-to-action\";}s:8:\"keywords\";a:2:{i:0;s:14:\"call-to-action\";i:1;s:10:\"newsletter\";}}s:15:\"event-3-col.php\";a:5:{s:5:\"title\";s:46:\"Events, 3 columns with event images and titles\";s:4:\"slug\";s:28:\"twentytwentyfive/event-3-col\";s:11:\"description\";s:95:\"A header with title and text and three columns that show 3 events with their images and titles.\";s:10:\"categories\";a:1:{i:0;s:6:\"banner\";}s:8:\"keywords\";a:3:{i:0;s:6:\"events\";i:1;s:7:\"columns\";i:2;s:6:\"images\";}}s:14:\"event-rsvp.php\";a:7:{s:5:\"title\";s:10:\"Event RSVP\";s:4:\"slug\";s:27:\"twentytwentyfive/event-rsvp\";s:11:\"description\";s:64:\"RSVP for an upcoming event with a cover image and event details.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:1:{i:0;s:14:\"call-to-action\";}s:8:\"keywords\";a:3:{i:0;s:14:\"call-to-action\";i:1;s:4:\"rsvp\";i:2;s:5:\"event\";}s:10:\"blockTypes\";a:1:{i:0;s:17:\"core/post-content\";}}s:18:\"event-schedule.php\";a:5:{s:5:\"title\";s:14:\"Event schedule\";s:4:\"slug\";s:31:\"twentytwentyfive/event-schedule\";s:11:\"description\";s:54:\"A section with specified dates and times for an event.\";s:10:\"categories\";a:1:{i:0;s:5:\"about\";}s:8:\"keywords\";a:4:{i:0;s:6:\"events\";i:1;s:6:\"agenda\";i:2;s:8:\"schedule\";i:3;s:8:\"lectures\";}}s:19:\"footer-centered.php\";a:5:{s:5:\"title\";s:15:\"Centered footer\";s:4:\"slug\";s:32:\"twentytwentyfive/footer-centered\";s:11:\"description\";s:44:\"Footer with centered site title and tagline.\";s:10:\"categories\";a:1:{i:0;s:6:\"footer\";}s:10:\"blockTypes\";a:1:{i:0;s:25:\"core/template-part/footer\";}}s:18:\"footer-columns.php\";a:5:{s:5:\"title\";s:19:\"Footer with columns\";s:4:\"slug\";s:31:\"twentytwentyfive/footer-columns\";s:11:\"description\";s:45:\"Footer columns with title, tagline and links.\";s:10:\"categories\";a:1:{i:0;s:6:\"footer\";}s:10:\"blockTypes\";a:1:{i:0;s:25:\"core/template-part/footer\";}}s:21:\"footer-newsletter.php\";a:5:{s:5:\"title\";s:29:\"Footer with newsletter signup\";s:4:\"slug\";s:34:\"twentytwentyfive/footer-newsletter\";s:11:\"description\";s:51:\"Footer with large site title and newsletter signup.\";s:10:\"categories\";a:1:{i:0;s:6:\"footer\";}s:10:\"blockTypes\";a:1:{i:0;s:25:\"core/template-part/footer\";}}s:17:\"footer-social.php\";a:5:{s:5:\"title\";s:33:\"Centered footer with social links\";s:4:\"slug\";s:30:\"twentytwentyfive/footer-social\";s:11:\"description\";s:49:\"Footer with centered site title and social links.\";s:10:\"categories\";a:1:{i:0;s:6:\"footer\";}s:10:\"blockTypes\";a:1:{i:0;s:25:\"core/template-part/footer\";}}s:10:\"footer.php\";a:5:{s:5:\"title\";s:6:\"Footer\";s:4:\"slug\";s:23:\"twentytwentyfive/footer\";s:11:\"description\";s:51:\"Footer columns with logo, title, tagline and links.\";s:10:\"categories\";a:1:{i:0;s:6:\"footer\";}s:10:\"blockTypes\";a:1:{i:0;s:25:\"core/template-part/footer\";}}s:16:\"format-audio.php\";a:4:{s:5:\"title\";s:12:\"Audio format\";s:4:\"slug\";s:29:\"twentytwentyfive/format-audio\";s:11:\"description\";s:73:\"An audio post format with an image, title, audio player, and description.\";s:10:\"categories\";a:1:{i:0;s:28:\"twentytwentyfive_post-format\";}}s:15:\"format-link.php\";a:4:{s:5:\"title\";s:11:\"Link format\";s:4:\"slug\";s:28:\"twentytwentyfive/format-link\";s:11:\"description\";s:77:\"A link post format with a description and an emphasized link for key content.\";s:10:\"categories\";a:1:{i:0;s:28:\"twentytwentyfive_post-format\";}}s:15:\"grid-videos.php\";a:4:{s:5:\"title\";s:16:\"Grid with videos\";s:4:\"slug\";s:28:\"twentytwentyfive/grid-videos\";s:11:\"description\";s:19:\"A grid with videos.\";s:10:\"categories\";a:1:{i:0;s:5:\"about\";}}s:24:\"grid-with-categories.php\";a:5:{s:5:\"title\";s:20:\"Grid with categories\";s:4:\"slug\";s:37:\"twentytwentyfive/grid-with-categories\";s:11:\"description\";s:41:\"A grid section with different categories.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:1:{i:0;s:6:\"banner\";}}s:19:\"header-centered.php\";a:5:{s:5:\"title\";s:20:\"Centered site header\";s:4:\"slug\";s:32:\"twentytwentyfive/header-centered\";s:11:\"description\";s:52:\"Site header with centered site title and navigation.\";s:10:\"categories\";a:1:{i:0;s:6:\"header\";}s:10:\"blockTypes\";a:1:{i:0;s:25:\"core/template-part/header\";}}s:18:\"header-columns.php\";a:5:{s:5:\"title\";s:19:\"Header with columns\";s:4:\"slug\";s:31:\"twentytwentyfive/header-columns\";s:11:\"description\";s:54:\"Site header with site title and navigation in columns.\";s:10:\"categories\";a:1:{i:0;s:6:\"header\";}s:10:\"blockTypes\";a:1:{i:0;s:25:\"core/template-part/header\";}}s:22:\"header-large-title.php\";a:5:{s:5:\"title\";s:23:\"Header with large title\";s:4:\"slug\";s:35:\"twentytwentyfive/header-large-title\";s:11:\"description\";s:63:\"Site header with large site title and right-aligned navigation.\";s:10:\"categories\";a:1:{i:0;s:6:\"header\";}s:10:\"blockTypes\";a:1:{i:0;s:25:\"core/template-part/header\";}}s:10:\"header.php\";a:5:{s:5:\"title\";s:6:\"Header\";s:4:\"slug\";s:23:\"twentytwentyfive/header\";s:11:\"description\";s:43:\"Site header with site title and navigation.\";s:10:\"categories\";a:1:{i:0;s:6:\"header\";}s:10:\"blockTypes\";a:1:{i:0;s:25:\"core/template-part/header\";}}s:36:\"heading-and-paragraph-with-image.php\";a:4:{s:5:\"title\";s:45:\"Heading and paragraph with image on the right\";s:4:\"slug\";s:49:\"twentytwentyfive/heading-and-paragraph-with-image\";s:11:\"description\";s:89:\"A two-column section with a heading and paragraph on the left, and an image on the right.\";s:10:\"categories\";a:1:{i:0;s:5:\"about\";}}s:13:\"hero-book.php\";a:5:{s:5:\"title\";s:9:\"Hero book\";s:4:\"slug\";s:26:\"twentytwentyfive/hero-book\";s:11:\"description\";s:66:\"A hero section for the book with a description and pre-order link.\";s:10:\"categories\";a:1:{i:0;s:6:\"banner\";}s:8:\"keywords\";a:3:{i:0;s:7:\"podcast\";i:1;s:4:\"hero\";i:2;s:7:\"stories\";}}s:25:\"hero-full-width-image.php\";a:4:{s:5:\"title\";s:22:\"Hero, full width image\";s:4:\"slug\";s:38:\"twentytwentyfive/hero-full-width-image\";s:11:\"description\";s:68:\"A hero with a full width image, heading, short paragraph and button.\";s:10:\"categories\";a:1:{i:0;s:6:\"banner\";}}s:41:\"hero-overlapped-book-cover-with-links.php\";a:4:{s:5:\"title\";s:38:\"Hero, overlapped book cover with links\";s:4:\"slug\";s:54:\"twentytwentyfive/hero-overlapped-book-cover-with-links\";s:11:\"description\";s:47:\"A hero with an overlapped book cover and links.\";s:10:\"categories\";a:1:{i:0;s:6:\"banner\";}}s:16:\"hero-podcast.php\";a:5:{s:5:\"title\";s:12:\"Hero podcast\";s:4:\"slug\";s:29:\"twentytwentyfive/hero-podcast\";s:11:\"description\";s:0:\"\";s:10:\"categories\";a:1:{i:0;s:6:\"banner\";}s:8:\"keywords\";a:3:{i:0;s:7:\"podcast\";i:1;s:4:\"hero\";i:2;s:7:\"stories\";}}s:14:\"hidden-404.php\";a:4:{s:5:\"title\";s:3:\"404\";s:4:\"slug\";s:27:\"twentytwentyfive/hidden-404\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;}s:23:\"hidden-blog-heading.php\";a:4:{s:5:\"title\";s:19:\"Hidden blog heading\";s:4:\"slug\";s:36:\"twentytwentyfive/hidden-blog-heading\";s:11:\"description\";s:52:\"Hidden heading for the home page and index template.\";s:8:\"inserter\";b:0;}s:17:\"hidden-search.php\";a:4:{s:5:\"title\";s:6:\"Search\";s:4:\"slug\";s:30:\"twentytwentyfive/hidden-search\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;}s:18:\"hidden-sidebar.php\";a:4:{s:5:\"title\";s:7:\"Sidebar\";s:4:\"slug\";s:31:\"twentytwentyfive/hidden-sidebar\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;}s:21:\"hidden-written-by.php\";a:4:{s:5:\"title\";s:10:\"Written by\";s:4:\"slug\";s:34:\"twentytwentyfive/hidden-written-by\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;}s:9:\"logos.php\";a:4:{s:5:\"title\";s:5:\"Logos\";s:4:\"slug\";s:22:\"twentytwentyfive/logos\";s:11:\"description\";s:77:\"Showcasing the podcast\'s clients with a heading and a series of client logos.\";s:10:\"categories\";a:1:{i:0;s:6:\"banner\";}}s:24:\"media-instagram-grid.php\";a:5:{s:5:\"title\";s:14:\"Instagram grid\";s:4:\"slug\";s:37:\"twentytwentyfive/media-instagram-grid\";s:11:\"description\";s:62:\"A grid section with photos and a link to an Instagram profile.\";s:13:\"viewportWidth\";i:1440;s:10:\"categories\";a:3:{i:0;s:5:\"media\";i:1;s:7:\"gallery\";i:2;s:8:\"featured\";}}s:14:\"more-posts.php\";a:5:{s:5:\"title\";s:10:\"More posts\";s:4:\"slug\";s:27:\"twentytwentyfive/more-posts\";s:11:\"description\";s:45:\"Displays a list of posts with title and date.\";s:10:\"categories\";a:1:{i:0;s:5:\"query\";}s:10:\"blockTypes\";a:1:{i:0;s:10:\"core/query\";}}s:21:\"overlapped-images.php\";a:4:{s:5:\"title\";s:41:\"Overlapping images and paragraph on right\";s:4:\"slug\";s:34:\"twentytwentyfive/overlapped-images\";s:11:\"description\";s:53:\"A section with overlapping images, and a description.\";s:10:\"categories\";a:2:{i:0;s:5:\"about\";i:1;s:8:\"featured\";}}s:22:\"page-business-home.php\";a:8:{s:5:\"title\";s:17:\"Business homepage\";s:4:\"slug\";s:35:\"twentytwentyfive/page-business-home\";s:11:\"description\";s:28:\"A business homepage pattern.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:2:{i:0;s:21:\"twentytwentyfive_page\";i:1;s:8:\"featured\";}s:8:\"keywords\";a:1:{i:0;s:7:\"starter\";}s:10:\"blockTypes\";a:1:{i:0;s:17:\"core/post-content\";}s:9:\"postTypes\";a:2:{i:0;s:4:\"page\";i:1;s:11:\"wp_template\";}}s:20:\"page-coming-soon.php\";a:8:{s:5:\"title\";s:11:\"Coming soon\";s:4:\"slug\";s:33:\"twentytwentyfive/page-coming-soon\";s:11:\"description\";s:96:\"A full-width cover banner that can be applied to a page or it can work as a single landing page.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:2:{i:0;s:21:\"twentytwentyfive_page\";i:1;s:8:\"featured\";}s:8:\"keywords\";a:1:{i:0;s:7:\"starter\";}s:10:\"blockTypes\";a:1:{i:0;s:17:\"core/post-content\";}s:9:\"postTypes\";a:2:{i:0;s:4:\"page\";i:1;s:11:\"wp_template\";}}s:15:\"page-cv-bio.php\";a:7:{s:5:\"title\";s:6:\"CV/bio\";s:4:\"slug\";s:28:\"twentytwentyfive/page-cv-bio\";s:11:\"description\";s:36:\"A pattern for a CV/Bio landing page.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:3:{i:0;s:21:\"twentytwentyfive_page\";i:1;s:5:\"about\";i:2;s:8:\"featured\";}s:8:\"keywords\";a:1:{i:0;s:7:\"starter\";}s:10:\"blockTypes\";a:1:{i:0;s:17:\"core/post-content\";}}s:21:\"page-landing-book.php\";a:8:{s:5:\"title\";s:21:\"Landing page for book\";s:4:\"slug\";s:34:\"twentytwentyfive/page-landing-book\";s:11:\"description\";s:104:\"A landing page for the book with a hero section, pre-order links, locations, FAQs and newsletter signup.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:2:{i:0;s:21:\"twentytwentyfive_page\";i:1;s:8:\"featured\";}s:8:\"keywords\";a:1:{i:0;s:7:\"starter\";}s:10:\"blockTypes\";a:1:{i:0;s:17:\"core/post-content\";}s:9:\"postTypes\";a:2:{i:0;s:4:\"page\";i:1;s:11:\"wp_template\";}}s:22:\"page-landing-event.php\";a:8:{s:5:\"title\";s:22:\"Landing page for event\";s:4:\"slug\";s:35:\"twentytwentyfive/page-landing-event\";s:11:\"description\";s:87:\"A landing page for the event with a hero section, description, FAQs and call to action.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:2:{i:0;s:21:\"twentytwentyfive_page\";i:1;s:8:\"featured\";}s:8:\"keywords\";a:1:{i:0;s:7:\"starter\";}s:10:\"blockTypes\";a:1:{i:0;s:17:\"core/post-content\";}s:9:\"postTypes\";a:2:{i:0;s:4:\"page\";i:1;s:11:\"wp_template\";}}s:24:\"page-landing-podcast.php\";a:8:{s:5:\"title\";s:24:\"Landing page for podcast\";s:4:\"slug\";s:37:\"twentytwentyfive/page-landing-podcast\";s:11:\"description\";s:111:\"A landing page for the podcast with a hero section, description, logos, grid with videos and newsletter signup.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:2:{i:0;s:21:\"twentytwentyfive_page\";i:1;s:8:\"featured\";}s:8:\"keywords\";a:1:{i:0;s:7:\"starter\";}s:10:\"blockTypes\";a:1:{i:0;s:17:\"core/post-content\";}s:9:\"postTypes\";a:2:{i:0;s:4:\"page\";i:1;s:11:\"wp_template\";}}s:50:\"page-link-in-bio-heading-paragraph-links-image.php\";a:7:{s:5:\"title\";s:59:\"Link in bio heading, paragraph, links and full-height image\";s:4:\"slug\";s:63:\"twentytwentyfive/page-link-in-bio-heading-paragraph-links-image\";s:11:\"description\";s:84:\"A link in bio landing page with a heading, paragraph, links and a full height image.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:3:{i:0;s:21:\"twentytwentyfive_page\";i:1;s:6:\"banner\";i:2;s:8:\"featured\";}s:8:\"keywords\";a:1:{i:0;s:7:\"starter\";}s:10:\"blockTypes\";a:1:{i:0;s:17:\"core/post-content\";}}s:33:\"page-link-in-bio-wide-margins.php\";a:7:{s:5:\"title\";s:48:\"Link in bio with profile, links and wide margins\";s:4:\"slug\";s:46:\"twentytwentyfive/page-link-in-bio-wide-margins\";s:11:\"description\";s:86:\"A link in bio landing page with social links, a profile photo and a brief description.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:3:{i:0;s:21:\"twentytwentyfive_page\";i:1;s:6:\"banner\";i:2;s:8:\"featured\";}s:8:\"keywords\";a:1:{i:0;s:7:\"starter\";}s:10:\"blockTypes\";a:1:{i:0;s:17:\"core/post-content\";}}s:39:\"page-link-in-bio-with-tight-margins.php\";a:8:{s:5:\"title\";s:30:\"Link in bio with tight margins\";s:4:\"slug\";s:52:\"twentytwentyfive/page-link-in-bio-with-tight-margins\";s:11:\"description\";s:90:\"A full-width, full-height link in bio section with an image, a paragraph and social links.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:2:{i:0;s:21:\"twentytwentyfive_page\";i:1;s:6:\"banner\";}s:8:\"keywords\";a:1:{i:0;s:7:\"starter\";}s:10:\"blockTypes\";a:1:{i:0;s:17:\"core/post-content\";}s:9:\"postTypes\";a:2:{i:0;s:4:\"page\";i:1;s:11:\"wp_template\";}}s:23:\"page-portfolio-home.php\";a:8:{s:5:\"title\";s:18:\"Portfolio homepage\";s:4:\"slug\";s:36:\"twentytwentyfive/page-portfolio-home\";s:11:\"description\";s:29:\"A portfolio homepage pattern.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:2:{i:0;s:21:\"twentytwentyfive_page\";i:1;s:5:\"posts\";}s:8:\"keywords\";a:1:{i:0;s:7:\"starter\";}s:10:\"blockTypes\";a:1:{i:0;s:17:\"core/post-content\";}s:9:\"postTypes\";a:2:{i:0;s:4:\"page\";i:1;s:11:\"wp_template\";}}s:18:\"page-shop-home.php\";a:8:{s:5:\"title\";s:13:\"Shop homepage\";s:4:\"slug\";s:31:\"twentytwentyfive/page-shop-home\";s:11:\"description\";s:24:\"A shop homepage pattern.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:1:{i:0;s:21:\"twentytwentyfive_page\";}s:8:\"keywords\";a:1:{i:0;s:7:\"starter\";}s:10:\"blockTypes\";a:1:{i:0;s:17:\"core/post-content\";}s:9:\"postTypes\";a:2:{i:0;s:4:\"page\";i:1;s:11:\"wp_template\";}}s:19:\"post-navigation.php\";a:5:{s:5:\"title\";s:15:\"Post navigation\";s:4:\"slug\";s:32:\"twentytwentyfive/post-navigation\";s:11:\"description\";s:29:\"Next and previous post links.\";s:10:\"categories\";a:1:{i:0;s:4:\"text\";}s:10:\"blockTypes\";a:1:{i:0;s:25:\"core/post-navigation-link\";}}s:17:\"pricing-2-col.php\";a:5:{s:5:\"title\";s:18:\"Pricing, 2 columns\";s:4:\"slug\";s:30:\"twentytwentyfive/pricing-2-col\";s:11:\"description\";s:88:\"Pricing section with two columns, pricing plan, description, and call-to-action buttons.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:1:{i:0;s:14:\"call-to-action\";}}s:17:\"pricing-3-col.php\";a:4:{s:5:\"title\";s:18:\"Pricing, 3 columns\";s:4:\"slug\";s:30:\"twentytwentyfive/pricing-3-col\";s:11:\"description\";s:100:\"A three-column boxed pricing table designed to showcase services, descriptions, and pricing options.\";s:10:\"categories\";a:3:{i:0;s:14:\"call-to-action\";i:1;s:6:\"banner\";i:2;s:8:\"services\";}}s:18:\"services-3-col.php\";a:4:{s:5:\"title\";s:19:\"Services, 3 columns\";s:4:\"slug\";s:31:\"twentytwentyfive/services-3-col\";s:11:\"description\";s:56:\"Three columns with images and text to showcase services.\";s:10:\"categories\";a:3:{i:0;s:14:\"call-to-action\";i:1;s:6:\"banner\";i:2;s:8:\"services\";}}s:36:\"services-subscriber-only-section.php\";a:4:{s:5:\"title\";s:33:\"Services, subscriber only section\";s:4:\"slug\";s:49:\"twentytwentyfive/services-subscriber-only-section\";s:11:\"description\";s:72:\"A subscriber-only section highlighting exclusive services and offerings.\";s:10:\"categories\";a:2:{i:0;s:14:\"call-to-action\";i:1;s:8:\"services\";}}s:24:\"services-team-photos.php\";a:4:{s:5:\"title\";s:21:\"Services, team photos\";s:4:\"slug\";s:37:\"twentytwentyfive/services-team-photos\";s:11:\"description\";s:59:\"Display team photos in a services section with grid layout.\";s:10:\"categories\";a:3:{i:0;s:6:\"banner\";i:1;s:14:\"call-to-action\";i:2;s:8:\"featured\";}}s:37:\"template-404-vertical-header-blog.php\";a:5:{s:5:\"title\";s:17:\"Right-aligned 404\";s:4:\"slug\";s:50:\"twentytwentyfive/template-404-vertical-header-blog\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:13:\"templateTypes\";a:1:{i:0;s:3:\"404\";}}s:30:\"template-archive-news-blog.php\";a:6:{s:5:\"title\";s:17:\"News blog archive\";s:4:\"slug\";s:43:\"twentytwentyfive/template-archive-news-blog\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:1:{i:0;s:7:\"archive\";}}s:31:\"template-archive-photo-blog.php\";a:6:{s:5:\"title\";s:18:\"Photo blog archive\";s:4:\"slug\";s:44:\"twentytwentyfive/template-archive-photo-blog\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:1:{i:0;s:7:\"archive\";}}s:30:\"template-archive-text-blog.php\";a:6:{s:5:\"title\";s:17:\"Text blog archive\";s:4:\"slug\";s:43:\"twentytwentyfive/template-archive-text-blog\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:1:{i:0;s:7:\"archive\";}}s:41:\"template-archive-vertical-header-blog.php\";a:6:{s:5:\"title\";s:21:\"Right-aligned archive\";s:4:\"slug\";s:54:\"twentytwentyfive/template-archive-vertical-header-blog\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:1:{i:0;s:7:\"archive\";}}s:27:\"template-home-news-blog.php\";a:6:{s:5:\"title\";s:14:\"News blog home\";s:4:\"slug\";s:40:\"twentytwentyfive/template-home-news-blog\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:3:{i:0;s:10:\"front-page\";i:1;s:5:\"index\";i:2;s:4:\"home\";}}s:28:\"template-home-photo-blog.php\";a:6:{s:5:\"title\";s:15:\"Photo blog home\";s:4:\"slug\";s:41:\"twentytwentyfive/template-home-photo-blog\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:3:{i:0;s:10:\"front-page\";i:1;s:5:\"index\";i:2;s:4:\"home\";}}s:38:\"template-home-posts-grid-news-blog.php\";a:5:{s:5:\"title\";s:34:\"News blog with featured posts grid\";s:4:\"slug\";s:51:\"twentytwentyfive/template-home-posts-grid-news-blog\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:3:{i:0;s:10:\"front-page\";i:1;s:5:\"index\";i:2;s:4:\"home\";}}s:27:\"template-home-text-blog.php\";a:6:{s:5:\"title\";s:14:\"Text blog home\";s:4:\"slug\";s:40:\"twentytwentyfive/template-home-text-blog\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:2:{i:0;s:10:\"front-page\";i:1;s:4:\"home\";}}s:38:\"template-home-vertical-header-blog.php\";a:6:{s:5:\"title\";s:18:\"Right-aligned home\";s:4:\"slug\";s:51:\"twentytwentyfive/template-home-vertical-header-blog\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:3:{i:0;s:10:\"front-page\";i:1;s:5:\"index\";i:2;s:4:\"home\";}}s:40:\"template-home-with-sidebar-news-blog.php\";a:6:{s:5:\"title\";s:22:\"News blog with sidebar\";s:4:\"slug\";s:53:\"twentytwentyfive/template-home-with-sidebar-news-blog\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:3:{i:0;s:10:\"front-page\";i:1;s:5:\"index\";i:2;s:4:\"home\";}}s:28:\"template-page-photo-blog.php\";a:5:{s:5:\"title\";s:15:\"Photo blog page\";s:4:\"slug\";s:41:\"twentytwentyfive/template-page-photo-blog\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:13:\"templateTypes\";a:1:{i:0;s:4:\"page\";}}s:38:\"template-page-vertical-header-blog.php\";a:5:{s:5:\"title\";s:18:\"Right-aligned page\";s:4:\"slug\";s:51:\"twentytwentyfive/template-page-vertical-header-blog\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:13:\"templateTypes\";a:1:{i:0;s:4:\"page\";}}s:33:\"template-query-loop-news-blog.php\";a:4:{s:5:\"title\";s:20:\"News blog query loop\";s:4:\"slug\";s:46:\"twentytwentyfive/template-query-loop-news-blog\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;}s:34:\"template-query-loop-photo-blog.php\";a:6:{s:5:\"title\";s:16:\"Photo blog posts\";s:4:\"slug\";s:47:\"twentytwentyfive/template-query-loop-photo-blog\";s:11:\"description\";s:54:\"A list of posts, 3 columns, with only featured images.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:1:{i:0;s:5:\"query\";}s:10:\"blockTypes\";a:1:{i:0;s:10:\"core/query\";}}s:33:\"template-query-loop-text-blog.php\";a:4:{s:5:\"title\";s:20:\"Text blog query loop\";s:4:\"slug\";s:46:\"twentytwentyfive/template-query-loop-text-blog\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;}s:44:\"template-query-loop-vertical-header-blog.php\";a:4:{s:5:\"title\";s:24:\"Right-aligned query loop\";s:4:\"slug\";s:57:\"twentytwentyfive/template-query-loop-vertical-header-blog\";s:11:\"description\";s:0:\"\";s:8:\"inserter\";b:0;}s:23:\"template-query-loop.php\";a:5:{s:5:\"title\";s:23:\"List of posts, 1 column\";s:4:\"slug\";s:36:\"twentytwentyfive/template-query-loop\";s:11:\"description\";s:61:\"A list of posts, 1 column, with featured image and post date.\";s:10:\"categories\";a:1:{i:0;s:5:\"query\";}s:10:\"blockTypes\";a:1:{i:0;s:10:\"core/query\";}}s:29:\"template-search-news-blog.php\";a:6:{s:5:\"title\";s:24:\"News blog search results\";s:4:\"slug\";s:42:\"twentytwentyfive/template-search-news-blog\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:1:{i:0;s:6:\"search\";}}s:30:\"template-search-photo-blog.php\";a:6:{s:5:\"title\";s:25:\"Photo blog search results\";s:4:\"slug\";s:43:\"twentytwentyfive/template-search-photo-blog\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:1:{i:0;s:6:\"search\";}}s:29:\"template-search-text-blog.php\";a:6:{s:5:\"title\";s:24:\"Text blog search results\";s:4:\"slug\";s:42:\"twentytwentyfive/template-search-text-blog\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:1:{i:0;s:6:\"search\";}}s:40:\"template-search-vertical-header-blog.php\";a:6:{s:5:\"title\";s:26:\"Right-aligned blog, search\";s:4:\"slug\";s:53:\"twentytwentyfive/template-search-vertical-header-blog\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:1:{i:0;s:6:\"search\";}}s:40:\"template-single-left-aligned-content.php\";a:6:{s:5:\"title\";s:30:\"Post with left-aligned content\";s:4:\"slug\";s:47:\"twentytwentyfive/post-with-left-aligned-content\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:2:{i:0;s:5:\"posts\";i:1;s:6:\"single\";}}s:29:\"template-single-news-blog.php\";a:6:{s:5:\"title\";s:34:\"News blog single post with sidebar\";s:4:\"slug\";s:42:\"twentytwentyfive/template-single-news-blog\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:2:{i:0;s:5:\"posts\";i:1;s:6:\"single\";}}s:26:\"template-single-offset.php\";a:6:{s:5:\"title\";s:34:\"Offset post without featured image\";s:4:\"slug\";s:39:\"twentytwentyfive/template-single-offset\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:2:{i:0;s:5:\"posts\";i:1;s:6:\"single\";}}s:30:\"template-single-photo-blog.php\";a:6:{s:5:\"title\";s:22:\"Photo blog single post\";s:4:\"slug\";s:43:\"twentytwentyfive/template-single-photo-blog\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:2:{i:0;s:5:\"posts\";i:1;s:6:\"single\";}}s:29:\"template-single-text-blog.php\";a:6:{s:5:\"title\";s:21:\"Text blog single post\";s:4:\"slug\";s:42:\"twentytwentyfive/template-single-text-blog\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:2:{i:0;s:5:\"posts\";i:1;s:6:\"single\";}}s:40:\"template-single-vertical-header-blog.php\";a:6:{s:5:\"title\";s:25:\"Right-aligned single post\";s:4:\"slug\";s:53:\"twentytwentyfive/template-single-vertical-header-blog\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";i:1400;s:8:\"inserter\";b:0;s:13:\"templateTypes\";a:2:{i:0;s:5:\"posts\";i:1;s:6:\"single\";}}s:22:\"testimonials-2-col.php\";a:5:{s:5:\"title\";s:21:\"2 columns with avatar\";s:4:\"slug\";s:35:\"twentytwentyfive/testimonials-2-col\";s:11:\"description\";s:42:\"Two columns with testimonials and avatars.\";s:10:\"categories\";a:1:{i:0;s:12:\"testimonials\";}s:8:\"keywords\";a:1:{i:0;s:11:\"testimonial\";}}s:22:\"testimonials-6-col.php\";a:5:{s:5:\"title\";s:35:\"3 column layout with 6 testimonials\";s:4:\"slug\";s:35:\"twentytwentyfive/testimonials-6-col\";s:11:\"description\";s:86:\"A section with three columns and two rows, each containing a testimonial and citation.\";s:10:\"categories\";a:1:{i:0;s:12:\"testimonials\";}s:8:\"keywords\";a:1:{i:0;s:11:\"testimonial\";}}s:22:\"testimonials-large.php\";a:5:{s:5:\"title\";s:32:\"Review with large image on right\";s:4:\"slug\";s:35:\"twentytwentyfive/testimonials-large\";s:11:\"description\";s:46:\"A testimonial with a large image on the right.\";s:10:\"categories\";a:1:{i:0;s:12:\"testimonials\";}s:8:\"keywords\";a:1:{i:0;s:11:\"testimonial\";}}s:13:\"text-faqs.php\";a:6:{s:5:\"title\";s:4:\"FAQs\";s:4:\"slug\";s:26:\"twentytwentyfive/text-faqs\";s:11:\"description\";s:68:\"A FAQs section with a FAQ heading and list of questions and answers.\";s:13:\"viewportWidth\";i:1400;s:10:\"categories\";a:2:{i:0;s:4:\"text\";i:1;s:5:\"about\";}s:8:\"keywords\";a:5:{i:0;s:3:\"faq\";i:1;s:5:\"about\";i:2;s:10:\"frequently\";i:3;s:5:\"asked\";i:4;s:9:\"questions\";}}s:19:\"vertical-header.php\";a:6:{s:5:\"title\";s:20:\"Vertical site header\";s:4:\"slug\";s:32:\"twentytwentyfive/vertical-header\";s:11:\"description\";s:52:\"Vertical site header with site title and navigation.\";s:13:\"viewportWidth\";i:300;s:10:\"categories\";a:1:{i:0;s:6:\"header\";}s:10:\"blockTypes\";a:1:{i:0;s:34:\"core/template-part/vertical-header\";}}}}", "off");

/* INSERT TABLE DATA: dev_postmeta */
INSERT INTO `dev_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `dev_postmeta` VALUES("2", "3", "_wp_page_template", "default");

/* INSERT TABLE DATA: dev_posts */
INSERT INTO `dev_posts` VALUES("1", "1", "2026-01-20 16:50:05", "2026-01-20 15:50:05", "<!-- wp:paragraph -->\n<p>Bienvenue sur WordPress. Ceci est votre premier article. Modifiez-le ou supprimez-le, puis commencez à écrire !</p>\n<!-- /wp:paragraph -->", "Bonjour tout le monde !", "", "publish", "open", "open", "", "bonjour-tout-le-monde", "", "", "2026-01-20 16:50:05", "2026-01-20 15:50:05", "", "0", "http://dev.odysseedengrain-patesbio.fr/?p=1", "0", "post", "", "1");
INSERT INTO `dev_posts` VALUES("2", "1", "2026-01-20 16:50:05", "2026-01-20 15:50:05", "<!-- wp:paragraph -->\n<p>Ceci est une page d’exemple. C’est différent d’un article de blog parce qu’elle restera au même endroit et apparaîtra dans la navigation de votre site (dans la plupart des thèmes). La plupart des gens commencent par une page « À propos » qui les présente aux personnes visitant le site. Cela pourrait ressembler à quelque chose comme cela :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\">\n<!-- wp:paragraph -->\n<p>Bonjour ! Je suis un mécanicien qui aspire à devenir acteur, et voici mon site. J’habite à Bordeaux, j’ai un super chien baptisé Russell, et j’aime la vodka (ainsi qu’être surpris par la pluie soudaine lors de longues balades sur la plage au coucher du soleil).</p>\n<!-- /wp:paragraph -->\n</blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>…ou quelque chose comme cela :</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\">\n<!-- wp:paragraph -->\n<p>La société 123 Machin Truc a été créée en 1971, et n’a cessé de proposer au public des machins-trucs de qualité depuis lors. Située à Saint-Remy-en-Bouzemont-Saint-Genest-et-Isson, 123 Machin Truc emploie 2 000 personnes, et fabrique toutes sortes de bidules supers pour la communauté bouzemontoise.</p>\n<!-- /wp:paragraph -->\n</blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>En tant que nouvel utilisateur ou utilisatrice de WordPress, vous devriez vous rendre sur <a href=\"http://dev.odysseedengrain-patesbio.fr/wp-admin/\">votre tableau de bord</a> pour supprimer cette page et créer de nouvelles pages pour votre contenu. Amusez-vous bien !</p>\n<!-- /wp:paragraph -->", "Page d’exemple", "", "publish", "closed", "open", "", "page-d-exemple", "", "", "2026-01-20 16:50:05", "2026-01-20 15:50:05", "", "0", "http://dev.odysseedengrain-patesbio.fr/?page_id=2", "0", "page", "", "0");
INSERT INTO `dev_posts` VALUES("3", "1", "2026-01-20 16:50:05", "2026-01-20 15:50:05", "<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Qui sommes-nous ?</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>L’adresse de notre site est : http://dev.odysseedengrain-patesbio.fr.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Commentaires</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Quand vous laissez un commentaire sur notre site, les données inscrites dans le formulaire de commentaire, ainsi que votre adresse IP et l’agent utilisateur de votre navigateur sont collectés pour nous aider à la détection des commentaires indésirables.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Une chaîne anonymisée créée à partir de votre adresse e-mail (également appelée hash) peut être envoyée au service Gravatar pour vérifier si vous utilisez ce dernier. Les clauses de confidentialité du service Gravatar sont disponibles ici : https://automattic.com/privacy/. Après validation de votre commentaire, votre photo de profil sera visible publiquement à coté de votre commentaire.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Médias</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous téléversez des images sur le site, nous vous conseillons d’éviter de téléverser des images contenant des données EXIF de coordonnées GPS. Les personnes visitant votre site peuvent télécharger et extraire des données de localisation depuis ces images.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Cookies</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous déposez un commentaire sur notre site, il vous sera proposé d’enregistrer votre nom, adresse e-mail et site dans des cookies. C’est uniquement pour votre confort afin de ne pas avoir à saisir ces informations si vous déposez un autre commentaire plus tard. Ces cookies expirent au bout d’un an.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Si vous vous rendez sur la page de connexion, un cookie temporaire sera créé afin de déterminer si votre navigateur accepte les cookies. Il ne contient pas de données personnelles et sera supprimé automatiquement à la fermeture de votre navigateur.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Lorsque vous vous connecterez, nous mettrons en place un certain nombre de cookies pour enregistrer vos informations de connexion et vos préférences d’écran. La durée de vie d’un cookie de connexion est de deux jours, celle d’un cookie d’option d’écran est d’un an. Si vous cochez « Se souvenir de moi », votre cookie de connexion sera conservé pendant deux semaines. Si vous vous déconnectez de votre compte, le cookie de connexion sera effacé.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>En modifiant ou en publiant une publication, un cookie supplémentaire sera enregistré dans votre navigateur. Ce cookie ne comprend aucune donnée personnelle. Il indique simplement l’ID de la publication que vous venez de modifier. Il expire au bout d’un jour.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Contenu embarqué depuis d’autres sites</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Les articles de ce site peuvent inclure des contenus intégrés (par exemple des vidéos, images, articles…). Le contenu intégré depuis d’autres sites se comporte de la même manière que si le visiteur se rendait sur cet autre site.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Ces sites web pourraient collecter des données sur vous, utiliser des cookies, embarquer des outils de suivis tiers, suivre vos interactions avec ces contenus embarqués si vous disposez d’un compte connecté sur leur site web.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Utilisation et transmission de vos données personnelles</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous demandez une réinitialisation de votre mot de passe, votre adresse IP sera incluse dans l’e-mail de réinitialisation.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Durées de stockage de vos données</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous laissez un commentaire, le commentaire et ses métadonnées sont conservés indéfiniment. Cela permet de reconnaître et approuver automatiquement les commentaires suivants au lieu de les laisser dans la file de modération.</p>\n<!-- /wp:paragraph -->\n<!-- wp:paragraph -->\n<p>Pour les comptes qui s’inscrivent sur notre site (le cas échéant), nous stockons également les données personnelles indiquées dans leur profil. Tous les comptes peuvent voir, modifier ou supprimer leurs informations personnelles à tout moment (à l’exception de leur identifiant). Les gestionnaires du site peuvent aussi voir et modifier ces informations.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Les droits que vous avez sur vos données</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Si vous avez un compte ou si vous avez laissé des commentaires sur le site, vous pouvez demander à recevoir un fichier contenant toutes les données personnelles que nous possédons à votre sujet, incluant celles que vous nous avez fournies. Vous pouvez également demander la suppression des données personnelles vous concernant. Cela ne prend pas en compte les données stockées à des fins administratives, légales ou pour des raisons de sécurité.</p>\n<!-- /wp:paragraph -->\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Où vos données sont envoyées</h2>\n<!-- /wp:heading -->\n<!-- wp:paragraph -->\n<p><strong class=\"privacy-policy-tutorial\">Texte suggéré : </strong>Les commentaires des visiteurs peuvent être vérifiés à l’aide d’un service automatisé de détection des commentaires indésirables.</p>\n<!-- /wp:paragraph -->\n", "Politique de confidentialité", "", "draft", "closed", "open", "", "politique-de-confidentialite", "", "", "2026-01-20 16:50:05", "2026-01-20 15:50:05", "", "0", "http://dev.odysseedengrain-patesbio.fr/?page_id=3", "0", "page", "", "0");
INSERT INTO `dev_posts` VALUES("4", "0", "2026-01-20 16:50:06", "2026-01-20 15:50:06", "<!-- wp:page-list /-->", "Navigation", "", "publish", "closed", "closed", "", "navigation", "", "", "2026-01-20 16:50:06", "2026-01-20 15:50:06", "", "0", "http://dev.odysseedengrain-patesbio.fr/2026/01/20/navigation/", "0", "wp_navigation", "", "0");
INSERT INTO `dev_posts` VALUES("5", "1", "2026-01-20 16:50:27", "0000-00-00 00:00:00", "", "Brouillon auto", "", "auto-draft", "open", "open", "", "", "", "", "2026-01-20 16:50:27", "0000-00-00 00:00:00", "", "0", "http://dev.odysseedengrain-patesbio.fr/?p=5", "0", "post", "", "0");

/* INSERT TABLE DATA: dev_term_relationships */
INSERT INTO `dev_term_relationships` VALUES("1", "1", "0");

/* INSERT TABLE DATA: dev_term_taxonomy */
INSERT INTO `dev_term_taxonomy` VALUES("1", "1", "category", "", "0", "1");

/* INSERT TABLE DATA: dev_terms */
INSERT INTO `dev_terms` VALUES("1", "Non classé", "non-classe", "0");

/* INSERT TABLE DATA: dev_usermeta */
INSERT INTO `dev_usermeta` VALUES("1", "1", "nickname", "origin");
INSERT INTO `dev_usermeta` VALUES("2", "1", "first_name", "");
INSERT INTO `dev_usermeta` VALUES("3", "1", "last_name", "");
INSERT INTO `dev_usermeta` VALUES("4", "1", "description", "");
INSERT INTO `dev_usermeta` VALUES("5", "1", "rich_editing", "true");
INSERT INTO `dev_usermeta` VALUES("6", "1", "syntax_highlighting", "true");
INSERT INTO `dev_usermeta` VALUES("7", "1", "comment_shortcuts", "false");
INSERT INTO `dev_usermeta` VALUES("8", "1", "admin_color", "fresh");
INSERT INTO `dev_usermeta` VALUES("9", "1", "use_ssl", "0");
INSERT INTO `dev_usermeta` VALUES("10", "1", "show_admin_bar_front", "true");
INSERT INTO `dev_usermeta` VALUES("11", "1", "locale", "");
INSERT INTO `dev_usermeta` VALUES("12", "1", "dev_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `dev_usermeta` VALUES("13", "1", "dev_user_level", "10");
INSERT INTO `dev_usermeta` VALUES("14", "1", "dismissed_wp_pointers", "");
INSERT INTO `dev_usermeta` VALUES("15", "1", "show_welcome_panel", "1");
INSERT INTO `dev_usermeta` VALUES("16", "1", "session_tokens", "a:2:{s:64:\"9c85c271d0e2d0246bbe006baaeb8936c81a1c38802c3a84f5ddf2db682ddb9c\";a:4:{s:10:\"expiration\";i:1769097017;s:2:\"ip\";s:38:\"2a01:cb19:8241:c100:18d9:8976:c05:3ad2\";s:2:\"ua\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36\";s:5:\"login\";i:1768924217;}s:64:\"334a749311ca8b12ffa103d7070a941b9d23afa6fc0b83b1c92612514e2272ca\";a:4:{s:10:\"expiration\";i:1769097025;s:2:\"ip\";s:38:\"2a01:cb19:8241:c100:18d9:8976:c05:3ad2\";s:2:\"ua\";s:117:\"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/143.0.0.0 Safari/537.36\";s:5:\"login\";i:1768924225;}}");
INSERT INTO `dev_usermeta` VALUES("17", "1", "dev_dashboard_quick_press_last_post_id", "5");
INSERT INTO `dev_usermeta` VALUES("18", "1", "community-events-location", "a:1:{s:2:\"ip\";s:21:\"2a01:cb19:8241:c100::\";}");

/* INSERT TABLE DATA: dev_users */
INSERT INTO `dev_users` VALUES("1", "origin", "$wp$2y$10$080zAv/N7iwwulcdLWDNZ.OEQW2vJHvEzxasLZBAuf45u8cdz42x.", "origin", "contact@originartstudio.fr", "http://dev.odysseedengrain-patesbio.fr", "2026-01-20 15:50:05", "", "0", "origin");

/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("273", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-05-23 13:25:20", "2023-05-23 15:25:20", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1684848320;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1684848320;}", "4", "1", "2023-05-23 13:25:29", "2023-05-23 15:25:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("504", "action_scheduler/migration_hook", "failed", "2023-10-17 12:08:51", "2023-10-17 14:08:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1697544531;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1697544531;}", "1", "1", "2023-10-17 12:08:53", "2023-10-17 14:08:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("574", "action_scheduler/migration_hook", "failed", "2023-12-07 10:06:53", "2023-12-07 11:06:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1701943613;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1701943613;}", "1", "1", "2023-12-07 10:06:54", "2023-12-07 11:06:54", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1624", "wpo_ips_semaphore_lock_cleanup", "failed", "2025-06-05 16:07:03", "2025-06-05 18:07:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749139623;s:18:\"\0*\0first_timestamp\";i:1728402432;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749139623;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}", "5", "1", "2025-06-05 16:12:43", "2025-06-05 18:12:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1696", "wpo_ips_semaphore_lock_cleanup", "failed", "2025-07-05 16:12:43", "2025-07-05 18:12:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1751731963;s:18:\"\0*\0first_timestamp\";i:1728402432;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1751731963;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}", "5", "1", "2025-07-05 16:15:16", "2025-07-05 18:15:16", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1815", "wpo_ips_semaphore_lock_cleanup", "failed", "2025-08-04 16:15:16", "2025-08-04 18:15:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1754324116;s:18:\"\0*\0first_timestamp\";i:1728402432;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1754324116;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}", "5", "1", "2025-08-04 16:16:57", "2025-08-04 18:16:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1942", "wpo_ips_semaphore_lock_cleanup", "failed", "2025-09-03 16:16:57", "2025-09-03 18:16:57", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756916217;s:18:\"\0*\0first_timestamp\";i:1728402432;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756916217;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}", "5", "1", "2025-09-03 16:18:09", "2025-09-03 18:18:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2065", "wpo_ips_semaphore_lock_cleanup", "failed", "2025-10-03 16:18:09", "2025-10-03 18:18:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759508289;s:18:\"\0*\0first_timestamp\";i:1728402432;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759508289;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}", "5", "1", "2025-10-03 16:34:18", "2025-10-03 18:34:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2516", "woocommerce_refresh_order_count_cache", "complete", "2025-12-21 00:46:29", "2025-12-21 01:46:29", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766277989;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766277989;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-21 00:48:24", "2025-12-21 01:48:24", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2517", "woocommerce_cleanup_draft_orders", "complete", "2025-12-21 16:02:23", "2025-12-21 17:02:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766332943;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766332943;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-21 16:07:38", "2025-12-21 17:07:38", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2518", "woocommerce_cleanup_draft_orders", "complete", "2025-12-21 16:02:23", "2025-12-21 17:02:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766332943;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766332943;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-21 16:07:38", "2025-12-21 17:07:38", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2519", "wc-admin_import_orders", "complete", "2025-12-20 19:01:50", "2025-12-20 20:01:50", "[1268]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766257310;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766257310;}", "2", "1", "2025-12-20 19:04:23", "2025-12-20 20:04:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2520", "woocommerce_refresh_order_count_cache", "complete", "2025-12-21 12:48:24", "2025-12-21 13:48:24", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766321304;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766321304;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-21 12:51:26", "2025-12-21 13:51:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2521", "woocommerce_refresh_order_count_cache", "complete", "2025-12-22 00:51:26", "2025-12-22 01:51:26", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766364686;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766364686;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-22 00:54:15", "2025-12-22 01:54:15", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2522", "woocommerce_cleanup_draft_orders", "complete", "2025-12-22 16:07:38", "2025-12-22 17:07:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766419658;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766419658;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-22 16:08:12", "2025-12-22 17:08:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2523", "woocommerce_cleanup_draft_orders", "complete", "2025-12-22 16:07:38", "2025-12-22 17:07:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766419658;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766419658;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-22 16:08:12", "2025-12-22 17:08:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2524", "woocommerce_refresh_order_count_cache", "complete", "2025-12-22 12:54:15", "2025-12-22 13:54:15", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766408055;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766408055;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-22 12:54:36", "2025-12-22 13:54:36", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2525", "wc_delete_related_product_transients_async", "complete", "2025-12-22 10:27:18", "2025-12-22 11:27:18", "{\"post_id\":735}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766399238;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766399238;}", "7", "1", "2025-12-22 10:28:00", "2025-12-22 11:28:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2526", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 10:27:19", "2025-12-22 11:27:19", "[735,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766399239;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766399239;}", "3", "1", "2025-12-22 10:28:00", "2025-12-22 11:28:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2527", "wc_delete_related_product_transients_async", "complete", "2025-12-22 10:34:30", "2025-12-22 11:34:30", "{\"post_id\":713}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766399670;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766399670;}", "7", "1", "2025-12-22 10:35:01", "2025-12-22 11:35:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2528", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 10:34:31", "2025-12-22 11:34:31", "[713,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766399671;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766399671;}", "3", "1", "2025-12-22 10:35:01", "2025-12-22 11:35:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2529", "wc_delete_related_product_transients_async", "complete", "2025-12-22 10:37:35", "2025-12-22 11:37:35", "{\"post_id\":736}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766399855;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766399855;}", "7", "1", "2025-12-22 10:38:00", "2025-12-22 11:38:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2530", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 10:37:37", "2025-12-22 11:37:37", "[736,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766399857;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766399857;}", "3", "1", "2025-12-22 10:38:00", "2025-12-22 11:38:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2531", "wc_delete_related_product_transients_async", "complete", "2025-12-22 10:38:33", "2025-12-22 11:38:33", "{\"post_id\":713}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766399913;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766399913;}", "7", "1", "2025-12-22 10:39:01", "2025-12-22 11:39:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2532", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 10:38:34", "2025-12-22 11:38:34", "[713,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766399914;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766399914;}", "3", "1", "2025-12-22 10:39:01", "2025-12-22 11:39:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2533", "wc_delete_related_product_transients_async", "complete", "2025-12-22 10:39:34", "2025-12-22 11:39:34", "{\"post_id\":735}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766399974;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766399974;}", "7", "1", "2025-12-22 10:39:56", "2025-12-22 11:39:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2534", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 10:39:35", "2025-12-22 11:39:35", "[735,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766399975;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766399975;}", "3", "1", "2025-12-22 10:39:56", "2025-12-22 11:39:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2535", "wc_delete_related_product_transients_async", "complete", "2025-12-22 10:41:27", "2025-12-22 11:41:27", "{\"post_id\":737}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766400087;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766400087;}", "7", "1", "2025-12-22 10:41:57", "2025-12-22 11:41:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2536", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 10:41:28", "2025-12-22 11:41:28", "[737,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766400088;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766400088;}", "3", "1", "2025-12-22 10:41:57", "2025-12-22 11:41:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2537", "wc_delete_related_product_transients_async", "complete", "2025-12-22 10:42:39", "2025-12-22 11:42:39", "{\"post_id\":738}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766400159;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766400159;}", "7", "1", "2025-12-22 10:43:02", "2025-12-22 11:43:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2538", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 10:42:40", "2025-12-22 11:42:40", "[738,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766400160;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766400160;}", "3", "1", "2025-12-22 10:43:02", "2025-12-22 11:43:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2539", "wc_delete_related_product_transients_async", "complete", "2025-12-22 10:44:22", "2025-12-22 11:44:22", "{\"post_id\":739}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766400262;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766400262;}", "7", "1", "2025-12-22 10:45:05", "2025-12-22 11:45:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2540", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 10:44:23", "2025-12-22 11:44:23", "[739,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766400263;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766400263;}", "3", "1", "2025-12-22 10:45:05", "2025-12-22 11:45:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2541", "wc_delete_related_product_transients_async", "complete", "2025-12-22 10:45:08", "2025-12-22 11:45:08", "{\"post_id\":739}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766400308;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766400308;}", "7", "1", "2025-12-22 10:45:57", "2025-12-22 11:45:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2542", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 10:45:09", "2025-12-22 11:45:09", "[739,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766400309;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766400309;}", "3", "1", "2025-12-22 10:45:57", "2025-12-22 11:45:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2543", "wc_delete_related_product_transients_async", "complete", "2025-12-22 10:46:08", "2025-12-22 11:46:08", "{\"post_id\":740}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766400368;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766400368;}", "7", "1", "2025-12-22 10:46:45", "2025-12-22 11:46:45", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2544", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 10:46:09", "2025-12-22 11:46:09", "[740,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766400369;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766400369;}", "3", "1", "2025-12-22 10:46:45", "2025-12-22 11:46:45", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2545", "wc_delete_related_product_transients_async", "complete", "2025-12-22 10:51:45", "2025-12-22 11:51:45", "{\"post_id\":738}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766400705;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766400705;}", "7", "1", "2025-12-22 10:52:04", "2025-12-22 11:52:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2546", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 10:51:46", "2025-12-22 11:51:46", "[738,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766400706;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766400706;}", "3", "1", "2025-12-22 10:52:04", "2025-12-22 11:52:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2547", "wc_delete_related_product_transients_async", "complete", "2025-12-22 10:53:09", "2025-12-22 11:53:09", "{\"post_id\":741}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766400789;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766400789;}", "7", "1", "2025-12-22 10:54:06", "2025-12-22 11:54:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2548", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 10:53:10", "2025-12-22 11:53:10", "[741,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766400790;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766400790;}", "3", "1", "2025-12-22 10:54:06", "2025-12-22 11:54:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2549", "wc_delete_related_product_transients_async", "complete", "2025-12-22 10:56:44", "2025-12-22 11:56:44", "{\"post_id\":742}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766401004;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766401004;}", "7", "1", "2025-12-22 10:57:02", "2025-12-22 11:57:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2550", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 10:56:45", "2025-12-22 11:56:45", "[742,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766401005;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766401005;}", "3", "1", "2025-12-22 10:57:02", "2025-12-22 11:57:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2551", "wc_delete_related_product_transients_async", "complete", "2025-12-22 10:57:51", "2025-12-22 11:57:51", "{\"post_id\":743}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766401071;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766401071;}", "7", "1", "2025-12-22 10:58:08", "2025-12-22 11:58:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2552", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 10:57:52", "2025-12-22 11:57:52", "[743,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766401072;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766401072;}", "3", "1", "2025-12-22 10:58:08", "2025-12-22 11:58:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2553", "wc_delete_related_product_transients_async", "complete", "2025-12-22 10:58:58", "2025-12-22 11:58:58", "{\"post_id\":741}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766401138;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766401138;}", "7", "1", "2025-12-22 11:00:00", "2025-12-22 12:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2554", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 10:58:59", "2025-12-22 11:58:59", "[741,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766401139;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766401139;}", "3", "1", "2025-12-22 11:00:00", "2025-12-22 12:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2555", "wc_delete_related_product_transients_async", "complete", "2025-12-22 11:00:26", "2025-12-22 12:00:26", "{\"post_id\":744}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766401226;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766401226;}", "7", "1", "2025-12-22 11:01:11", "2025-12-22 12:01:11", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2556", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 11:00:27", "2025-12-22 12:00:27", "[744,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766401227;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766401227;}", "3", "1", "2025-12-22 11:01:11", "2025-12-22 12:01:11", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2557", "wc_delete_related_product_transients_async", "complete", "2025-12-22 11:01:28", "2025-12-22 12:01:28", "{\"post_id\":746}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766401288;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766401288;}", "7", "1", "2025-12-22 11:02:08", "2025-12-22 12:02:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2558", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 11:01:29", "2025-12-22 12:01:29", "[746,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766401289;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766401289;}", "3", "1", "2025-12-22 11:02:08", "2025-12-22 12:02:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2559", "wc_delete_related_product_transients_async", "complete", "2025-12-22 11:02:23", "2025-12-22 12:02:23", "{\"post_id\":753}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766401343;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766401343;}", "7", "1", "2025-12-22 11:02:56", "2025-12-22 12:02:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2560", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 11:02:24", "2025-12-22 12:02:24", "[753,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766401344;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766401344;}", "3", "1", "2025-12-22 11:02:56", "2025-12-22 12:02:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2561", "wc_delete_related_product_transients_async", "complete", "2025-12-22 11:19:10", "2025-12-22 12:19:10", "{\"post_id\":753}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766402350;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766402350;}", "7", "1", "2025-12-22 11:19:51", "2025-12-22 12:19:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2562", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 11:19:11", "2025-12-22 12:19:11", "[753,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766402351;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766402351;}", "3", "1", "2025-12-22 11:19:51", "2025-12-22 12:19:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2563", "wc_delete_related_product_transients_async", "complete", "2025-12-22 11:25:41", "2025-12-22 12:25:41", "{\"post_id\":753}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766402741;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766402741;}", "7", "1", "2025-12-22 11:26:00", "2025-12-22 12:26:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2564", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 11:25:42", "2025-12-22 12:25:42", "[753,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766402742;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766402742;}", "3", "1", "2025-12-22 11:26:00", "2025-12-22 12:26:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2565", "wc_delete_related_product_transients_async", "complete", "2025-12-22 11:28:11", "2025-12-22 12:28:11", "{\"post_id\":753}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766402891;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766402891;}", "7", "1", "2025-12-22 11:28:31", "2025-12-22 12:28:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2566", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 11:28:12", "2025-12-22 12:28:12", "[753,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766402892;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766402892;}", "3", "1", "2025-12-22 11:28:31", "2025-12-22 12:28:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2567", "wc_delete_related_product_transients_async", "complete", "2025-12-22 12:46:24", "2025-12-22 13:46:24", "{\"post_id\":605}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766407584;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766407584;}", "7", "1", "2025-12-22 12:46:59", "2025-12-22 13:46:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2568", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 12:46:25", "2025-12-22 13:46:25", "[605,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766407585;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766407585;}", "3", "1", "2025-12-22 12:46:59", "2025-12-22 13:46:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2569", "wc_delete_related_product_transients_async", "complete", "2025-12-22 12:47:35", "2025-12-22 13:47:35", "{\"post_id\":778}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766407655;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766407655;}", "7", "1", "2025-12-22 12:48:00", "2025-12-22 13:48:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2570", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 12:47:36", "2025-12-22 13:47:36", "[778,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766407656;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766407656;}", "3", "1", "2025-12-22 12:48:00", "2025-12-22 13:48:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2571", "wc_delete_related_product_transients_async", "complete", "2025-12-22 12:48:23", "2025-12-22 13:48:23", "{\"post_id\":779}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766407703;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766407703;}", "7", "1", "2025-12-22 12:48:55", "2025-12-22 13:48:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2572", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 12:48:24", "2025-12-22 13:48:24", "[779,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766407704;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766407704;}", "3", "1", "2025-12-22 12:48:55", "2025-12-22 13:48:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2573", "wc_delete_related_product_transients_async", "complete", "2025-12-22 12:49:38", "2025-12-22 13:49:38", "{\"post_id\":780}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766407778;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766407778;}", "7", "1", "2025-12-22 12:50:02", "2025-12-22 13:50:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2574", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 12:49:39", "2025-12-22 13:49:39", "[780,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766407779;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766407779;}", "3", "1", "2025-12-22 12:50:02", "2025-12-22 13:50:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2575", "wc_delete_related_product_transients_async", "complete", "2025-12-22 12:50:47", "2025-12-22 13:50:47", "{\"post_id\":605}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766407847;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766407847;}", "7", "1", "2025-12-22 12:51:00", "2025-12-22 13:51:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2576", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 12:50:48", "2025-12-22 13:50:48", "[605,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766407848;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766407848;}", "3", "1", "2025-12-22 12:51:00", "2025-12-22 13:51:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2577", "wc_delete_related_product_transients_async", "complete", "2025-12-22 12:52:49", "2025-12-22 13:52:49", "{\"post_id\":781}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766407969;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766407969;}", "7", "1", "2025-12-22 12:53:03", "2025-12-22 13:53:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2578", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 12:52:50", "2025-12-22 13:52:50", "[781,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766407970;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766407970;}", "3", "1", "2025-12-22 12:53:03", "2025-12-22 13:53:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2579", "wc_delete_related_product_transients_async", "complete", "2025-12-22 12:53:35", "2025-12-22 13:53:35", "{\"post_id\":754}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408015;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408015;}", "7", "1", "2025-12-22 12:53:56", "2025-12-22 13:53:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2580", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 12:53:36", "2025-12-22 13:53:36", "[754,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408016;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408016;}", "3", "1", "2025-12-22 12:53:56", "2025-12-22 13:53:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2581", "wc_delete_related_product_transients_async", "complete", "2025-12-22 12:54:35", "2025-12-22 13:54:35", "{\"post_id\":755}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408075;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408075;}", "7", "1", "2025-12-22 12:54:36", "2025-12-22 13:54:36", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2582", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 12:54:36", "2025-12-22 13:54:36", "[755,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408076;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408076;}", "3", "1", "2025-12-22 12:54:36", "2025-12-22 13:54:36", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2583", "woocommerce_refresh_order_count_cache", "complete", "2025-12-23 00:54:36", "2025-12-23 01:54:36", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766451276;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766451276;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-23 00:56:51", "2025-12-23 01:56:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2584", "wc_delete_related_product_transients_async", "complete", "2025-12-22 12:55:17", "2025-12-22 13:55:17", "{\"post_id\":756}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408117;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408117;}", "7", "1", "2025-12-22 12:55:41", "2025-12-22 13:55:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2585", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 12:55:18", "2025-12-22 13:55:18", "[756,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408118;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408118;}", "3", "1", "2025-12-22 12:55:41", "2025-12-22 13:55:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2586", "wc_delete_related_product_transients_async", "complete", "2025-12-22 12:56:01", "2025-12-22 13:56:01", "{\"post_id\":757}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408161;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408161;}", "7", "1", "2025-12-22 12:56:42", "2025-12-22 13:56:42", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2587", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 12:56:02", "2025-12-22 13:56:02", "[757,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408162;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408162;}", "3", "1", "2025-12-22 12:56:42", "2025-12-22 13:56:42", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2588", "wc_delete_related_product_transients_async", "complete", "2025-12-22 12:56:49", "2025-12-22 13:56:49", "{\"post_id\":758}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408209;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408209;}", "7", "1", "2025-12-22 12:56:59", "2025-12-22 13:56:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2589", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 12:56:50", "2025-12-22 13:56:50", "[758,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408210;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408210;}", "3", "1", "2025-12-22 12:56:59", "2025-12-22 13:56:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2590", "wc_delete_related_product_transients_async", "complete", "2025-12-22 12:58:12", "2025-12-22 13:58:12", "{\"post_id\":637}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408292;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408292;}", "7", "1", "2025-12-22 12:58:50", "2025-12-22 13:58:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2591", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 12:58:13", "2025-12-22 13:58:13", "[637,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408293;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408293;}", "3", "1", "2025-12-22 12:58:50", "2025-12-22 13:58:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2592", "wc_delete_related_product_transients_async", "complete", "2025-12-22 12:59:27", "2025-12-22 13:59:27", "{\"post_id\":636}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408367;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408367;}", "7", "1", "2025-12-22 12:59:52", "2025-12-22 13:59:52", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2593", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 12:59:28", "2025-12-22 13:59:28", "[636,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408368;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408368;}", "3", "1", "2025-12-22 12:59:52", "2025-12-22 13:59:52", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2594", "wc_delete_related_product_transients_async", "complete", "2025-12-22 13:00:32", "2025-12-22 14:00:32", "{\"post_id\":637}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408432;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408432;}", "7", "1", "2025-12-22 13:00:55", "2025-12-22 14:00:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2595", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 13:00:33", "2025-12-22 14:00:33", "[637,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408433;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408433;}", "3", "1", "2025-12-22 13:00:55", "2025-12-22 14:00:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2596", "wc_delete_related_product_transients_async", "complete", "2025-12-22 13:01:57", "2025-12-22 14:01:57", "{\"post_id\":759}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408517;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408517;}", "7", "1", "2025-12-22 13:01:57", "2025-12-22 14:01:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2597", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 13:01:58", "2025-12-22 14:01:58", "[759,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408518;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408518;}", "3", "1", "2025-12-22 13:03:16", "2025-12-22 14:03:16", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2598", "wc_delete_related_product_transients_async", "complete", "2025-12-22 13:02:37", "2025-12-22 14:02:37", "{\"post_id\":760}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408557;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408557;}", "7", "1", "2025-12-22 13:03:16", "2025-12-22 14:03:16", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2599", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 13:02:38", "2025-12-22 14:02:38", "[760,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408558;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408558;}", "3", "1", "2025-12-22 13:03:16", "2025-12-22 14:03:16", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2600", "wc_delete_related_product_transients_async", "complete", "2025-12-22 13:03:56", "2025-12-22 14:03:56", "{\"post_id\":855}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408636;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408636;}", "7", "1", "2025-12-22 13:03:56", "2025-12-22 14:03:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2601", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 13:03:57", "2025-12-22 14:03:57", "[855,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408637;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408637;}", "3", "1", "2025-12-22 13:04:24", "2025-12-22 14:04:24", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2602", "wc_delete_related_product_transients_async", "complete", "2025-12-22 13:04:35", "2025-12-22 14:04:35", "{\"post_id\":866}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408675;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408675;}", "7", "1", "2025-12-22 13:06:03", "2025-12-22 14:06:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2603", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 13:04:36", "2025-12-22 14:04:36", "[866,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766408676;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766408676;}", "3", "1", "2025-12-22 13:06:03", "2025-12-22 14:06:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2604", "wc_delete_related_product_transients_async", "complete", "2025-12-22 13:14:22", "2025-12-22 14:14:22", "{\"post_id\":1309}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766409262;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766409262;}", "7", "1", "2025-12-22 13:15:24", "2025-12-22 14:15:24", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2605", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 13:14:23", "2025-12-22 14:14:23", "[1309,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766409263;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766409263;}", "3", "1", "2025-12-22 13:15:24", "2025-12-22 14:15:24", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2606", "wc_delete_related_product_transients_async", "complete", "2025-12-22 13:29:07", "2025-12-22 14:29:07", "{\"post_id\":1314}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766410147;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766410147;}", "7", "1", "2025-12-22 13:29:37", "2025-12-22 14:29:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2607", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 13:29:08", "2025-12-22 14:29:08", "[1314,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766410148;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766410148;}", "3", "1", "2025-12-22 13:29:37", "2025-12-22 14:29:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2608", "wc_delete_related_product_transients_async", "complete", "2025-12-22 13:35:22", "2025-12-22 14:35:22", "{\"post_id\":1315}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766410522;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766410522;}", "7", "1", "2025-12-22 13:35:58", "2025-12-22 14:35:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2609", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 13:35:23", "2025-12-22 14:35:23", "[1315,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766410523;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766410523;}", "3", "1", "2025-12-22 13:35:58", "2025-12-22 14:35:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2610", "wc_delete_related_product_transients_async", "complete", "2025-12-22 13:40:10", "2025-12-22 14:40:10", "{\"post_id\":1317}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766410810;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766410810;}", "7", "1", "2025-12-22 13:40:17", "2025-12-22 14:40:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2611", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 13:40:11", "2025-12-22 14:40:11", "[1317,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766410811;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766410811;}", "3", "1", "2025-12-22 13:40:17", "2025-12-22 14:40:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2612", "wc_delete_related_product_transients_async", "complete", "2025-12-22 13:40:40", "2025-12-22 14:40:40", "{\"post_id\":1317}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766410840;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766410840;}", "7", "1", "2025-12-22 13:41:04", "2025-12-22 14:41:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2613", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 13:40:41", "2025-12-22 14:40:41", "[1317,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766410841;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766410841;}", "3", "1", "2025-12-22 13:41:04", "2025-12-22 14:41:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2614", "wc_delete_related_product_transients_async", "complete", "2025-12-22 13:47:38", "2025-12-22 14:47:38", "{\"post_id\":1320}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766411258;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766411258;}", "7", "1", "2025-12-22 13:48:04", "2025-12-22 14:48:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2615", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 13:47:39", "2025-12-22 14:47:39", "[1320,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766411259;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766411259;}", "3", "1", "2025-12-22 13:48:04", "2025-12-22 14:48:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2616", "wc_delete_related_product_transients_async", "complete", "2025-12-22 13:48:14", "2025-12-22 14:48:14", "{\"post_id\":1320}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766411294;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766411294;}", "7", "1", "2025-12-22 13:49:01", "2025-12-22 14:49:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2617", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 13:48:15", "2025-12-22 14:48:15", "[1320,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766411295;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766411295;}", "3", "1", "2025-12-22 13:49:01", "2025-12-22 14:49:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2618", "wc_delete_related_product_transients_async", "complete", "2025-12-22 13:49:28", "2025-12-22 14:49:28", "{\"post_id\":1320}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766411368;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766411368;}", "7", "1", "2025-12-22 13:49:58", "2025-12-22 14:49:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2619", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 13:49:29", "2025-12-22 14:49:29", "[1320,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766411369;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766411369;}", "3", "1", "2025-12-22 13:49:58", "2025-12-22 14:49:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2620", "wc_delete_related_product_transients_async", "complete", "2025-12-22 13:51:07", "2025-12-22 14:51:07", "{\"post_id\":754}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766411467;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766411467;}", "7", "1", "2025-12-22 13:51:41", "2025-12-22 14:51:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2621", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 13:51:08", "2025-12-22 14:51:08", "[754,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766411468;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766411468;}", "3", "1", "2025-12-22 13:51:41", "2025-12-22 14:51:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2622", "wc_delete_related_product_transients_async", "complete", "2025-12-22 13:51:28", "2025-12-22 14:51:28", "{\"post_id\":1320}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766411488;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766411488;}", "7", "1", "2025-12-22 13:51:41", "2025-12-22 14:51:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2623", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 13:51:30", "2025-12-22 14:51:30", "[1320,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766411490;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766411490;}", "3", "1", "2025-12-22 13:51:41", "2025-12-22 14:51:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2624", "wc_delete_related_product_transients_async", "complete", "2025-12-22 13:56:49", "2025-12-22 14:56:49", "{\"post_id\":1323}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766411809;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766411809;}", "7", "1", "2025-12-22 13:57:17", "2025-12-22 14:57:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2625", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 13:56:50", "2025-12-22 14:56:50", "[1323,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766411810;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766411810;}", "3", "1", "2025-12-22 13:57:17", "2025-12-22 14:57:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2626", "wc_delete_related_product_transients_async", "complete", "2025-12-22 13:57:23", "2025-12-22 14:57:23", "{\"post_id\":1323}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766411843;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766411843;}", "7", "1", "2025-12-22 13:57:58", "2025-12-22 14:57:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2627", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 13:57:24", "2025-12-22 14:57:24", "[1323,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766411844;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766411844;}", "3", "1", "2025-12-22 13:57:58", "2025-12-22 14:57:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2628", "wc_delete_related_product_transients_async", "complete", "2025-12-22 14:09:53", "2025-12-22 15:09:53", "{\"post_id\":855}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766412593;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766412593;}", "7", "1", "2025-12-22 14:09:55", "2025-12-22 15:09:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2629", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 14:09:54", "2025-12-22 15:09:54", "[855,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766412594;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766412594;}", "3", "1", "2025-12-22 14:09:56", "2025-12-22 15:09:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2630", "wc_delete_related_product_transients_async", "complete", "2025-12-22 14:12:36", "2025-12-22 15:12:36", "{\"post_id\":866}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766412756;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766412756;}", "7", "1", "2025-12-22 14:12:51", "2025-12-22 15:12:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2631", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 14:12:37", "2025-12-22 15:12:37", "[866,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766412757;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766412757;}", "3", "1", "2025-12-22 14:12:51", "2025-12-22 15:12:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2632", "wc_delete_related_product_transients_async", "complete", "2025-12-22 14:14:20", "2025-12-22 15:14:20", "{\"post_id\":1327}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766412860;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766412860;}", "7", "1", "2025-12-22 14:14:54", "2025-12-22 15:14:54", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2633", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 14:14:21", "2025-12-22 15:14:21", "[1327,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766412861;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766412861;}", "3", "1", "2025-12-22 14:14:54", "2025-12-22 15:14:54", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2634", "wc_delete_related_product_transients_async", "complete", "2025-12-22 14:22:34", "2025-12-22 15:22:34", "{\"post_id\":1327}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766413354;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766413354;}", "7", "1", "2025-12-22 14:23:03", "2025-12-22 15:23:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2635", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 14:22:35", "2025-12-22 15:22:35", "[1327,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766413355;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766413355;}", "3", "1", "2025-12-22 14:23:03", "2025-12-22 15:23:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2636", "wc_delete_related_product_transients_async", "complete", "2025-12-22 14:24:26", "2025-12-22 15:24:26", "{\"post_id\":1327}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766413466;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766413466;}", "7", "1", "2025-12-22 14:25:16", "2025-12-22 15:25:16", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2637", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 14:24:27", "2025-12-22 15:24:27", "[1327,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766413467;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766413467;}", "3", "1", "2025-12-22 14:25:16", "2025-12-22 15:25:16", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2638", "wc_delete_related_product_transients_async", "complete", "2025-12-22 14:25:19", "2025-12-22 15:25:19", "{\"post_id\":1327}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766413519;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766413519;}", "7", "1", "2025-12-22 14:25:55", "2025-12-22 15:25:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2639", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 14:25:20", "2025-12-22 15:25:20", "[1327,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766413520;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766413520;}", "3", "1", "2025-12-22 14:25:55", "2025-12-22 15:25:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2640", "wc_delete_related_product_transients_async", "complete", "2025-12-22 14:26:07", "2025-12-22 15:26:07", "{\"post_id\":1328}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766413567;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766413567;}", "7", "1", "2025-12-22 14:26:21", "2025-12-22 15:26:21", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2641", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 14:26:08", "2025-12-22 15:26:08", "[1328,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766413568;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766413568;}", "3", "1", "2025-12-22 14:26:21", "2025-12-22 15:26:21", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2642", "wc_delete_related_product_transients_async", "complete", "2025-12-22 14:29:13", "2025-12-22 15:29:13", "{\"post_id\":1327}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766413753;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766413753;}", "7", "1", "2025-12-22 14:29:30", "2025-12-22 15:29:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2643", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 14:29:14", "2025-12-22 15:29:14", "[1327,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766413754;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766413754;}", "3", "1", "2025-12-22 14:29:30", "2025-12-22 15:29:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2644", "wc_delete_related_product_transients_async", "complete", "2025-12-22 14:30:08", "2025-12-22 15:30:08", "{\"post_id\":1328}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766413808;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766413808;}", "7", "1", "2025-12-22 14:30:40", "2025-12-22 15:30:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2645", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 14:30:09", "2025-12-22 15:30:09", "[1328,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766413809;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766413809;}", "3", "1", "2025-12-22 14:30:40", "2025-12-22 15:30:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2646", "wc_delete_related_product_transients_async", "complete", "2025-12-22 14:30:49", "2025-12-22 15:30:49", "{\"post_id\":1328}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766413849;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766413849;}", "7", "1", "2025-12-22 14:31:02", "2025-12-22 15:31:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2647", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 14:30:50", "2025-12-22 15:30:50", "[1328,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766413850;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766413850;}", "3", "1", "2025-12-22 14:31:02", "2025-12-22 15:31:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2648", "wc_delete_related_product_transients_async", "complete", "2025-12-22 14:31:03", "2025-12-22 15:31:03", "{\"post_id\":1328}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766413863;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766413863;}", "7", "1", "2025-12-22 14:31:50", "2025-12-22 15:31:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2649", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 14:31:05", "2025-12-22 15:31:05", "[1328,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766413865;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766413865;}", "3", "1", "2025-12-22 14:31:50", "2025-12-22 15:31:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2650", "wc_delete_related_product_transients_async", "complete", "2025-12-22 15:02:34", "2025-12-22 16:02:34", "{\"post_id\":870}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766415754;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766415754;}", "7", "1", "2025-12-22 15:03:00", "2025-12-22 16:03:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2651", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 15:02:35", "2025-12-22 16:02:35", "[870,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766415755;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766415755;}", "3", "1", "2025-12-22 15:03:00", "2025-12-22 16:03:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2652", "wc_delete_related_product_transients_async", "complete", "2025-12-22 15:03:21", "2025-12-22 16:03:21", "{\"post_id\":743}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766415801;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766415801;}", "7", "1", "2025-12-22 15:04:16", "2025-12-22 16:04:16", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2653", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 15:03:22", "2025-12-22 16:03:22", "[743,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766415802;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766415802;}", "3", "1", "2025-12-22 15:04:16", "2025-12-22 16:04:16", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2654", "wc_delete_related_product_transients_async", "complete", "2025-12-22 15:07:12", "2025-12-22 16:07:12", "{\"post_id\":756}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766416032;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766416032;}", "7", "1", "2025-12-22 15:07:34", "2025-12-22 16:07:34", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2655", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 15:07:13", "2025-12-22 16:07:13", "[756,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766416033;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766416033;}", "3", "1", "2025-12-22 15:07:34", "2025-12-22 16:07:34", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2656", "wc_delete_related_product_transients_async", "complete", "2025-12-22 15:10:34", "2025-12-22 16:10:34", "{\"post_id\":874}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766416234;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766416234;}", "7", "1", "2025-12-22 15:10:51", "2025-12-22 16:10:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2657", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 15:10:35", "2025-12-22 16:10:35", "[874,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766416235;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766416235;}", "3", "1", "2025-12-22 15:10:51", "2025-12-22 16:10:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2658", "wc_delete_related_product_transients_async", "complete", "2025-12-22 15:39:45", "2025-12-22 16:39:45", "{\"post_id\":875}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766417985;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766417985;}", "7", "1", "2025-12-22 15:40:00", "2025-12-22 16:40:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2659", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 15:39:46", "2025-12-22 16:39:46", "[875,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766417986;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766417986;}", "3", "1", "2025-12-22 15:40:00", "2025-12-22 16:40:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2660", "wc_delete_related_product_transients_async", "complete", "2025-12-22 15:40:44", "2025-12-22 16:40:44", "{\"post_id\":870}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766418044;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766418044;}", "7", "1", "2025-12-22 15:40:59", "2025-12-22 16:40:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2661", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 15:40:45", "2025-12-22 16:40:45", "[870,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766418045;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766418045;}", "3", "1", "2025-12-22 15:40:59", "2025-12-22 16:40:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2662", "wc_delete_related_product_transients_async", "complete", "2025-12-22 15:40:55", "2025-12-22 16:40:55", "{\"post_id\":875}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766418055;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766418055;}", "7", "1", "2025-12-22 15:40:59", "2025-12-22 16:40:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2663", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 15:40:56", "2025-12-22 16:40:56", "[875,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766418056;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766418056;}", "3", "1", "2025-12-22 15:40:59", "2025-12-22 16:40:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2664", "wc_delete_related_product_transients_async", "complete", "2025-12-22 15:41:49", "2025-12-22 16:41:49", "{\"post_id\":874}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766418109;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766418109;}", "7", "1", "2025-12-22 15:42:06", "2025-12-22 16:42:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2665", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 15:41:50", "2025-12-22 16:41:50", "[874,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766418110;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766418110;}", "3", "1", "2025-12-22 15:42:06", "2025-12-22 16:42:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2666", "wc_delete_related_product_transients_async", "complete", "2025-12-22 15:56:44", "2025-12-22 16:56:44", "{\"post_id\":664}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766419004;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766419004;}", "7", "1", "2025-12-22 15:56:56", "2025-12-22 16:56:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2667", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 15:56:45", "2025-12-22 16:56:45", "[664,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766419005;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766419005;}", "3", "1", "2025-12-22 15:56:56", "2025-12-22 16:56:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2668", "wc_delete_related_product_transients_async", "complete", "2025-12-22 15:58:07", "2025-12-22 16:58:07", "{\"post_id\":664}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766419087;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766419087;}", "7", "1", "2025-12-22 15:59:02", "2025-12-22 16:59:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2669", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 15:58:08", "2025-12-22 16:58:08", "[664,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766419088;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766419088;}", "3", "1", "2025-12-22 15:59:02", "2025-12-22 16:59:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2670", "wc_delete_related_product_transients_async", "complete", "2025-12-22 16:00:00", "2025-12-22 17:00:00", "{\"post_id\":664}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766419200;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766419200;}", "7", "1", "2025-12-22 16:00:00", "2025-12-22 17:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2671", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 16:00:01", "2025-12-22 17:00:01", "[664,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766419201;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766419201;}", "3", "1", "2025-12-22 16:00:03", "2025-12-22 17:00:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2672", "wc_delete_related_product_transients_async", "complete", "2025-12-22 16:07:26", "2025-12-22 17:07:26", "{\"post_id\":664}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766419646;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766419646;}", "7", "1", "2025-12-22 16:08:12", "2025-12-22 17:08:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2673", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 16:07:27", "2025-12-22 17:07:27", "[664,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766419647;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766419647;}", "3", "1", "2025-12-22 16:08:12", "2025-12-22 17:08:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2674", "woocommerce_cleanup_draft_orders", "complete", "2025-12-23 16:08:12", "2025-12-23 17:08:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766506092;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766506092;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-23 16:10:14", "2025-12-23 17:10:14", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2675", "woocommerce_cleanup_draft_orders", "complete", "2025-12-23 16:08:12", "2025-12-23 17:08:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766506092;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766506092;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-23 16:10:14", "2025-12-23 17:10:14", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2676", "wc_delete_related_product_transients_async", "complete", "2025-12-22 16:08:19", "2025-12-22 17:08:19", "{\"post_id\":664}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766419699;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766419699;}", "7", "1", "2025-12-22 16:09:32", "2025-12-22 17:09:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2677", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 16:08:20", "2025-12-22 17:08:20", "[664,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766419700;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766419700;}", "3", "1", "2025-12-22 16:09:32", "2025-12-22 17:09:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2678", "wc_delete_related_product_transients_async", "complete", "2025-12-22 16:10:24", "2025-12-22 17:10:24", "{\"post_id\":781}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766419824;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766419824;}", "7", "1", "2025-12-22 16:11:04", "2025-12-22 17:11:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2679", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 16:10:25", "2025-12-22 17:10:25", "[781,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766419825;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766419825;}", "3", "1", "2025-12-22 16:11:04", "2025-12-22 17:11:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2680", "wc_delete_related_product_transients_async", "complete", "2025-12-22 16:13:26", "2025-12-22 17:13:26", "{\"post_id\":1328}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766420006;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766420006;}", "7", "1", "2025-12-22 16:14:15", "2025-12-22 17:14:15", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2681", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-22 16:13:27", "2025-12-22 17:13:27", "[1328,2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766420007;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766420007;}", "3", "1", "2025-12-22 16:14:15", "2025-12-22 17:14:15", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2682", "woocommerce_refresh_order_count_cache", "complete", "2025-12-23 12:56:51", "2025-12-23 13:56:51", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766494611;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766494611;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-23 13:03:29", "2025-12-23 14:03:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2683", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2025-12-23 02:59:51", "2025-12-23 03:59:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766458791;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766458791;}", "3", "1", "2025-12-23 03:00:35", "2025-12-23 04:00:35", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2684", "woocommerce_refresh_order_count_cache", "complete", "2025-12-24 01:03:29", "2025-12-24 02:03:29", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766538209;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766538209;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-24 01:03:32", "2025-12-24 02:03:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2685", "woocommerce_cleanup_draft_orders", "complete", "2025-12-24 16:10:14", "2025-12-24 17:10:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766592614;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766592614;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-24 16:12:47", "2025-12-24 17:12:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2686", "woocommerce_cleanup_draft_orders", "complete", "2025-12-24 16:10:14", "2025-12-24 17:10:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766592614;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766592614;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-24 16:12:47", "2025-12-24 17:12:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2687", "woocommerce_refresh_order_count_cache", "complete", "2025-12-24 13:03:32", "2025-12-24 14:03:32", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766581412;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766581412;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-24 13:03:52", "2025-12-24 14:03:52", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2688", "woocommerce_refresh_order_count_cache", "complete", "2025-12-25 01:03:52", "2025-12-25 02:03:52", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766624632;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766624632;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-25 01:04:17", "2025-12-25 02:04:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2689", "woocommerce_cleanup_draft_orders", "complete", "2025-12-25 16:12:47", "2025-12-25 17:12:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766679167;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766679167;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-25 16:13:00", "2025-12-25 17:13:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2690", "woocommerce_cleanup_draft_orders", "complete", "2025-12-25 16:12:47", "2025-12-25 17:12:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766679167;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766679167;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-25 16:13:00", "2025-12-25 17:13:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2691", "woocommerce_refresh_order_count_cache", "complete", "2025-12-25 13:04:17", "2025-12-25 14:04:17", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766667857;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766667857;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-25 13:17:32", "2025-12-25 14:17:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2692", "woocommerce_refresh_order_count_cache", "complete", "2025-12-26 01:17:32", "2025-12-26 02:17:32", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766711852;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766711852;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-26 01:50:24", "2025-12-26 02:50:24", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2693", "woocommerce_cleanup_draft_orders", "complete", "2025-12-26 16:13:00", "2025-12-26 17:13:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766765580;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766765580;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-26 16:14:16", "2025-12-26 17:14:16", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2694", "woocommerce_cleanup_draft_orders", "complete", "2025-12-26 16:13:00", "2025-12-26 17:13:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766765580;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766765580;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-26 16:14:16", "2025-12-26 17:14:16", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2695", "woocommerce_refresh_order_count_cache", "complete", "2025-12-26 13:50:24", "2025-12-26 14:50:24", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766757024;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766757024;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-26 13:53:23", "2025-12-26 14:53:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2696", "woocommerce_refresh_order_count_cache", "complete", "2025-12-27 01:53:23", "2025-12-27 02:53:23", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766800403;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766800403;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-27 02:03:22", "2025-12-27 03:03:22", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2697", "woocommerce_cleanup_draft_orders", "complete", "2025-12-27 16:14:16", "2025-12-27 17:14:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766852056;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766852056;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-27 16:14:47", "2025-12-27 17:14:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2698", "woocommerce_cleanup_draft_orders", "complete", "2025-12-27 16:14:16", "2025-12-27 17:14:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766852056;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766852056;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-27 16:14:47", "2025-12-27 17:14:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2699", "woocommerce_refresh_order_count_cache", "complete", "2025-12-27 14:03:22", "2025-12-27 15:03:22", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766844202;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766844202;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-27 14:07:43", "2025-12-27 15:07:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2700", "woocommerce_refresh_order_count_cache", "complete", "2025-12-28 02:07:43", "2025-12-28 03:07:43", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766887663;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766887663;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-28 02:10:48", "2025-12-28 03:10:48", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2701", "woocommerce_cleanup_draft_orders", "complete", "2025-12-28 16:14:47", "2025-12-28 17:14:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766938487;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766938487;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-28 16:15:31", "2025-12-28 17:15:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2702", "woocommerce_cleanup_draft_orders", "complete", "2025-12-28 16:14:47", "2025-12-28 17:14:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766938487;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766938487;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-28 16:15:31", "2025-12-28 17:15:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2703", "woocommerce_refresh_order_count_cache", "complete", "2025-12-28 14:10:48", "2025-12-28 15:10:48", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766931048;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766931048;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-28 14:12:13", "2025-12-28 15:12:13", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2704", "wc-admin_import_orders", "complete", "2025-12-28 09:50:23", "2025-12-28 10:50:23", "[1349]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766915423;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766915423;}", "2", "1", "2025-12-28 09:50:56", "2025-12-28 10:50:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2705", "wc-admin_import_orders", "complete", "2025-12-28 11:35:04", "2025-12-28 12:35:04", "[1348]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766921704;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766921704;}", "2", "1", "2025-12-28 11:41:20", "2025-12-28 12:41:20", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2706", "woocommerce_refresh_order_count_cache", "complete", "2025-12-29 02:12:13", "2025-12-29 03:12:13", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1766974333;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1766974333;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-29 02:18:23", "2025-12-29 03:18:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2707", "woocommerce_cleanup_draft_orders", "complete", "2025-12-29 16:15:31", "2025-12-29 17:15:31", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767024931;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767024931;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-29 16:19:51", "2025-12-29 17:19:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2708", "woocommerce_cleanup_draft_orders", "complete", "2025-12-29 16:15:31", "2025-12-29 17:15:31", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767024931;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767024931;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-29 16:19:51", "2025-12-29 17:19:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2709", "wc-admin_import_orders", "complete", "2025-12-28 17:07:05", "2025-12-28 18:07:05", "[1350]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766941625;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766941625;}", "2", "1", "2025-12-28 17:10:05", "2025-12-28 18:10:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2710", "wc-admin_import_orders", "complete", "2025-12-28 20:13:30", "2025-12-28 21:13:30", "[1351]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1766952810;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1766952810;}", "2", "1", "2025-12-28 20:19:26", "2025-12-28 21:19:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2711", "woocommerce_refresh_order_count_cache", "complete", "2025-12-29 14:18:23", "2025-12-29 15:18:23", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767017903;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767017903;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-29 14:19:53", "2025-12-29 15:19:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2712", "woocommerce_refresh_order_count_cache", "complete", "2025-12-30 02:19:53", "2025-12-30 03:19:53", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767061193;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767061193;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-30 02:27:10", "2025-12-30 03:27:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2713", "woocommerce_cleanup_draft_orders", "complete", "2025-12-30 16:19:51", "2025-12-30 17:19:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767111591;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767111591;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-30 16:19:59", "2025-12-30 17:19:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2714", "woocommerce_cleanup_draft_orders", "complete", "2025-12-30 16:19:51", "2025-12-30 17:19:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767111591;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767111591;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-30 16:19:59", "2025-12-30 17:19:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2715", "woocommerce_refresh_order_count_cache", "complete", "2025-12-30 14:27:10", "2025-12-30 15:27:10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767104830;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767104830;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-30 14:28:18", "2025-12-30 15:28:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2716", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-30 08:32:53", "2025-12-30 09:32:53", "[1302,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767083573;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767083573;}", "3", "1", "2025-12-30 08:41:43", "2025-12-30 09:41:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2717", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-30 08:32:53", "2025-12-30 09:32:53", "[1307,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767083573;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767083573;}", "3", "1", "2025-12-30 08:41:43", "2025-12-30 09:41:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2718", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-30 08:32:53", "2025-12-30 09:32:53", "[1318,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767083573;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767083573;}", "3", "1", "2025-12-30 08:41:43", "2025-12-30 09:41:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2719", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-30 08:32:53", "2025-12-30 09:32:53", "[1319,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767083573;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767083573;}", "3", "1", "2025-12-30 08:41:43", "2025-12-30 09:41:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2720", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-12-30 08:32:53", "2025-12-30 09:32:53", "[1324,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767083573;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767083573;}", "3", "1", "2025-12-30 08:41:43", "2025-12-30 09:41:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2721", "woocommerce_refresh_order_count_cache", "complete", "2025-12-31 02:28:18", "2025-12-31 03:28:18", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767148098;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767148098;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-31 02:28:30", "2025-12-31 03:28:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2722", "woocommerce_cleanup_draft_orders", "complete", "2025-12-31 16:19:59", "2025-12-31 17:19:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767197999;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767197999;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-31 16:23:48", "2025-12-31 17:23:48", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2723", "woocommerce_cleanup_draft_orders", "complete", "2025-12-31 16:19:59", "2025-12-31 17:19:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767197999;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767197999;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-12-31 16:23:48", "2025-12-31 17:23:48", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2724", "woocommerce_refresh_order_count_cache", "complete", "2025-12-31 14:28:30", "2025-12-31 15:28:30", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767191310;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767191310;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2025-12-31 14:29:30", "2025-12-31 15:29:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2725", "woocommerce_refresh_order_count_cache", "complete", "2026-01-01 02:29:30", "2026-01-01 03:29:30", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767234570;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767234570;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-01 02:29:52", "2026-01-01 03:29:52", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2726", "woocommerce_cleanup_draft_orders", "complete", "2026-01-01 16:23:48", "2026-01-01 17:23:48", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767284628;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767284628;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-01 16:27:03", "2026-01-01 17:27:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2727", "woocommerce_cleanup_draft_orders", "complete", "2026-01-01 16:23:48", "2026-01-01 17:23:48", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767284628;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767284628;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-01 16:27:03", "2026-01-01 17:27:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2728", "woocommerce_refresh_order_count_cache", "complete", "2026-01-01 14:29:52", "2026-01-01 15:29:52", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767277792;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767277792;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-01 14:30:15", "2026-01-01 15:30:15", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2729", "woocommerce_refresh_order_count_cache", "complete", "2026-01-02 02:30:15", "2026-01-02 03:30:15", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767321015;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767321015;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-02 02:31:06", "2026-01-02 03:31:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2730", "woocommerce_cleanup_draft_orders", "complete", "2026-01-02 16:27:03", "2026-01-02 17:27:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767371223;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767371223;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-02 16:32:10", "2026-01-02 17:32:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2731", "woocommerce_cleanup_draft_orders", "complete", "2026-01-02 16:27:03", "2026-01-02 17:27:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767371223;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767371223;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-02 16:32:10", "2026-01-02 17:32:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2732", "woocommerce_refresh_order_count_cache", "complete", "2026-01-02 14:31:06", "2026-01-02 15:31:06", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767364266;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767364266;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-02 14:31:27", "2026-01-02 15:31:27", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2733", "woocommerce_refresh_order_count_cache", "complete", "2026-01-03 02:31:27", "2026-01-03 03:31:27", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767407487;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767407487;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-03 02:37:24", "2026-01-03 03:37:24", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2734", "woocommerce_cleanup_draft_orders", "complete", "2026-01-03 16:32:10", "2026-01-03 17:32:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767457930;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767457930;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-03 16:33:28", "2026-01-03 17:33:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2735", "woocommerce_cleanup_draft_orders", "complete", "2026-01-03 16:32:10", "2026-01-03 17:32:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767457930;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767457930;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-03 16:33:28", "2026-01-03 17:33:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2736", "woocommerce_refresh_order_count_cache", "complete", "2026-01-03 14:37:24", "2026-01-03 15:37:24", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767451044;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767451044;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-03 14:38:51", "2026-01-03 15:38:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2737", "woocommerce_refresh_order_count_cache", "complete", "2026-01-04 02:38:51", "2026-01-04 03:38:51", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767494331;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767494331;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-04 02:39:49", "2026-01-04 03:39:49", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2738", "wc-admin_import_orders", "complete", "2026-01-03 16:24:03", "2026-01-03 17:24:03", "[1352]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767457443;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767457443;}", "2", "1", "2026-01-03 16:25:16", "2026-01-03 17:25:16", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2739", "wc-admin_import_orders", "complete", "2026-01-03 16:25:59", "2026-01-03 17:25:59", "[1352]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767457559;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767457559;}", "2", "1", "2026-01-03 16:29:51", "2026-01-03 17:29:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2740", "woocommerce_cleanup_draft_orders", "complete", "2026-01-04 16:33:28", "2026-01-04 17:33:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767544408;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767544408;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-04 16:38:12", "2026-01-04 17:38:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2741", "woocommerce_cleanup_draft_orders", "complete", "2026-01-04 16:33:28", "2026-01-04 17:33:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767544408;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767544408;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-04 16:38:12", "2026-01-04 17:38:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2742", "woocommerce_refresh_order_count_cache", "complete", "2026-01-04 14:39:49", "2026-01-04 15:39:49", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767537589;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767537589;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-04 14:40:20", "2026-01-04 15:40:20", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2743", "woocommerce_refresh_order_count_cache", "complete", "2026-01-05 02:40:20", "2026-01-05 03:40:20", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767580820;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767580820;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-05 02:42:13", "2026-01-05 03:42:13", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2744", "woocommerce_cleanup_draft_orders", "complete", "2026-01-05 16:38:12", "2026-01-05 17:38:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767631092;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767631092;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-05 16:39:23", "2026-01-05 17:39:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2745", "woocommerce_cleanup_draft_orders", "complete", "2026-01-05 16:38:12", "2026-01-05 17:38:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767631092;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767631092;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-05 16:39:23", "2026-01-05 17:39:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2746", "woocommerce_refresh_order_count_cache", "complete", "2026-01-05 14:42:13", "2026-01-05 15:42:13", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767624133;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767624133;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-05 14:47:56", "2026-01-05 15:47:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2747", "wc-admin_import_orders", "complete", "2026-01-05 11:26:18", "2026-01-05 12:26:18", "[1353]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767612378;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767612378;}", "2", "1", "2026-01-05 11:30:07", "2026-01-05 12:30:07", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2748", "woocommerce_refresh_order_count_cache", "complete", "2026-01-06 02:47:56", "2026-01-06 03:47:56", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767667676;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767667676;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-06 02:48:48", "2026-01-06 03:48:48", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2749", "woocommerce_cleanup_draft_orders", "complete", "2026-01-06 16:39:23", "2026-01-06 17:39:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767717563;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767717563;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-06 16:46:49", "2026-01-06 17:46:49", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2750", "woocommerce_cleanup_draft_orders", "complete", "2026-01-06 16:39:23", "2026-01-06 17:39:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767717563;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767717563;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-06 16:46:49", "2026-01-06 17:46:49", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2751", "woocommerce_refresh_order_count_cache", "complete", "2026-01-06 14:48:48", "2026-01-06 15:48:48", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767710928;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767710928;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-06 14:50:14", "2026-01-06 15:50:14", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2752", "woocommerce_refresh_order_count_cache", "complete", "2026-01-07 02:50:14", "2026-01-07 03:50:14", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767754214;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767754214;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-07 02:57:02", "2026-01-07 03:57:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2753", "woocommerce_cleanup_draft_orders", "complete", "2026-01-07 16:46:49", "2026-01-07 17:46:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767804409;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767804409;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-07 16:51:12", "2026-01-07 17:51:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2754", "woocommerce_cleanup_draft_orders", "complete", "2026-01-07 16:46:49", "2026-01-07 17:46:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767804409;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767804409;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-07 16:51:12", "2026-01-07 17:51:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2755", "woocommerce_refresh_order_count_cache", "complete", "2026-01-07 14:57:02", "2026-01-07 15:57:02", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767797822;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767797822;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-07 14:57:02", "2026-01-07 15:57:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2756", "wc-admin_import_orders", "complete", "2026-01-07 10:39:10", "2026-01-07 11:39:10", "[1355]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1767782350;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1767782350;}", "2", "1", "2026-01-07 10:40:04", "2026-01-07 11:40:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2757", "woocommerce_refresh_order_count_cache", "complete", "2026-01-08 02:57:02", "2026-01-08 03:57:02", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767841022;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767841022;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-08 02:57:51", "2026-01-08 03:57:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2758", "woocommerce_cleanup_draft_orders", "complete", "2026-01-08 16:51:12", "2026-01-08 17:51:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767891072;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767891072;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-08 16:51:24", "2026-01-08 17:51:24", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2759", "woocommerce_cleanup_draft_orders", "complete", "2026-01-08 16:51:12", "2026-01-08 17:51:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767891072;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767891072;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-08 16:51:24", "2026-01-08 17:51:24", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2760", "woocommerce_refresh_order_count_cache", "complete", "2026-01-08 14:57:51", "2026-01-08 15:57:51", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767884271;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767884271;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-08 14:58:30", "2026-01-08 15:58:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2761", "woocommerce_refresh_order_count_cache", "complete", "2026-01-09 02:58:30", "2026-01-09 03:58:30", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767927510;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767927510;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-09 03:00:28", "2026-01-09 04:00:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2762", "woocommerce_cleanup_draft_orders", "complete", "2026-01-09 16:51:24", "2026-01-09 17:51:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767977484;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767977484;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-09 16:53:53", "2026-01-09 17:53:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2763", "woocommerce_cleanup_draft_orders", "complete", "2026-01-09 16:51:24", "2026-01-09 17:51:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767977484;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767977484;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-09 16:53:53", "2026-01-09 17:53:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2764", "woocommerce_refresh_order_count_cache", "complete", "2026-01-09 15:00:28", "2026-01-09 16:00:28", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1767970828;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1767970828;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-09 15:00:59", "2026-01-09 16:00:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2765", "woocommerce_refresh_order_count_cache", "complete", "2026-01-10 03:00:59", "2026-01-10 04:00:59", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768014059;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768014059;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-10 03:09:20", "2026-01-10 04:09:20", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2766", "woocommerce_cleanup_draft_orders", "complete", "2026-01-10 16:53:53", "2026-01-10 17:53:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768064033;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768064033;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-10 16:56:44", "2026-01-10 17:56:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2767", "woocommerce_cleanup_draft_orders", "complete", "2026-01-10 16:53:53", "2026-01-10 17:53:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768064033;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768064033;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-10 16:56:44", "2026-01-10 17:56:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2768", "woocommerce_refresh_order_count_cache", "complete", "2026-01-10 15:09:20", "2026-01-10 16:09:20", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768057760;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768057760;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-10 15:13:40", "2026-01-10 16:13:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2769", "woocommerce_refresh_order_count_cache", "complete", "2026-01-11 03:13:40", "2026-01-11 04:13:40", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768101220;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768101220;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-11 03:14:01", "2026-01-11 04:14:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2770", "woocommerce_cleanup_draft_orders", "complete", "2026-01-11 16:56:44", "2026-01-11 17:56:44", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768150604;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768150604;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-11 17:01:35", "2026-01-11 18:01:35", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2771", "woocommerce_cleanup_draft_orders", "complete", "2026-01-11 16:56:44", "2026-01-11 17:56:44", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768150604;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768150604;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-11 17:01:35", "2026-01-11 18:01:35", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2772", "woocommerce_refresh_order_count_cache", "complete", "2026-01-11 15:14:01", "2026-01-11 16:14:01", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768144441;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768144441;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-11 15:19:55", "2026-01-11 16:19:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2773", "woocommerce_refresh_order_count_cache", "complete", "2026-01-12 03:19:55", "2026-01-12 04:19:55", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768187995;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768187995;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-12 03:23:17", "2026-01-12 04:23:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2774", "woocommerce_cleanup_draft_orders", "complete", "2026-01-12 17:01:35", "2026-01-12 18:01:35", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768237295;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768237295;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-12 17:02:09", "2026-01-12 18:02:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2775", "woocommerce_cleanup_draft_orders", "complete", "2026-01-12 17:01:35", "2026-01-12 18:01:35", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768237295;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768237295;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-12 17:02:09", "2026-01-12 18:02:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2776", "woocommerce_refresh_order_count_cache", "complete", "2026-01-12 15:23:17", "2026-01-12 16:23:17", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768231397;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768231397;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-12 15:32:40", "2026-01-12 16:32:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2777", "wc-admin_import_orders", "complete", "2026-01-12 13:24:16", "2026-01-12 14:24:16", "[1356]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768224256;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768224256;}", "2", "1", "2026-01-12 13:25:28", "2026-01-12 14:25:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2778", "woocommerce_refresh_order_count_cache", "complete", "2026-01-13 03:32:40", "2026-01-13 04:32:40", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768275160;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768275160;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-13 03:33:05", "2026-01-13 04:33:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2779", "woocommerce_cleanup_draft_orders", "complete", "2026-01-13 17:02:09", "2026-01-13 18:02:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768323729;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768323729;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-13 17:09:57", "2026-01-13 18:09:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2780", "woocommerce_cleanup_draft_orders", "complete", "2026-01-13 17:02:09", "2026-01-13 18:02:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768323729;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768323729;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-13 17:09:57", "2026-01-13 18:09:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2781", "woocommerce_refresh_order_count_cache", "complete", "2026-01-13 15:33:05", "2026-01-13 16:33:05", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768318385;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768318385;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-13 15:35:52", "2026-01-13 16:35:52", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2782", "woocommerce_refresh_order_count_cache", "complete", "2026-01-14 03:35:52", "2026-01-14 04:35:52", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768361752;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768361752;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-14 03:50:43", "2026-01-14 04:50:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2783", "woocommerce_cleanup_draft_orders", "complete", "2026-01-14 17:09:57", "2026-01-14 18:09:57", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768410597;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768410597;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-14 17:11:06", "2026-01-14 18:11:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2784", "woocommerce_cleanup_draft_orders", "complete", "2026-01-14 17:09:57", "2026-01-14 18:09:57", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768410597;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768410597;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-14 17:11:06", "2026-01-14 18:11:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2785", "woocommerce_refresh_order_count_cache", "complete", "2026-01-14 15:50:43", "2026-01-14 16:50:43", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768405843;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768405843;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-14 15:52:03", "2026-01-14 16:52:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2786", "woocommerce_refresh_order_count_cache", "complete", "2026-01-15 03:52:03", "2026-01-15 04:52:03", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768449123;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768449123;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-15 04:03:46", "2026-01-15 05:03:46", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2787", "woocommerce_cleanup_draft_orders", "complete", "2026-01-15 17:11:06", "2026-01-15 18:11:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768497066;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768497066;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-15 17:18:25", "2026-01-15 18:18:25", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2788", "woocommerce_cleanup_draft_orders", "complete", "2026-01-15 17:11:06", "2026-01-15 18:11:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768497066;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768497066;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-15 17:18:25", "2026-01-15 18:18:25", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2789", "woocommerce_refresh_order_count_cache", "complete", "2026-01-15 16:03:46", "2026-01-15 17:03:46", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768493026;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768493026;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-15 16:05:45", "2026-01-15 17:05:45", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2790", "woocommerce_refresh_order_count_cache", "complete", "2026-01-16 04:05:45", "2026-01-16 05:05:45", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768536345;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768536345;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-16 04:20:16", "2026-01-16 05:20:16", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2791", "woocommerce_cleanup_draft_orders", "complete", "2026-01-16 17:18:25", "2026-01-16 18:18:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768583905;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768583905;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-16 17:18:48", "2026-01-16 18:18:48", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2792", "woocommerce_cleanup_draft_orders", "complete", "2026-01-16 17:18:25", "2026-01-16 18:18:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768583905;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768583905;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-16 17:18:48", "2026-01-16 18:18:48", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2793", "woocommerce_refresh_order_count_cache", "complete", "2026-01-16 16:20:16", "2026-01-16 17:20:16", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768580416;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768580416;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-16 16:23:59", "2026-01-16 17:23:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2794", "woocommerce_refresh_order_count_cache", "complete", "2026-01-17 04:23:59", "2026-01-17 05:23:59", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768623839;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768623839;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-17 04:27:43", "2026-01-17 05:27:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2795", "woocommerce_cleanup_draft_orders", "complete", "2026-01-17 17:18:48", "2026-01-17 18:18:48", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768670328;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768670328;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-17 17:27:26", "2026-01-17 18:27:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2796", "woocommerce_cleanup_draft_orders", "complete", "2026-01-17 17:18:48", "2026-01-17 18:18:48", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768670328;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768670328;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-17 17:27:26", "2026-01-17 18:27:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2797", "woocommerce_refresh_order_count_cache", "complete", "2026-01-17 16:27:43", "2026-01-17 17:27:43", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768667263;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768667263;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-17 16:31:10", "2026-01-17 17:31:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2798", "woocommerce_refresh_order_count_cache", "complete", "2026-01-18 04:31:10", "2026-01-18 05:31:10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768710670;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768710670;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-18 04:34:00", "2026-01-18 05:34:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2799", "woocommerce_cleanup_draft_orders", "complete", "2026-01-18 17:27:26", "2026-01-18 18:27:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768757246;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768757246;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-18 17:30:11", "2026-01-18 18:30:11", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2800", "woocommerce_cleanup_draft_orders", "complete", "2026-01-18 17:27:26", "2026-01-18 18:27:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768757246;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768757246;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-18 17:30:11", "2026-01-18 18:30:11", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2801", "woocommerce_refresh_order_count_cache", "complete", "2026-01-18 16:34:00", "2026-01-18 17:34:00", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768754040;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768754040;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-18 16:42:37", "2026-01-18 17:42:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2802", "woocommerce_refresh_order_count_cache", "complete", "2026-01-19 04:42:37", "2026-01-19 05:42:37", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768797757;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768797757;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-19 05:01:58", "2026-01-19 06:01:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2803", "woocommerce_cleanup_draft_orders", "complete", "2026-01-19 17:30:11", "2026-01-19 18:30:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768843811;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768843811;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-19 17:30:29", "2026-01-19 18:30:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2804", "woocommerce_cleanup_draft_orders", "complete", "2026-01-19 17:30:11", "2026-01-19 18:30:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768843811;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768843811;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-19 17:30:29", "2026-01-19 18:30:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2805", "woocommerce_refresh_order_count_cache", "complete", "2026-01-19 17:01:58", "2026-01-19 18:01:58", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768842118;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768842118;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-19 17:10:08", "2026-01-19 18:10:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2806", "wc-admin_import_orders", "complete", "2026-01-19 11:36:22", "2026-01-19 12:36:22", "[1357]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768822582;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768822582;}", "2", "1", "2026-01-19 11:36:55", "2026-01-19 12:36:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2807", "woocommerce_refresh_order_count_cache", "complete", "2026-01-20 05:10:08", "2026-01-20 06:10:08", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768885808;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768885808;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "1", "2026-01-20 05:18:25", "2026-01-20 06:18:25", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2808", "woocommerce_cleanup_draft_orders", "pending", "2026-01-20 17:30:29", "2026-01-20 18:30:29", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768930229;s:18:\"\0*\0first_timestamp\";i:1675415778;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768930229;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2809", "woocommerce_cleanup_draft_orders", "pending", "2026-01-20 17:30:29", "2026-01-20 18:30:29", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768930229;s:18:\"\0*\0first_timestamp\";i:1733236575;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768930229;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2810", "woocommerce_refresh_order_count_cache", "pending", "2026-01-20 17:18:25", "2026-01-20 18:18:25", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768929505;s:18:\"\0*\0first_timestamp\";i:1749619664;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768929505;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2811", "action_scheduler/migration_hook", "complete", "2026-01-20 16:21:28", "2026-01-20 17:21:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768926088;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768926088;}", "1", "1", "2026-01-20 16:21:55", "2026-01-20 17:21:55", "0", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "count");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "wc_delete_related_product_transients_group");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("813", "273", "action créée", "2023-05-23 13:25:20", "2023-05-23 15:25:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("817", "273", "action lancée via WP Cron", "2023-05-23 13:25:29", "2023-05-23 15:25:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("818", "273", "échec de l’action via WP Cron : L’action planifiée pour woocommerce_run_on_woocommerce_admin_updated ne sera pas exécutée car aucun rappel n’est enregistré.", "2023-05-23 13:25:29", "2023-05-23 15:25:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1508", "504", "action créée", "2023-10-17 12:07:51", "2023-10-17 14:07:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("1509", "504", "action lancée via WP Cron", "2023-10-17 12:08:53", "2023-10-17 14:08:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1510", "504", "échec de l’action via WP Cron : L’action planifiée pour action_scheduler/migration_hook ne sera pas exécutée car aucun rappel n’est enregistré.", "2023-10-17 12:08:53", "2023-10-17 14:08:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1718", "574", "action créée", "2023-12-07 10:05:53", "2023-12-07 11:05:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1719", "574", "action lancée via WP Cron", "2023-12-07 10:06:54", "2023-12-07 11:06:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("1720", "574", "échec de l’action via WP Cron : L’action planifiée pour action_scheduler/migration_hook ne sera pas exécutée car aucun rappel n’est enregistré.", "2023-12-07 10:06:54", "2023-12-07 11:06:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4865", "1624", "action créée", "2025-05-06 16:07:03", "2025-05-06 18:07:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("5079", "1624", "action commencée via WP Cron", "2025-06-05 16:12:43", "2025-06-05 18:12:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5080", "1624", "échec de l’action via WP Cron : L’action planifiée pour wpo_ips_semaphore_lock_cleanup ne sera pas exécutée car aucun rappel n’est enregistré.", "2025-06-05 16:12:43", "2025-06-05 18:12:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5081", "1696", "action créée", "2025-06-05 16:12:43", "2025-06-05 18:12:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("5434", "1696", "action commencée via WP Cron", "2025-07-05 16:15:16", "2025-07-05 18:15:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("5435", "1696", "échec de l’action via WP Cron : L’action planifiée pour wpo_ips_semaphore_lock_cleanup ne sera pas exécutée car aucun rappel n’est enregistré.", "2025-07-05 16:15:16", "2025-07-05 18:15:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("5436", "1815", "action créée", "2025-07-05 16:15:16", "2025-07-05 18:15:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("5815", "1815", "action commencée via WP Cron", "2025-08-04 16:16:57", "2025-08-04 18:16:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("5816", "1815", "échec de l’action via WP Cron : L’action planifiée pour wpo_ips_semaphore_lock_cleanup ne sera pas exécutée car aucun rappel n’est enregistré.", "2025-08-04 16:16:57", "2025-08-04 18:16:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("5817", "1942", "action créée", "2025-08-04 16:16:57", "2025-08-04 18:16:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("6184", "1942", "action commencée via WP Cron", "2025-09-03 16:18:09", "2025-09-03 18:18:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6185", "1942", "échec de l’action via WP Cron : L’action planifiée pour wpo_ips_semaphore_lock_cleanup ne sera pas exécutée car aucun rappel n’est enregistré.", "2025-09-03 16:18:09", "2025-09-03 18:18:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6186", "2065", "action créée", "2025-09-03 16:18:09", "2025-09-03 18:18:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6547", "2065", "action commencée via WP Cron", "2025-10-03 16:34:18", "2025-10-03 18:34:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6548", "2065", "échec de l’action via WP Cron : L’action planifiée pour wpo_ips_semaphore_lock_cleanup ne sera pas exécutée car aucun rappel n’est enregistré.", "2025-10-03 16:34:18", "2025-10-03 18:34:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("6549", "2065", "Cette action semble échouer systématiquement. Une nouvelle instance ne sera pas planifiée.", "2025-10-03 16:34:18", "2025-10-03 18:34:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7542", "2516", "action créée", "2025-12-20 12:46:29", "2025-12-20 13:46:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("7545", "2517", "action créée", "2025-12-20 16:02:23", "2025-12-20 17:02:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7548", "2518", "action créée", "2025-12-20 16:02:23", "2025-12-20 17:02:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7549", "2519", "action créée", "2025-12-20 19:01:45", "2025-12-20 20:01:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("7550", "2519", "action commencée via WP Cron", "2025-12-20 19:04:23", "2025-12-20 20:04:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7551", "2519", "action terminée via WP Cron", "2025-12-20 19:04:23", "2025-12-20 20:04:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7552", "2516", "action commencée via WP Cron", "2025-12-21 00:48:24", "2025-12-21 01:48:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7553", "2516", "action terminée via WP Cron", "2025-12-21 00:48:24", "2025-12-21 01:48:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7554", "2520", "action créée", "2025-12-21 00:48:24", "2025-12-21 01:48:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7555", "2520", "action commencée via WP Cron", "2025-12-21 12:51:26", "2025-12-21 13:51:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("7556", "2520", "action terminée via WP Cron", "2025-12-21 12:51:26", "2025-12-21 13:51:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("7557", "2521", "action créée", "2025-12-21 12:51:26", "2025-12-21 13:51:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("7558", "2517", "action commencée via WP Cron", "2025-12-21 16:07:38", "2025-12-21 17:07:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7559", "2517", "action terminée via WP Cron", "2025-12-21 16:07:38", "2025-12-21 17:07:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7560", "2522", "action créée", "2025-12-21 16:07:38", "2025-12-21 17:07:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7561", "2518", "action commencée via WP Cron", "2025-12-21 16:07:38", "2025-12-21 17:07:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7562", "2518", "action terminée via WP Cron", "2025-12-21 16:07:38", "2025-12-21 17:07:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7563", "2523", "action créée", "2025-12-21 16:07:38", "2025-12-21 17:07:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7564", "2521", "action commencée via WP Cron", "2025-12-22 00:54:15", "2025-12-22 01:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("7565", "2521", "action terminée via WP Cron", "2025-12-22 00:54:15", "2025-12-22 01:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("7566", "2524", "action créée", "2025-12-22 00:54:15", "2025-12-22 01:54:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("7567", "2525", "action créée", "2025-12-22 10:27:18", "2025-12-22 11:27:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7568", "2526", "action créée", "2025-12-22 10:27:18", "2025-12-22 11:27:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7569", "2525", "action commencée via WP Cron", "2025-12-22 10:28:00", "2025-12-22 11:28:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7570", "2525", "action terminée via WP Cron", "2025-12-22 10:28:00", "2025-12-22 11:28:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7571", "2526", "action commencée via WP Cron", "2025-12-22 10:28:00", "2025-12-22 11:28:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7572", "2526", "action terminée via WP Cron", "2025-12-22 10:28:00", "2025-12-22 11:28:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7573", "2527", "action créée", "2025-12-22 10:34:30", "2025-12-22 11:34:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("7574", "2528", "action créée", "2025-12-22 10:34:30", "2025-12-22 11:34:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("7575", "2527", "action commencée via WP Cron", "2025-12-22 10:35:01", "2025-12-22 11:35:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7576", "2527", "action terminée via WP Cron", "2025-12-22 10:35:01", "2025-12-22 11:35:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7577", "2528", "action commencée via WP Cron", "2025-12-22 10:35:01", "2025-12-22 11:35:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7578", "2528", "action terminée via WP Cron", "2025-12-22 10:35:01", "2025-12-22 11:35:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7579", "2529", "action créée", "2025-12-22 10:37:35", "2025-12-22 11:37:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7580", "2530", "action créée", "2025-12-22 10:37:36", "2025-12-22 11:37:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7581", "2529", "action commencée via WP Cron", "2025-12-22 10:38:00", "2025-12-22 11:38:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7582", "2529", "action terminée via WP Cron", "2025-12-22 10:38:00", "2025-12-22 11:38:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7583", "2530", "action commencée via WP Cron", "2025-12-22 10:38:00", "2025-12-22 11:38:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7584", "2530", "action terminée via WP Cron", "2025-12-22 10:38:00", "2025-12-22 11:38:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7585", "2531", "action créée", "2025-12-22 10:38:33", "2025-12-22 11:38:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7586", "2532", "action créée", "2025-12-22 10:38:33", "2025-12-22 11:38:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7587", "2531", "action commencée via WP Cron", "2025-12-22 10:39:01", "2025-12-22 11:39:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7588", "2531", "action terminée via WP Cron", "2025-12-22 10:39:01", "2025-12-22 11:39:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7589", "2532", "action commencée via WP Cron", "2025-12-22 10:39:01", "2025-12-22 11:39:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7590", "2532", "action terminée via WP Cron", "2025-12-22 10:39:01", "2025-12-22 11:39:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7591", "2533", "action créée", "2025-12-22 10:39:34", "2025-12-22 11:39:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("7592", "2534", "action créée", "2025-12-22 10:39:34", "2025-12-22 11:39:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("7593", "2533", "action commencée via WP Cron", "2025-12-22 10:39:56", "2025-12-22 11:39:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7594", "2533", "action terminée via WP Cron", "2025-12-22 10:39:56", "2025-12-22 11:39:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7595", "2534", "action commencée via WP Cron", "2025-12-22 10:39:56", "2025-12-22 11:39:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7596", "2534", "action terminée via WP Cron", "2025-12-22 10:39:56", "2025-12-22 11:39:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7597", "2535", "action créée", "2025-12-22 10:41:27", "2025-12-22 11:41:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7598", "2536", "action créée", "2025-12-22 10:41:27", "2025-12-22 11:41:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7599", "2535", "action commencée via WP Cron", "2025-12-22 10:41:57", "2025-12-22 11:41:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("7600", "2535", "action terminée via WP Cron", "2025-12-22 10:41:57", "2025-12-22 11:41:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("7601", "2536", "action commencée via WP Cron", "2025-12-22 10:41:57", "2025-12-22 11:41:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("7602", "2536", "action terminée via WP Cron", "2025-12-22 10:41:57", "2025-12-22 11:41:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("7603", "2537", "action créée", "2025-12-22 10:42:39", "2025-12-22 11:42:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("7604", "2538", "action créée", "2025-12-22 10:42:39", "2025-12-22 11:42:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("7605", "2537", "action commencée via WP Cron", "2025-12-22 10:43:02", "2025-12-22 11:43:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("7606", "2537", "action terminée via WP Cron", "2025-12-22 10:43:02", "2025-12-22 11:43:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("7607", "2538", "action commencée via WP Cron", "2025-12-22 10:43:02", "2025-12-22 11:43:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("7608", "2538", "action terminée via WP Cron", "2025-12-22 10:43:02", "2025-12-22 11:43:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("7609", "2539", "action créée", "2025-12-22 10:44:22", "2025-12-22 11:44:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7610", "2540", "action créée", "2025-12-22 10:44:22", "2025-12-22 11:44:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7611", "2539", "action commencée via WP Cron", "2025-12-22 10:45:05", "2025-12-22 11:45:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7612", "2539", "action terminée via WP Cron", "2025-12-22 10:45:05", "2025-12-22 11:45:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7613", "2540", "action commencée via WP Cron", "2025-12-22 10:45:05", "2025-12-22 11:45:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7614", "2540", "action terminée via WP Cron", "2025-12-22 10:45:05", "2025-12-22 11:45:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7615", "2541", "action créée", "2025-12-22 10:45:08", "2025-12-22 11:45:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("7616", "2542", "action créée", "2025-12-22 10:45:08", "2025-12-22 11:45:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("7617", "2541", "action commencée via WP Cron", "2025-12-22 10:45:57", "2025-12-22 11:45:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("7618", "2541", "action terminée via WP Cron", 