<?php
/**
 * Map For Section Heading
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Section Heading */
/*-----------------------------------------------------------------------------------*/

vc_map( array(
  'name' => __('Section Heading', 'hcode-addons'),
  'description' => __( 'Add styled section heading', 'hcode-addons' ),  
  'icon' => 'fa-solid fa-heading h-code-shortcode-icon',
  'base' => 'hcode_section_heading',
  'category' => 'H-Code',
  'params' => array(
    array(
      'type' => 'dropdown',
      'admin_label' => true,
      'heading' => __('Heading Style', 'hcode-addons'),
      'param_name' => 'hcode_heading_type',
      'value' => array(__('Select Heading Style', 'hcode-addons') => '',
                       __('Heading Style1', 'hcode-addons') => 'heading-style1',
                       __('Heading Style2', 'hcode-addons') => 'heading-style2',
                       __('Heading Style3', 'hcode-addons') => 'heading-style3',
                       __('Heading Style4', 'hcode-addons') => 'heading-style4',
                       __('Heading Style5', 'hcode-addons') => 'heading-style5',
                       __('Heading Style6', 'hcode-addons') => 'heading-style6',
                       __('Heading Style7', 'hcode-addons') => 'heading-style7',
                       __('Heading Style8', 'hcode-addons') => 'heading-style8',
                       __('Heading Style9', 'hcode-addons') => 'heading-style9',
                       __('Heading Style10', 'hcode-addons') => 'heading-style10',
              ),
      ),
    array(
      'type' => 'hcode_preview_image',
      'heading' => __('Select pre-made style for Heading', 'hcode-addons'),
      'param_name' => 'heading_preview_image',
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'heading' => __('Custom Icon', 'hcode-addons'),
      'param_name' => 'custom_icon',
      'value' => array(__('NO', 'hcode-addons') => '0',
                       __('YES', 'hcode-addons') => '1'
                      ),
      'dependency' => array( 'element' => 'hcode_heading_type', 'value' => array('heading-style2','heading-style5','heading-style7','heading-style10') ),
    ),
    array(
      'type' => 'attach_image',
      'heading' => __('Custom Icon Image', 'hcode-addons'),
      'param_name' => 'custom_icon_image',
      'dependency' => array( 'element' => 'custom_icon', 'value' => '1' ),
      'description' => __( 'Recommended size: Extra Large - 60px X 60px, Large - 50px X 50px, Medium - 40px X 40px, Small - 25px X 25px, Extra Small - 18px X 18px', 'hcode-addons' ),
    ),
    array(
      'type' => 'hcode_icon',
      'heading' => __('Select Icon Type', 'hcode-addons'),
      'param_name' => 'hcode_et_line_icon_list',
      'description' => __('Select Font Type', 'hcode-addons'),
      'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),
    ),
    array(
      'type' => 'dropdown',
      'heading' => __('Heading Tag', 'hcode-addons'),
      'param_name' => 'hcode_heading_tag',
      'value' => array(__('Select Heading Tag', 'hcode-addons') => '',
                       __('h1', 'hcode-addons') => 'h1',
                       __('h2', 'hcode-addons') => 'h2',
                       __('h3', 'hcode-addons') => 'h3',
                       __('h4', 'hcode-addons') => 'h4',
                       __('h5', 'hcode-addons') => 'h5',
                       __('h6', 'hcode-addons') => 'h6',
                       __('div', 'hcode-addons') => 'div',
                      ),
      'group' => 'Heading Style',
      'std' => 'h1',
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Heading Number', 'hcode-addons'),
      'param_name' => 'hcode_heading_number',
      'dependency' => array( 'element' => 'hcode_heading_type', 'value' => array('heading-style6') ),
    ),
    array(
      'type' => 'textfield',
      'admin_label' => true,
      'heading' => __('Heading Title', 'hcode-addons'),
      'param_name' => 'hcode_heading',
      'dependency' => array( 'element' => 'hcode_heading_type', 'value' => array('heading-style1','heading-style2','heading-style3','heading-style4','heading-style5','heading-style6','heading-style7','heading-style8','heading-style9','heading-style10') ),
    ),
    array(
      'type' => 'textarea',
      'heading' => __('Subtitle', 'hcode-addons'),
      'param_name' => 'subtitle',
      'dependency' => array( 'element' => 'hcode_heading_type', 'value' => array('heading-style2','heading-style9') ),
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'heading' => __('Enable Underline On Title', 'hcode-addons'),
      'param_name' => 'hcode_enable_underline_on_title',
      'value' => array(__('No', 'hcode-addons') => '0', 
                       __('Yes', 'hcode-addons') => '1'
                      ),
      'dependency' => array( 'element' => 'hcode_heading_type', 'value' => array('heading-style9') ),
      'std' => '1',
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'heading' => __('Add Separator', 'hcode-addons'),
      'param_name' => 'hcode_seperator',
      'value' => array(__('False', 'hcode-addons') => '0', 
                       __('True', 'hcode-addons') => '1'
                      ),
      'description' => __('Select TRUE to add Separator.', 'hcode-addons'),
      'dependency' => array( 'element' => 'hcode_heading_type', 'value' => array('heading-style1','heading-style6') ),
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'heading' => __('Double Line', 'hcode-addons'),
      'param_name' => 'hcode_double_line',
      'value' => array(__('False', 'hcode-addons') => '0', 
                       __('True', 'hcode-addons') => '1'
                      ),
      'description' => __('Select TRUE to add double line with both the side.', 'hcode-addons'),
      'dependency' => array( 'element' => 'hcode_heading_type', 'value' => array('heading-style2','heading-style3') ),
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Text BG Color', 'hcode-addons' ),
      'param_name' => 'hcode_heading_text_bg_color',
      'dependency' => array( 'element' => 'hcode_heading_type', 'value' => array('heading-style2') ),
      'group' => 'Heading Style',
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Number Text Color', 'hcode-addons' ),
      'param_name' => 'hcode_heading_number_text_color',
      'dependency' => array( 'element' => 'hcode_heading_type', 'value' => array('heading-style6') ),
      'group' => 'Heading Style',
    ),
    array(
      'type' => 'dropdown',
      'heading' => __('Text Color', 'hcode-addons'),
      'param_name' => 'hcode_text_color',
      'value' => array(__('Select Text Color', 'hcode-addons') => '',
                       __('Black', 'hcode-addons') => 'black-text',
                       __('White', 'hcode-addons') => 'white-text',
                       __('Custom', 'hcode-addons') => 'custom',
              ),
      'dependency' => array( 'element' => 'hcode_heading_type', 'value' => array('heading-style1','heading-style2','heading-style3','heading-style4','heading-style5','heading-style6','heading-style7','heading-style8','heading-style9','heading-style10') ),
      'group' => 'Heading Style',
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Text Color', 'hcode-addons' ),
      'param_name' => 'hcode_heading_text_color',
      'dependency' => array( 'element' => 'hcode_text_color', 'value' => array('custom') ),
      'group' => 'Heading Style',
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Subtitle Color', 'hcode-addons' ),
      'param_name' => 'hcode_heading_subtitle_color',
      'dependency' => array( 'element' => 'hcode_heading_type', 'value' => array('heading-style2','heading-style9') ),
      'group' => 'Heading Style',
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Border Color', 'hcode-addons' ),
      'param_name' => 'hcode_heading_border_color',
      'dependency' => array( 'element' => 'hcode_heading_type', 'value' => array('heading-style2','heading-style3','heading-style4') ),
      'group' => 'Heading Style',
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Title Underline Color', 'hcode-addons' ),
      'param_name' => 'hcode_underline_color',
      'dependency' => array( 'element' => 'hcode_enable_underline_on_title', 'value' => '1' ),
      'group' => 'Style',
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Separator Color', 'hcode-addons' ),
      'param_name' => 'hcode_heading_sep_color',
      'group' => 'Heading Style',
      'dependency' => array( 'element' => 'hcode_seperator', 'value' => array('1') ),
    ),
    array(
      'type' => 'dropdown',
      'heading' => __('Select Icon Size', 'hcode-addons'),
      'param_name' => 'icon_size',
      'value' => array(__('Default', 'hcode-addons') => '',
                       __('Extra Large', 'hcode-addons') => 'extra-large-icon', 
                       __('Large', 'hcode-addons') => 'large-icon',
                       __('Medium', 'hcode-addons') => 'medium-icon',
                       __('Small', 'hcode-addons') => 'small-icon',
                       __('Extra Small', 'hcode-addons') => 'extra-small-icon',
                      ),
      'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),
      'group' => 'Heading Style',
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Icon Color', 'hcode-addons' ),
      'param_name' => 'hcode_heading_icon_color',
      'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),
      'group' => 'Heading Style',
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'class' => '',
      'heading' => __('Required Padding Setting?', 'hcode-addons'),
      'param_name' => 'padding_setting',
      'value' => array(__('No', 'hcode-addons') => '0', 
                       __('Yes', 'hcode-addons') => '1'
                      ),
      'dependency' => array( 'element' => 'hcode_heading_type', 'value' => array('heading-style1','heading-style2','heading-style3','heading-style4','heading-style5','heading-style6','heading-style7','heading-style8','heading-style9','heading-style10') ),
      'group' => 'Css Style',
    ),
    array(
      'type' => 'hcode_custom_desktop_padding',
      'param_name' => 'desktop_padding',
      'heading' => __('Padding (For Desktop Device)', 'hcode-addons' ),
      'value' => '',
      'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
      'group' => 'Css Style',
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Custom Padding (For Desktop Devices)', 'hcode-addons' ),
      'param_name' => 'custom_desktop_padding',
      'dependency' => array( 'element' => 'desktop_padding', 'value' => array('custom-desktop-padding') ),
      'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
      'group' => 'Css Style',
    ),
    array(
      'type' => 'hcode_custom_ipad_padding',
      'param_name' => 'ipad_padding',
      'heading' => __('Padding (For iPad Device)', 'hcode-addons' ),
      'value' => '',
      'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
      'group' => 'Css Style',
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Custom Padding (For iPad Devices)', 'hcode-addons' ),
      'param_name' => 'custom_ipad_padding',
      'dependency' => array( 'element' => 'ipad_padding', 'value' => array('custom-ipad-padding') ),
      'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
      'group' => 'Css Style',
    ),
    array(
      'type' => 'hcode_custom_mobile_padding',
      'param_name' => 'mobile_padding',
      'heading' => __('Padding (For Mobile Device)', 'hcode-addons' ),
      'value' => '',
      'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
      'group' => 'Css Style',
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Custom Padding (For Mobile Devices)', 'hcode-addons' ),
      'param_name' => 'custom_mobile_padding',
      'dependency' => array( 'element' => 'mobile_padding', 'value' => array('custom-mobile-padding') ),
      'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
      'group' => 'Css Style',
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'heading' => __('Required Margin Setting?', 'hcode-addons'),
      'param_name' => 'margin_setting',
      'value' => array(__('No', 'hcode-addons') => '0', 
                       __('Yes', 'hcode-addons') => '1'
                      ),
      'dependency' => array( 'element' => 'hcode_heading_type', 'value' => array('heading-style1','heading-style2','heading-style3','heading-style4','heading-style5','heading-style6','heading-style7','heading-style8','heading-style9','heading-style10') ),
      'group' => 'Css Style',
    ),
    array(
      'type' => 'hcode_custom_desktop_margin',
      'param_name' => 'desktop_margin',
      'heading' => __('Margin (For Desktop Device)', 'hcode-addons' ),
      'value' => '',
      'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
      'group' => 'Css Style',
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Custom Margin (For Desktop Devices)', 'hcode-addons' ),
      'param_name' => 'custom_desktop_margin',
      'dependency' => array( 'element' => 'desktop_margin', 'value' => array('custom-desktop-margin') ),
      'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
      'group' => 'Css Style',
    ),
    array(
      'type' => 'hcode_custom_ipad_margin',
      'param_name' => 'ipad_margin',
      'heading' => __('Margin (For iPad Device)', 'hcode-addons' ),
      'value' => '',
      'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
      'group' => 'Css Style',
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Custom Margin (For iPad Devices)', 'hcode-addons' ),
      'param_name' => 'custom_ipad_margin',
      'dependency' => array( 'element' => 'ipad_margin', 'value' => array('custom-ipad-margin') ),
      'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
      'group' => 'Css Style',
    ),
    array(
      'type' => 'hcode_custom_mobile_margin',
      'param_name' => 'mobile_margin',
      'heading' => __('Margin (For Mobile Device)', 'hcode-addons' ),
      'value' => '',
      'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
      'group' => 'Css Style',
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Custom Margin (For Mobile Devices)', 'hcode-addons' ),
      'param_name' => 'custom_mobile_margin',
      'dependency' => array( 'element' => 'mobile_margin', 'value' => array('custom-mobile-margin') ),
      'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
      'group' => 'Css Style',
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Font Size', 'hcode-addons' ),
      'param_name' => 'font_size',
      'description' => __( 'Define font size like 12px', 'hcode-addons' ),
      'dependency' => array( 'element' => 'hcode_heading_type', 'value' => array('heading-style1','heading-style2','heading-style3','heading-style4','heading-style5','heading-style6','heading-style7','heading-style8','heading-style9','heading-style10') ),
      'group' => 'Css Style',
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Line Height', 'hcode-addons' ),
      'param_name' => 'line_height',
      'description' => __( 'Define line height like 20px', 'hcode-addons' ),
      'dependency' => array( 'element' => 'hcode_heading_type', 'value' => array('heading-style1','heading-style2','heading-style3','heading-style4','heading-style5','heading-style6','heading-style7','heading-style8','heading-style9','heading-style10') ),
      'group' => 'Css Style',
    ),
    array(
      'type' => 'dropdown',
      'param_name' => 'font_weight',
      'heading' => __('Font Weight', 'hcode-addons' ),
      'value' => array(__('Select Font Weight', 'hcode-addons') => '', 
                       __('Font weight 300', 'hcode-addons') => '300',
                       __('Font weight 400', 'hcode-addons') => '400',
                       __('Font weight 500', 'hcode-addons') => '500',
                       __('Font weight 600', 'hcode-addons') => '600',
                       __('Font weight 700', 'hcode-addons') => '700',
                       __('Font weight 800', 'hcode-addons') => '800',
                       __('Font weight 900', 'hcode-addons') => '900',
                      ),
      'dependency' => array( 'element' => 'hcode_heading_type', 'value' => array('heading-style1','heading-style2','heading-style3','heading-style4','heading-style5','heading-style6','heading-style7','heading-style8','heading-style9','heading-style10') ),
      'group' => 'Css Style',
    ),
    array(
        'type'        => 'responsive_font_settings',
        'param_name'  => 'hcode_responsive_title_font',
        'heading'     => esc_html__( 'Font Settings For Title', 'hcode-addons' ),
        'hide_font_settings_element_lg' => array('font-size','line-height'),
        'dependency' => array( 'element' => 'hcode_heading_type', 'value' => array('heading-style1','heading-style2','heading-style3','heading-style4','heading-style5','heading-style6','heading-style7','heading-style8','heading-style9','heading-style10') ),
        'group' => 'Font Settings',
    ),
    array(
        'type'        => 'responsive_font_settings',
        'param_name'  => 'hcode_responsive_subtitle_font',
        'heading'     => esc_html__( 'Font Settings For Subtitle / Number', 'hcode-addons' ),
        'dependency' => array( 'element' => 'hcode_heading_type', 'value' => array('heading-style2','heading-style6','heading-style9') ),
        'group' => 'Font Settings',
    ),
    array(
        'type' => 'hcode_custom_srcset',
        'param_name' => 'hcode_icon_image_srcset',
        'heading' => __('Icon Image SRCSET', 'hcode-addons' ),
        'value' => 'full',
        'dependency' => array( 'element' => 'custom_icon', 'value' => '1' ),
        'group' => 'SRCSET',
    ),
    $hcode_vc_extra_id,
    $hcode_vc_extra_class,
    )
) );