<?php
/**
 * Map For Parallax
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Parallax */
/*-----------------------------------------------------------------------------------*/

vc_map( array(
  'name' => __('Parallax', 'hcode-addons'),
  'icon' => 'fa-solid fa-exchange-alt h-code-shortcode-icon',
  'base' => 'hcode_parallax',
  'category' => 'H-Code',
  'description' => __( 'Create a parallax section', 'hcode-addons' ),
  'params' => array(
      array(
          'type' => 'dropdown',
          'admin_label' => true,
          'class' => '',
          'heading' => __('Style', 'hcode-addons'),
          'param_name' => 'hcode_parallax_style',
          'value' => array(__('Select Style', 'hcode-addons') => '',
                           __('Parallax', 'hcode-addons') => 'parallax',
                           __('Parallax with Description', 'hcode-addons') => 'portfolio-with-desc',
          ),
      ),
      array(
          'type' => 'hcode_preview_image',
          'heading' => __('Select pre-made style', 'hcode-addons'),
          'param_name' => 'slider_parallax_preview_image',
      ),
      array(
          'type' => 'hcode_multiple_portfolio_categories',
          'heading' => __('Select Categories', 'hcode-addons'),
          'param_name' => 'hcode_categories_list',
          'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('parallax','portfolio-with-desc') ),
      ),
      array(
          'type' => 'textfield',
          'heading' => __('No. of Post Per Page', 'hcode-addons'),
          'param_name' => 'hcode_post_per_page',
          'value'     => '10',
          'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('parallax','portfolio-with-desc') ),
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __('Show Excerpt', 'hcode-addons'),
          'param_name' => 'hcode_show_excerpt',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'description' => __( 'Select Yes to show excerpt, no to show full content', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('portfolio-with-desc')),
      ),
      array(
          'type'        => 'textfield',
          'heading'     => __('Excerpt Length', 'hcode-addons' ),
          'description' => __( 'Enter numaric value like 20', 'hcode-addons' ),
          'param_name'  => 'hcode_excerpt_length',
          'value'     => '15',
          'dependency'  => array( 'element' => 'hcode_show_excerpt', 'value' => array('1') ),
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __('Show Button', 'hcode-addons'),
          'param_name' => 'hcode_show_button',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'std' => '1',
          'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('parallax','portfolio-with-desc') ),
      ),
      array(
          'type'        => 'vc_link',
          'heading'     => __('Button Link', 'hcode-addons' ),
          'param_name'  => 'hcode_button_link',
          'dependency'  => array( 'element' => 'hcode_show_button', 'value' => array('1') ),
      ),
      array(
          'type'        => 'hcode_custom_switch_option',
          'heading'     => __('Enable Separator', 'hcode-addons' ),
          'param_name'  => 'hcode_seperater',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'std' => '1',
          'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('portfolio-with-desc') )
      ),
      array(
          'type' => 'colorpicker',
          'class' => '',
          'heading' => __( 'Separator Color', 'hcode-addons' ),
          'param_name' => 'hcode_sep_color',
          'dependency' => array( 'element' => 'hcode_seperater', 'value' => array('1') ),
      ),  
      array(
          'type' => 'textfield',
          'heading' => __('Separator Height', 'hcode-addons' ),
          'param_name' => 'seperator_height',
          'dependency' => array( 'element' => 'hcode_seperater', 'value' => array('1') ),
          'description' => __( 'Define custom separator height in px like 2px', 'hcode-addons' ),
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __('Show Filter', 'hcode-addons'),
          'param_name' => 'hcode_show_filter',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'description' => __( 'Select YES to show filter above portfolio parallax.', 'hcode-addons' ),
          'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('parallax','portfolio-with-desc') ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'heading' => __('Show All Categories Filter', 'hcode-addons'),
          'param_name' => 'hcode_show_all_categories_filter',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'std' => '1',
          'description' => __( 'Select YES to show filter above portfolio', 'hcode-addons' ),
          'dependency' => array( 'element' => 'hcode_show_filter', 'value' => '1' ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'hcode_multiple_portfolio_categories',
          'heading' => __('Select Default Category Selected', 'hcode-addons'),
          'param_name' => 'hcode_default_category_selected',    
          'multiple' => false,
          'dependency' => array( 'element' => 'hcode_show_filter', 'value' => '1' ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'dropdown',
          'class' => '',
          'heading' => __('Categories Order By', 'hcode-addons'),
          'param_name' => 'hcode_portfolio_categories_orderby',
          'value' => array(__('Select Order By', 'hcode-addons') => '',
                           __('Name', 'hcode-addons') => 'name',
                           __('Slug', 'hcode-addons') => 'slug',
                           __('Id', 'hcode-addons') => 'id',
                           __('Count', 'hcode-addons') => 'count',
          ),
          'std' => 'id',
          'dependency' => array( 'element' => 'hcode_show_filter', 'value' => '1' ),
          'group' => 'Settings',
      ),
      array(
          'type' => 'dropdown',
          'class' => '',
          'heading' => __('Categories Order', 'hcode-addons'),
          'param_name' => 'hcode_portfolio_categories_order',
          'value' => array(__('Select Order', 'hcode-addons') => '',
                           __('Ascending', 'hcode-addons') => 'ASC',
                           __('Descending', 'hcode-addons') => 'DESC',
          ),
          'std' => 'ASC',
          'dependency' => array( 'element' => 'hcode_show_filter', 'value' => '1' ),
          'group' => 'Settings',
      ),
      array(
        'type' => 'dropdown',
        'heading' => __('Filter Color', 'hcode-addons'),
        'param_name' => 'hcode_filter_color',
        'value' => array(__('Select Filter Color', 'hcode-addons') => '',
                         __('Black', 'hcode-addons') => 'nav-tabs-black',
                         __('Gray', 'hcode-addons') => 'nav-tabs-gray',
                         __('Custom', 'hcode-addons') => 'custom',
                ),
        'std' => 'nav-tabs-black',
        'dependency' => array( 'element' => 'hcode_show_filter', 'value' => '1' ),
        'group' => 'Filter Style',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Custom Filter Color', 'hcode-addons' ),
        'param_name' => 'hcode_filter_custom_color',
        'dependency' => array( 'element' => 'hcode_filter_color', 'value' => array('custom') ),
        'group' => 'Filter Style',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Custom Filter Hover Color', 'hcode-addons' ),
        'param_name' => 'hcode_filter_hover_color',
        'dependency' => array( 'element' => 'hcode_show_filter', 'value' => array('1') ),
        'group' => 'Filter Style',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Custom Filter Border Color', 'hcode-addons' ),
        'param_name' => 'hcode_filter_border_color',
        'dependency' => array( 'element' => 'hcode_show_filter', 'value' => array('1') ),
        'group' => 'Filter Style',
      ),
      array(
          'type' => 'dropdown',
          'admin_label' => true,
          'heading' => __( 'Display Items Order by', 'hcode-addons' ),
          'param_name' => 'orderby',
          'value' => array(__('Select Order by', 'hcode-addons') => '',
                           __( 'Date', 'hcode-addons' ) => 'date',
                           __( 'ID', 'hcode-addons' ) => 'ID',
                           __( 'Author', 'hcode-addons' ) => 'author',
                           __( 'Title', 'hcode-addons' ) => 'title',
                           __( 'Modified', 'hcode-addons' ) => 'modified',
                           __( 'Random', 'hcode-addons' ) => 'rand',
                           __( 'Comment count', 'hcode-addons' ) => 'comment_count',
                           __( 'Menu order', 'hcode-addons' ) => 'menu_order',
                          ),
          'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('parallax','portfolio-with-desc') ),
          'group' => 'Order'
      ),
      array(
        'type' => 'dropdown',
        'admin_label' => true,
        'heading' => __( 'Display Items Sort by', 'hcode-addons' ),
        'param_name' => 'order',
        'value' => array(__('Select Sort by', 'hcode-addons') => '',
                         __( 'Descending', 'hcode-addons' ) => 'DESC',
                         __( 'Ascending', 'hcode-addons' ) => 'ASC',
                        ),
        'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('parallax','portfolio-with-desc') ),
        'group' => 'Order'
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'class' => '',
          'heading' => __('Required Padding Setting?', 'hcode-addons'),
          'param_name' => 'padding_setting',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('portfolio-with-desc') ),
          'group' => 'Style',
      ),
      array(
        'type' => 'hcode_custom_desktop_padding',
        'param_name' => 'desktop_padding',
        'heading' => __('Padding (For Desktop Device)', 'hcode-addons' ),
        'value' => '',
        'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Custom Padding (For Desktop Devices)', 'hcode-addons' ),
        'param_name' => 'custom_desktop_padding',
        'dependency' => array( 'element' => 'desktop_padding', 'value' => array('custom-desktop-padding') ),
        'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
        'group' => 'Style',
      ),
      array(
        'type' => 'hcode_custom_ipad_padding',
        'param_name' => 'ipad_padding',
        'heading' => __('Padding (For iPad Device)', 'hcode-addons' ),
        'value' => '',
        'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Custom Padding (For iPad Devices)', 'hcode-addons' ),
        'param_name' => 'custom_ipad_padding',
        'dependency' => array( 'element' => 'ipad_padding', 'value' => array('custom-ipad-padding') ),
        'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
        'group' => 'Style',
      ),
      array(
        'type' => 'hcode_custom_mobile_padding',
        'param_name' => 'mobile_padding',
        'heading' => __('Padding (For Mobile Device)', 'hcode-addons' ),
        'value' => '',
        'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Custom Padding (For Mobile Devices)', 'hcode-addons' ),
        'param_name' => 'custom_mobile_padding',
        'dependency' => array( 'element' => 'mobile_padding', 'value' => array('custom-mobile-padding') ),
        'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
        'group' => 'Style',
      ),
      array(
          'type' => 'hcode_custom_switch_option',
          'class' => '',
          'heading' => __('Required Margin Setting?', 'hcode-addons'),
          'param_name' => 'margin_setting',
          'value' => array(__('No', 'hcode-addons') => '0', 
                           __('Yes', 'hcode-addons') => '1'
                          ),
          'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('portfolio-with-desc') ),
          'group' => 'Style',
      ),
      array(
        'type' => 'hcode_custom_desktop_margin',
        'param_name' => 'desktop_margin',
        'heading' => __('Margin (For Desktop Device)', 'hcode-addons' ),
        'value' => '',
        'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Custom Margin (For Desktop Devices)', 'hcode-addons' ),
        'param_name' => 'custom_desktop_margin',
        'dependency' => array( 'element' => 'desktop_margin', 'value' => array('custom-desktop-margin') ),
        'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
        'group' => 'Style',
      ),
      array(
        'type' => 'hcode_custom_ipad_margin',
        'param_name' => 'ipad_margin',
        'heading' => __('Margin (For iPad Device)', 'hcode-addons' ),
        'value' => '',
        'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Custom Margin (For iPad Devices)', 'hcode-addons' ),
        'param_name' => 'custom_ipad_margin',
        'dependency' => array( 'element' => 'ipad_margin', 'value' => array('custom-ipad-margin') ),
        'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
        'group' => 'Style',
      ),
      array(
        'type' => 'hcode_custom_mobile_margin',
        'param_name' => 'mobile_margin',
        'heading' => __('Margin (For Mobile Device)', 'hcode-addons' ),
        'value' => '',
        'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
        'group' => 'Style',
      ),
      array(
        'type' => 'textfield',
        'heading' => __('Custom Margin (For Mobile Devices)', 'hcode-addons' ),
        'param_name' => 'custom_mobile_margin',
        'dependency' => array( 'element' => 'mobile_margin', 'value' => array('custom-mobile-margin') ),
        'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
        'group' => 'Style',
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => esc_html__( 'Overlay color', 'hcode-addons' ),
        'param_name' => 'hcode_overlay_color',
        'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => 'parallax' ),
        'group' => esc_html__( 'Color', 'hcode-addons' ),
      ),
      array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'Overlay opacity', 'hcode-addons'),
        'param_name' => 'hcode_overlay_opacity',
        'value' => array( esc_html__( 'Default opacity','hcode-addons') => '',
                          '0'  => '0',
                          '0.1'  => '0.1',
                          '0.2'  => '0.2',
                          '0.3'  => '0.3',
                          '0.4'  => '0.4',
                          '0.5'  => '0.5',
                          '0.6'  => '0.6',
                          '0.7'  => '0.7',
                          '0.8'  => '0.8',
                          '0.9'  => '0.9',
                          '1.0'  => '1.0',
                        ),
        'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => 'parallax' ),
        'group' => esc_html__( 'Color', 'hcode-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Title Color', 'hcode-addons' ),
        'param_name' => 'hcode_title_color',
        'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('parallax','portfolio-with-desc') ),
        'group' => esc_html__( 'Color', 'hcode-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Subtitle / Content Color', 'hcode-addons' ),
        'param_name' => 'hcode_subtitle_color',
        'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('parallax','portfolio-with-desc') ),
        'group' => esc_html__( 'Color', 'hcode-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Background Color', 'hcode-addons' ),
        'param_name' => 'hcode_bg_color',
        'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('parallax','portfolio-with-desc') ),
        'group' => esc_html__( 'Color', 'hcode-addons' ),
      ),
      array(
        'type' => 'colorpicker',
        'class' => '',
        'heading' => __( 'Hover Background Color', 'hcode-addons' ),
        'param_name' => 'hcode_hover_bg_color',
        'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('portfolio-with-desc') ),
        'group' => esc_html__( 'Color', 'hcode-addons' ),
      ),
      array(
        'type'        => 'responsive_font_settings',
        'param_name'  => 'hcode_responsive_title_font',
        'heading'     => esc_html__( 'Font Settings For Title', 'hcode-addons' ),
        'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('parallax','portfolio-with-desc') ),
        'group' => 'Font Settings',
      ),
      array(
        'type'        => 'responsive_font_settings',
        'param_name'  => 'hcode_responsive_subtitle_font',
        'heading'     => esc_html__( 'Font Settings For Subtitle', 'hcode-addons' ),
        'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('parallax') ),
        'group' => 'Font Settings',
      ),
      array(
        'type'        => 'responsive_font_settings',
        'param_name'  => 'hcode_responsive_filter_font',
        'heading'     => esc_html__( 'Font Settings For Filter', 'hcode-addons' ),
        'hide_font_settings_element_lg' => array('text-align'),
        'hide_font_settings_element_md' => array('text-align'),
        'hide_font_settings_element_sm' => array('text-align'),
        'hide_font_settings_element_xs' => array('text-align'),
        'dependency'  => array( 'element' => 'hcode_show_filter', 'value' => array('1') ),
        'group' => 'Font Settings',
      ),
      array(
          'type' => 'hcode_custom_srcset',
          'param_name' => 'hcode_image_srcset',
          'heading' => __('Image SRCSET', 'hcode-addons' ),
          'value' => 'full',
          'group' => 'SRCSET',
          'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('parallax','portfolio-with-desc') ),
      ),
      array(
          'type' => 'hcode_animation_style',
          'param_name' => 'hcode_animation_style',
          'heading' => __('Animation Type', 'hcode-addons' ),
          'value' => '',
          'group' => 'Animation',
          'dependency'  => array( 'element' => 'hcode_parallax_style', 'value' => array('portfolio-with-desc') ),
      ),
      $hcode_vc_extra_id,
      $hcode_vc_extra_class,
  )
) );