<?php
/**
 * Map For Simple Image
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Simple Image */
/*-----------------------------------------------------------------------------------*/

vc_map( array(
      'name' => __( 'Simple Image', 'hcode-addons' ),
      'base' => 'hcode_simple_image',
      'category' => 'H-Code',
      'icon' => 'h-code-shortcode-icon fa-regular fa-image',
      'description' => __( 'Add an image with different options', 'hcode-addons' ),
      'params' => array(
          array(
            'type' => 'attach_image',
            'admin_label' => true,
            'heading' => __('Block Image', 'hcode-addons' ),
            'param_name' => 'hcode_image',
          ),
          array(
            'type' => 'hcode_custom_switch_option',
            'class' => '',
            'heading' => __('Show Full Image in Mobile Device', 'hcode-addons'),
            'param_name' => 'hcode_mobile_full_image',
            'value' => array(__('NO', 'hcode-addons') => '0', 
                             __('YES', 'hcode-addons') => '1'
                            ),
          ),
          array(
            'type' => 'hcode_custom_switch_option',
            'class' => '',
            'heading' => __('Show Image With Border', 'hcode-addons'),
            'param_name' => 'hcode_image_with_border',
            'value' => array(__('NO', 'hcode-addons') => '0', 
                             __('YES', 'hcode-addons') => '1'
                            ),
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Url', 'hcode-addons' ),
            'param_name' => 'hcode_url',
            'description' => __( 'Define url of image', 'hcode-addons' ),
          ),
          array(
            'type' => 'hcode_custom_switch_option',
            'class' => '',
            'heading' => __( 'Target Blank', 'hcode-addons'),
            'param_name' => 'hcode_target_blank',
            'value' => array(__('NO', 'hcode-addons') => '0', 
                             __('YES', 'hcode-addons') => '1'
                            ),
          ),
          /* Add image caption in H-Code v1.5 */
          array(
            'type' => 'hcode_custom_switch_option',
            'class' => '',
            'heading' => __( 'Show Image Caption', 'hcode-addons'),
            'param_name' => 'hcode_show_image_caption',
            'value' => array(__('NO', 'hcode-addons') => '0', 
                             __('YES', 'hcode-addons') => '1'
                            ),
          ),
          array(
            'type' => 'dropdown',
            'heading' => __( 'Image Caption Position', 'hcode-addons' ),
            'param_name' => 'hcode_image_caption_position',
            'value' => array(__( 'Select Caption Position', 'hcode-addons' ) => '',
                             __( 'Top', 'hcode-addons' ) => 'image-caption-top',
                             __( 'Bottom', 'hcode-addons' ) => 'image-caption-bottom',
                            ),
            'dependency' => array( 'element' => 'hcode_show_image_caption', 'value' => array('1') ),
          ),
          array(
            'type' => 'dropdown',
            'heading' => __( 'Caption Text Alignment', 'hcode-addons' ),
            'param_name' => 'hcode_image_caption_text_alignment',
            'value' => array(__( 'None', 'hcode-addons' ) => '',
                             __( 'Left', 'hcode-addons' ) => 'text-left',
                             __( 'Center', 'hcode-addons' ) => 'text-center',
                             __( 'Right', 'hcode-addons' ) => 'text-right',
                            ),
            'dependency' => array( 'element' => 'hcode_show_image_caption', 'value' => array('1') ),
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Min Height', 'hcode-addons' ),
            'param_name' => 'hcode_min_height',
            'dependency' => array( 'element' => 'hcode_image_with_border', 'value' => array('1') ),
            'description' => __( 'Define Min height like 500px', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'dropdown',
            'heading' => __('Min Height For Mobile Device', 'hcode-addons' ),
            'param_name' => 'hcode_mobile_min_height',
            'value' => array(__('Select Min Height For Mobile Device', 'hcode-addons') => '',
                             __('min-height 100px', 'hcode-addons') => 'min-height-100', 
                             __('min-height 150px', 'hcode-addons') => 'min-height-150', 
                             __('min-height 200px', 'hcode-addons') => 'min-height-200', 
                             __('min-height 250px', 'hcode-addons') => 'min-height-250',
                             __('min-height 300px', 'hcode-addons') => 'min-height-300', 
                             __('min-height 350px', 'hcode-addons') => 'min-height-350', 
                             __('min-height 400px', 'hcode-addons') => 'min-height-400', 
                             __('min-height 450px', 'hcode-addons') => 'min-height-450',
                             __('min-height 500px', 'hcode-addons') => 'min-height-500', 
                             __('min-height 550px', 'hcode-addons') => 'min-height-550', 
                             __('min-height 600px', 'hcode-addons') => 'min-height-600', 
                             __('min-height 650px', 'hcode-addons') => 'min-height-650',

                            ),
            'dependency' => array( 'element' => 'hcode_image_with_border', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_switch_option',
            'class' => '',
            'heading' => __('Alignment Setting', 'hcode-addons'),
            'param_name' => 'alignment_setting',
            'value' => array(__('No', 'hcode-addons') => '0', 
                             __('Yes', 'hcode-addons') => '1'
                            ),
            'description' => __( 'Select Yes to set div in alignment of column', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'desktop_alignment',
            'heading' => __('Alignment (For Desktop Device)', 'hcode-addons' ),
            'value' => array(__('No Align', 'hcode-addons') => '',
                             __('Left Align', 'hcode-addons') => 'alignleft',
                             __('Right Align', 'hcode-addons') => 'alignright',
                             __('Center Align', 'hcode-addons') => 'aligncenter',
                            ),
            'dependency' => array( 'element' => 'alignment_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'ipad_alignment',
            'heading' => __('Alignment (For iPad/Tablet Device)', 'hcode-addons' ),
            'value' => array(__('No Align', 'hcode-addons') => '',
                             __('Left Align', 'hcode-addons') => 'sm-alignleft',
                             __('Right Align', 'hcode-addons') => 'sm-alignright',
                             __('Center Align', 'hcode-addons') => 'sm-aligncenter',
                            ),
            'dependency' => array( 'element' => 'alignment_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'dropdown',
            'param_name' => 'mobile_alignment',
            'heading' => __('Alignment (For Mobile Device)', 'hcode-addons' ),
            'value' => array(__('No Align', 'hcode-addons') => '',
                             __('Left Align', 'hcode-addons') => 'xs-alignleft',
                             __('Right Align', 'hcode-addons') => 'xs-alignright',
                             __('Center Align', 'hcode-addons') => 'xs-aligncenter',
                            ),
            'dependency' => array( 'element' => 'alignment_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_switch_option',
            'class' => '',
            'heading' => __('Required Padding Setting?', 'hcode-addons'),
            'param_name' => 'padding_setting',
            'value' => array(__('No', 'hcode-addons') => '0', 
                             __('Yes', 'hcode-addons') => '1'
                            ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_desktop_padding',
            'param_name' => 'desktop_padding',
            'heading' => __('Padding (For Desktop Device)', 'hcode-addons' ),
            'value' => '',
            'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Custom Padding (For Desktop Devices)', 'hcode-addons' ),
            'param_name' => 'custom_desktop_padding',
            'dependency' => array( 'element' => 'desktop_padding', 'value' => array('custom-desktop-padding') ),
            'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),

            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_ipad_padding',
            'param_name' => 'ipad_padding',
            'heading' => __('Padding (For iPad Device)', 'hcode-addons' ),
            'value' => '',
            'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Custom Padding (For iPad Devices)', 'hcode-addons' ),
            'param_name' => 'custom_ipad_padding',
            'dependency' => array( 'element' => 'ipad_padding', 'value' => array('custom-ipad-padding') ),
            'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_mobile_padding',
            'param_name' => 'mobile_padding',
            'heading' => __('Padding (For Mobile Device)', 'hcode-addons' ),
            'value' => '',
            'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Custom Padding (For Mobile Devices)', 'hcode-addons' ),
            'param_name' => 'custom_mobile_padding',
            'dependency' => array( 'element' => 'mobile_padding', 'value' => array('custom-mobile-padding') ),
            'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_switch_option',
            'class' => '',
            'heading' => __('Required Margin Setting?', 'hcode-addons'),
            'param_name' => 'margin_setting',
            'value' => array(__('No', 'hcode-addons') => '0', 
                             __('Yes', 'hcode-addons') => '1'
                            ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_desktop_margin',
            'param_name' => 'desktop_margin',
            'heading' => __('Margin (For Desktop Device)', 'hcode-addons' ),
            'value' => '',
            'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Custom Margin (For Desktop Devices)', 'hcode-addons' ),
            'param_name' => 'custom_desktop_margin',
            'dependency' => array( 'element' => 'desktop_margin', 'value' => array('custom-desktop-margin') ),
            'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_ipad_margin',
            'param_name' => 'ipad_margin',
            'heading' => __('Margin (For iPad Device)', 'hcode-addons' ),
            'value' => '',
            'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Custom Margin (For iPad Devices)', 'hcode-addons' ),
            'param_name' => 'custom_ipad_margin',
            'dependency' => array( 'element' => 'ipad_margin', 'value' => array('custom-ipad-margin') ),
            'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_mobile_margin',
            'param_name' => 'mobile_margin',
            'heading' => __('Margin (For Mobile Device)', 'hcode-addons' ),
            'value' => '',
            'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
            'group' => 'Style',
          ),
          array(
            'type' => 'textfield',
            'heading' => __('Custom Margin (For Mobile Devices)', 'hcode-addons' ),
            'param_name' => 'custom_mobile_margin',
            'dependency' => array( 'element' => 'mobile_margin', 'value' => array('custom-mobile-margin') ),
            'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
            'group' => 'Style',
          ),
          array(
            'type' => 'hcode_custom_srcset',
            'param_name' => 'hcode_image_srcset',
            'heading' => __('Image SRCSET', 'hcode-addons' ),
            'value' => 'full',
            'group' => 'SRCSET',
          ),
          $hcode_vc_extra_id,
          $hcode_vc_extra_class,
      )
    ) );