<?php
/**
 * Map For Feature Box
 *
 * @package H-Code
 */
?>
<?php
/*-----------------------------------------------------------------------------------*/
/* Feature Box */
/*-----------------------------------------------------------------------------------*/
vc_map( array(
  'name' => __('Features Box', 'hcode-addons'),
  'description' => __('Place a features box', 'hcode-addons'),
  'icon' => 'fa-solid fa-building h-code-shortcode-icon',
  'base' => 'hcode_feature_box',
  'category' => 'H-Code',
  'params' => array(
    array(
      'type' => 'dropdown',
      'admin_label' => true,
      'heading' => __('Feature Style', 'hcode-addons'),
      'param_name' => 'hcode_feature_type',
      'value' => array(__('Select Feature Style', 'hcode-addons') => '',
                       __('Feature Style 1', 'hcode-addons') => 'featurebox1',
                       __('Feature Style 2', 'hcode-addons') => 'featurebox2',
                       __('Feature Style 3', 'hcode-addons') => 'featurebox3',
                       __('Feature Style 4', 'hcode-addons') => 'featurebox4',
                       __('Feature Style 5', 'hcode-addons') => 'featurebox5',
                       __('Feature Style 6', 'hcode-addons') => 'featurebox6',
                       __('Feature Style 7', 'hcode-addons') => 'featurebox7',
                       __('Feature Style 8', 'hcode-addons') => 'featurebox8',
                       __('Feature Style 9', 'hcode-addons') => 'featurebox9',
                       __('Feature Style 10', 'hcode-addons') => 'featurebox10',
                      ),
    ),
    array(
      'type' => 'hcode_preview_image',
      'heading' => __('Select pre-made style for Feature', 'hcode-addons'),
      'param_name' => 'feature_box_preview_image',
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'heading' => __('Custom Icon', 'hcode-addons'),
      'param_name' => 'custom_icon',
      'value' => array(__('NO', 'hcode-addons') => '0',
                       __('YES', 'hcode-addons') => '1'
                      ),
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox1','featurebox2','featurebox3','featurebox7','featurebox9')),
    ),
    array(
      'type' => 'attach_image',
      'heading' => __('Custom Icon Image', 'hcode-addons'),
      'param_name' => 'custom_icon_image',
      'dependency' => array( 'element' => 'custom_icon', 'value' => '1' ),
      'description' => __( 'Recommended size: Extra Large - 60px X 60px, Large - 50px X 50px, Medium - 40px X 40px, Small - 25px X 25px, Extra Small - 18px X 18px', 'hcode-addons' ),
    ),
    array(
      'type' => 'hcode_icon',
      'heading' => __('Select Icon Type', 'hcode-addons'),
      'param_name' => 'hcode_et_line_icon_list',
      'description' => __('Select Font Type', 'hcode-addons'),
      'dependency' => array( 'element' => 'custom_icon', 'value' => '0' ),      
    ),
    array(
      'type' => 'attach_image',
      'heading' => __('Image', 'hcode-addons' ),
      'param_name' => 'hcode_feature_image',
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox8','featurebox10')),
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Number Text', 'hcode-addons' ),
      'param_name' => 'hcode_process_no',
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox1')),
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Number Text', 'hcode-addons' ),
      'param_name' => 'hcode_number',
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox9')),
    ),
    array(
      'type' => 'textfield',
      'admin_label' => true,
      'heading' => __('Title', 'hcode-addons' ),
      'param_name' => 'hcode_feature_title',
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox1','featurebox2','featurebox3','featurebox6','featurebox7','featurebox8','featurebox9','featurebox10')),
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Link', 'hcode-addons' ),
      'param_name' => 'hcode_feature_title_link',
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox2','featurebox3','featurebox6','featurebox7','featurebox8','featurebox9','featurebox10')),
    ),
    array(
      'type' => 'dropdown',
      'heading' => __('Link Target', 'hcode-addons' ),
      'param_name' => 'hcode_feature_title_link_target',
      'value' => array(__('Select Link Target', 'hcode-addons') => '',
                       __('Same window / tab', 'hcode-addons') => '_self', 
                       __('New Window / tab', 'hcode-addons') => '_blank',
                      ),
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox2','featurebox3','featurebox6','featurebox7','featurebox8','featurebox9','featurebox10')),
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Subtitle', 'hcode-addons' ),
      'param_name' => 'hcode_feature_subtitle',
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox6')),
    ),
    array(
      'type' => 'textarea_html',
      'heading' => __('Description', 'hcode-addons'),
      'param_name' => 'content',
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox1','featurebox2','featurebox3','featurebox6','featurebox7','featurebox8', 'featurebox10')),
    ),
    array(
      'type' => 'hcode_posts_list',
      'admin_label' => true,
      'heading' => __('Blog Post', 'hcode-addons'),
      'param_name' => 'hcode_posts_list',
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox5','featurebox4')),
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Currency Symbol', 'hcode-addons' ),
      'param_name' => 'hcode_feature_currency',
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox6')),
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Price', 'hcode-addons' ),
      'param_name' => 'hcode_feature_price',
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox6')),
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Enter Per Month Text', 'hcode-addons' ),
      'param_name' => 'hcode_feature_per_month_text',
      'value' => '/mo',
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox6')),
    ),
    array(
      'type'        => 'vc_link',
      'heading'     => __('Button Link', 'hcode-addons' ),
      'param_name'  => 'hcode_feature_button_link',
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox6')),
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'class' => '',
      'heading' => __('Show Post Image', 'hcode-addons'),
      'param_name' => 'hcode_show_post_image',
      'value' => array(__('NO', 'hcode-addons') => '0', 
                       __('YES', 'hcode-addons') => '1'
                      ),
      'std' => '1',
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox5') ),
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'class' => '',
      'heading' => __('Show Post Title', 'hcode-addons'),
      'param_name' => 'hcode_show_post_title',
      'value' => array(__('NO', 'hcode-addons') => '0', 
                       __('YES', 'hcode-addons') => '1'
                      ),
      'std' => '1',
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox4', 'featurebox5') ),
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'class' => '',
      'heading' => __('Show Post Author', 'hcode-addons'),
      'param_name' => 'hcode_show_post_author',
      'value' => array(__('NO', 'hcode-addons') => '0', 
                       __('YES', 'hcode-addons') => '1'
                      ),
      'std' => '1',
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox4', 'featurebox5') ),
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'class' => '',
      'heading' => __('Show Post Date', 'hcode-addons'),
      'param_name' => 'hcode_show_post_date',
      'value' => array(__('NO', 'hcode-addons') => '0', 
                       __('YES', 'hcode-addons') => '1'
                      ),
      'std' => '1',
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => 'featurebox5' ),
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'class' => '',
      'heading' => __('Show Post Excerpt', 'hcode-addons'),
      'param_name' => 'hcode_show_post_excerpt',
      'value' => array(__('NO', 'hcode-addons') => '0', 
                       __('YES', 'hcode-addons') => '1'
                      ),
      'std' => '1',
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => 'featurebox5' ),
    ),
    array(
      'type'        => 'textfield',
      'heading'     => __('Excerpt Length', 'hcode-addons' ),
      'description' => __( 'Enter numaric value like 20', 'hcode-addons' ),
      'param_name'  => 'hcode_excerpt_length',
      'value'       => '15',
      'dependency'  => array( 'element' => 'hcode_show_post_excerpt', 'value' => array('1')),
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'class' => '',
      'heading' => __('Show Separator', 'hcode-addons'),
      'param_name' => 'hcode_enable_seperator',
      'value' => array(__('NO', 'hcode-addons') => '0', 
                       __('YES', 'hcode-addons') => '1'
                      ),
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox1','featurebox3','featurebox5','featurebox7')),
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'class' => '',
      'heading' => __('Active Feature', 'hcode-addons'),
      'param_name' => 'hcode_active_feature',
      'value' => array(__('NO', 'hcode-addons') => '0', 
                       __('YES', 'hcode-addons') => '1'
                      ),
      'description' => __( 'Select YES to mark as active feature', 'hcode-addons' ),
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox6')),
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'class' => '',
      'heading' => __('Enable Icon', 'hcode-addons'),
      'param_name' => 'hcode_feature_icon',
      'value' => array(__('NO', 'hcode-addons') => '0', 
                       __('YES', 'hcode-addons') => '1'
                      ),
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox8')),
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'class' => '',
      'heading' => __('Enable Star', 'hcode-addons'),
      'param_name' => 'hcode_feature_star',
      'value' => array(__('NO', 'hcode-addons') => '0', 
                       __('YES', 'hcode-addons') => '1'
                      ),
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox8')),
    ),
    array(
      'type' => 'dropdown',
      'heading' => __('Stars', 'hcode-addons'),
      'param_name' => 'hcode_stars',
      'admin_label' => true,
      'value' => array(__('Select Stars', 'hcode-addons') => '',
                       __('Star 1', 'hcode-addons') => '1',
                       __('Star 2', 'hcode-addons') => '2', 
                       __('Star 3', 'hcode-addons') => '3',
                       __('Star 4', 'hcode-addons') => '4',
                       __('Star 5', 'hcode-addons') => '5',
                      ),
      'dependency' => array( 'element' => 'hcode_feature_star', 'value' => array('1') ),
    ),
    array(
      'type' => 'dropdown',
      'heading' => __('Select Icon Size', 'hcode-addons'),
      'param_name' => 'counter_icon_size',
      'value' => array(__('Default', 'hcode-addons') => '',
                       __('Extra Large', 'hcode-addons') => 'extra-large-icon', 
                       __('Large', 'hcode-addons') => 'large-icon',
                       __('Medium', 'hcode-addons') => 'medium-icon',
                       __('Small', 'hcode-addons') => 'small-icon',
                       __('Extra Small', 'hcode-addons') => 'extra-small-icon',
                      ),
      'dependency' => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox1','featurebox2','featurebox3','featurebox7','featurebox8','featurebox9') ),
      'group' => 'Configuration',
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Icon Color', 'hcode-addons' ),
      'param_name' => 'hcode_icon_color',
      'dependency' => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox1','featurebox2','featurebox3','featurebox7','featurebox8','featurebox9') ),
      'group' => 'Configuration',
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Star Color', 'hcode-addons' ),
      'param_name' => 'hcode_star_color',
      'dependency' => array( 'element' => 'hcode_feature_star', 'value' => array('1') ),
      'group' => 'Configuration',
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Number Color', 'hcode-addons' ),
      'param_name' => 'hcode_number_color',
      'dependency' => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox1','featurebox9') ),
      'group' => 'Configuration',
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Title Color', 'hcode-addons' ),
      'param_name' => 'hcode_title_color',
      'group' => 'Configuration',
      'dependency' => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox1','featurebox2','featurebox3','featurebox4','featurebox5','featurebox6','featurebox7','featurebox8','featurebox9','featurebox10') ),
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Subtitle Color', 'hcode-addons' ),
      'param_name' => 'hcode_subtitle_color',
      'group' => 'Configuration',
      'dependency' => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox6') ),
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Separator Color', 'hcode-addons' ),
      'param_name' => 'hcode_sep_color',
      'dependency' => array( 'element' => 'hcode_enable_seperator', 'value' => array('1') ),
      'group' => 'Configuration',
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Meta Color', 'hcode-addons' ),
      'param_name' => 'hcode_meta_color',
      'dependency' => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox4','featurebox5') ),
      'group' => 'Configuration',
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Box Background Color', 'hcode-addons' ),
      'param_name' => 'hcode_box_background_color',
      'dependency' => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox4') ),
      'group' => 'Configuration',
    ),
    array(
      'type' => 'colorpicker',
      'class' => '',
      'heading' => __( 'Box Background Hover Color', 'hcode-addons' ),
      'param_name' => 'hcode_box_background_hover_color',
      'dependency' => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox4') ),
      'group' => 'Configuration',
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'class' => '',
      'heading' => __('Required Padding Setting?', 'hcode-addons'),
      'param_name' => 'padding_setting',
      'value' => array(__('No', 'hcode-addons') => '0', 
                       __('Yes', 'hcode-addons') => '1'
                      ),
      'group' => 'Style',
      'dependency' => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox1','featurebox2','featurebox3','featurebox6','featurebox7','featurebox8','featurebox9','featurebox10') ),
    ),
    array(
      'type' => 'hcode_custom_desktop_padding',
      'param_name' => 'desktop_padding',
      'heading' => __('Padding (For Desktop Device)', 'hcode-addons' ),
      'value' => '',
      'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
      'group' => 'Style',
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Custom Padding (For Desktop Devices)', 'hcode-addons' ),
      'param_name' => 'custom_desktop_padding',
      'dependency' => array( 'element' => 'desktop_padding', 'value' => array('custom-desktop-padding') ),
      'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
      'group' => 'Style',
    ),
    array(
      'type' => 'hcode_custom_ipad_padding',
      'param_name' => 'ipad_padding',
      'heading' => __('Padding (For iPad Device)', 'hcode-addons' ),
      'value' => '',
      'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
      'group' => 'Style',
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Custom Padding (For iPad Devices)', 'hcode-addons' ),
      'param_name' => 'custom_ipad_padding',
      'dependency' => array( 'element' => 'ipad_padding', 'value' => array('custom-ipad-padding') ),
      'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
      'group' => 'Style',
    ),
    array(
      'type' => 'hcode_custom_mobile_padding',
      'param_name' => 'mobile_padding',
      'heading' => __('Padding (For Mobile Device)', 'hcode-addons' ),
      'value' => '',
      'dependency' => array( 'element' => 'padding_setting', 'value' => array('1') ),
      'group' => 'Style',
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Custom Padding (For Mobile Devices)', 'hcode-addons' ),
      'param_name' => 'custom_mobile_padding',
      'dependency' => array( 'element' => 'mobile_padding', 'value' => array('custom-mobile-padding') ),
      'description' => __( 'Specify padding like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
      'group' => 'Style',
    ),
    array(
      'type' => 'hcode_custom_switch_option',
      'class' => '',
      'heading' => __('Required Margin Setting?', 'hcode-addons'),
      'param_name' => 'margin_setting',
      'value' => array(__('No', 'hcode-addons') => '0', 
                       __('Yes', 'hcode-addons') => '1'
                      ),
      'group' => 'Style',
      'dependency' => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox1','featurebox2','featurebox3','featurebox6','featurebox7','featurebox8','featurebox9','featurebox10') ),
    ),
    array(
      'type' => 'hcode_custom_desktop_margin',
      'param_name' => 'desktop_margin',
      'heading' => __('Margin (For Desktop Device)', 'hcode-addons' ),
      'value' => '',
      'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
      'group' => 'Style',
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Custom Margin (For Desktop Devices)', 'hcode-addons' ),
      'param_name' => 'custom_desktop_margin',
      'dependency' => array( 'element' => 'desktop_margin', 'value' => array('custom-desktop-margin') ),
      'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
      'group' => 'Style',
    ),
    array(
      'type' => 'hcode_custom_ipad_margin',
      'param_name' => 'ipad_margin',
      'heading' => __('Margin (For iPad Device)', 'hcode-addons' ),
      'value' => '',
      'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
      'group' => 'Style',
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Custom Margin (For iPad Devices)', 'hcode-addons' ),
      'param_name' => 'custom_ipad_margin',
      'dependency' => array( 'element' => 'ipad_margin', 'value' => array('custom-ipad-margin') ),
      'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
      'group' => 'Style',
    ),
    array(
      'type' => 'hcode_custom_mobile_margin',
      'param_name' => 'mobile_margin',
      'heading' => __('Margin (For Mobile Device)', 'hcode-addons' ),
      'value' => '',
      'dependency' => array( 'element' => 'margin_setting', 'value' => array('1') ),
      'group' => 'Style',
    ),
    array(
      'type' => 'textfield',
      'heading' => __('Custom Margin (For Mobile Devices)', 'hcode-addons' ),
      'param_name' => 'custom_mobile_margin',
      'dependency' => array( 'element' => 'mobile_margin', 'value' => array('custom-mobile-margin') ),
      'description' => __( 'Specify margin like (10px 12px 10px 12px or 10px or 10%...)', 'hcode-addons' ),
      'group' => 'Style',
    ), 
    array(
      'type'        => 'hcode_button_settings',
      'param_name'  => 'button_config_settings',
      'heading'     => esc_html__( 'Button Configuration', 'hcode-addons' ),
      'group' => 'Button Configuration',
      'dependency' => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox6') ),
      'description' => __( 'You can easily set button text-transform, font-size, line-height, letter-spacing for all devices ', 'hcode-addons' ),
      'hide_font_settings_element'=>array('icon-color','icon-hover-color')
    ),
    array(
        'type'        => 'responsive_font_settings',
        'param_name'  => 'hcode_responsive_title_font',
        'heading'     => esc_html__( 'Font Settings For Title', 'hcode-addons' ),
        'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox1','featurebox2','featurebox3','featurebox6','featurebox7','featurebox8','featurebox9','featurebox10')),
        'group' => 'Font Settings',
    ),
    array(
        'type'        => 'responsive_font_settings',
        'param_name'  => 'hcode_responsive_number_font',
        'heading'     => esc_html__( 'Font Settings For Number', 'hcode-addons' ),
        'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox1', 'featurebox9')),
        'group' => 'Font Settings',
    ),
    array(
        'type'        => 'responsive_font_settings',
        'param_name'  => 'hcode_responsive_post_meta_font',
        'heading'     => esc_html__( 'Font Settings For Post Meta', 'hcode-addons' ),
        'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox4', 'featurebox5')),
        'group' => 'Font Settings',
    ),
    array(
        'type'        => 'responsive_font_settings',
        'param_name'  => 'hcode_responsive_subtitle_font',
        'heading'     => esc_html__( 'Font Settings For Subtitle', 'hcode-addons' ),
        'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox6')),
        'group' => 'Font Settings',
    ),
    array(
      'type' => 'hcode_custom_srcset',
      'param_name' => 'hcode_image_srcset',
      'heading' => __('Image SRCSET', 'hcode-addons' ),
      'value' => 'full',
      'dependency'  => array( 'element' => 'hcode_feature_type', 'value' => array('featurebox5','featurebox8','featurebox10')),
      'group' => 'SRCSET',
    ),
    array(
      'type' => 'hcode_custom_srcset',
      'param_name' => 'hcode_icon_image_srcset',
      'heading' => __('Icon Image SRCSET', 'hcode-addons' ),
      'value' => 'full',
      'dependency' => array( 'element' => 'custom_icon', 'value' => '1' ),
      'group' => 'SRCSET',
    ),
    $hcode_vc_extra_id,
    $hcode_vc_extra_class,
    )
) );
